/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.statistics.jmx.ConcurrentMapStatisticsManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.StripedReadWriteLock;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.search.impl.SearchManager;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.TierableStore;
import net.sf.ehcache.store.offheap.BackingMapFactory;
import net.sf.ehcache.store.offheap.EhcacheConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolableStore;
import net.sf.ehcache.store.offheap.pool.impl.CrossPoolEvictionException;
import net.sf.ehcache.util.SetAsList;
import net.sf.ehcache.writer.CacheWriterManager;

public class OffHeapStore
extends AbstractStore
implements TierableStore,
OffHeapPoolableStore,
net.sf.ehcache.store.StripedReadWriteLockProvider {
    private final String cacheName;
    private final boolean tierPinned;
    private final OffHeapPool pool;
    private final EhcacheConcurrentOffHeapClockCache map;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.STATUS_UNINITIALISED);
    private CacheLockProvider lockProvider;

    public OffHeapStore(BackingMapFactory factory, Ehcache cache, OffHeapPool pool, SearchManager searchManger) {
        super(searchManger);
        this.cacheName = cache.getName();
        PinningConfiguration pinningConfiguration = cache.getCacheConfiguration().getPinningConfiguration();
        this.tierPinned = pinningConfiguration != null && pinningConfiguration.getStore() == PinningConfiguration.Store.LOCALHEAP;
        this.map = factory.create(this);
        this.pool = pool;
        if (this.pool != null) {
            this.pool.registerStore(this);
        }
        if (!this.status.compareAndSet(Status.STATUS_UNINITIALISED, Status.STATUS_ALIVE)) {
            throw new AssertionError();
        }
    }

    @Override
    public void unpinAll() {
        this.map.unpinAll();
    }

    @Override
    public boolean isPinned(Object key) {
        return this.map.isPinned(key);
    }

    @Override
    public void setPinned(Object key, boolean pinned) {
        this.map.setPinning((Serializable)key, pinned);
    }

    @Override
    public void fill(Element element) {
        if (element == null) {
            return;
        }
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        this.map.fill(element.getKey(), element);
    }

    @Override
    public boolean removeIfNotPinned(Object key) {
        return !this.tierPinned && !this.isPinned(key) && this.remove(key) != null;
    }

    @Override
    public boolean put(Element element) throws CacheException {
        if (element == null) {
            return false;
        }
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        return this.map.put(element.getKey(), element) == null;
    }

    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        boolean result = this.put(element);
        if (writerManager != null) {
            writerManager.put(element);
        }
        return result;
    }

    @Override
    public Element get(Object key) {
        if (key == null) {
            return null;
        }
        return (Element)this.map.get(key);
    }

    @Override
    public Element getQuiet(Object key) {
        return this.get(key);
    }

    @Override
    public List<?> getKeys() {
        return new SetAsList(this.map.keySet());
    }

    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        return (Element)this.map.remove(key);
    }

    @Override
    public void removeNoReturn(Object key) {
        if (key != null) {
            this.map.removeNoReturn(key);
        }
    }

    @Override
    public boolean isTierPinned() {
        return this.tierPinned;
    }

    @Override
    public Set getPresentPinnedKeys() {
        return this.map.pinnedKeySet();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        Element removed = this.remove(key);
        if (writerManager != null) {
            writerManager.remove(new CacheEntry(key, removed));
        }
        return removed;
    }

    @Override
    public void removeAll() throws CacheException {
        this.map.clear();
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        return this.map.putIfAbsent(element.getKey(), element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        Object key = element.getObjectKey();
        ReentrantReadWriteLock.WriteLock l = this.map.getLock(key).writeLock();
        l.lock();
        try {
            Element value = (Element)this.map.get(key);
            if (this.map.remove(key, element, comparator)) {
                Element element2 = value;
                return element2;
            }
            Element element3 = null;
            return element3;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        return this.map.replace(element.getKey(), old, element, comparator);
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        return this.map.replace(element.getKey(), element);
    }

    @Override
    public void dispose() {
        if (this.status.compareAndSet(Status.STATUS_ALIVE, Status.STATUS_SHUTDOWN)) {
            this.map.destroy();
        }
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    @Override
    public int getInMemorySize() {
        return 0;
    }

    @Override
    public int getOffHeapSize() {
        return this.getSize();
    }

    @Override
    public int getOnDiskSize() {
        return 0;
    }

    @Override
    public int getTerracottaClusteredSize() {
        return 0;
    }

    @Override
    public long getInMemorySizeInBytes() {
        return 0L;
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return this.map.getOccupiedMemory();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return 0L;
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return false;
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return false;
    }

    @Override
    public void expireElements() {
        for (Serializable key : this.map.keySet()) {
            this.expireElement(key);
        }
    }

    protected Set<Serializable> keySet() {
        return this.map.keySet();
    }

    protected Element expireElement(Object key) {
        Element value = this.get(key);
        return value != null && value.isExpired() && this.map.remove(key, value) ? value : null;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean bufferFull() {
        return false;
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return null;
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
    }

    @Override
    public Object getInternalContext() {
        CacheLockProvider lp = this.lockProvider;
        return lp == null ? (this.lockProvider = new LockProvider(this.map)) : lp;
    }

    @Override
    public Object getMBean() {
        return new ConcurrentMapStatisticsManager(this.map);
    }

    public void handleOversizeMappingException(Element e, OversizeMappingException cause) {
        if (!this.map.shrinkOthers(e.getKey().hashCode())) {
            throw new CacheException("The element '" + e + "' is too large to be stored" + " in this offheap store.", cause);
        }
    }

    public void handleCrossPoolEvictionException(Element e, CrossPoolEvictionException cause) {
        if (this.pool == null) {
            throw new AssertionError();
        }
        if (!this.pool.getEvictor().freeSpace(this.pool.getOffHeapPoolableStores(), 0L, this, e.getObjectKey().hashCode())) {
            throw new CacheException("The element '" + e + "' is too large to be stored" + " in this offheap store.", cause);
        }
    }

    public void handleCrossPoolEvictionException(int keyHash, CrossPoolEvictionException cause) {
        if (this.pool == null) {
            throw new AssertionError();
        }
        if (!this.pool.getEvictor().freeSpace(this.pool.getOffHeapPoolableStores(), 0L, this, keyHash)) {
            throw new CacheException("A binary element is too large to be stored in this offheap store.", cause);
        }
    }

    private RuntimeException handleNotSerializableException(Element e) {
        return new CacheException("The element '" + e + "' is not serializable and" + " cannot be put into the offheap cache " + this.cacheName);
    }

    @Override
    public StripedReadWriteLock createStripedReadWriteLock() {
        return new StripedReadWriteLockProvider(this.map);
    }

    public void registerMasterLocks(List<ReadWriteLockSync> masterLocks) {
        this.map.registerMasterLocks(masterLocks);
    }

    public boolean evictFromOnHeap(int count, long size) {
        return false;
    }

    public boolean evictFromOnDisk(int count, long size) {
        return false;
    }

    @Override
    public boolean evictFromOffHeap(int count, long size) {
        return this.map.shrink();
    }

    @Override
    public boolean evictFromOffHeap(int count, long size, int excludedHash) {
        return this.map.shrinkOthers(excludedHash);
    }

    @Override
    public long getApproximateSize() {
        return this.map.getSize();
    }

    @Override
    public float getApproximateOffHeapHitRate() {
        return this.map.getHitRate();
    }

    @Override
    public float getApproximateOffHeapMissRate() {
        return this.map.getMissRate();
    }

    @Override
    public long getApproximateSizeInBytes() {
        return this.map.getOccupiedMemory();
    }

    @Override
    public long getApproximateAllocatedCapacityInBytes() {
        return this.map.getAllocatedMemory();
    }

    public float getApproximateDiskHitRate() {
        return 0.0f;
    }

    public float getApproximateDiskMissRate() {
        return 0.0f;
    }

    public float getApproximateHeapHitRate() {
        return 0.0f;
    }

    public float getApproximateHeapMissRate() {
        return 0.0f;
    }

    private static class StripedReadWriteLockProvider
    implements StripedReadWriteLock {
        private final ReadWriteLockSync[] locks;
        private final EhcacheConcurrentOffHeapClockCache offHeapMap;

        public StripedReadWriteLockProvider(EhcacheConcurrentOffHeapClockCache map) {
            this.offHeapMap = map;
            int concurrency = map.getConcurrency();
            this.locks = new ReadWriteLockSync[concurrency];
            for (int i = 0; i < concurrency; ++i) {
                this.locks[i] = new ReadWriteLockSync();
            }
        }

        @Override
        public ReadWriteLock getLockForKey(Object key) {
            return this.getSyncForKey(key).getReadWriteLock();
        }

        @Override
        public List<ReadWriteLockSync> getAllSyncs() {
            return Collections.unmodifiableList(Arrays.asList(this.locks));
        }

        @Override
        public ReadWriteLockSync getSyncForKey(Object key) {
            return this.locks[this.offHeapMap.getIndexFor(key)];
        }
    }

    private static class LockProvider
    implements CacheLockProvider {
        private final EhcacheConcurrentOffHeapClockCache offHeapMap;

        public LockProvider(EhcacheConcurrentOffHeapClockCache map) {
            this.offHeapMap = map;
        }

        @Override
        public Sync getSyncForKey(Object key) {
            return new ReadWriteLockSync(this.offHeapMap.getLock(key));
        }
    }
}

