/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.store;

import com.terracottatech.offheapstore.filesystem.File;
import com.terracottatech.offheapstore.filesystem.SeekableOutputStream;
import java.io.IOException;
import org.terracotta.shaded.lucene.store.IndexOutput;

public class OffHeapIndexOutputStream
extends IndexOutput {
    private final SeekableOutputStream stream;

    public OffHeapIndexOutputStream(File file) throws IOException {
        this.stream = file.getOutputStream();
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.stream.write(b & 0xFF);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.stream.write(b, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public long getFilePointer() {
        long pointer = 0L;
        try {
            pointer = this.stream.getFilePointer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.stream.seek(pos);
    }

    @Override
    public long length() throws IOException {
        return this.stream.length();
    }
}

