/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import org.terracotta.shaded.lucene.search.BooleanQuery;

public class Configuration {
    private double maxRamBufferSize = 16.0;
    private int maxBufferedDocs = -1;
    private int mergeFactor = 10;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private boolean doAccessChecks = true;
    private final int indexesPerCache;
    private final int maxConcurrentQueries;
    private final boolean useOffHeap;
    private final boolean useRamDir;
    private final boolean useCommitThread;
    private final int offHeapFileSegmentCount;
    private final int offHeapFileBlockSize;
    private final int offHeapFileMaxPageSize;

    public Configuration(int indexesPerCache, int maxConcurrentQueries, boolean useOffHeap, boolean useRamDir, boolean useCommitThread, int offHeapFileSegmentCount, int offHeapFileBlockSize, int offHeapFileMaxPageSize) {
        this.indexesPerCache = indexesPerCache;
        this.maxConcurrentQueries = maxConcurrentQueries;
        this.useOffHeap = useOffHeap;
        this.useRamDir = useRamDir;
        this.useCommitThread = useCommitThread;
        this.offHeapFileSegmentCount = offHeapFileSegmentCount;
        this.offHeapFileBlockSize = offHeapFileBlockSize;
        this.offHeapFileMaxPageSize = offHeapFileMaxPageSize;
    }

    public boolean useRamDir() {
        return this.useRamDir;
    }

    public boolean useOffHeap() {
        return this.useOffHeap;
    }

    public int maxConcurrentQueries() {
        return this.maxConcurrentQueries;
    }

    public int indexesPerCache() {
        return this.indexesPerCache;
    }

    public boolean useCommitThread() {
        return this.useCommitThread;
    }

    public int getOffHeapFileSegmentCount() {
        return this.offHeapFileSegmentCount;
    }

    public int getOffHeapFileBlockSize() {
        return this.offHeapFileBlockSize;
    }

    public int getOffHeapFileMaxPageSize() {
        return this.offHeapFileMaxPageSize;
    }

    public double getMaxRamBufferSize() {
        return this.maxRamBufferSize;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public int getMaxClauseCount() {
        return BooleanQuery.getMaxClauseCount();
    }

    public void setMaxRamBufferSize(float maxRamBufferSize) {
        this.maxRamBufferSize = maxRamBufferSize;
    }

    public void setMaxBufferedDocs(int maxBufferedDocs) {
        this.maxBufferedDocs = maxBufferedDocs;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    public boolean doAccessChecks() {
        return this.doAccessChecks;
    }

    public void setDoAccessChecks(boolean doChecks) {
        this.doAccessChecks = doChecks;
    }

    public void setMaxClauseCount(int max) {
        BooleanQuery.setMaxClauseCount(max);
    }
}

