/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.util;

import com.terracottatech.offheapstore.util.Statistic;
import java.util.concurrent.TimeUnit;

abstract class AbstractStatistic
implements Statistic {
    final long rateAveragePeriod;

    AbstractStatistic() {
        this(0L, TimeUnit.SECONDS);
    }

    AbstractStatistic(long averagePeriod, TimeUnit unit) {
        this.rateAveragePeriod = unit.toNanos(averagePeriod);
    }

    float iterateMovingAverage(float nowValue, long now, float thenAverage, long then) {
        if (this.rateAveragePeriod == 0L || Float.isNaN(thenAverage)) {
            return nowValue;
        }
        float alpha = (float)this.alpha(now, then);
        return alpha * nowValue + (1.0f - alpha) * thenAverage;
    }

    private double alpha(long now, long then) {
        return -Math.expm1(-((double)(now - then)) / (double)this.rateAveragePeriod);
    }
}

