/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage;

import com.terracottatech.offheapstore.paging.OffHeapStorageArea;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.BinaryStorageEngine;
import com.terracottatech.offheapstore.storage.PortabilityBasedStorageEngine;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.restartable.RestartableDelegateStorageEngine;
import com.terracottatech.offheapstore.storage.restartable.WriteContext;
import com.terracottatech.offheapstore.util.DebuggingUtils;
import com.terracottatech.offheapstore.util.Factory;
import java.nio.ByteBuffer;

public class OffHeapBufferStorageEngine<K, V>
extends PortabilityBasedStorageEngine<K, V>
implements BinaryStorageEngine<K, V>,
OffHeapStorageArea.Owner,
RestartableDelegateStorageEngine {
    private static final int KEY_HASH_OFFSET = 0;
    private static final int KEY_LENGTH_OFFSET = 4;
    private static final int VALUE_LENGTH_OFFSET = 8;
    private static final int DATA_OFFSET = 12;
    private static final int HEADER_SIZE = 12;
    private final OffHeapStorageArea storageArea;

    public static <K, V> Factory<OffHeapBufferStorageEngine<K, V>> createFactory(final PageSource source, final int pageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim) {
        return new Factory<OffHeapBufferStorageEngine<K, V>>(){

            @Override
            public OffHeapBufferStorageEngine<K, V> newInstance() {
                return new OffHeapBufferStorageEngine(source, pageSize, keyPortability, valuePortability, thief, victim);
            }
        };
    }

    public static <K, V> Factory<OffHeapBufferStorageEngine<K, V>> createFactory(final PageSource source, final int initialPageSize, final int maximalPageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim) {
        return new Factory<OffHeapBufferStorageEngine<K, V>>(){

            @Override
            public OffHeapBufferStorageEngine<K, V> newInstance() {
                return new OffHeapBufferStorageEngine(source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim);
            }
        };
    }

    public OffHeapBufferStorageEngine(PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this(source, pageSize, pageSize, keyPortability, valuePortability);
    }

    public OffHeapBufferStorageEngine(PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this(source, initialPageSize, maximalPageSize, keyPortability, valuePortability, false, false);
    }

    public OffHeapBufferStorageEngine(PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        this(source, pageSize, pageSize, keyPortability, valuePortability, thief, victim);
    }

    public OffHeapBufferStorageEngine(PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        super(keyPortability, valuePortability);
        this.storageArea = new OffHeapStorageArea(this, source, initialPageSize, maximalPageSize, thief, victim);
    }

    @Override
    protected void clearInternal() {
        this.storageArea.clear();
    }

    @Override
    protected void free(long address) {
        this.storageArea.free((int)address);
    }

    @Override
    public ByteBuffer readKeyBuffer(long address) {
        int length = this.storageArea.readInt((int)address + 4);
        return this.storageArea.readBuffer((int)address + 12, length).asReadOnlyBuffer();
    }

    @Override
    protected WriteContext getKeyWriteContext(long address) {
        int keyLength = this.storageArea.readInt((int)address + 4);
        return this.getWriteContext((int)address + 12, keyLength);
    }

    @Override
    public ByteBuffer readValueBuffer(long address) {
        int keyLength = this.storageArea.readInt((int)address + 4);
        int valueLength = this.storageArea.readInt((int)address + 8);
        return this.storageArea.readBuffer((int)address + 12 + keyLength, valueLength).asReadOnlyBuffer();
    }

    @Override
    protected WriteContext getValueWriteContext(long address) {
        int keyLength = this.storageArea.readInt((int)address + 4);
        int valueLength = this.storageArea.readInt((int)address + 8);
        return this.getWriteContext((int)address + 12 + keyLength, valueLength);
    }

    private WriteContext getWriteContext(final int address, final int max) {
        return new WriteContext(){

            @Override
            public void setLong(int offset, long value) {
                if (offset < 0 || offset > max) {
                    throw new IllegalArgumentException();
                }
                OffHeapBufferStorageEngine.this.storageArea.writeLong(address + offset, value);
            }

            @Override
            public void flush() {
            }
        };
    }

    @Override
    protected Long writeMappingBuffers(ByteBuffer keyBuffer, ByteBuffer valueBuffer, int hash) {
        int valueLength;
        int keyLength = keyBuffer.remaining();
        int address = this.storageArea.allocate(keyLength + (valueLength = valueBuffer.remaining()) + 12);
        if (address >= 0) {
            this.storageArea.writeInt(address + 0, hash);
            this.storageArea.writeInt(address + 4, keyLength);
            this.storageArea.writeInt(address + 8, valueLength);
            this.storageArea.writeBuffer(address + 12, keyBuffer);
            this.storageArea.writeBuffer(address + 12 + keyLength, valueBuffer);
            return 0xFFFFFFFFL & (long)address;
        }
        return null;
    }

    @Override
    protected Long writeMappingBuffersGathering(ByteBuffer[] keyBuffers, ByteBuffer[] valueBuffers, int hash) {
        int valueLength;
        int keyLength = OffHeapBufferStorageEngine.dataLength(keyBuffers);
        int address = this.storageArea.allocate(keyLength + (valueLength = OffHeapBufferStorageEngine.dataLength(valueBuffers)) + 12);
        if (address >= 0) {
            this.storageArea.writeInt(address + 0, hash);
            this.storageArea.writeInt(address + 4, keyLength);
            this.storageArea.writeInt(address + 8, valueLength);
            this.storageArea.writeBuffers(address + 12, keyBuffers);
            this.storageArea.writeBuffers(address + 12 + keyLength, valueBuffers);
            return 0xFFFFFFFFL & (long)address;
        }
        return null;
    }

    @Override
    public long getAllocatedMemory() {
        return this.storageArea.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.storageArea.getOccupiedMemory();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OffHeapBufferStorageEngine ");
        sb.append("allocated=").append(DebuggingUtils.toBase2SuffixedString(this.getAllocatedMemory())).append("B ");
        sb.append("occupied=").append(DebuggingUtils.toBase2SuffixedString(this.getOccupiedMemory())).append("B\n");
        sb.append("Storage Area: ").append(this.storageArea);
        return sb.toString();
    }

    @Override
    public void destroy() {
        this.storageArea.destroy();
    }

    @Override
    public boolean shrink() {
        return this.storageArea.shrink();
    }

    @Override
    public boolean evictAtAddress(int address) {
        int hash = this.storageArea.readInt(address + 0);
        int slot = this.owner.getSlotForHashAndEncoding(hash, 0xFFFFFFFFL & (long)address, -1L);
        return this.owner.evict(slot, true);
    }

    @Override
    public boolean isThief() {
        return this.owner.isThiefForTableAllocations();
    }

    @Override
    public byte[] readBinary(long encoding) {
        int keyLength = this.storageArea.readInt((int)encoding + 4);
        int valueLength = this.storageArea.readInt((int)encoding + 8);
        ByteBuffer data = this.storageArea.readBuffer((int)encoding, 12 + keyLength + valueLength);
        return OffHeapBufferStorageEngine.toByteArray(data);
    }

    @Override
    public int readPojoHash(long encoding) {
        return this.storageArea.readInt((int)encoding + 0);
    }

    @Override
    public Long writeBinary(byte[] binary, int hash, int metadata) {
        int address = this.storageArea.allocate(binary.length);
        if (address >= 0) {
            this.storageArea.writeBuffer(address, ByteBuffer.wrap(binary));
            return 0xFFFFFFFFL & (long)address;
        }
        return null;
    }

    private static byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            if (array.length == buffer.capacity()) {
                return array;
            }
            byte[] copy = new byte[buffer.capacity()];
            System.arraycopy(array, buffer.arrayOffset(), copy, 0, buffer.capacity());
            return copy;
        }
        byte[] copy = new byte[buffer.capacity()];
        buffer.clear();
        buffer.get(copy);
        return copy;
    }
}

