/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.pinning;

import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.pinning.CompoundPinnableStorageEngine;
import com.terracottatech.offheapstore.storage.BinaryStorageEngine;
import com.terracottatech.offheapstore.storage.BooleanHalfStorageEngine;
import com.terracottatech.offheapstore.storage.OffHeapBufferHalfStorageEngine;
import com.terracottatech.offheapstore.storage.OffHeapBufferStorageEngine;
import com.terracottatech.offheapstore.storage.SplitStorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.restartable.RestartableDelegateStorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class PinnableOffHeapBufferStorageEngine<K, V>
extends CompoundPinnableStorageEngine<K, V>
implements RestartableDelegateStorageEngine,
BinaryStorageEngine<K, V> {
    private final StorageEngine<K, Boolean> pinnedKeyEngine;

    public static <K, V> Factory<PinnableOffHeapBufferStorageEngine<K, V>> createFactory(PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        return PinnableOffHeapBufferStorageEngine.createFactory(source, pageSize, keyPortability, valuePortability, false, false);
    }

    public static <K, V> Factory<PinnableOffHeapBufferStorageEngine<K, V>> createFactory(final PageSource source, final int pageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim) {
        return new Factory<PinnableOffHeapBufferStorageEngine<K, V>>(){

            @Override
            public PinnableOffHeapBufferStorageEngine<K, V> newInstance() {
                return new PinnableOffHeapBufferStorageEngine(source, pageSize, keyPortability, valuePortability, thief, victim);
            }
        };
    }

    public PinnableOffHeapBufferStorageEngine(PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this(source, pageSize, keyPortability, valuePortability, false, false);
    }

    public PinnableOffHeapBufferStorageEngine(PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        super(new OffHeapBufferStorageEngine<K, V>(source, pageSize, keyPortability, valuePortability, thief, victim), new OffHeapBufferStorageEngine<K, V>(source, pageSize, keyPortability, valuePortability, true, false));
        OffHeapBufferHalfStorageEngine<? super K> keyEngine = new OffHeapBufferHalfStorageEngine<K>(source, pageSize, keyPortability, true, false);
        this.pinnedKeyEngine = new SplitStorageEngine<K, Boolean>(keyEngine, BooleanHalfStorageEngine.INSTANCE);
    }

    @Override
    public StorageEngine<K, Boolean> getPinnedKeyEngine() {
        return this.pinnedKeyEngine;
    }

    @Override
    public ByteBuffer readBinaryKey(long encoding) {
        return ((RestartableDelegateStorageEngine)((Object)this.getStorageEngineForEncoding(encoding))).readBinaryKey(this.getEncoding(encoding));
    }

    @Override
    public ByteBuffer readBinaryValue(long encoding) {
        return ((RestartableDelegateStorageEngine)((Object)this.getStorageEngineForEncoding(encoding))).readBinaryValue(this.getEncoding(encoding));
    }

    @Override
    public boolean equalsBinaryKey(ByteBuffer probeKey, long encoding) {
        return ((RestartableDelegateStorageEngine)((Object)this.getStorageEngineForEncoding(encoding))).equalsBinaryKey(probeKey, this.getEncoding(encoding));
    }

    @Override
    public int readPojoHash(long encoding) {
        return ((RestartableDelegateStorageEngine)((Object)this.getStorageEngineForEncoding(encoding))).readPojoHash(this.getEncoding(encoding));
    }

    @Override
    public Long writeBinaryMapping(ByteBuffer[] binaryKey, ByteBuffer[] binaryValue, int pojoHash, int metadata) {
        BinaryStorageEngine engine = this.getStorageEngineForMetadata(metadata);
        Long rawEncoding = ((RestartableDelegateStorageEngine)((Object)engine)).writeBinaryMapping(binaryKey, binaryValue, pojoHash, metadata);
        try {
            return this.getEncodingForMetadata(metadata, rawEncoding);
        }
        catch (IllegalArgumentException e) {
            engine.freeMapping(rawEncoding, pojoHash, false);
            return null;
        }
    }

    @Override
    public Lock readLock() {
        return ((ReadWriteLock)((Object)this.normalEngine)).readLock();
    }

    @Override
    public Lock writeLock() {
        return ((ReadWriteLock)((Object)this.normalEngine)).writeLock();
    }
}

