/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.transaction;

import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionCodec;
import com.terracottatech.frs.action.ActionFactory;
import com.terracottatech.frs.action.InvalidatingAction;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.transaction.TransactionAction;
import com.terracottatech.frs.transaction.TransactionHandle;
import com.terracottatech.frs.transaction.TransactionHandleImpl;
import com.terracottatech.frs.transaction.TransactionLSNCallback;
import com.terracottatech.frs.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;

class TransactionalAction
implements InvalidatingAction,
TransactionAction {
    public static final ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer> FACTORY = new ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer>(){

        @Override
        public Action create(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, ActionCodec codec, ByteBuffer[] buffers) {
            return new TransactionalAction(TransactionHandleImpl.withByteBuffers(buffers), ByteBufferUtils.get(buffers), codec.decode(buffers));
        }
    };
    private static final byte COMMIT_BIT = 1;
    private static final byte BEGIN_BIT = 2;
    private final TransactionHandle handle;
    private final Action action;
    private final byte mode;
    private final TransactionLSNCallback callback;

    TransactionalAction(TransactionHandle handle, byte mode, Action action) {
        this.handle = handle;
        this.action = action;
        this.mode = mode;
        this.callback = null;
    }

    TransactionalAction(TransactionHandle handle, boolean begin, boolean commit, Action action, TransactionLSNCallback callback) {
        this.handle = handle;
        this.action = action;
        byte tempMode = 0;
        if (commit) {
            tempMode = (byte)(tempMode | 1);
        }
        if (begin) {
            tempMode = (byte)(tempMode | 2);
        }
        this.mode = tempMode;
        this.callback = callback;
    }

    @Override
    public boolean isCommit() {
        return (this.mode & 1) != 0;
    }

    @Override
    public boolean isBegin() {
        return (this.mode & 2) != 0;
    }

    @Override
    public TransactionHandle getHandle() {
        return this.handle;
    }

    Action getAction() {
        return this.action;
    }

    @Override
    public Set<Long> getInvalidatedLsns() {
        if (this.action instanceof InvalidatingAction) {
            return ((InvalidatingAction)this.action).getInvalidatedLsns();
        }
        return Collections.emptySet();
    }

    @Override
    public void record(long lsn) {
        assert (this.callback != null);
        this.action.record(lsn);
        this.callback.setLsn(lsn);
    }

    @Override
    public void replay(long lsn) {
        this.action.replay(lsn);
    }

    @Override
    public ByteBuffer[] getPayload(ActionCodec codec) {
        ByteBuffer handleBuffer = this.handle.toByteBuffer();
        ByteBuffer header = ByteBuffer.allocate(handleBuffer.capacity() + 1);
        header.put(handleBuffer).put(this.mode).flip();
        return ByteBufferUtils.concatenate(header, codec.encode(this.action));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionalAction that = (TransactionalAction)o;
        return this.handle.equals(that.handle) && this.action.equals(that.action) && this.mode == that.mode;
    }

    public int hashCode() {
        int result = this.handle != null ? this.handle.hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TransactionalAction{handle=" + this.handle + ", action=" + this.action + ", mode=" + this.mode + '}';
    }
}

