/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.GlobalBufferSource;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ManualBufferSource
implements BufferSource {
    private final BufferSource parent;
    private final long maxCapacity;
    private long usage = 0L;
    private int created = 0;
    private int allocated = 0;
    private int min = Integer.MAX_VALUE;
    private int max = 0;
    private int fails = 0;
    private int failedAllocation = 0;
    private final ArrayList<BufferWrapper> pool = new ArrayList();

    public ManualBufferSource(long maxCapacity) {
        this.parent = GlobalBufferSource.getInstance(this, maxCapacity);
        this.maxCapacity = maxCapacity;
    }

    public ManualBufferSource(BufferSource parent, long maxCapacity) {
        this.parent = parent;
        this.maxCapacity = maxCapacity;
    }

    @Override
    public synchronized ByteBuffer getBuffer(int size) {
        if (this.min > size) {
            this.min = size;
        }
        if (this.max < size) {
            this.max = size;
        }
        if (size < 1024) {
            return ByteBuffer.allocate(size);
        }
        if ((long)size + this.usage > this.maxCapacity) {
            ++this.fails;
            return null;
        }
        ByteBuffer base = this.parent.getBuffer(size);
        if (base == null) {
            base = this.performAllocation(size);
            if (base == null) {
                ++this.failedAllocation;
            } else {
                this.allocated += base.capacity();
                ++this.created;
            }
        }
        if (base != null) {
            base.clear();
            if (base.remaining() != size) {
                base.limit(size);
            }
            BufferWrapper wrap = new BufferWrapper(base);
            assert (!this.pool.contains(wrap));
            this.pool.add(wrap);
            this.usage += (long)base.capacity();
        }
        return base;
    }

    protected ByteBuffer performAllocation(int size) {
        try {
            int allocate = Math.round((float)size * 1.05f);
            if (allocate < 65536) {
                allocate = 65536;
            }
            ByteBuffer base = ByteBuffer.allocateDirect(allocate);
            return base;
        }
        catch (OutOfMemoryError err) {
            this.parent.reclaim();
            return null;
        }
    }

    @Override
    public synchronized void reclaim() {
        if (this.parent != null) {
            this.parent.reclaim();
        }
    }

    private long calculateUsage() {
        long val = 0L;
        for (BufferWrapper buffer : this.pool) {
            val += (long)buffer.capacity();
        }
        return val;
    }

    @Override
    public synchronized void returnBuffer(ByteBuffer buffer) {
        assert (buffer != null);
        if (this.pool.remove(new BufferWrapper(buffer))) {
            assert (!this.pool.contains(new BufferWrapper(buffer)));
            this.usage -= (long)buffer.capacity();
            assert (this.usage == this.calculateUsage());
            this.parent.returnBuffer(buffer);
        }
    }

    public String toString() {
        return "buffer pool created: " + this.created + " bytes held: " + this.usage + " capacity: " + this.maxCapacity + " min: " + this.min + " max: " + this.max + " overcommit: " + this.fails + " allocated: " + this.allocated + " failedAlloc: " + this.failedAllocation + " size: " + this.pool.size();
    }

    static class BufferWrapper {
        private final ByteBuffer check;

        BufferWrapper(ByteBuffer eq) {
            this.check = eq;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BufferWrapper) {
                return ((BufferWrapper)obj).check == this.check;
            }
            return super.equals(obj);
        }

        public int capacity() {
            return this.check.capacity();
        }
    }
}

