/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.search.similarities;

import org.terracotta.shaded.lucene.index.FieldInvertState;
import org.terracotta.shaded.lucene.index.Norm;
import org.terracotta.shaded.lucene.search.similarities.TFIDFSimilarity;
import org.terracotta.shaded.lucene.util.BytesRef;

public class DefaultSimilarity
extends TFIDFSimilarity {
    protected boolean discountOverlaps = true;

    @Override
    public float coord(int overlap, int maxOverlap) {
        return (float)overlap / (float)maxOverlap;
    }

    @Override
    public float queryNorm(float sumOfSquaredWeights) {
        return (float)(1.0 / Math.sqrt(sumOfSquaredWeights));
    }

    @Override
    public void computeNorm(FieldInvertState state, Norm norm) {
        int numTerms = this.discountOverlaps ? state.getLength() - state.getNumOverlap() : state.getLength();
        norm.setByte(this.encodeNormValue(state.getBoost() * (float)(1.0 / Math.sqrt(numTerms))));
    }

    @Override
    public float tf(float freq) {
        return (float)Math.sqrt(freq);
    }

    @Override
    public float sloppyFreq(int distance) {
        return 1.0f / (float)(distance + 1);
    }

    @Override
    public float scorePayload(int doc, int start, int end, BytesRef payload) {
        return 1.0f;
    }

    @Override
    public float idf(long docFreq, long numDocs) {
        return (float)(Math.log((double)numDocs / (double)(docFreq + 1L)) + 1.0);
    }

    public void setDiscountOverlaps(boolean v) {
        this.discountOverlaps = v;
    }

    public boolean getDiscountOverlaps() {
        return this.discountOverlaps;
    }

    public String toString() {
        return "DefaultSimilarity";
    }
}

