/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.codecs.lucene40;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.terracotta.shaded.lucene.codecs.CodecUtil;
import org.terracotta.shaded.lucene.codecs.PostingsWriterBase;
import org.terracotta.shaded.lucene.codecs.TermStats;
import org.terracotta.shaded.lucene.codecs.lucene40.Lucene40SkipListWriter;
import org.terracotta.shaded.lucene.index.CorruptIndexException;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.IndexFileNames;
import org.terracotta.shaded.lucene.index.SegmentWriteState;
import org.terracotta.shaded.lucene.store.IndexOutput;
import org.terracotta.shaded.lucene.store.RAMOutputStream;
import org.terracotta.shaded.lucene.util.BytesRef;
import org.terracotta.shaded.lucene.util.IOUtils;

public final class Lucene40PostingsWriter
extends PostingsWriterBase {
    static final String TERMS_CODEC = "Lucene40PostingsWriterTerms";
    static final String FRQ_CODEC = "Lucene40PostingsWriterFrq";
    static final String PRX_CODEC = "Lucene40PostingsWriterPrx";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    final IndexOutput freqOut;
    final IndexOutput proxOut;
    final Lucene40SkipListWriter skipListWriter;
    static final int DEFAULT_SKIP_INTERVAL = 16;
    final int skipInterval;
    final int skipMinimum;
    final int maxSkipLevels = 10;
    final int totalNumDocs;
    IndexOutput termsOut;
    FieldInfo.IndexOptions indexOptions;
    boolean storePayloads;
    boolean storeOffsets;
    long freqStart;
    long proxStart;
    FieldInfo fieldInfo;
    int lastPayloadLength;
    int lastOffsetLength;
    int lastPosition;
    int lastOffset;
    int lastDocID;
    int df;
    private final List<PendingTerm> pendingTerms;
    private final RAMOutputStream bytesWriter;

    public Lucene40PostingsWriter(SegmentWriteState state) throws IOException {
        this(state, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Lucene40PostingsWriter(SegmentWriteState state, int skipInterval) throws IOException {
        IndexOutput proxOut;
        block5: {
            this.maxSkipLevels = 10;
            this.pendingTerms = new ArrayList<PendingTerm>();
            this.bytesWriter = new RAMOutputStream();
            this.skipInterval = skipInterval;
            this.skipMinimum = skipInterval;
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "frq");
            this.freqOut = state.directory.createOutput(fileName, state.context);
            boolean success = false;
            proxOut = null;
            try {
                CodecUtil.writeHeader(this.freqOut, FRQ_CODEC, 0);
                if (state.fieldInfos.hasProx()) {
                    fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "prx");
                    proxOut = state.directory.createOutput(fileName, state.context);
                    CodecUtil.writeHeader(proxOut, PRX_CODEC, 0);
                } else {
                    proxOut = null;
                }
                this.proxOut = proxOut;
                success = true;
                if (success) break block5;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(this.freqOut, proxOut);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.freqOut, proxOut);
        }
        this.totalNumDocs = state.segmentInfo.getDocCount();
        this.skipListWriter = new Lucene40SkipListWriter(skipInterval, 10, this.totalNumDocs, this.freqOut, proxOut);
    }

    @Override
    public void start(IndexOutput termsOut) throws IOException {
        this.termsOut = termsOut;
        CodecUtil.writeHeader(termsOut, TERMS_CODEC, 0);
        termsOut.writeInt(this.skipInterval);
        termsOut.writeInt(10);
        termsOut.writeInt(this.skipMinimum);
    }

    @Override
    public void startTerm() {
        this.freqStart = this.freqOut.getFilePointer();
        if (this.proxOut != null) {
            this.proxStart = this.proxOut.getFilePointer();
        }
        this.lastPayloadLength = -1;
        this.lastOffsetLength = -1;
        this.skipListWriter.resetSkip();
    }

    @Override
    public void setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.indexOptions = fieldInfo.getIndexOptions();
        this.storeOffsets = this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        this.storePayloads = fieldInfo.hasPayloads();
    }

    @Override
    public void startDoc(int docID, int termDocFreq) throws IOException {
        int delta = docID - this.lastDocID;
        if (docID < 0 || this.df > 0 && delta <= 0) {
            throw new CorruptIndexException("docs out of order (" + docID + " <= " + this.lastDocID + " ) (freqOut: " + this.freqOut + ")");
        }
        if (++this.df % this.skipInterval == 0) {
            this.skipListWriter.setSkipData(this.lastDocID, this.storePayloads, this.lastPayloadLength, this.storeOffsets, this.lastOffsetLength);
            this.skipListWriter.bufferSkip(this.df);
        }
        assert (docID < this.totalNumDocs) : "docID=" + docID + " totalNumDocs=" + this.totalNumDocs;
        this.lastDocID = docID;
        if (this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY) {
            this.freqOut.writeVInt(delta);
        } else if (1 == termDocFreq) {
            this.freqOut.writeVInt(delta << 1 | 1);
        } else {
            this.freqOut.writeVInt(delta << 1);
            this.freqOut.writeVInt(termDocFreq);
        }
        this.lastPosition = 0;
        this.lastOffset = 0;
    }

    @Override
    public void addPosition(int position, BytesRef payload, int startOffset, int endOffset) throws IOException {
        assert (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) : "invalid indexOptions: " + (Object)((Object)this.indexOptions);
        assert (this.proxOut != null);
        int delta = position - this.lastPosition;
        assert (delta >= 0) : "position=" + position + " lastPosition=" + this.lastPosition;
        this.lastPosition = position;
        int payloadLength = 0;
        if (this.storePayloads) {
            int n = payloadLength = payload == null ? 0 : payload.length;
            if (payloadLength != this.lastPayloadLength) {
                this.lastPayloadLength = payloadLength;
                this.proxOut.writeVInt(delta << 1 | 1);
                this.proxOut.writeVInt(payloadLength);
            } else {
                this.proxOut.writeVInt(delta << 1);
            }
        } else {
            this.proxOut.writeVInt(delta);
        }
        if (this.storeOffsets) {
            int offsetDelta = startOffset - this.lastOffset;
            int offsetLength = endOffset - startOffset;
            assert (offsetDelta >= 0 && offsetLength >= 0) : "startOffset=" + startOffset + ",lastOffset=" + this.lastOffset + ",endOffset=" + endOffset;
            if (offsetLength != this.lastOffsetLength) {
                this.proxOut.writeVInt(offsetDelta << 1 | 1);
                this.proxOut.writeVInt(offsetLength);
            } else {
                this.proxOut.writeVInt(offsetDelta << 1);
            }
            this.lastOffset = startOffset;
            this.lastOffsetLength = offsetLength;
        }
        if (payloadLength > 0) {
            this.proxOut.writeBytes(payload.bytes, payload.offset, payloadLength);
        }
    }

    @Override
    public void finishDoc() {
    }

    @Override
    public void finishTerm(TermStats stats) throws IOException {
        assert (stats.docFreq > 0);
        assert (stats.docFreq == this.df);
        int skipOffset = this.df >= this.skipMinimum ? (int)(this.skipListWriter.writeSkip(this.freqOut) - this.freqStart) : -1;
        this.pendingTerms.add(new PendingTerm(this.freqStart, this.proxStart, skipOffset));
        this.lastDocID = 0;
        this.df = 0;
    }

    @Override
    public void flushTermsBlock(int start, int count) throws IOException {
        if (count == 0) {
            this.termsOut.writeByte((byte)0);
            return;
        }
        assert (start <= this.pendingTerms.size());
        assert (count <= start);
        int limit = this.pendingTerms.size() - start + count;
        PendingTerm firstTerm = this.pendingTerms.get(limit - count);
        this.bytesWriter.writeVLong(firstTerm.freqStart);
        if (firstTerm.skipOffset != -1) {
            assert (firstTerm.skipOffset > 0);
            this.bytesWriter.writeVInt(firstTerm.skipOffset);
        }
        if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            this.bytesWriter.writeVLong(firstTerm.proxStart);
        }
        long lastFreqStart = firstTerm.freqStart;
        long lastProxStart = firstTerm.proxStart;
        for (int idx = limit - count + 1; idx < limit; ++idx) {
            PendingTerm term = this.pendingTerms.get(idx);
            this.bytesWriter.writeVLong(term.freqStart - lastFreqStart);
            lastFreqStart = term.freqStart;
            if (term.skipOffset != -1) {
                assert (term.skipOffset > 0);
                this.bytesWriter.writeVInt(term.skipOffset);
            }
            if (this.indexOptions.compareTo(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) continue;
            this.bytesWriter.writeVLong(term.proxStart - lastProxStart);
            lastProxStart = term.proxStart;
        }
        this.termsOut.writeVInt((int)this.bytesWriter.getFilePointer());
        this.bytesWriter.writeTo(this.termsOut);
        this.bytesWriter.reset();
        this.pendingTerms.subList(limit - count, limit).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.freqOut.close();
        }
        finally {
            if (this.proxOut != null) {
                this.proxOut.close();
            }
        }
    }

    private static class PendingTerm {
        public final long freqStart;
        public final long proxStart;
        public final int skipOffset;

        public PendingTerm(long freqStart, long proxStart, int skipOffset) {
            this.freqStart = freqStart;
            this.proxStart = proxStart;
            this.skipOffset = skipOffset;
        }
    }
}

