/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.restartability;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.RestartStoreException;
import com.terracottatech.frs.RestartStoreFactory;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.RegisterableObjectManager;
import com.terracottatech.frs.object.RestartableObject;
import com.terracottatech.frs.recovery.RecoveryException;
import com.terracottatech.offheapstore.storage.portability.SerializablePortability;
import com.terracottatech.offheapstore.storage.restartable.portability.RestartableSerializablePortability;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.DiskStorePathManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.generator.ConfigurationUtil;
import net.sf.ehcache.store.restartability.ConfigurationRules;
import net.sf.ehcache.store.restartability.ControlledTransactionRestartStore;
import net.sf.ehcache.store.restartability.EhcacheObjectManager;
import net.sf.ehcache.store.restartability.RestartableStringMap;
import net.sf.ehcache.store.restartability.RestartableTransactionIDFactory;
import net.sf.ehcache.util.LongSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheRestartability {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheObjectManager.class);
    private static final String BASE_DIRECTORY = "persistence";
    private static final String METADATA_DIRECTORY = "metadata";
    private static final String CACHE_DIRECTORY = "cachedata";
    private static final String PORTABILITY_IDENTIFIER = "portability";
    private static final String CACHES_IDENTIFIER = "caches";
    private static final String ELEMENT_ID_SEQUENCES = "element-id-sequences";
    private static final String TRANSACTIONS_IDENTIFIER = "__transactions__";
    private static final String CACHE_PREFIX = "__cache__";
    private static final String PINNING_PREFIX = "__pinning__";
    private static final String WRITE_BEHIND_PREFIX = "__writebehind__";
    private static final String SOFT_LOCK_PREFIX = "__softlock__";
    private final CopyOnWriteArrayList<Runnable> startupCallbacks = new CopyOnWriteArrayList();
    private final RegisterableObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> metadataObjectManager = new RegisterableObjectManager();
    private final EhcacheObjectManager cacheObjectManager = new EhcacheObjectManager();
    private final CacheManager cacheManager;
    private final Map<String, String> newCacheConfigs = new HashMap<String, String>();
    private final Map<ByteBuffer, ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer>> newCacheStripes = new HashMap<ByteBuffer, ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer>>();
    private boolean started;
    private ControlledTransactionRestartStore<ByteBuffer, ByteBuffer, ByteBuffer> cacheStore;
    private RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> metadataStore;
    private RestartableSerializablePortability<ByteBuffer> restartablePortability;
    private RestartableStringMap restartableCaches;
    private RestartableTransactionIDFactory restartableTransactions;
    private RestartableStringMap elementIdSequences;

    public EhcacheRestartability(CacheManager manager) {
        this.cacheManager = manager;
    }

    public synchronized boolean bootstrapped() {
        return this.started && this.cacheStore != null;
    }

    public synchronized void startup() {
        if (this.cacheManager.getDiskStorePathManager().resolveAndLockIfExists(BASE_DIRECTORY)) {
            this.constructRestartability();
        }
        this.bootstrapRestartability();
        this.started = true;
        for (Runnable callback : this.startupCallbacks) {
            callback.run();
        }
        this.startupCallbacks.clear();
    }

    public synchronized void shutdown() {
        if (this.metadataStore != null) {
            EhcacheRestartability.shutdownStore(this.metadataStore);
        }
        if (this.cacheStore != null) {
            EhcacheRestartability.shutdownStore(this.cacheStore);
        }
    }

    public synchronized SerializablePortability getRestartablePortability() {
        this.constructRestartability();
        return this.restartablePortability;
    }

    public synchronized RestartableTransactionIDFactory getTransactionIDFactory() {
        this.constructRestartability();
        return this.restartableTransactions;
    }

    public synchronized LongSequence getElementIdSequence(String cacheName) {
        this.constructRestartability();
        return new RestartableElementIdSequence(this, cacheName);
    }

    private long getNextElementIdBatch(String cacheName, long batchSize) {
        String value = (String)this.elementIdSequences.get(cacheName);
        long next = value == null ? 1L + batchSize : Long.valueOf(value) + batchSize;
        this.elementIdSequences.put(cacheName, String.valueOf(next));
        return next;
    }

    public synchronized RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> getCacheStore() {
        this.constructRestartability();
        return this.cacheStore;
    }

    public synchronized void registerCacheStripe(ByteBuffer identifier, Configuration config, CacheConfiguration cacheConfig, ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer> objectManager) {
        String existingXml = (String)this.restartableCaches.get(cacheConfig.getName());
        if (existingXml == null) {
            String name = cacheConfig.getName();
            String configXml = ConfigurationUtil.generateCacheConfigurationText(config, cacheConfig);
            if (this.bootstrapped()) {
                this.restartableCaches.put(name, configXml);
                this.cacheObjectManager.registerStripe(identifier, objectManager);
            } else {
                this.newCacheConfigs.put(name, configXml);
                this.newCacheStripes.put(identifier, objectManager);
            }
        } else {
            CacheConfiguration existing = ConfigurationFactory.parseCacheConfiguration(existingXml);
            ConfigurationRules.validateConfig(existing, cacheConfig);
            this.cacheObjectManager.registerStripe(identifier, objectManager);
        }
    }

    public synchronized void registerRestartableCacheObject(RestartableObject<ByteBuffer, ByteBuffer, ByteBuffer> restartableObject) {
        this.cacheObjectManager.registerObject(restartableObject);
    }

    private void registerNewCaches() {
        this.restartableCaches.putAll(this.newCacheConfigs);
        for (Map.Entry<ByteBuffer, ObjectManagerStripe<ByteBuffer, ByteBuffer, ByteBuffer>> e : this.newCacheStripes.entrySet()) {
            this.cacheObjectManager.registerStripe(e.getKey(), e.getValue());
        }
    }

    private void constructRestartability() {
        if (this.cacheStore == null) {
            DiskStorePathManager diskPathManager = this.cacheManager.getDiskStorePathManager();
            File baseLogDirectory = diskPathManager.getFile(BASE_DIRECTORY);
            if (diskPathManager.isAutoCreated()) {
                throw new InvalidConfigurationException("The disk path for this cache manager has been auto-generated due to a path conflict with another cache manager. You must define a specific unique disk path for this manager in order to use restartable caches.");
            }
            if (diskPathManager.isDefault()) {
                throw new InvalidConfigurationException("The disk path for this cache manager is the default path. You must define a specific unique disk path for this manager in order to use restartable caches.");
            }
            this.metadataStore = this.createMetadataStore(new File(baseLogDirectory, METADATA_DIRECTORY));
            this.cacheStore = this.createCacheStore(new File(baseLogDirectory, CACHE_DIRECTORY));
            ByteBuffer portabilityIdentifier = EhcacheRestartability.toByteBuffer(PORTABILITY_IDENTIFIER);
            this.restartablePortability = new RestartableSerializablePortability<ByteBuffer>(portabilityIdentifier, this.metadataStore, true);
            this.metadataObjectManager.registerStripe(portabilityIdentifier, this.restartablePortability);
            this.restartableCaches = new RestartableStringMap(EhcacheRestartability.toByteBuffer(CACHES_IDENTIFIER), this.metadataStore);
            this.metadataObjectManager.registerObject(this.restartableCaches);
            this.restartableTransactions = new RestartableTransactionIDFactory(this);
            this.elementIdSequences = new RestartableStringMap(EhcacheRestartability.toByteBuffer(ELEMENT_ID_SEQUENCES), this.metadataStore);
            this.metadataObjectManager.registerObject(this.elementIdSequences);
            EhcacheRestartability.startStore(this.metadataStore);
            if (this.started) {
                this.bootstrapRestartability();
            }
        }
    }

    private void bootstrapRestartability() {
        if (this.cacheStore != null) {
            for (Map.Entry cache : this.restartableCaches.entrySet()) {
                CacheConfiguration existing = ConfigurationFactory.parseCacheConfiguration((String)cache.getValue());
                Ehcache current = this.cacheManager.getEhcache((String)cache.getKey());
                if (current == null) {
                    LOGGER.info("Auto-creating missing restartable cache '{}' using configuration : \n{}", cache.getKey(), cache.getValue());
                    this.cacheManager.addCache(new Cache(existing));
                    continue;
                }
                ConfigurationRules.validateConfig(existing, current.getCacheConfiguration());
            }
            EhcacheRestartability.startStore(this.cacheStore);
            this.registerNewCaches();
        }
    }

    private RestartStore<ByteBuffer, ByteBuffer, ByteBuffer> createMetadataStore(File logDirectory) {
        logDirectory.mkdirs();
        Properties properties = new Properties();
        try {
            return RestartStoreFactory.createStore(this.metadataObjectManager, logDirectory, properties);
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
        catch (RestartStoreException e) {
            throw new CacheException(e);
        }
    }

    private ControlledTransactionRestartStore<ByteBuffer, ByteBuffer, ByteBuffer> createCacheStore(File logDirectory) {
        logDirectory.mkdirs();
        Properties properties = new Properties();
        try {
            return new ControlledTransactionRestartStore<ByteBuffer, ByteBuffer, ByteBuffer>(RestartStoreFactory.createStore((ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer>)this.cacheObjectManager, logDirectory, properties));
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
        catch (RestartStoreException e) {
            throw new CacheException(e);
        }
    }

    private static void startStore(RestartStore<?, ?, ?> store) {
        try {
            store.startup().get();
        }
        catch (RecoveryException e) {
            throw new CacheException(e);
        }
        catch (InterruptedException e) {
            throw new CacheException(e);
        }
        catch (ExecutionException e) {
            throw new CacheException(e.getCause());
        }
    }

    private static void shutdownStore(RestartStore<?, ?, ?> store) {
        try {
            store.shutdown();
        }
        catch (InterruptedException e) {
            throw new CacheException(e);
        }
    }

    public static ByteBuffer getTransactionsIdentifier() {
        return EhcacheRestartability.toByteBuffer(TRANSACTIONS_IDENTIFIER);
    }

    public static ByteBuffer getCacheIdentifier(String cacheName) {
        return EhcacheRestartability.toByteBuffer(CACHE_PREFIX + cacheName);
    }

    public static boolean isCacheIdentifier(ByteBuffer identifier) {
        return identifier.asCharBuffer().toString().startsWith(CACHE_PREFIX);
    }

    public static ByteBuffer getCachePinningIdentifier(String cacheName) {
        return EhcacheRestartability.toByteBuffer(PINNING_PREFIX + cacheName);
    }

    public static boolean isPinningIdentifier(ByteBuffer identifier) {
        return identifier.asCharBuffer().toString().startsWith(PINNING_PREFIX);
    }

    public static ByteBuffer getWriteBehindIdentifier(String cacheName, int index) {
        return EhcacheRestartability.toByteBuffer(WRITE_BEHIND_PREFIX + index + "__" + cacheName);
    }

    public static boolean isWriteBehindIdentifier(ByteBuffer identifier) {
        return identifier.asCharBuffer().toString().startsWith(WRITE_BEHIND_PREFIX);
    }

    public static ByteBuffer getSoftLockIdentifier(String cacheName) {
        return EhcacheRestartability.toByteBuffer(SOFT_LOCK_PREFIX + cacheName);
    }

    public static boolean isSoftLockIdentifier(ByteBuffer identifier) {
        return identifier.asCharBuffer().toString().startsWith(SOFT_LOCK_PREFIX);
    }

    public static String getCacheNameFor(ByteBuffer identifier) {
        String writeBehindName;
        String[] components;
        String stringIdentifier = identifier.asCharBuffer().toString();
        if (EhcacheRestartability.isCacheIdentifier(identifier)) {
            return stringIdentifier.substring(CACHE_PREFIX.length());
        }
        if (EhcacheRestartability.isPinningIdentifier(identifier)) {
            return stringIdentifier.substring(PINNING_PREFIX.length());
        }
        if (EhcacheRestartability.isSoftLockIdentifier(identifier)) {
            return stringIdentifier.substring(SOFT_LOCK_PREFIX.length());
        }
        if (EhcacheRestartability.isWriteBehindIdentifier(identifier) && (components = (writeBehindName = stringIdentifier.substring(WRITE_BEHIND_PREFIX.length())).split("__", 2)).length == 2) {
            return components[1];
        }
        throw new IllegalArgumentException("Unexpected identifier : " + stringIdentifier);
    }

    public static ByteBuffer toByteBuffer(String string) {
        ByteBuffer buffer = ByteBuffer.allocate(string.length() * 2);
        buffer.asCharBuffer().put(string);
        return buffer;
    }

    public void beginCacheStoreTransaction(boolean synchronous) {
        this.cacheStore.beginControlledTransaction(synchronous);
    }

    public void commitCacheStoreTransaction() throws TransactionException {
        this.cacheStore.commitControlledTransaction();
    }

    public void callbackOnStartupComplete(Runnable callback) {
        if (this.started) {
            callback.run();
        } else {
            this.startupCallbacks.add(callback);
        }
    }

    private static class RestartableElementIdSequence
    implements LongSequence {
        private static final long BATCH_SIZE = RestartableElementIdSequence.getBatchSize();
        private final AtomicLong sequence;
        private final String cacheName;
        private final EhcacheRestartability parent;
        private volatile long batchEnd;

        RestartableElementIdSequence(EhcacheRestartability parent, String cacheName) {
            this.parent = parent;
            this.cacheName = cacheName;
            this.batchEnd = this.getNextBatch();
            this.sequence = new AtomicLong(this.batchEnd - BATCH_SIZE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long next() {
            long next = this.sequence.getAndIncrement();
            if (next >= this.batchEnd) {
                RestartableElementIdSequence restartableElementIdSequence = this;
                synchronized (restartableElementIdSequence) {
                    while (next >= this.batchEnd) {
                        this.batchEnd = this.getNextBatch();
                    }
                }
            }
            return next;
        }

        private long getNextBatch() {
            return this.parent.getNextElementIdBatch(this.cacheName, RestartableElementIdSequence.BATCH_SIZE);
        }

        private static long getBatchSize() {
            long defaultBatchSize = 25000L;
            return Long.getLong(EhcacheRestartability.class.getName() + ".elementIdBatchSize", defaultBatchSize);
        }
    }
}

