/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.tiering;

import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.search.impl.SearchManager;
import net.sf.ehcache.store.CacheKeySet;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.FrontEndCacheTier;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.TierableStore;
import net.sf.ehcache.store.offheap.OffHeapStore;
import net.sf.ehcache.store.offheap.pool.impl.CrossPoolEvictionException;
import net.sf.ehcache.writer.CacheWriterManager;

public final class OnHeapFrontedOffHeapStore
extends FrontEndCacheTier<MemoryStore, OffHeapStore>
implements TierableStore {
    public OnHeapFrontedOffHeapStore(CacheConfiguration cacheConfiguration, MemoryStore cache, OffHeapStore authority, SearchManager searchManager) {
        super(cache, authority, cacheConfiguration.getCopyStrategy(), searchManager, cacheConfiguration.isCopyOnWrite(), cacheConfiguration.isCopyOnRead());
        authority.registerMasterLocks(this.getAllLocks());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fill(Element e) {
        try {
            Object key = e.getObjectKey();
            Lock lock = this.getLockFor(key).writeLock();
            lock.lock();
            try {
                Element copy = this.copyElementForWriteIfNeeded(e);
                ((MemoryStore)this.cache).fill(copy);
                ((OffHeapStore)this.authority).fill(copy);
            }
            finally {
                lock.unlock();
            }
        }
        catch (OversizeMappingException ex) {
        }
        catch (CrossPoolEvictionException crossPoolEvictionException) {
            // empty catch block
        }
    }

    @Override
    public boolean removeIfNotPinned(Object key) {
        boolean removedFromCache = ((MemoryStore)this.cache).removeIfNotPinned(key);
        boolean removedFromAuthority = ((OffHeapStore)this.authority).removeIfNotPinned(key);
        return removedFromCache || removedFromAuthority;
    }

    @Override
    public boolean put(Element e) {
        while (true) {
            try {
                return super.put(e);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(e, ex);
                continue;
            }
            catch (CrossPoolEvictionException ex) {
                this.handleCrossPoolEvictionException(e, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean putWithWriter(Element e, CacheWriterManager writer) {
        while (true) {
            try {
                return super.putWithWriter(e, writer);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(e, ex);
                continue;
            }
            catch (CrossPoolEvictionException ex) {
                this.handleCrossPoolEvictionException(e, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public Element putIfAbsent(Element e) throws NullPointerException {
        while (true) {
            try {
                return super.putIfAbsent(e);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(e, ex);
                continue;
            }
            catch (CrossPoolEvictionException ex) {
                this.handleCrossPoolEvictionException(e, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean replace(Element old, Element e, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        while (true) {
            try {
                return super.replace(old, e, comparator);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(e, ex);
                continue;
            }
            catch (CrossPoolEvictionException ex) {
                this.handleCrossPoolEvictionException(e, ex);
                continue;
            }
            break;
        }
    }

    @Override
    public Element replace(Element e) throws NullPointerException {
        while (true) {
            try {
                return super.replace(e);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(e, ex);
                continue;
            }
            catch (CrossPoolEvictionException ex) {
                this.handleCrossPoolEvictionException(e, ex);
                continue;
            }
            break;
        }
    }

    private void handleCrossPoolEvictionException(Element e, CrossPoolEvictionException cause) {
        ((OffHeapStore)this.authority).handleCrossPoolEvictionException(e, cause);
    }

    private void handleOversizeMappingException(Element e, OversizeMappingException cause) {
        ((OffHeapStore)this.authority).handleOversizeMappingException(e, cause);
    }

    @Override
    public Object getMBean() {
        return ((OffHeapStore)this.authority).getMBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNoReturn(Object key) {
        if (key != null) {
            Lock lock = this.getLockFor(key).writeLock();
            lock.lock();
            try {
                ((MemoryStore)this.cache).removeNoReturn(key);
                ((OffHeapStore)this.authority).removeNoReturn(key);
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public boolean isTierPinned() {
        return ((MemoryStore)this.cache).isTierPinned() || ((OffHeapStore)this.authority).isTierPinned();
    }

    @Override
    public Set getPresentPinnedKeys() {
        CacheKeySet cacheKeySet = new CacheKeySet(((OffHeapStore)this.authority).getPresentPinnedKeys(), ((MemoryStore)this.cache).getPresentPinnedKeys());
        return cacheKeySet;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }
}

