/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.factories;

import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.pinning.PinnableSegment;
import com.terracottatech.offheapstore.pinning.PinnableStorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import java.io.Serializable;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.FrontEndCacheTier;
import net.sf.ehcache.store.offheap.factories.EhcacheSegmentFactory;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.offheap.pool.OffHeapPoolableStore;
import net.sf.ehcache.store.offheap.util.DelegatingOffHeapPoolableStore;

public class EhcachePooledSegmentFactory
implements Factory<PinnableSegment<Serializable, Element>> {
    private final OffHeapPool pool;
    private final OffHeapPoolableStore owner;
    private final RegisteredEventListeners evictionListener;
    private final Factory<? extends PinnableStorageEngine<? super Serializable, ? super Element>> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;
    private volatile boolean pinningEnabled;
    private final boolean notify;

    public EhcachePooledSegmentFactory(OffHeapPool pool, OffHeapPoolableStore owner, RegisteredEventListeners evictionListener, PageSource source, Factory<? extends PinnableStorageEngine<? super Serializable, ? super Element>> storageEngineFactory, int initialTableSize, boolean cachePinned, boolean notify) {
        this.pool = pool;
        this.owner = owner;
        this.evictionListener = evictionListener;
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.pinningEnabled = cachePinned;
        this.notify = notify;
    }

    @Override
    public PinnableSegment<Serializable, Element> newInstance() {
        PinnableStorageEngine<? super Serializable, ? super Element> storageEngine = this.storageEngineFactory.newInstance();
        try {
            if (this.notify) {
                return new NotifyingEhcachePooledSegment(this.pool, this.owner, this.evictionListener, this.tableSource, storageEngine, this.tableSize, this.pinningEnabled);
            }
            return new EhcachePooledSegment(this.pool, this.owner, this.evictionListener, this.tableSource, storageEngine, this.tableSize, this.pinningEnabled);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    static class NotifyingEhcachePooledSegment
    extends EhcachePooledSegment {
        NotifyingEhcachePooledSegment(OffHeapPool pool, OffHeapPoolableStore owner, RegisteredEventListeners evictionListener, PageSource source, PinnableStorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, boolean pinningEnabled) {
            super(pool, owner, evictionListener, source, storageEngine, tableSize, pinningEnabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evict(int index, boolean shrink) {
            if (this.cachePinned) {
                throw new OutOfMemoryError("cannot evict pinned cache");
            }
            Element e = (Element)this.getAtTableOffset(index);
            FrontEndCacheTier store = this.evictionListener.getFrontEndCacheTier();
            if (store == null || !this.isPinned(e.getObjectKey()) && store.isEvictionCandidate(e)) {
                boolean evicted;
                try {
                    if (this.evictionListener.hasCacheEventListeners()) {
                        if (e.isExpired()) {
                            this.evictionListener.notifyElementExpiry(e, false);
                        } else {
                            this.evictionListener.notifyElementEvicted(e, false);
                        }
                    }
                }
                finally {
                    evicted = super.evict(index, shrink);
                }
                return evicted;
            }
            return false;
        }
    }

    static class EhcachePooledSegment
    extends EhcacheSegmentFactory.EhcacheSegment {
        private final LocalOffHeapPoolableStore localPoolableStore;
        private final OffHeapPool pool;

        EhcachePooledSegment(OffHeapPool pool, OffHeapPoolableStore owner, RegisteredEventListeners evictionListener, PageSource source, PinnableStorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, boolean pinningEnabled) {
            super(evictionListener, source, storageEngine, tableSize, pinningEnabled);
            this.pool = pool;
            this.localPoolableStore = new LocalOffHeapPoolableStore(owner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void storageEngineFailure(Object failure) {
            if (this.cachePinned) {
                StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed.\n");
                sb.append("Cache pinned : ").append(this.cachePinned).append("\n");
                sb.append("Storage Engine : ").append(this.storageEngine);
                throw new OutOfMemoryError(sb.toString());
            }
            this.localPoolableStore.setContext(failure);
            try {
                if (!this.pool.getEvictor().freeSpace(this.localPoolableStore, this.pool.getOffHeapPoolableStores(), -1L)) {
                    throw new OversizeMappingException();
                }
            }
            finally {
                this.localPoolableStore.clearContext();
            }
        }

        class LocalOffHeapPoolableStore
        extends DelegatingOffHeapPoolableStore
        implements OffHeapPoolableStore {
            private Object failure;

            public LocalOffHeapPoolableStore(OffHeapPoolableStore store) {
                super(store);
            }

            @Override
            public boolean evictFromOffHeap(int count, long size) {
                try {
                    EhcachePooledSegment.super.storageEngineFailure(this.failure);
                    return true;
                }
                catch (OversizeMappingException e) {
                    return false;
                }
            }

            public void setContext(Object failure) {
                this.failure = failure;
            }

            public void clearContext() {
                this.failure = null;
            }
        }
    }
}

