/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import com.terracottatech.offheapstore.statistics.jmx.ConcurrentMapStatisticsManager;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.SizeOfPolicyConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.pool.PoolAccessor;
import net.sf.ehcache.pool.PoolableStore;
import net.sf.ehcache.pool.impl.UnboundedPool;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.TierableStore;
import net.sf.ehcache.store.offheap.disk.EhcachePersistentConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStorePoolAccessor;
import net.sf.ehcache.util.SetAsList;
import net.sf.ehcache.writer.CacheWriterManager;

public class OffHeapDiskStore
extends AbstractStore
implements TierableStore,
PoolableStore {
    protected final File dataFile;
    protected final EhcachePersistentConcurrentOffHeapClockCache map;
    private final RegisteredEventListeners eventService;
    protected final AtomicReference<Status> status = new AtomicReference<Status>(Status.STATUS_UNINITIALISED);
    protected volatile PoolAccessor<PoolableStore> onDiskPoolAccessor;
    private CacheLockProvider lockProvider;
    private final CacheConfiguration config;
    private volatile boolean cachePinned;
    private final boolean tierPinned;

    public OffHeapDiskStore(File dataFile, EhcachePersistentConcurrentOffHeapClockCache map, RegisteredEventListeners eventService, Pool<PoolableStore> onDiskPool, Ehcache cache) {
        this.dataFile = dataFile;
        this.map = map;
        this.eventService = eventService;
        if (onDiskPool instanceof UnboundedPool) {
            this.onDiskPoolAccessor = onDiskPool.createPoolAccessor(this, SizeOfPolicyConfiguration.resolveMaxDepth(cache), SizeOfPolicyConfiguration.resolveBehavior(cache).equals((Object)SizeOfPolicyConfiguration.MaxDepthExceededBehavior.ABORT));
        } else {
            this.onDiskPoolAccessor = new OffHeapDiskStorePoolAccessor(onDiskPool, this);
            onDiskPool.registerPoolAccessor(this.onDiskPoolAccessor);
        }
        this.config = cache.getCacheConfiguration();
        if (!this.status.compareAndSet(Status.STATUS_UNINITIALISED, Status.STATUS_ALIVE)) {
            throw new AssertionError();
        }
        this.cachePinned = this.determineCachePinned(cache.getCacheConfiguration());
        this.tierPinned = this.config != null && this.config.getPinningConfiguration() != null && this.config.getPinningConfiguration().getStore() == PinningConfiguration.Store.LOCALHEAP;
    }

    private boolean determineCachePinned(CacheConfiguration cacheConfiguration) {
        PinningConfiguration pinningConfiguration = cacheConfiguration.getPinningConfiguration();
        if (pinningConfiguration == null) {
            return false;
        }
        switch (pinningConfiguration.getStore()) {
            case LOCALHEAP: {
                return false;
            }
            case LOCALMEMORY: {
                return false;
            }
            case INCACHE: {
                return cacheConfiguration.isOverflowToDisk();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void unpinAll() {
    }

    @Override
    public boolean isPinned(Object key) {
        return false;
    }

    @Override
    public void setPinned(Object key, boolean pinned) {
    }

    @Override
    public void fill(Element element) {
        this.put(element);
    }

    @Override
    public boolean removeIfNotPinned(Object key) {
        return !this.tierPinned && !this.isPinned(key) && this.remove(key) != null;
    }

    @Override
    public boolean put(Element element) throws CacheException {
        if (element == null) {
            return false;
        }
        if (this.onDiskPoolAccessor.add(element.getObjectKey(), element.getObjectValue(), element, this.cachePinned) > -1L) {
            return this.map.put(element.getKey(), element) == null;
        }
        this.map.remove(element.getObjectKey());
        this.eventService.notifyElementEvicted(element, false);
        return true;
    }

    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        boolean result = this.put(element);
        if (writerManager != null) {
            writerManager.put(element);
        }
        return result;
    }

    @Override
    public Element get(Object key) {
        if (key == null) {
            return null;
        }
        return (Element)this.map.get(key);
    }

    @Override
    public Element getQuiet(Object key) {
        return this.get(key);
    }

    @Override
    public List<?> getKeys() {
        return new SetAsList(this.map.keySet());
    }

    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        Element removedElement = (Element)this.map.remove(key);
        if (removedElement != null) {
            this.onDiskPoolAccessor.delete(0L);
        }
        return removedElement;
    }

    @Override
    public void removeNoReturn(Object key) {
        if (key != null) {
            this.map.removeNoReturn(key);
        }
    }

    @Override
    public boolean isTierPinned() {
        return this.tierPinned;
    }

    @Override
    public Set getPresentPinnedKeys() {
        return Collections.emptySet();
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        Element removed = this.remove(key);
        if (writerManager != null) {
            writerManager.remove(new CacheEntry(key, removed));
        }
        return removed;
    }

    @Override
    public void removeAll() throws CacheException {
        this.map.clear();
        this.onDiskPoolAccessor.clear();
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        if (this.onDiskPoolAccessor.add(element.getObjectKey(), element.getObjectValue(), element, this.cachePinned) > -1L) {
            Element oldElement = this.map.putIfAbsent(element.getKey(), element);
            if (oldElement != null) {
                this.onDiskPoolAccessor.delete(0L);
            }
            return oldElement;
        }
        this.eventService.notifyElementEvicted(element, false);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        Object key = element.getObjectKey();
        ReentrantReadWriteLock.WriteLock l = this.map.getLock(key).writeLock();
        l.lock();
        try {
            Element value = (Element)this.map.get(key);
            if (this.map.remove(key, element, comparator)) {
                this.onDiskPoolAccessor.delete(0L);
                Element element2 = value;
                return element2;
            }
            Element element3 = null;
            return element3;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        if (this.onDiskPoolAccessor.add(element.getObjectKey(), element.getObjectValue(), element, this.cachePinned) > -1L) {
            boolean replaced = this.map.replace(element.getKey(), old, element, comparator);
            if (!replaced) {
                this.onDiskPoolAccessor.delete(0L);
            }
            return replaced;
        }
        this.eventService.notifyElementEvicted(element, false);
        return false;
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        if (this.onDiskPoolAccessor.add(element.getObjectKey(), element.getObjectValue(), element, this.cachePinned) > -1L) {
            Element oldElement = this.map.replace(element.getKey(), element);
            if (oldElement == null) {
                this.onDiskPoolAccessor.delete(0L);
            }
            return oldElement;
        }
        this.eventService.notifyElementEvicted(element, false);
        return null;
    }

    @Override
    public void dispose() {
        if (this.status.compareAndSet(Status.STATUS_ALIVE, Status.STATUS_SHUTDOWN)) {
            try {
                this.map.close();
                this.dataFile.delete();
                this.onDiskPoolAccessor.unlink();
            }
            catch (IOException e) {
                throw new CacheException("Failed to cleanly dispose the disk store", e);
            }
        }
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    @Override
    public int getInMemorySize() {
        return 0;
    }

    @Override
    public int getOffHeapSize() {
        return 0;
    }

    @Override
    public int getOnDiskSize() {
        return this.getSize();
    }

    @Override
    public int getTerracottaClusteredSize() {
        return 0;
    }

    @Override
    public long getInMemorySizeInBytes() {
        return 0L;
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return 0L;
    }

    public long getOccupiedMemory() {
        return this.map.getOccupiedMemory();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        if (this.onDiskPoolAccessor.getSize() < 0L) {
            return this.map.getOccupiedMemory();
        }
        return this.onDiskPoolAccessor.getSize();
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return false;
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return false;
    }

    @Override
    public void expireElements() {
        for (Object key : this.map.keySet()) {
            Element value = this.get(key);
            if (!value.isExpired() || !this.map.remove(key, value)) continue;
            this.onDiskPoolAccessor.delete(0L);
            this.eventService.notifyElementExpiry(value, false);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean bufferFull() {
        return this.map.bufferFull();
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return null;
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
    }

    @Override
    public Object getInternalContext() {
        CacheLockProvider lp = this.lockProvider;
        return lp == null ? (this.lockProvider = new LockProvider()) : lp;
    }

    @Override
    public Object getMBean() {
        return new ConcurrentMapStatisticsManager(this.map);
    }

    @Override
    public boolean evictFromOnHeap(int count, long size) {
        return false;
    }

    public boolean evictFromOffHeap(int count, long size) {
        return false;
    }

    @Override
    public boolean evictFromOnDisk(int count, long size) {
        if (this.cachePinned) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            Element evicted = this.map.evictOne();
            if (evicted == null) {
                return false;
            }
            this.onDiskPoolAccessor.delete(0L);
        }
        return true;
    }

    @Override
    public float getApproximateDiskHitRate() {
        return this.map.getHitRate();
    }

    @Override
    public float getApproximateDiskMissRate() {
        return this.map.getMissRate();
    }

    @Override
    public float getApproximateHeapHitRate() {
        return 0.0f;
    }

    @Override
    public float getApproximateHeapMissRate() {
        return 0.0f;
    }

    @Override
    public long getApproximateDiskCountSize() {
        return this.map.getSize();
    }

    @Override
    public long getApproximateDiskByteSize() {
        return this.getOnDiskSizeInBytes();
    }

    @Override
    public long getApproximateHeapCountSize() {
        return 0L;
    }

    @Override
    public long getApproximateHeapByteSize() {
        return 0L;
    }

    class LockProvider
    implements CacheLockProvider {
        LockProvider() {
        }

        @Override
        public Sync getSyncForKey(Object key) {
            return new ReadWriteLockSync(OffHeapDiskStore.this.map.getLock(key));
        }
    }
}

