/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import com.terracottatech.frs.TransactionException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.search.impl.SearchManager;
import net.sf.ehcache.store.offheap.BackingMapFactory;
import net.sf.ehcache.store.offheap.NotifyingOffHeapStore;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;
import net.sf.ehcache.store.restartability.EhcacheRestartability;
import net.sf.ehcache.writer.CacheWriterManager;

public class RestartableOffheapStore
extends NotifyingOffHeapStore {
    private final boolean synchronous;
    private final EhcacheRestartability restartability;

    public RestartableOffheapStore(BackingMapFactory factory, Ehcache cache, OffHeapPool pool, SearchManager searchManger, boolean synchronous, EhcacheRestartability restartability) {
        super(factory, cache, pool, searchManger);
        this.synchronous = synchronous;
        this.restartability = restartability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        this.restartability.beginCacheStoreTransaction(this.synchronous);
        try {
            boolean bl = super.putWithWriter(element, writerManager);
            return bl;
        }
        finally {
            try {
                this.restartability.commitCacheStoreTransaction();
            }
            catch (TransactionException e) {
                throw new CacheException(e);
            }
        }
    }

    @Override
    public void dispose() {
    }
}

