/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.search.impl.SearchManager;
import net.sf.ehcache.store.offheap.BackingMapFactory;
import net.sf.ehcache.store.offheap.OffHeapStore;
import net.sf.ehcache.store.offheap.pool.OffHeapPool;

public class NotifyingOffHeapStore
extends OffHeapStore {
    private final RegisteredEventListeners cacheEventNotificationService;

    public NotifyingOffHeapStore(BackingMapFactory factory, Ehcache cache, OffHeapPool pool, SearchManager searchManager) {
        super(factory, cache, pool, searchManager);
        this.cacheEventNotificationService = cache.getCacheEventNotificationService();
    }

    @Override
    public void expireElements() {
        for (Serializable o : this.keySet()) {
            Element element = this.expireElement(o);
            if (element == null) continue;
            this.cacheEventNotificationService.notifyElementExpiry(element, false);
        }
    }
}

