/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.aggregator;

import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.Aggregator;
import com.terracottatech.search.aggregator.Average;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DoubleAverage
extends Average {
    private double sum = 0.0;
    private int count = 0;

    public DoubleAverage(String attributeName, ValueType type) {
        super(attributeName, type);
    }

    @Override
    public void accept(Object input) throws IllegalArgumentException {
        if (input == null) {
            return;
        }
        if (!(input instanceof Number)) {
            throw new IllegalArgumentException(input.getClass().getName() + " is not a number for attribute [" + this.getAttributeName() + "]");
        }
        ++this.count;
        this.sum += ((Number)input).doubleValue();
    }

    @Override
    public void accept(Aggregator incoming) throws IllegalArgumentException {
        if (incoming instanceof DoubleAverage) {
            this.count += ((DoubleAverage)incoming).count;
            this.sum += ((DoubleAverage)incoming).sum;
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Double getResult() {
        if (this.count == 0) {
            return null;
        }
        return this.sum / (double)this.count;
    }

    @Override
    Aggregator deserializeData(DataInput input) throws IOException {
        this.sum = input.readDouble();
        this.count = input.readInt();
        return this;
    }

    @Override
    void serializeData(DataOutput output) throws IOException {
        output.writeDouble(this.sum);
        output.writeInt(this.count);
    }
}

