/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.GroupedQueryResult;
import com.terracottatech.search.IndexQueryResult;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.QueryResultComparator;
import com.terracottatech.search.aggregator.Aggregator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public final class ResultTools {
    public static void mergeGroupedResults(List<? extends IndexQueryResult> indexResults) {
        List<? extends IndexQueryResult> groups = indexResults;
        LinkedHashMap<Set<NVPair>, GroupedQueryResult> uniqueGroups = new LinkedHashMap<Set<NVPair>, GroupedQueryResult>();
        for (GroupedQueryResult groupedQueryResult : groups) {
            Set<NVPair> groupBy = groupedQueryResult.getGroupedAttributes();
            GroupedQueryResult dest = (GroupedQueryResult)uniqueGroups.get(groupBy);
            if (dest == null) {
                uniqueGroups.put(groupBy, groupedQueryResult);
                continue;
            }
            ResultTools.aggregate(dest.getAggregators(), groupedQueryResult.getAggregators());
        }
        groups.clear();
        groups.addAll(uniqueGroups.values());
    }

    public static void aggregate(List<Aggregator> aggregates, List<Aggregator> incoming) {
        if (incoming.isEmpty()) {
            return;
        }
        if (aggregates.isEmpty()) {
            aggregates.addAll(incoming);
        } else {
            for (int i = 0; i < aggregates.size(); ++i) {
                aggregates.get(i).accept(incoming.get(i));
            }
        }
    }

    private static <T extends IndexQueryResult> List<T> nextIndexResults(Collection<List<T>> resultsFromAllIndexes, final Comparator<IndexQueryResult> comp) {
        return Collections.min(resultsFromAllIndexes, new Comparator<List<T>>(){

            @Override
            public int compare(List<T> o1, List<T> o2) {
                IndexQueryResult head2;
                IndexQueryResult head1 = o1.isEmpty() ? null : (IndexQueryResult)o1.get(0);
                IndexQueryResult indexQueryResult = head2 = o2.isEmpty() ? null : (IndexQueryResult)o2.get(0);
                return head1 == null && head2 == null ? 0 : (head1 == null ? 1 : (head2 == null ? -1 : comp.compare(head1, head2)));
            }
        });
    }

    public static <T extends IndexQueryResult> List<T> mergeSort(Collection<List<T>> idxResults, List<NVPair> sortBy) {
        IndexQueryResult lowest = null;
        ArrayList<IndexQueryResult> sorted = new ArrayList<IndexQueryResult>();
        QueryResultComparator resComp = new QueryResultComparator(sortBy);
        do {
            List<T> next;
            if ((next = ResultTools.nextIndexResults(idxResults, resComp)).isEmpty()) {
                lowest = null;
                continue;
            }
            lowest = (IndexQueryResult)next.remove(0);
            sorted.add(lowest);
        } while (lowest != null);
        return sorted;
    }
}

