/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable;

import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.restartable.LinkedNode;
import com.terracottatech.offheapstore.storage.restartable.WriteContext;
import java.nio.ByteBuffer;

public class AttachedLinkedNode<T>
implements LinkedNode<T> {
    private final Portability<? super T> valuePortability;
    private final ByteBuffer data;
    private final WriteContext writer;

    public AttachedLinkedNode(ByteBuffer buffer, Portability<? super T> valuePortability, WriteContext writer) {
        this.valuePortability = valuePortability;
        this.data = buffer;
        this.writer = writer;
    }

    @Override
    public long getLsn() {
        return this.getLong(0);
    }

    @Override
    public void setLsn(long lsn) {
        this.writer.setLong(0, lsn);
    }

    @Override
    public long getNext() {
        return this.getLong(16);
    }

    @Override
    public long getPrevious() {
        return this.getLong(8);
    }

    @Override
    public void setNext(long encoding) {
        this.writer.setLong(16, encoding);
    }

    @Override
    public void setPrevious(long encoding) {
        this.writer.setLong(8, encoding);
    }

    @Override
    public T getValue() {
        return this.valuePortability.decode(this.getBuffer(24));
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    private ByteBuffer getBuffer(int offset) {
        if (offset < this.data.capacity()) {
            this.data.position(offset);
            return this.data.slice();
        }
        throw new IllegalArgumentException();
    }

    private long getLong(int address) {
        if (address + 8 < this.data.capacity()) {
            return this.data.getLong(address);
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return this.getPrevious() + "<== OffHeapLinkedNode [lsn = " + this.getLsn() + "] ==> " + this.getNext();
    }

    @Override
    public int getMetadata() {
        throw new UnsupportedOperationException();
    }
}

