/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.listener;

import com.terracottatech.offheapstore.storage.listener.ListenableStorageEngine;
import com.terracottatech.offheapstore.storage.listener.StorageEngineListener;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractListenableStorageEngine<K, V>
implements ListenableStorageEngine<K, V> {
    private final Set<StorageEngineListener<? super K, ? super V>> listeners = new CopyOnWriteArraySet<StorageEngineListener<? super K, ? super V>>();

    @Override
    public void registerListener(StorageEngineListener<? super K, ? super V> listener) {
        this.listeners.add(listener);
    }

    protected final boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    protected final void fireWritten(K key, V value, ByteBuffer binaryKey, ByteBuffer binaryValue, int hash, int metadata, long encoding) {
        for (StorageEngineListener<K, V> listener : this.listeners) {
            listener.written(key, value, binaryKey.duplicate(), binaryValue.duplicate(), hash, metadata, encoding);
        }
    }

    protected final void fireFreed(K key, long encoding, int hash, boolean removed) {
        for (StorageEngineListener<K, V> listener : this.listeners) {
            listener.freed(key, encoding, hash, removed);
        }
    }

    protected final void fireCleared() {
        for (StorageEngineListener<K, V> listener : this.listeners) {
            listener.cleared();
        }
    }

    protected final void fireCopied(int hash, long oldEncoding, long newEncoding, int metadata) {
        for (StorageEngineListener<K, V> listener : this.listeners) {
            listener.copied(hash, oldEncoding, newEncoding, metadata);
        }
    }
}

