/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.pinning;

import com.terracottatech.offheapstore.OffHeapHashMap;
import com.terracottatech.offheapstore.pinning.PinnableStorageEngine;
import com.terracottatech.offheapstore.storage.BinaryStorageEngine;
import com.terracottatech.offheapstore.storage.listener.AbstractListenableStorageEngine;
import java.nio.ByteBuffer;

public abstract class CompoundPinnableStorageEngine<K, V>
extends AbstractListenableStorageEngine<K, V>
implements PinnableStorageEngine<K, V> {
    protected final BinaryStorageEngine<K, V> normalEngine;
    protected final BinaryStorageEngine<K, V> pinnedEngine;

    public CompoundPinnableStorageEngine(BinaryStorageEngine<K, V> normal, BinaryStorageEngine<K, V> pinned) {
        this.normalEngine = normal;
        this.pinnedEngine = pinned;
    }

    @Override
    public Long copyMapping(int hash, long encoding, int metadata) {
        BinaryStorageEngine<K, V> updated;
        BinaryStorageEngine<K, V> original = this.getStorageEngineForEncoding(encoding);
        if (original == (updated = this.getStorageEngineForMetadata(metadata))) {
            return encoding;
        }
        byte[] data = original.readBinary(this.getEncoding(encoding));
        Long rawEncoding = updated.writeBinary(data, hash, metadata);
        try {
            Long result = this.getEncodingForMetadata(metadata, rawEncoding);
            if (result != null) {
                this.fireCopied(hash, encoding, result, metadata);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            updated.freeMapping(rawEncoding, hash, false);
            return null;
        }
    }

    @Override
    public Long writeMapping(K key, V value, int hash, int metadata) {
        BinaryStorageEngine<K, V> engine = this.getStorageEngineForMetadata(metadata);
        Long rawEncoding = engine.writeMapping(key, value, hash, metadata);
        try {
            Long result = this.getEncodingForMetadata(metadata, rawEncoding);
            if (result != null && this.hasListeners()) {
                this.fireWritten(key, value, engine.readKeyBuffer(rawEncoding), engine.readValueBuffer(rawEncoding), hash, metadata, result);
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            engine.freeMapping(rawEncoding, hash, false);
            return null;
        }
    }

    public ByteBuffer readKeyBuffer(long encoding) {
        return this.getStorageEngineForEncoding(encoding).readKeyBuffer(this.getEncoding(encoding));
    }

    public ByteBuffer readValueBuffer(long encoding) {
        return this.getStorageEngineForEncoding(encoding).readValueBuffer(this.getEncoding(encoding));
    }

    public Long writeBinary(byte[] binary, int hash, int metadata) {
        BinaryStorageEngine<K, V> engine = this.getStorageEngineForMetadata(metadata);
        Long rawEncoding = engine.writeBinary(binary, hash, metadata);
        try {
            return this.getEncodingForMetadata(metadata, rawEncoding);
        }
        catch (IllegalArgumentException e) {
            engine.freeMapping(rawEncoding, hash, false);
            return null;
        }
    }

    public byte[] readBinary(long encoding) {
        return this.getStorageEngineForEncoding(encoding).readBinary(this.getEncoding(encoding));
    }

    @Override
    public void attachedMapping(long encoding, int hash, int metadata) {
        this.getStorageEngineForMetadata(metadata).attachedMapping(this.getEncoding(encoding), hash, metadata);
    }

    @Override
    public void freeMapping(long encoding, int hash, boolean removal) {
        if (this.hasListeners()) {
            K key = this.readKey(encoding, hash);
            this.getStorageEngineForEncoding(encoding).freeMapping(this.getEncoding(encoding), hash, removal);
            this.fireFreed(key, encoding, hash, removal);
        } else {
            this.getStorageEngineForEncoding(encoding).freeMapping(this.getEncoding(encoding), hash, removal);
        }
    }

    @Override
    public V readValue(long encoding) {
        return this.getStorageEngineForEncoding(encoding).readValue(this.getEncoding(encoding));
    }

    @Override
    public boolean equalsValue(Object value, long encoding) {
        return this.getStorageEngineForEncoding(encoding).equalsValue(value, this.getEncoding(encoding));
    }

    @Override
    public K readKey(long encoding, int hashCode) {
        return this.getStorageEngineForEncoding(encoding).readKey(this.getEncoding(encoding), hashCode);
    }

    @Override
    public boolean equalsKey(Object key, long encoding) {
        return this.getStorageEngineForEncoding(encoding).equalsKey(key, this.getEncoding(encoding));
    }

    @Override
    public void clear() {
        this.normalEngine.clear();
        this.pinnedEngine.clear();
        this.fireCleared();
    }

    @Override
    public long getAllocatedMemory() {
        return this.normalEngine.getAllocatedMemory() + this.pinnedEngine.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.normalEngine.getOccupiedMemory() + this.pinnedEngine.getOccupiedMemory();
    }

    @Override
    public void invalidateCache() {
        this.normalEngine.invalidateCache();
        this.pinnedEngine.invalidateCache();
    }

    @Override
    public void bind(OffHeapHashMap<?, ?> owner) {
        this.normalEngine.bind(owner);
        this.pinnedEngine.bind(owner);
    }

    @Override
    public void destroy() {
        this.normalEngine.destroy();
        this.pinnedEngine.destroy();
    }

    @Override
    public boolean shrink() {
        return this.normalEngine.shrink();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Normal Storage Engine:\n").append(this.normalEngine).append("\n");
        sb.append("Pinned Storage Engine:\n").append(this.pinnedEngine).append("\n");
        return sb.toString();
    }

    protected BinaryStorageEngine<K, V> getStorageEngineForMetadata(int metadata) {
        if ((metadata & 0x40000000) == 0) {
            return this.normalEngine;
        }
        return this.pinnedEngine;
    }

    protected Long getEncodingForMetadata(int metadata, Long encoding) throws IllegalArgumentException {
        if (encoding == null) {
            return null;
        }
        if ((metadata & 0x40000000) == 0) {
            if (encoding >= 0L) {
                return encoding;
            }
            throw new IllegalArgumentException();
        }
        if (encoding < 0L || encoding == Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        return -encoding.longValue();
    }

    protected BinaryStorageEngine<K, V> getStorageEngineForEncoding(long encoding) {
        if (encoding < 0L) {
            return this.pinnedEngine;
        }
        return this.normalEngine;
    }

    protected long getEncoding(long encoding) {
        return Math.abs(encoding);
    }
}

