/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.concurrent;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.statistics.ConcurrentMapStatistics;
import com.terracottatech.offheapstore.statistics.MapStatistics;
import com.terracottatech.offheapstore.statistics.SwitchableLatencyMonitoringSegment;
import com.terracottatech.offheapstore.util.Factory;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractConcurrentOffHeapMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
ConcurrentMapStatistics {
    private static final int MAX_SEGMENTS = 65536;
    private static final int DEFAULT_CONCURRENCY = 16;
    protected final Segment<K, V>[] segments;
    private final int segmentShift;
    private final int segmentMask;
    private Set<K> keySet;
    private Set<Map.Entry<K, V>> entrySet;
    private Collection<V> values;

    public AbstractConcurrentOffHeapMap(Factory<? extends Segment<K, V>> segmentFactory, boolean latencyMonitoring) {
        this(segmentFactory, 16, latencyMonitoring);
    }

    public AbstractConcurrentOffHeapMap(Factory<? extends Segment<K, V>> segmentFactory, int concurrency, boolean latencyMonitoring) {
        int ssize;
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency must be positive [was: " + concurrency + "]");
        }
        if (concurrency > 65536) {
            concurrency = 65536;
        }
        int sshift = 0;
        for (ssize = 1; ssize < concurrency; ssize <<= 1) {
            ++sshift;
        }
        this.segmentShift = 32 - sshift;
        this.segmentMask = ssize - 1;
        this.segments = new Segment[ssize];
        try {
            if (latencyMonitoring) {
                for (int i = 0; i < this.segments.length; ++i) {
                    this.segments[i] = new SwitchableLatencyMonitoringSegment<K, V>(segmentFactory.newInstance());
                }
            } else {
                for (int i = 0; i < this.segments.length; ++i) {
                    this.segments[i] = segmentFactory.newInstance();
                }
            }
        }
        catch (RuntimeException e) {
            for (Segment<K, V> s : this.segments) {
                if (s == null) continue;
                s.destroy();
            }
            throw e;
        }
    }

    protected Segment<K, V> segmentFor(Object key) {
        return this.segmentFor(key.hashCode());
    }

    protected Segment<K, V> segmentFor(int hash) {
        return this.segments[this.getIndexFor(hash)];
    }

    public int getIndexFor(int hash) {
        return AbstractConcurrentOffHeapMap.spread(hash) >>> this.segmentShift & this.segmentMask;
    }

    public List<Segment<K, V>> getSegments() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    protected int getConcurrency() {
        return this.segments.length;
    }

    private static int spread(int hash) {
        int h = hash;
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long sum = 0L;
        this.readLockAll();
        try {
            for (Segment<K, V> m : this.segments) {
                sum += (long)m.size();
            }
        }
        finally {
            this.readUnlockAll();
        }
        if (sum > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)sum;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.segmentFor(key).containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        this.readLockAll();
        try {
            for (Segment<K, V> m : this.segments) {
                if (!m.containsValue(value)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.readUnlockAll();
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.segmentFor(key).get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.segmentFor(key).put(key, value);
    }

    public V fill(K key, V value) {
        return this.segmentFor(key).fill(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.segmentFor(key).remove(key);
    }

    public void removeNoReturn(Object key) {
        this.segmentFor(key).removeNoReturn(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.writeLockAll();
        try {
            for (Segment<K, V> m : this.segments) {
                m.clear();
            }
        }
        finally {
            this.writeUnlockAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.writeLockAll();
        try {
            for (Segment<K, V> m : this.segments) {
                m.destroy();
            }
        }
        finally {
            this.writeUnlockAll();
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.segmentFor(key).putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.segmentFor(key).remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.segmentFor(key).replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.segmentFor(key).replace(key, value);
    }

    @Override
    public Set<K> keySet() {
        AggregateKeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new AggregateKeySet());
    }

    @Override
    public Collection<V> values() {
        AggregatedValuesCollection vc = this.values;
        return vc != null ? vc : (this.values = new AggregatedValuesCollection());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        AggregateEntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new AggregateEntrySet());
    }

    protected void readLockAll() {
        for (Segment<K, V> m : this.segments) {
            m.readLock().lock();
        }
    }

    protected void readUnlockAll() {
        for (Segment<K, V> m : this.segments) {
            m.readLock().unlock();
        }
    }

    public final void writeLockAll() {
        for (Segment<K, V> m : this.segments) {
            m.writeLock().lock();
        }
    }

    public final void writeUnlockAll() {
        for (Segment<K, V> m : this.segments) {
            m.writeLock().unlock();
        }
    }

    @Override
    public List<MapStatistics> getSegmentStatistics() {
        return Collections.unmodifiableList(Arrays.asList(this.segments));
    }

    @Override
    public long getSize() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getSize();
        }
        return sum;
    }

    @Override
    public long getTableCapacity() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getTableCapacity();
        }
        return sum;
    }

    @Override
    public long getUsedSlotCount() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getUsedSlotCount();
        }
        return sum;
    }

    @Override
    public long getRemovedSlotCount() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getRemovedSlotCount();
        }
        return sum;
    }

    @Override
    public int getReprobeLength() {
        throw new UnsupportedOperationException("Segmented maps do not have a reprobe length");
    }

    @Override
    public long getHitCount() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getHitCount();
        }
        return sum;
    }

    @Override
    public long getMissCount() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getMissCount();
        }
        return sum;
    }

    @Override
    public long getPutCount() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getPutCount();
        }
        return sum;
    }

    @Override
    public float getHitRate() {
        float sum = 0.0f;
        for (Segment<K, V> m : this.segments) {
            sum += m.getHitRate();
        }
        return sum;
    }

    @Override
    public float getMissRate() {
        float sum = 0.0f;
        for (Segment<K, V> m : this.segments) {
            sum += m.getMissRate();
        }
        return sum;
    }

    @Override
    public float getPutRate() {
        float sum = 0.0f;
        for (Segment<K, V> m : this.segments) {
            sum += m.getPutRate();
        }
        return sum;
    }

    @Override
    public long getAverageLatency() {
        long sum = 0L;
        long nSum = 0L;
        for (Segment<K, V> m : this.segments) {
            long n = m.getLatencySampleSize();
            if (n <= 0L) continue;
            sum += m.getAverageLatency() * n;
            nSum += n;
        }
        if (nSum == 0L) {
            return 0L;
        }
        return sum / nSum;
    }

    @Override
    public long getMaximumLatency() {
        long max = Long.MIN_VALUE;
        for (Segment<K, V> m : this.segments) {
            long l = m.getMaximumLatency();
            if (l <= max) continue;
            max = l;
        }
        return max;
    }

    @Override
    public long getMinimumLatency() {
        long min = Long.MAX_VALUE;
        for (Segment<K, V> m : this.segments) {
            long l = m.getMinimumLatency();
            if (l >= min) continue;
            min = l;
        }
        return min;
    }

    @Override
    public long getSigmaLatency() {
        long sumM2 = 0L;
        long sumN = 0L;
        for (Segment<K, V> m : this.segments) {
            long n = m.getLatencySampleSize();
            if (n <= 0L) continue;
            long sigma = m.getSigmaLatency();
            long m2 = sigma * sigma * (n - 1L);
            sumM2 += m2;
            sumN += n;
        }
        if (sumN <= 1L) {
            return 0L;
        }
        return (long)Math.sqrt((double)sumM2 / (double)(sumN - 1L));
    }

    @Override
    public long getLatencySampleSize() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getLatencySampleSize();
        }
        return sum;
    }

    @Override
    public long getAllocatedMemory() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getAllocatedMemory();
        }
        return sum;
    }

    @Override
    public long getOccupiedMemory() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getOccupiedMemory();
        }
        return sum;
    }

    @Override
    public long getDataAllocatedMemory() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getDataAllocatedMemory();
        }
        return sum;
    }

    @Override
    public long getDataOccupiedMemory() {
        long sum = 0L;
        for (Segment<K, V> m : this.segments) {
            sum += m.getDataOccupiedMemory();
        }
        return sum;
    }

    public void setLatencyMonitoring(boolean enabled) {
        for (Segment<K, V> m : this.segments) {
            if (!(m instanceof SwitchableLatencyMonitoringSegment)) continue;
            ((SwitchableLatencyMonitoringSegment)m).setMonitoring(enabled);
        }
    }

    public boolean isLatencyMonitoringEnabled() {
        for (Segment<K, V> m : this.segments) {
            if (m instanceof SwitchableLatencyMonitoringSegment && ((SwitchableLatencyMonitoringSegment)m).isMonitoring()) continue;
            return false;
        }
        return true;
    }

    protected abstract class AggregateIterator<T>
    implements Iterator<T> {
        protected final Iterator<Map<K, V>> listIterator;
        protected Iterator<T> currentIterator;

        protected abstract Iterator<T> getNextIterator();

        public AggregateIterator() {
            this.listIterator = Arrays.asList(AbstractConcurrentOffHeapMap.this.segments).iterator();
            while (this.listIterator.hasNext()) {
                this.currentIterator = this.getNextIterator();
                if (!this.currentIterator.hasNext()) continue;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator == null) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            while (this.listIterator.hasNext()) {
                this.currentIterator = this.getNextIterator();
                if (!this.currentIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.currentIterator == null) {
                throw new NoSuchElementException();
            }
            if (this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            while (this.listIterator.hasNext()) {
                this.currentIterator = this.getNextIterator();
                if (!this.currentIterator.hasNext()) continue;
                return this.currentIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            this.currentIterator.remove();
        }
    }

    private abstract class BaseAggregateSet<T>
    extends AbstractSet<T> {
        private BaseAggregateSet() {
        }

        @Override
        public int size() {
            return AbstractConcurrentOffHeapMap.this.size();
        }

        @Override
        public void clear() {
            AbstractConcurrentOffHeapMap.this.clear();
        }
    }

    class AggregatedValuesCollection
    extends AbstractCollection<V> {
        AggregatedValuesCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return new AggregateIterator<V>(){

                @Override
                protected Iterator<V> getNextIterator() {
                    return ((Map)this.listIterator.next()).values().iterator();
                }
            };
        }

        @Override
        public int size() {
            return AbstractConcurrentOffHeapMap.this.size();
        }
    }

    class AggregateEntrySet
    extends BaseAggregateSet<Map.Entry<K, V>> {
        AggregateEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new AggregateIterator<Map.Entry<K, V>>(){

                @Override
                protected Iterator<Map.Entry<K, V>> getNextIterator() {
                    return ((Map)this.listIterator.next()).entrySet().iterator();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = AbstractConcurrentOffHeapMap.this.get(e.getKey());
            return value != null && value.equals(e.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object value = AbstractConcurrentOffHeapMap.this.get(e.getKey());
            if (value != null && value.equals(e.getValue())) {
                return AbstractConcurrentOffHeapMap.this.remove(e.getKey()) != null;
            }
            return false;
        }
    }

    class AggregateKeySet
    extends BaseAggregateSet<K> {
        AggregateKeySet() {
        }

        @Override
        public boolean contains(Object o) {
            return AbstractConcurrentOffHeapMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractConcurrentOffHeapMap.this.remove(o) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new AggregateIterator<K>(){

                @Override
                protected Iterator<K> getNextIterator() {
                    return ((Map)this.listIterator.next()).keySet().iterator();
                }
            };
        }
    }
}

