/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.concurrent;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.util.Factory;

public abstract class AbstractConcurrentOffHeapCache<K, V>
extends AbstractConcurrentOffHeapMap<K, V> {
    public AbstractConcurrentOffHeapCache(Factory<? extends Segment<K, V>> segmentFactory, boolean latencyMonitoring) {
        super(segmentFactory, latencyMonitoring);
    }

    public AbstractConcurrentOffHeapCache(Factory<? extends Segment<K, V>> segmentFactory, int concurrency, boolean latencyMonitoring) {
        super(segmentFactory, concurrency, latencyMonitoring);
    }

    @Override
    public V put(K key, V value) {
        try {
            return super.put(key, value);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    return super.put(key, value);
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    V ex = super.put(key, value);
                    return ex;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    @Override
    public V fill(K key, V value) {
        try {
            return super.fill(key, value);
        }
        catch (OversizeMappingException e) {
            return null;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        try {
            return super.putIfAbsent(key, value);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    return super.putIfAbsent(key, value);
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    V ex = super.putIfAbsent(key, value);
                    return ex;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        try {
            return super.replace(key, oldValue, newValue);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    return super.replace(key, oldValue, newValue);
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    boolean ex = super.replace(key, oldValue, newValue);
                    return ex;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    @Override
    public V replace(K key, V value) {
        try {
            return super.replace(key, value);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    return super.replace(key, value);
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    V ex = super.replace(key, value);
                    return ex;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    public final boolean handleOversizeMappingException(int hash) {
        boolean evicted = false;
        Segment target = this.segmentFor(hash);
        for (Segment s : this.segments) {
            if (s == target) continue;
            evicted |= s.shrink();
        }
        return evicted;
    }
}

