/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    public static final String NEWLINE = System.getProperty("line.separator");

    public static List<String> readLines(Reader in) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(in);
        ArrayList<String> list = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            list.add(line);
        }
        return list;
    }

    public static List<String> readLines(InputStream in) throws IOException {
        return IOUtils.readLines(new InputStreamReader(in));
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = in.read(buffer)) != -1) {
            out.write(buffer, 0, n);
        }
    }

    public static void closeQuietly(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Reader in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Writer out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        return IOUtils.readStream(inputStream).toByteArray();
    }

    public static ByteArrayOutputStream readStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(buffer.length);
        int returnValue = inputStream.read(buffer);
        while (-1 != returnValue) {
            outputStream.write(buffer, 0, returnValue);
            returnValue = inputStream.read(buffer);
        }
        outputStream.close();
        inputStream.close();
        return outputStream;
    }

    public static String readToString(InputStream in) throws IOException {
        String string;
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(NEWLINE);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        return string;
    }
}

