/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.license.ehcache;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import net.sf.ehcache.util.MemorySizeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.ehcachedx.util.Vm;
import org.terracotta.license.AbstractLicenseResolverFactory;
import org.terracotta.license.EnterpriseLicenseResolverFactory;
import org.terracotta.license.License;
import org.terracotta.license.LicenseException;

public class LicenseManager {
    private static final long BYTES_PER_MEGABYTE = 0x100000L;
    private static final long LOG_EXPIRED_LICENSE_PERIOD = 3600000L;
    private static final int MIN_DIRECT_MEMORY_SIZE_IN_MB = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseManager.class);
    private static volatile boolean initialized;
    private static Timer expiredTimer;
    private static final AtomicInteger enterpriseManagerCount;
    private static License license;
    private static final CacheManagerEventListener enterpriseManagerListener;

    private static synchronized void init() {
        EnterpriseLicenseResolverFactory factory = new EnterpriseLicenseResolverFactory();
        license = ((AbstractLicenseResolverFactory)factory).resolveLicense();
        initialized = true;
        if (license != null) {
            LOGGER.info("Terracotta license loaded from " + ((AbstractLicenseResolverFactory)factory).getLicenseLocation() + "\n" + license.toString());
            if (license.isExpired()) {
                throw new LicenseException("Your Terracotta license has expired " + license.expirationDate());
            }
        }
    }

    private static synchronized License getLicense() {
        if (!initialized) {
            LicenseManager.init();
        }
        return license;
    }

    private static synchronized void scheduleExpiredTimerIfNeeded(Date expirationDate) {
        if (expirationDate != null && new Date().before(expirationDate)) {
            LicenseManager.killTimer();
            expiredTimer = new Timer("Licensed expired timer", true);
            long delayTime = expirationDate.getTime() - System.currentTimeMillis();
            delayTime = delayTime < 0L ? 100L : delayTime;
            expiredTimer.scheduleAtFixedRate(LicenseManager.getExpiredTimerTask(), delayTime, 3600000L);
        }
    }

    private static TimerTask getExpiredTimerTask() {
        return new TimerTask(){

            public void run() {
                LOGGER.error("Your Terracotta license has expired {}", (Object)LicenseManager.getLicense().expirationDate());
            }
        };
    }

    private static void verifyCapability(String capability) {
        LicenseManager.assertLicenseValid();
        if (!LicenseManager.getLicense().isCapabilityEnabled(capability)) {
            throw new LicenseException("Your license key doesn't allow usage of '" + capability + "' capability");
        }
    }

    public static void verifyOffHeapUsage(CacheManager cacheManager) {
        LicenseManager.verifyCapability("ehcache offheap");
        long maxHeapFromVMInBytes = Vm.maxDirectMemory();
        LOGGER.info("Detected maximum direct memory size: " + maxHeapFromVMInBytes / 0x100000L + " MB");
        if (maxHeapFromVMInBytes / 0x100000L < 128L) {
            throw new LicenseException("Direct memory size of less than 128 MB was set at JVM level. Please set a bigger value with -XX:MaxDirectMemorySize");
        }
        if (maxHeapFromVMInBytes == Long.MAX_VALUE) {
            throw new LicenseException("No direct memory size was set at JVM level. Please set it with -XX:MaxDirectMemorySize");
        }
        String maxHeapSizeFromLicense = LicenseManager.getLicense().getRequiredProperty("ehcache.maxOffHeap");
        long maxHeapAllowedInBytes = MemorySizeParser.parse(maxHeapSizeFromLicense);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("max offheap from VM: " + maxHeapFromVMInBytes);
            LOGGER.debug("max offheap allowed: " + maxHeapAllowedInBytes);
        }
        if (maxHeapFromVMInBytes > maxHeapAllowedInBytes) {
            throw new LicenseException("Your license only allows up to " + maxHeapSizeFromLicense + " in offheap size. Your VM is configured with " + maxHeapFromVMInBytes / 0x100000L + " MB.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("data model: " + Vm.dataModel() + "-bit");
        }
        if (Vm.dataModel() < 64) {
            LOGGER.warn("Your JVM seems to be running with a 32-bit data model. If you get OutOfMemoryError it could be that it is running out of process space. Please see the documentation for further information on configuring OffHeapStore with 32-bit JVMs.");
        }
        LicenseManager.afterVerified(cacheManager);
    }

    private static synchronized void afterVerified(CacheManager cacheManager) {
        CacheManagerEventListenerRegistry registry = cacheManager.getCacheManagerEventListenerRegistry();
        if (!registry.getRegisteredListeners().contains(enterpriseManagerListener)) {
            registry.registerListener(enterpriseManagerListener);
            if (enterpriseManagerCount.getAndIncrement() == 0) {
                LicenseManager.scheduleExpiredTimerIfNeeded(LicenseManager.getLicense().expirationDate());
            }
        }
    }

    public static void assertLicenseValid() {
        if (LicenseManager.getLicense() == null) {
            throw new LicenseException("Terracotta license key is required for Enterprise capabilities. Please place terracotta-license.key in Terracotta installed directory or in resource path. You could also specify it through system property -Dcom.tc.productkey.path=/path/to/key");
        }
        Date expirationDate = LicenseManager.getLicense().expirationDate();
        if (expirationDate != null && expirationDate.before(new Date())) {
            throw new LicenseException("Your Terracotta license has expired on " + expirationDate);
        }
    }

    private static synchronized void killTimer() {
        if (expiredTimer != null) {
            expiredTimer.cancel();
            expiredTimer = null;
        }
    }

    static {
        enterpriseManagerCount = new AtomicInteger(0);
        enterpriseManagerListener = new CacheManagerEventListener(){

            public void dispose() {
                if (enterpriseManagerCount.decrementAndGet() == 0) {
                    LicenseManager.killTimer();
                }
            }

            public void init() throws CacheException {
            }

            public Status getStatus() {
                return null;
            }

            public void notifyCacheAdded(String cacheName) {
            }

            public void notifyCacheRemoved(String cacheName) {
            }
        };
    }
}

