/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.factories;

import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.OffHeapBufferStorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngineFactory;
import java.io.Serializable;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.offheap.portability.EhcacheElementPortability;
import net.sf.ehcache.store.offheap.portability.EhcacheKeyPortability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheStorageEngineFactory
implements StorageEngineFactory<Serializable, Element> {
    private final PageSource source;
    private final int pageSize;
    private final int defaultTTL;
    private final int defaultTTI;

    public EhcacheStorageEngineFactory(PageSource source, int pageSize, int defaultTTL, int defaultTTI) {
        this.source = source;
        this.pageSize = pageSize;
        this.defaultTTI = defaultTTI;
        this.defaultTTL = defaultTTL;
    }

    @Override
    public StorageEngine<Serializable, Element> newInstance() {
        return new OffHeapBufferStorageEngine<Serializable, Element>(this.source, this.pageSize, new EhcacheKeyPortability(), new EhcacheElementPortability(this.defaultTTL, this.defaultTTI));
    }
}

