/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.factories;

import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngine;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngineFactory;
import com.terracottatech.offheapstore.disk.storage.FileBackedStorageEngine;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.offheap.portability.PersistentEhcacheElementPortability;
import net.sf.ehcache.store.offheap.portability.PersistentEhcacheKeyPortability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcachePersistentStorageEngineFactory
implements PersistentStorageEngineFactory<Serializable, Element> {
    private final MappedPageSource source;
    private final int initialDataSize;
    private final boolean bootstrap;
    private final int defaultTTL;
    private final int defaultTTI;
    private final List<ThreadPoolExecutor> diskWriters;
    private final int accessStripes;
    private int writerIndex;

    public EhcachePersistentStorageEngineFactory(MappedPageSource source, int initialDataSize, int accessStripes, int defaultTTL, int defaultTTI) {
        this(source, initialDataSize, accessStripes, true, defaultTTL, defaultTTI);
    }

    public EhcachePersistentStorageEngineFactory(MappedPageSource source, int initialDataSize, int accessStripes, boolean bootstrap, int defaultTTL, int defaultTTI) {
        this.source = source;
        this.initialDataSize = initialDataSize;
        this.bootstrap = bootstrap;
        this.defaultTTL = defaultTTL;
        this.defaultTTI = defaultTTI;
        this.diskWriters = new CopyOnWriteArrayList<ThreadPoolExecutor>();
        this.accessStripes = accessStripes;
    }

    @Override
    public PersistentStorageEngine<Serializable, Element> newInstance() {
        ThreadPoolExecutor writer;
        if (this.diskWriters.size() < this.accessStripes) {
            final int index = this.diskWriters.size();
            writer = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    return new Thread(r, "Ehcache Disk Write Thread [" + EhcachePersistentStorageEngineFactory.this.source.getFile().getName() + "] - " + index);
                }
            });
            this.diskWriters.add(writer);
        } else {
            writer = this.diskWriters.get(this.writerIndex++);
            if (this.writerIndex == this.diskWriters.size()) {
                this.writerIndex = 0;
            }
        }
        return new FileBackedStorageEngine<Serializable, Element>(this.source, new PersistentEhcacheKeyPortability(), new PersistentEhcacheElementPortability(this.defaultTTL, this.defaultTTI), this.initialDataSize, writer, this.bootstrap);
    }

    public long getTotalQueueSize() {
        long size = 0L;
        for (ThreadPoolExecutor e : this.diskWriters) {
            size += (long)e.getQueue().size();
        }
        return size;
    }
}

