/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.disk;

import com.terracottatech.offheapstore.statistics.jmx.ConcurrentMapStatisticsManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.offheap.configuration.DerivedDiskConfiguration;
import net.sf.ehcache.store.offheap.disk.EhcachePersistentConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.util.SetAsList;
import net.sf.ehcache.writer.CacheWriterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffHeapDiskStore
extends AbstractStore {
    protected final File dataFile;
    protected final EhcachePersistentConcurrentOffHeapClockCache map;
    private final RegisteredEventListeners eventService;
    protected final AtomicReference<Status> status = new AtomicReference<Status>(Status.STATUS_UNINITIALISED);
    private CacheLockProvider lockProvider;

    public OffHeapDiskStore(Ehcache cache, String diskStorePath) {
        if (diskStorePath == null) {
            throw new CacheException(cache.getName() + " Cache: Could not create disk store. " + "This CacheManager configuration does not allow creation of DiskStores. " + "If you wish to create DiskStores, please configure a diskStore path.");
        }
        CacheConfiguration config = cache.getCacheConfiguration();
        try {
            File diskDir = new File(diskStorePath);
            if (diskDir.exists() && !diskDir.isDirectory()) {
                throw new CacheException("Store directory \"" + diskDir.getCanonicalPath() + "\" exists and is not a directory.");
            }
            if (!diskDir.exists() && !diskDir.mkdirs()) {
                throw new CacheException("Could not create cache directory \"" + diskDir.getCanonicalPath() + "\".");
            }
            this.dataFile = new File(diskDir, cache.getName().replace('/', '_') + ".data");
            this.dataFile.deleteOnExit();
            this.map = EhcachePersistentConcurrentOffHeapClockCache.create(this.dataFile, cache.getCacheEventNotificationService(), config, new DerivedDiskConfiguration(cache.getName(), config.getMaxMemoryOffHeapInBytes()));
        }
        catch (IOException e) {
            throw new CacheException("Failed to create disk store", e);
        }
        this.eventService = cache.getCacheEventNotificationService();
        if (!this.status.compareAndSet(Status.STATUS_UNINITIALISED, Status.STATUS_ALIVE)) {
            throw new AssertionError();
        }
    }

    public OffHeapDiskStore(File dataFile, EhcachePersistentConcurrentOffHeapClockCache map, RegisteredEventListeners eventService) {
        this.dataFile = dataFile;
        this.map = map;
        this.eventService = eventService;
        if (!this.status.compareAndSet(Status.STATUS_UNINITIALISED, Status.STATUS_ALIVE)) {
            throw new AssertionError();
        }
    }

    @Override
    public boolean put(Element element) throws CacheException {
        if (element == null) {
            return false;
        }
        return this.map.put(element.getKey(), element) == null;
    }

    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        boolean result = this.put(element);
        if (writerManager != null) {
            writerManager.put(element);
        }
        return result;
    }

    @Override
    public Element get(Object key) {
        if (key == null) {
            return null;
        }
        return (Element)this.map.get(key);
    }

    @Override
    public Element getQuiet(Object key) {
        return this.get(key);
    }

    @Override
    public List<?> getKeys() {
        return new SetAsList(this.map.keySet());
    }

    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        return (Element)this.map.remove(key);
    }

    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        Element removed = this.remove(key);
        if (writerManager != null) {
            writerManager.remove(new CacheEntry(key, removed));
        }
        return removed;
    }

    @Override
    public void removeAll() throws CacheException {
        this.map.clear();
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        return this.map.putIfAbsent(element.getKey(), element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        Object key = element.getObjectKey();
        ReentrantReadWriteLock.WriteLock l = this.map.getLock(key).writeLock();
        l.lock();
        try {
            Element value = (Element)this.map.get(key);
            if (this.map.remove(key, element, comparator)) {
                Element element2 = value;
                return element2;
            }
            Element element3 = null;
            return element3;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        return this.map.replace(element.getKey(), old, element, comparator);
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        return this.map.replace(element.getKey(), element);
    }

    @Override
    public void dispose() {
        if (this.status.compareAndSet(Status.STATUS_ALIVE, Status.STATUS_SHUTDOWN)) {
            try {
                this.map.close();
                this.dataFile.delete();
            }
            catch (IOException e) {
                throw new CacheException("Failed to cleanly dispose the disk store", e);
            }
        }
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    @Override
    public int getInMemorySize() {
        return 0;
    }

    @Override
    public int getOffHeapSize() {
        return 0;
    }

    @Override
    public int getOnDiskSize() {
        return this.getSize();
    }

    @Override
    public int getTerracottaClusteredSize() {
        return 0;
    }

    @Override
    public long getInMemorySizeInBytes() {
        return 0L;
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return 0L;
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return this.map.getOccupiedMemory();
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return false;
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return false;
    }

    @Override
    public void expireElements() {
        for (Serializable key : this.map.keySet()) {
            Element value = this.get(key);
            if (!value.isExpired() || !this.map.remove(key, value)) continue;
            this.eventService.notifyElementExpiry(value, false);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean bufferFull() {
        return this.map.bufferFull();
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return null;
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
    }

    @Override
    public Object getInternalContext() {
        CacheLockProvider lp = this.lockProvider;
        return lp == null ? (this.lockProvider = new LockProvider()) : lp;
    }

    public ReadWriteLock getLock(Object key) {
        return this.map.getLock(key);
    }

    public void readLock() {
        for (ReentrantReadWriteLock l : this.map.getOrderedLocks()) {
            l.readLock().lock();
        }
    }

    public void readUnlock() {
        for (ReentrantReadWriteLock l : this.map.getOrderedLocks()) {
            l.readLock().unlock();
        }
    }

    public void writeLock() {
        for (ReentrantReadWriteLock l : this.map.getOrderedLocks()) {
            l.writeLock().lock();
        }
    }

    public void writeUnlock() {
        for (ReentrantReadWriteLock l : this.map.getOrderedLocks()) {
            l.writeLock().unlock();
        }
    }

    @Override
    public Object getMBean() {
        return new ConcurrentMapStatisticsManager(this.map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LockProvider
    implements CacheLockProvider {
        LockProvider() {
        }

        @Override
        public Sync[] getAndWriteLockAllSyncForKeys(Object ... keys) {
            Map<ReentrantReadWriteLock, AtomicInteger> segs = this.getSegmentsFor(keys);
            ArrayList<ReadWriteLockSync> ordered = new ArrayList<ReadWriteLockSync>();
            for (ReentrantReadWriteLock s : OffHeapDiskStore.this.map.getOrderedLocks()) {
                if (!segs.containsKey(s)) continue;
                AtomicInteger counter = segs.get(s);
                while (counter.getAndDecrement() > 0) {
                    s.writeLock().lock();
                }
                ordered.add(new ReadWriteLockSync(s));
            }
            return ordered.toArray(new Sync[ordered.size()]);
        }

        @Override
        public Sync[] getAndWriteLockAllSyncForKeys(long timeout, Object ... keys) throws TimeoutException {
            Map<ReentrantReadWriteLock, AtomicInteger> segs = this.getSegmentsFor(keys);
            ArrayList<ReentrantReadWriteLock.WriteLock> acquiredLocks = new ArrayList<ReentrantReadWriteLock.WriteLock>();
            ReentrantReadWriteLock.WriteLock unheldLock = null;
            ArrayList<ReadWriteLockSync> ordered = new ArrayList<ReadWriteLockSync>();
            for (ReentrantReadWriteLock s : OffHeapDiskStore.this.map.getOrderedLocks()) {
                boolean lockHeld;
                if (!segs.containsKey(s)) continue;
                try {
                    ReentrantReadWriteLock.WriteLock writeLock = s.writeLock();
                    lockHeld = writeLock.tryLock(timeout, TimeUnit.MILLISECONDS);
                    if (lockHeld) {
                        AtomicInteger counter = segs.get(s);
                        while (counter.decrementAndGet() > 0) {
                            writeLock.lock();
                            acquiredLocks.add(writeLock);
                        }
                        acquiredLocks.add(writeLock);
                    } else {
                        unheldLock = writeLock;
                    }
                }
                catch (InterruptedException e) {
                    lockHeld = false;
                }
                if (!lockHeld) {
                    for (int i = acquiredLocks.size() - 1; i >= 0; --i) {
                        Lock writeLock = (Lock)acquiredLocks.get(i);
                        writeLock.unlock();
                    }
                    throw new TimeoutException("could not acquire all locks in " + timeout + " ms - did not get " + unheldLock);
                }
                ordered.add(new ReadWriteLockSync(s));
            }
            return ordered.toArray(new Sync[ordered.size()]);
        }

        @Override
        public Sync getSyncForKey(Object key) {
            return new ReadWriteLockSync(OffHeapDiskStore.this.map.getLock(key));
        }

        @Override
        public void unlockWriteLockForAllKeys(Object ... keys) {
            for (Map.Entry<ReentrantReadWriteLock, AtomicInteger> entry : this.getSegmentsFor(keys).entrySet()) {
                while (entry.getValue().getAndDecrement() > 0) {
                    entry.getKey().writeLock().unlock();
                }
            }
        }

        private Map<ReentrantReadWriteLock, AtomicInteger> getSegmentsFor(Object ... keys) {
            HashMap<ReentrantReadWriteLock, AtomicInteger> segs = new HashMap<ReentrantReadWriteLock, AtomicInteger>();
            for (Object k : keys) {
                ReentrantReadWriteLock key = OffHeapDiskStore.this.map.getLock(k);
                if (segs.containsKey(key)) {
                    ((AtomicInteger)segs.get(key)).getAndIncrement();
                    continue;
                }
                segs.put(key, new AtomicInteger(1));
            }
            return segs;
        }
    }
}

