/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage;

import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.portability.Portability;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortabilityBasedStorageEngine<K, V>
implements StorageEngine<K, V> {
    protected final Portability<? super K> keyPortability;
    protected final Portability<? super V> valuePortability;
    private CachedEncode<K, V> lastMapping;

    public PortabilityBasedStorageEngine(Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this.keyPortability = keyPortability;
        this.valuePortability = valuePortability;
    }

    @Override
    public Long writeMapping(K key, V value, int hash) {
        ByteBuffer valueBuffer;
        if (this.lastMapping != null && this.lastMapping.getKey() == key && this.lastMapping.getValue() == value) {
            return this.writeMappingBuffers(this.lastMapping.getEncodedKey(), this.lastMapping.getEncodedValue(), hash);
        }
        ByteBuffer keyBuffer = this.keyPortability.encode(key);
        Long result = this.writeMappingBuffers(keyBuffer, valueBuffer = this.valuePortability.encode(value), hash);
        if (result == null) {
            this.lastMapping = new CachedEncode<K, V>(key, value, keyBuffer, valueBuffer);
        }
        return result;
    }

    @Override
    public void freeMapping(long encoding) {
        this.free(encoding);
    }

    @Override
    public V readValue(long encoding) {
        return this.valuePortability.decode(this.readValueBuffer(encoding));
    }

    @Override
    public boolean equalsValue(Object value, long encoding) {
        return this.valuePortability.equals(value, this.readValueBuffer(encoding));
    }

    @Override
    public K readKey(long encoding, int hashCode) {
        return this.keyPortability.decode(this.readKeyBuffer(encoding));
    }

    @Override
    public boolean equalsKey(Object key, long encoding) {
        return this.keyPortability.equals(key, this.readKeyBuffer(encoding));
    }

    protected abstract void free(long var1);

    protected abstract ByteBuffer readKeyBuffer(long var1);

    protected abstract ByteBuffer readValueBuffer(long var1);

    protected abstract Long writeMappingBuffers(ByteBuffer var1, ByteBuffer var2, int var3);

    @Override
    public void invalidateCache() {
        this.lastMapping = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CachedEncode<K, V> {
        private final K key;
        private final V value;
        private final ByteBuffer keyBuffer;
        private final ByteBuffer valueBuffer;

        public CachedEncode(K key, V value, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            this.key = key;
            this.value = value;
            this.keyBuffer = keyBuffer;
            this.valueBuffer = valueBuffer;
        }

        final K getKey() {
            return this.key;
        }

        final V getValue() {
            return this.value;
        }

        final ByteBuffer getEncodedKey() {
            return this.keyBuffer;
        }

        final ByteBuffer getEncodedValue() {
            return this.valueBuffer;
        }
    }
}

