/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.statistics;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.disk.persistent.Persistent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchableDelegatingSegment<K, V>
implements Segment<K, V>,
Persistent {
    private volatile Segment<K, V> delegate;

    public SwitchableDelegatingSegment(Segment<K, V> initial) {
        if (initial == null) {
            throw new NullPointerException();
        }
        this.delegate = initial;
    }

    public Segment<K, V> installDelegate(Segment<K, V> replacement) {
        if (replacement == null) {
            throw new NullPointerException();
        }
        Segment<K, V> old = this.delegate;
        this.delegate = replacement;
        return old;
    }

    public Segment<K, V> getDelegate() {
        return this.delegate;
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate.putAll(m);
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public long getUsedSlotCount() {
        return this.delegate.getUsedSlotCount();
    }

    @Override
    public long getTableCapacity() {
        return this.delegate.getTableCapacity();
    }

    @Override
    public long getSize() {
        return this.delegate.getSize();
    }

    @Override
    public long getRemovedSlotCount() {
        return this.delegate.getRemovedSlotCount();
    }

    @Override
    public int getReprobeLength() {
        return this.delegate.getReprobeLength();
    }

    @Override
    public long getPutCount() {
        return this.delegate.getPutCount();
    }

    @Override
    public long getOccupiedMemory() {
        return this.delegate.getOccupiedMemory();
    }

    @Override
    public long getMissCount() {
        return this.delegate.getMissCount();
    }

    @Override
    public long getMinimumLatency() {
        return this.delegate.getMinimumLatency();
    }

    @Override
    public long getMaximumLatency() {
        return this.delegate.getMaximumLatency();
    }

    @Override
    public long getHitCount() {
        return this.delegate.getHitCount();
    }

    @Override
    public long getDataOccupiedMemory() {
        return this.delegate.getDataOccupiedMemory();
    }

    @Override
    public long getDataAllocatedMemory() {
        return this.delegate.getDataAllocatedMemory();
    }

    @Override
    public long getAverageLatency() {
        return this.delegate.getAverageLatency();
    }

    @Override
    public long getSigmaLatency() {
        return this.delegate.getSigmaLatency();
    }

    @Override
    public long getLatencySampleSize() {
        return this.delegate.getLatencySampleSize();
    }

    @Override
    public long getAllocatedMemory() {
        return this.delegate.getAllocatedMemory();
    }

    @Override
    public V replace(K key, V value) {
        return this.delegate.replace(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public Lock getWriteLock() {
        return this.delegate.getWriteLock();
    }

    @Override
    public Lock getReadLock() {
        return this.delegate.getReadLock();
    }

    @Override
    public ReentrantReadWriteLock getLock() {
        return this.delegate.getLock();
    }

    @Override
    public void destroy() {
        this.delegate.destroy();
    }

    @Override
    public boolean shrink() {
        return this.delegate.shrink();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void flush() throws IOException {
        ((Persistent)((Object)this.delegate)).flush();
    }

    @Override
    public void close() throws IOException {
        ((Persistent)((Object)this.delegate)).close();
    }

    @Override
    public void persist(ObjectOutput output) throws IOException {
        ((Persistent)((Object)this.delegate)).persist(output);
    }

    @Override
    public void bootstrap(ObjectInput input) throws IOException {
        ((Persistent)((Object)this.delegate)).bootstrap(input);
    }
}

