/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.paging;

import com.terracottatech.offheapstore.buffersource.BufferSource;
import com.terracottatech.offheapstore.paging.OffHeapStorageArea;
import com.terracottatech.offheapstore.paging.Page;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.allocator.PowerOfTwoAllocator;
import com.terracottatech.offheapstore.util.DebuggingUtils;
import com.terracottatech.offheapstore.util.WeakIdentityHashMap;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpfrontAllocatingPageSource
implements PageSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpfrontAllocatingPageSource.class);
    private static final int ALLOCATION_PROGRESS_INTERVAL = 10;
    private static final long SLOW_ALLOCATION_DELAY = 1500L;
    private static final long CRITICAL_ALLOCATION_DELAY = 15000L;
    private static final String DO_NOT_HALT_SYSTEM_PROPERTY_NAME = "net.sf.ehcache.offheap.DoNotHaltOnCriticalAllocationDelay";
    private static final Comparator<Map.Entry<Page, AllocatedRegion>> REGION_COMPARATOR = new Comparator<Map.Entry<Page, AllocatedRegion>>(){

        @Override
        public int compare(Map.Entry<Page, AllocatedRegion> a, Map.Entry<Page, AllocatedRegion> b) {
            return a.getValue().address - b.getValue().address;
        }
    };
    private final List<PowerOfTwoAllocator> sliceAllocators = new ArrayList<PowerOfTwoAllocator>();
    private final List<PowerOfTwoAllocator> victimAllocators = new ArrayList<PowerOfTwoAllocator>();
    private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
    private final WeakIdentityHashMap<Page, AllocatedRegion> allocated = new WeakIdentityHashMap();
    private final List<WeakIdentityHashMap<Page, AllocatedRegion>> victims = new ArrayList<WeakIdentityHashMap<Page, AllocatedRegion>>();
    private final Cleaner cleaner;
    private volatile int availableSet = -1;

    public UpfrontAllocatingPageSource(BufferSource source, long max, int chunk) {
        this(source, max, chunk, -1, true);
    }

    public UpfrontAllocatingPageSource(BufferSource source, long max, int maxChunk, int minChunk) {
        this(source, max, maxChunk, minChunk, false);
    }

    private UpfrontAllocatingPageSource(BufferSource source, long max, int maxChunk, int minChunk, boolean fixed) {
        LOGGER.info("Allocating {}B in chunks", (Object)DebuggingUtils.toBase2SuffixedString(max));
        long start = System.currentTimeMillis();
        int chunk = (int)Math.min(max, (long)maxChunk);
        long size = 0L;
        int print = 10;
        long i = 0L;
        while (i < max) {
            long allocationDelay;
            long beforeAllocationTime = System.currentTimeMillis();
            int chunkSize = (int)Math.min((long)chunk, max - i);
            ByteBuffer b = source.allocateBuffer(chunkSize);
            if (b == null) {
                LOGGER.info("Allocated {}B in {}B chunks.", new Object[]{DebuggingUtils.toBase2SuffixedString(size), DebuggingUtils.toBase2SuffixedString(chunk)});
                size = 0L;
                if (fixed || (chunk >>>= 1) < minChunk) {
                    throw new IllegalArgumentException("An attempt was made to allocate more off-heap memory than the JVM can allow. The limit on off-heap memory size is given by the -XX:MaxDirectMemorySize command (or equivalent).");
                }
            } else {
                this.sliceAllocators.add(new PowerOfTwoAllocator(chunkSize));
                this.victimAllocators.add(new PowerOfTwoAllocator(chunkSize));
                this.victims.add(new WeakIdentityHashMap());
                this.buffers.add(b);
                i += (long)chunkSize;
                size += (long)chunkSize;
                while (100L * i / max >= (long)print) {
                    LOGGER.info("Allocation {}% complete", (Object)print);
                    print += 10;
                }
            }
            if ((allocationDelay = System.currentTimeMillis() - beforeAllocationTime) > 1500L) {
                LOGGER.warn("Off heap memory allocation is too slow - is the OS swapping?");
            }
            if (allocationDelay <= 15000L) continue;
            if (!Boolean.getBoolean(DO_NOT_HALT_SYSTEM_PROPERTY_NAME)) {
                LOGGER.error("Off heap memory allocation is way too slow - attempting to halt VM to prevent swap depletion. Please review your -XX:MaxDirectMemorySize and make sure the OS has enough resource to allocate {}B.", (Object)DebuggingUtils.toBase2SuffixedString(max));
                DebuggingUtils.commitSuicide("attempted VM halt");
                continue;
            }
            LOGGER.error("Off heap memory allocation is way too slow. Please review your -XX:MaxDirectMemorySize and make sure the OS has enough resource to allocate {}B.", (Object)DebuggingUtils.toBase2SuffixedString(max));
        }
        long end = System.currentTimeMillis();
        long timeToAllocate = end - start;
        LOGGER.info("Allocated {}B in {}B chunks.", new Object[]{DebuggingUtils.toBase2SuffixedString(size), DebuggingUtils.toBase2SuffixedString(chunk)});
        LOGGER.info("Took {} ms to create CacheManager off-heap storage of {}B.", (Object)timeToAllocate, (Object)DebuggingUtils.toBase2SuffixedString(max));
        this.cleaner = new Cleaner();
    }

    public void startCleaner() {
        LOGGER.info("Starting UpfrontAllocatingBufferSource Automatic Cleaner");
        this.cleaner.start();
    }

    public void stopCleaner() throws InterruptedException {
        LOGGER.info("Stopping UpfrontAllocatingBufferSource Automatic Cleaner");
        this.cleaner.shutdown();
        this.cleaner.join();
    }

    @Override
    public Page allocate(int size, boolean thief, boolean victim, OffHeapStorageArea owner) {
        if (thief) {
            return this.allocateAsThief(size, victim, owner);
        }
        return this.allocateFromFree(size, victim, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page allocateAsThief(int size, boolean victim, OffHeapStorageArea owner) {
        Page free = this.allocateFromFree(size, victim, owner);
        if (free != null) {
            return free;
        }
        PowerOfTwoAllocator victimAllocator = null;
        PowerOfTwoAllocator sliceAllocator = null;
        List<Object> targets = Collections.emptyList();
        ArrayList<AllocatedRegion> tempHolds = new ArrayList<AllocatedRegion>();
        IdentityHashMap releases = new IdentityHashMap();
        UpfrontAllocatingPageSource upfrontAllocatingPageSource = this;
        synchronized (upfrontAllocatingPageSource) {
            for (int i = 0; i < this.victimAllocators.size(); ++i) {
                int n;
                int n2 = this.victimAllocators.get(i).find(size);
                if (n2 < 0) continue;
                victimAllocator = this.victimAllocators.get(i);
                sliceAllocator = this.sliceAllocators.get(i);
                targets = this.findVictimPages(i, n2, size);
                int n3 = n2;
                for (Map.Entry entry : targets) {
                    AllocatedRegion r = (AllocatedRegion)entry.getValue();
                    victimAllocator.claim(r.address, r.size);
                    int claimSize = r.address - n;
                    if (claimSize > 0) {
                        tempHolds.add(new AllocatedRegion(-1, n, claimSize));
                        sliceAllocator.claim(n, claimSize);
                        victimAllocator.claim(n, claimSize);
                    }
                    n = r.address + r.size;
                }
                int claimSize = n2 + size - n;
                if (claimSize <= 0) break;
                tempHolds.add(new AllocatedRegion(-1, n, claimSize));
                sliceAllocator.claim(n, claimSize);
                victimAllocator.claim(n, claimSize);
                break;
            }
            if (targets.isEmpty()) {
                return this.allocateFromFree(size, victim, owner);
            }
            for (Map.Entry entry : targets) {
                Page page = (Page)entry.getKey();
                OffHeapStorageArea a = page.unbind();
                Collection collection = (Collection)releases.get(a);
                if (collection == null) {
                    LinkedList<Page> linkedList = new LinkedList<Page>();
                    linkedList.add(page);
                    releases.put(a, linkedList);
                    continue;
                }
                collection.add(page);
            }
        }
        LinkedList<Page> results = new LinkedList<Page>();
        for (Map.Entry entry : releases.entrySet()) {
            OffHeapStorageArea offHeapStorageArea = (OffHeapStorageArea)entry.getKey();
            Collection p = (Collection)entry.getValue();
            results.addAll(offHeapStorageArea.release(p));
        }
        UpfrontAllocatingPageSource upfrontAllocatingPageSource2 = this;
        synchronized (upfrontAllocatingPageSource2) {
            for (AllocatedRegion allocatedRegion : tempHolds) {
                sliceAllocator.free(allocatedRegion.address, allocatedRegion.size);
                victimAllocator.free(allocatedRegion.address, allocatedRegion.size);
            }
            if (results.size() == targets.size()) {
                for (Map.Entry entry : targets) {
                    AllocatedRegion r = (AllocatedRegion)entry.getValue();
                    victimAllocator.free(r.address, r.size);
                    this.free((Page)entry.getKey());
                }
                return this.allocateFromFree(size, victim, owner);
            }
            for (Map.Entry entry : targets) {
                Page p = (Page)entry.getKey();
                if (!results.contains(p)) continue;
                AllocatedRegion allocatedRegion = (AllocatedRegion)entry.getValue();
                victimAllocator.free(allocatedRegion.address, allocatedRegion.size);
                this.free(p);
            }
        }
        return this.allocateAsThief(size, victim, owner);
    }

    private List<Map.Entry<Page, AllocatedRegion>> findVictimPages(int chunk, int address, int size) {
        LinkedList<Map.Entry<Page, AllocatedRegion>> targets = new LinkedList<Map.Entry<Page, AllocatedRegion>>();
        Iterator<Map.Entry<Page, AllocatedRegion>> it = this.victims.get(chunk).entries();
        while (it.hasNext()) {
            Map.Entry<Page, AllocatedRegion> e = it.next();
            if (e == null) continue;
            AllocatedRegion r = e.getValue();
            if (r.address == address && r.size == size) {
                return Collections.singletonList(e);
            }
            if (r.address >= address + size || address >= r.address + r.size) continue;
            targets.add(e);
        }
        Collections.sort(targets, REGION_COMPARATOR);
        return targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page allocateFromFree(int size, boolean victim, OffHeapStorageArea owner) {
        if (Integer.bitCount(size) != 1) {
            int rounded = Integer.highestOneBit(size) << 1;
            LOGGER.info("Request to allocate {}B will allocate {}B", (Object)size, (Object)DebuggingUtils.toBase2SuffixedString(rounded));
            size = rounded;
        }
        if (this.isUnavailable(size)) {
            return null;
        }
        UpfrontAllocatingPageSource upfrontAllocatingPageSource = this;
        synchronized (upfrontAllocatingPageSource) {
            for (int i = 0; i < this.sliceAllocators.size(); ++i) {
                int address = this.sliceAllocators.get(i).allocate(size);
                if (address < 0) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Allocating a {}B buffer from chunk {} &{}", new Object[]{DebuggingUtils.toBase2SuffixedString(size), i, address});
                }
                AllocatedRegion r = new AllocatedRegion(i, address, size);
                ByteBuffer b = ((ByteBuffer)this.buffers.get(r.index).limit(address + size).position(address)).slice();
                Page p = new Page(b);
                this.allocated.put(p, r);
                if (victim) {
                    this.victims.get(i).put(p, r);
                } else {
                    this.victimAllocators.get(i).claim(address, size);
                }
                if (owner != null) {
                    p.bind(owner);
                }
                this.cleaner.register(p, r);
                return p;
            }
            this.markUnavailable(size);
            return null;
        }
    }

    @Override
    public synchronized void free(Page page) {
        AllocatedRegion r = this.allocated.remove(page);
        if (r != null) {
            if (r.size != page.size()) {
                throw new AssertionError();
            }
            if (r.clear()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Freeing a {}B buffer from chunk {} &{}", new Object[]{DebuggingUtils.toBase2SuffixedString(r.size), r.index, r.address});
                }
                this.markAllAvailable();
                this.sliceAllocators.get(r.index).free(r.address, r.size);
                this.victims.get(r.index).remove(page);
                this.victimAllocators.get(r.index).tryFree(r.address, r.size);
            }
        }
    }

    public synchronized long getAllocatedSize() {
        long sum = 0L;
        for (PowerOfTwoAllocator a : this.sliceAllocators) {
            sum += (long)a.occupied();
        }
        return sum;
    }

    public long getAllocatedSizeUnSync() {
        long sum = 0L;
        for (PowerOfTwoAllocator a : this.sliceAllocators) {
            sum += (long)a.occupied();
        }
        return sum;
    }

    private boolean isUnavailable(int size) {
        return (this.availableSet & size) == 0;
    }

    private synchronized void markAllAvailable() {
        this.availableSet = -1;
    }

    private synchronized void markUnavailable(int size) {
        this.availableSet &= ~size;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UpfrontAllocatingPageSource");
        for (int i = 0; i < this.buffers.size(); ++i) {
            sb.append("\nChunk ").append(i + 1).append('\n');
            sb.append("Size             : ").append(DebuggingUtils.toBase2SuffixedString(this.buffers.get(i).capacity())).append("B\n");
            sb.append("Free Allocator   : ").append(this.sliceAllocators.get(i)).append('\n');
            sb.append("Victim Allocator : ").append(this.victimAllocators.get(i));
        }
        return sb.toString();
    }

    class Cleaner
    extends Thread {
        final Map<Reference<?>, AllocatedRegion> phantom;
        final ReferenceQueue<Page> queue;
        volatile boolean shutdown;

        Cleaner() {
            super("UpfrontAllocatingBufferSource Cleaner");
            this.phantom = Collections.synchronizedMap(new HashMap());
            this.queue = new ReferenceQueue();
            this.shutdown = false;
            this.setDaemon(true);
        }

        void shutdown() {
            this.shutdown = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.shutdown) {
                try {
                    AllocatedRegion r = this.phantom.remove(this.queue.remove());
                    if (r == null || !r.clear()) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Freeing a {}B buffer from chunk {} &{} via GC detection", new Object[]{DebuggingUtils.toBase2SuffixedString(r.size), r.index, r.address});
                    }
                    UpfrontAllocatingPageSource upfrontAllocatingPageSource = UpfrontAllocatingPageSource.this;
                    synchronized (upfrontAllocatingPageSource) {
                        UpfrontAllocatingPageSource.this.markAllAvailable();
                        ((PowerOfTwoAllocator)UpfrontAllocatingPageSource.this.sliceAllocators.get(r.index)).free(r.address, r.size);
                        ((PowerOfTwoAllocator)UpfrontAllocatingPageSource.this.victimAllocators.get(r.index)).tryFree(r.address, r.size);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        void register(Page p, AllocatedRegion r) {
            if (this.isAlive()) {
                this.phantom.put(new PhantomReference<Page>(p, this.queue), r);
            }
        }
    }

    static class AllocatedRegion {
        final int index;
        final int address;
        final int size;
        boolean cleared = false;

        public AllocatedRegion(int index, int address, int size) {
            this.index = index;
            this.address = address;
            this.size = size;
        }

        synchronized boolean clear() {
            if (!this.cleared) {
                this.cleared = true;
                return true;
            }
            return false;
        }
    }
}

