/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.disk.storage;

import com.terracottatech.offheapstore.OffHeapHashMap;
import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.persistent.Persistent;
import com.terracottatech.offheapstore.disk.persistent.PersistentPortability;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngine;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngineFactory;
import com.terracottatech.offheapstore.disk.storage.AATreeFileAllocator;
import com.terracottatech.offheapstore.storage.PortabilityBasedStorageEngine;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBackedStorageEngine<K, V>
extends PortabilityBasedStorageEngine<K, V>
implements PersistentStorageEngine<K, V> {
    private static final int MAGIC = 1095582789;
    private static final int MAGIC_CHUNK = 1313753427;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBackedStorageEngine.class);
    private final ConcurrentHashMap<Long, FileWriteTask> pendingWrites = new ConcurrentHashMap();
    private final ExecutorService writeExecutor;
    private final MappedPageSource source;
    private final FileChannel writeChannel;
    private final AtomicReference<FileChannel> readChannelReference;
    private final long initialSize;
    private final int chunkIndexOffset;
    private final List<FileChunk> chunks = new CopyOnWriteArrayList<FileChunk>();

    public static <K, V> PersistentStorageEngineFactory<K, V> createFactory(final MappedPageSource source, final int initialSize, final PersistentPortability<? super K> keyPortability, final PersistentPortability<? super V> valuePortability) {
        return new PersistentStorageEngineFactory<K, V>(){

            @Override
            public PersistentStorageEngine<K, V> newInstance() {
                return new FileBackedStorageEngine(source, keyPortability, valuePortability, initialSize, new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()));
            }
        };
    }

    public static <K, V> PersistentStorageEngineFactory<K, V> createFactory(final MappedPageSource source, final int initialSize, final PersistentPortability<? super K> keyPortability, final PersistentPortability<? super V> valuePortability, final boolean bootstrap) {
        return new PersistentStorageEngineFactory<K, V>(){

            @Override
            public PersistentStorageEngine<K, V> newInstance() {
                return new FileBackedStorageEngine(source, keyPortability, valuePortability, initialSize, new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()), bootstrap);
            }
        };
    }

    public FileBackedStorageEngine(MappedPageSource source, PersistentPortability<? super K> keyPortability, PersistentPortability<? super V> valuePortability, int initialSize) {
        this(source, keyPortability, valuePortability, initialSize, true);
    }

    public FileBackedStorageEngine(MappedPageSource source, PersistentPortability<? super K> keyPortability, PersistentPortability<? super V> valuePortability, int initialSize, ThreadPoolExecutor writer) {
        this(source, keyPortability, valuePortability, initialSize, writer, true);
    }

    public FileBackedStorageEngine(MappedPageSource source, PersistentPortability<? super K> keyPortability, PersistentPortability<? super V> valuePortability, int initialSize, boolean bootstrap) {
        this(source, keyPortability, valuePortability, initialSize, new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>()), bootstrap);
    }

    public FileBackedStorageEngine(MappedPageSource source, PersistentPortability<? super K> keyPortability, PersistentPortability<? super V> valuePortability, int initialSize, ThreadPoolExecutor writer, boolean bootstrap) {
        super(keyPortability, valuePortability);
        if (writer.getMaximumPoolSize() != 1 || writer.getCorePoolSize() != 1) {
            throw new AssertionError();
        }
        this.writeExecutor = writer;
        this.writeChannel = source.getWritableChannel();
        this.readChannelReference = new AtomicReference<FileChannel>(source.getReadableChannel());
        this.source = source;
        this.initialSize = initialSize;
        this.chunkIndexOffset = 32 - Integer.numberOfLeadingZeros(initialSize);
        if (bootstrap) {
            this.chunks.add(new FileChunk(initialSize, 0L));
        }
    }

    @Override
    public void clear() {
        for (FileChunk c : this.chunks) {
            c.clear();
            if (!this.chunks.remove(c)) {
                throw new AssertionError((Object)"Concurrent modification while clearing!");
            }
        }
        if (!this.chunks.isEmpty()) {
            throw new AssertionError((Object)"Concurrent modification while clearing!");
        }
        this.chunks.add(new FileChunk(this.initialSize, 0L));
    }

    @Override
    public void bind(OffHeapHashMap<?, ?> owner) {
    }

    @Override
    public void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOGGER.warn("Exception while trying to close file backed storage engine", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Future<Void> flush = this.writeExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                FileBackedStorageEngine.this.writeChannel.force(true);
                return null;
            }
        });
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    flush.get();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.writeExecutor.shutdownNow();
            if (this.writeExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                LOGGER.debug("FileBackedStorageEngine for " + this.source.getFile().getName() + " terminated successfully");
            } else {
                LOGGER.warn("FileBackedStorageEngine for " + this.source.getFile().getName() + " timed-out during termination");
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("FileBackedStorageEngine for " + this.source.getFile().getName() + " interrupted during termination");
            Thread.currentThread().interrupt();
        }
        finally {
            try {
                this.writeChannel.close();
            }
            finally {
                ((FileChannel)this.readChannelReference.getAndSet(null)).close();
            }
        }
    }

    @Override
    public void persist(ObjectOutput output) throws IOException {
        output.writeInt(1095582789);
        ((Persistent)((Object)this.keyPortability)).persist(output);
        ((Persistent)((Object)this.valuePortability)).persist(output);
        output.writeInt(this.chunks.size());
        for (FileChunk c : this.chunks) {
            c.persist(output);
        }
    }

    @Override
    public void bootstrap(ObjectInput input) throws IOException {
        if (!this.chunks.isEmpty()) {
            throw new IllegalStateException();
        }
        if (input.readInt() != 1095582789) {
            throw new IOException("Wrong magic number");
        }
        ((Persistent)((Object)this.keyPortability)).bootstrap(input);
        ((Persistent)((Object)this.valuePortability)).bootstrap(input);
        int n = input.readInt();
        for (int i = 0; i < n; ++i) {
            this.chunks.add(new FileChunk(input));
        }
    }

    @Override
    protected void free(long address) {
        FileChunk chunk = this.findChunk(address);
        chunk.free(address - chunk.baseAddress());
    }

    @Override
    protected ByteBuffer readKeyBuffer(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.readKeyBuffer(address - chunk.baseAddress());
    }

    @Override
    protected ByteBuffer readValueBuffer(long address) {
        FileChunk chunk = this.findChunk(address);
        return chunk.readValueBuffer(address - chunk.baseAddress());
    }

    @Override
    protected Long writeMappingBuffers(ByteBuffer keyBuffer, ByteBuffer valueBuffer, int hash) {
        FileChunk c;
        Long address;
        for (FileChunk c2 : this.chunks) {
            Long address2 = c2.writeMappingBuffers(keyBuffer, valueBuffer);
            if (address2 == null) continue;
            return address2 + c2.baseAddress();
        }
        do {
            FileChunk last = this.chunks.get(this.chunks.size() - 1);
            long nextChunkSize = last.capacity() << 1;
            long nextChunkBaseAddress = last.baseAddress() + last.capacity();
            if (nextChunkSize < 0L) {
                return null;
            }
            c = new FileChunk(nextChunkSize, nextChunkBaseAddress);
            this.chunks.add(c);
        } while ((address = c.writeMappingBuffers(keyBuffer, valueBuffer)) == null);
        return address + c.baseAddress();
    }

    @Override
    public long getAllocatedMemory() {
        long sum = 0L;
        for (FileChunk c : this.chunks) {
            sum += c.capacity();
        }
        return sum;
    }

    @Override
    public long getOccupiedMemory() {
        long sum = 0L;
        for (FileChunk c : this.chunks) {
            sum += c.occupied();
        }
        return sum;
    }

    private FileChunk findChunk(long address) {
        int chunkIndex = 64 - Long.numberOfLeadingZeros(address + this.initialSize) - this.chunkIndexOffset;
        return this.chunks.get(chunkIndex);
    }

    private int readIntFromChannel(long position) throws IOException {
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        int i = 0;
        while (lengthBuffer.hasRemaining()) {
            int read = this.readFromChannel(lengthBuffer, position + (long)i);
            if (read < 0) {
                throw new EOFException();
            }
            i += read;
        }
        return ((ByteBuffer)lengthBuffer.flip()).getInt();
    }

    private void writeIntToChannel(long position, int data) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(data).flip();
        int i = 0;
        while (buffer.hasRemaining()) {
            int written = this.writeChannel.write(buffer, position + (long)i);
            if (written < 0) {
                throw new EOFException();
            }
            i += written;
        }
    }

    private void writeBufferToChannel(long position, ByteBuffer buffer) throws IOException {
        int i = 0;
        while (buffer.hasRemaining()) {
            int written = this.writeChannel.write(buffer, position + (long)i);
            if (written < 0) {
                throw new EOFException();
            }
            i += written;
        }
    }

    private int readFromChannel(ByteBuffer buffer, long position) throws IOException {
        FileChannel current = this.readChannelReference.get();
        if (current == null) {
            throw new IOException("Storage engine is closed");
        }
        try {
            return this.readFromChannel(current, buffer, position);
        }
        catch (ClosedChannelException e) {
            boolean interrupted = Thread.interrupted();
            while (true) {
                current = this.readChannelReference.get();
                try {
                    int n = this.readFromChannel(current, buffer, position);
                    return n;
                }
                catch (ClosedChannelException f) {
                    interrupted |= Thread.interrupted();
                    FileChannel newChannel = this.source.getReadableChannel();
                    if (!this.readChannelReference.compareAndSet(current, newChannel)) {
                        newChannel.close();
                        continue;
                    }
                    LOGGER.info("Creating new read-channel for " + this.source.getFile().getName() + " as previous one was closed (likely due to interrupt)");
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private int readFromChannel(FileChannel channel, ByteBuffer buffer, long position) throws IOException {
        int ret = channel.read(buffer, position);
        if (ret < 0) {
            ret = channel.read(buffer, position);
        }
        return ret;
    }

    @Override
    public boolean shrink() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileWriteTask
    implements Runnable {
        private final FileChunk chunk;
        private final ByteBuffer keyBuffer;
        private final ByteBuffer valueBuffer;
        private final long position;

        FileWriteTask(FileChunk chunk, long position, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            this.chunk = chunk;
            this.position = position;
            this.keyBuffer = keyBuffer;
            this.valueBuffer = valueBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FileChunk fileChunk = this.chunk;
                synchronized (fileChunk) {
                    if (this.chunk.isValid()) {
                        try {
                            try {
                                this.write();
                            }
                            catch (IOException e) {
                                LOGGER.warn("Received IOException '{}' while trying to write @ {} : trying again", (Object)e.getMessage(), (Object)this.position);
                                this.write();
                            }
                        }
                        catch (ClosedChannelException e) {
                            LOGGER.debug("DiskWriteTask terminated due to closed channel - we must be shutting down", (Throwable)e);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Received IOException '{}' during write @ {} : giving up", (Object)e.getMessage(), (Object)this.position);
                        }
                        catch (OutOfMemoryError e) {
                            LOGGER.error("Failed to allocate a direct buffer for a FileChannel write.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                            throw e;
                        }
                    }
                }
            }
            finally {
                FileBackedStorageEngine.this.pendingWrites.remove(this.position, this);
            }
        }

        private void write() throws IOException {
            ByteBuffer key = this.getKeyBuffer();
            ByteBuffer value = this.getValueBuffer();
            int keyLength = key.remaining();
            int valueLength = value.remaining();
            FileBackedStorageEngine.this.writeIntToChannel(this.position, keyLength + valueLength + 4);
            FileBackedStorageEngine.this.writeIntToChannel(this.position + 4L, keyLength);
            FileBackedStorageEngine.this.writeBufferToChannel(this.position + 8L, key);
            FileBackedStorageEngine.this.writeBufferToChannel(this.position + 8L + (long)keyLength, value);
            long size = FileBackedStorageEngine.this.writeChannel.size();
            long expected = this.position + (long)keyLength + (long)valueLength + 8L;
            if (size < expected) {
                throw new IOException("File size does not encompass last write [size:" + size + " end-of-write:" + expected);
            }
        }

        ByteBuffer getKeyBuffer() {
            return this.keyBuffer.duplicate();
        }

        ByteBuffer getValueBuffer() {
            return this.valueBuffer.duplicate();
        }
    }

    class FileChunk {
        private final AATreeFileAllocator allocator;
        private final long filePosition;
        private final long baseAddress;
        private boolean valid = true;

        FileChunk(long size, long baseAddress) {
            Long newOffset = FileBackedStorageEngine.this.source.allocateRegion(size);
            if (newOffset == null) {
                StringBuilder sb = new StringBuilder("Storage engine initial file data area allocation failed:\n");
                sb.append("Allocator: ").append(FileBackedStorageEngine.this.source);
                throw new IllegalArgumentException(sb.toString());
            }
            this.filePosition = newOffset;
            this.allocator = new AATreeFileAllocator(size);
            this.baseAddress = baseAddress;
        }

        FileChunk(ObjectInput input) throws IOException {
            if (input.readInt() != 1313753427) {
                throw new IOException("Wrong magic number");
            }
            this.filePosition = input.readLong();
            this.baseAddress = input.readLong();
            long size = input.readLong();
            FileBackedStorageEngine.this.source.claimRegion(this.filePosition, size);
            this.allocator = new AATreeFileAllocator(size, input);
        }

        ByteBuffer readKeyBuffer(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    int keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    ByteBuffer data = ByteBuffer.allocate(keyLength);
                    int i = 0;
                    while (data.hasRemaining()) {
                        int read = FileBackedStorageEngine.this.readFromChannel(data, position + (long)i + 8L);
                        if (read < 0) {
                            throw new EOFException();
                        }
                        i += read;
                    }
                    return (ByteBuffer)data.rewind();
                }
                return pending.getKeyBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Failed to allocate direct buffer for FileChannel read.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                throw e;
            }
        }

        ByteBuffer readValueBuffer(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.get(position);
                if (pending == null) {
                    int length = FileBackedStorageEngine.this.readIntFromChannel(position);
                    int keyLength = FileBackedStorageEngine.this.readIntFromChannel(position + 4L);
                    ByteBuffer data = ByteBuffer.allocate(length - keyLength - 4);
                    int i = 0;
                    while (data.hasRemaining()) {
                        int read = FileBackedStorageEngine.this.readFromChannel(data, position + (long)keyLength + 8L);
                        if (read < 0) {
                            throw new EOFException();
                        }
                        i += read;
                    }
                    return (ByteBuffer)data.rewind();
                }
                return pending.getValueBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                LOGGER.error("Failed to allocate direct buffer for FileChannel read.  Consider increasing the -XX:MaxDirectMemorySize property to allow enough space for the FileChannel transfer buffers");
                throw e;
            }
        }

        Long writeMappingBuffers(ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            int valueLength;
            int keyLength = keyBuffer.remaining();
            long address = this.allocator.allocate(keyLength + (valueLength = valueBuffer.remaining()) + 8);
            if (address >= 0L) {
                long position = this.filePosition + address;
                FileWriteTask task = new FileWriteTask(this, position, keyBuffer, valueBuffer);
                FileBackedStorageEngine.this.pendingWrites.put(position, task);
                FileBackedStorageEngine.this.writeExecutor.execute(task);
                return address;
            }
            return null;
        }

        void free(long address) {
            try {
                long position = this.filePosition + address;
                FileWriteTask pending = (FileWriteTask)FileBackedStorageEngine.this.pendingWrites.remove(position);
                if (pending == null) {
                    ByteBuffer length = ByteBuffer.allocate(4);
                    int i = 0;
                    while (length.hasRemaining()) {
                        i += FileBackedStorageEngine.this.readFromChannel(length, position + (long)i);
                    }
                    this.allocator.free(address, ((ByteBuffer)length.rewind()).getInt() + 4);
                } else {
                    int keyLength = pending.getKeyBuffer().remaining();
                    int valueLength = pending.getValueBuffer().remaining();
                    this.allocator.free(address, keyLength + valueLength + 8);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        synchronized void clear() {
            FileBackedStorageEngine.this.source.freeRegion(this.filePosition);
            this.valid = false;
        }

        long capacity() {
            return this.allocator.capacity();
        }

        long occupied() {
            return this.allocator.occupied();
        }

        long baseAddress() {
            return this.baseAddress;
        }

        void persist(ObjectOutput output) throws IOException {
            output.writeInt(1313753427);
            output.writeLong(this.filePosition);
            output.writeLong(this.baseAddress);
            output.writeLong(this.allocator.capacity());
            this.allocator.persist(output);
        }

        synchronized boolean isValid() {
            return this.valid;
        }
    }
}

