/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.disk.persistent;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.concurrent.SegmentFactory;
import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.persistent.PersistentReadWriteLockedOffHeapClockCache;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngine;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentReadWriteLockedOffHeapClockCacheFactory<K, V>
implements SegmentFactory<K, V> {
    private static final int DEFAULT_TABLE_SIZE = 128;
    private final PersistentStorageEngineFactory<? super K, ? super V> storageEngineFactory;
    private final MappedPageSource tableSource;
    private final int tableSize;
    private final boolean bootstrap;

    public PersistentReadWriteLockedOffHeapClockCacheFactory(MappedPageSource tableSource, PersistentStorageEngineFactory<? super K, ? super V> storageEngineFactory) {
        this(tableSource, storageEngineFactory, 128);
    }

    public PersistentReadWriteLockedOffHeapClockCacheFactory(MappedPageSource tableSource, PersistentStorageEngineFactory<? super K, ? super V> storageEngineFactory, boolean bootstrap) {
        this(tableSource, storageEngineFactory, 128, bootstrap);
    }

    public PersistentReadWriteLockedOffHeapClockCacheFactory(MappedPageSource tableSource, PersistentStorageEngineFactory<? super K, ? super V> storageEngineFactory, int tableSize) {
        this(tableSource, storageEngineFactory, tableSize, true);
    }

    public PersistentReadWriteLockedOffHeapClockCacheFactory(MappedPageSource tableSource, PersistentStorageEngineFactory<? super K, ? super V> storageEngineFactory, int tableSize, boolean bootstrap) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = tableSource;
        this.tableSize = tableSize;
        this.bootstrap = bootstrap;
    }

    @Override
    public Segment<K, V> newInstance() {
        PersistentStorageEngine<K, V> storageEngine = this.storageEngineFactory.newInstance();
        try {
            return new PersistentReadWriteLockedOffHeapClockCache<K, V>(this.tableSource, storageEngine, this.tableSize, this.bootstrap);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }
}

