/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore;

import com.terracottatech.offheapstore.AbstractLockedOffHeapHashMap;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.StorageEngine;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOffHeapClockCache<K, V>
extends AbstractLockedOffHeapHashMap<K, V> {
    private static final int PRESENT_CLOCK = Integer.MIN_VALUE;
    private final Random rndm = new Random();
    private int clockHand;

    public AbstractOffHeapClockCache(PageSource source, StorageEngine<? super K, ? super V> storageEngine) {
        super(source, storageEngine);
    }

    public AbstractOffHeapClockCache(PageSource source, StorageEngine<? super K, ? super V> storageEngine, boolean bootstrap) {
        super(source, storageEngine, bootstrap);
    }

    public AbstractOffHeapClockCache(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        super(source, storageEngine, tableSize);
    }

    public AbstractOffHeapClockCache(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap) {
        super(source, storageEngine, tableSize, bootstrap);
    }

    @Override
    protected void storageEngineFailure(int activeIndex, Object failure) {
        int evictionIndex;
        if (this.isEmpty()) {
            StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed.\n");
            sb.append("Storage Engine : ").append(this.storageEngine);
            throw new OversizeMappingException(sb.toString());
        }
        while ((evictionIndex = this.getEvictionIndex()) == activeIndex) {
            if (this.size() != 1) continue;
            StringBuilder sb = new StringBuilder("Storage Engine and Eviction Failed.\n");
            sb.append("Storage Engine : ").append(this.storageEngine);
            throw new OversizeMappingException(sb.toString());
        }
        this.evict(evictionIndex, false);
    }

    @Override
    protected void tableExpansionFailure(int start, int length) {
        this.evict(this.getEvictionIndex(start, length), false);
    }

    @Override
    protected void hit(int position) {
        this.hashtable.put(position + 0, -2147483647);
    }

    private int getEvictionIndex() {
        int initialHand = this.clockHand;
        int loops = 0;
        do {
            int hand;
            if ((this.clockHand += 4) + 0 >= this.hashtable.capacity()) {
                this.clockHand = 0;
            }
            if ((hand = this.hashtable.get(this.clockHand + 0)) == -2147483647) {
                this.hashtable.put(this.clockHand + 0, 1);
                continue;
            }
            if (hand != 1) continue;
            return this.clockHand;
        } while (initialHand != this.clockHand || ++loops != 2);
        throw new AssertionError((Object)("Clock Eviction Failure : " + this.size()));
    }

    private int getEvictionIndex(int start, int length) {
        int index = this.getEvictionIndex();
        int tableLength = this.hashtable.capacity();
        int probeLength = length * 4;
        if (probeLength >= this.hashtable.capacity()) {
            return index;
        }
        int end = start + probeLength & tableLength - 1;
        if (end > start && index >= start && index <= end) {
            return index;
        }
        if (end < start && (index >= start || index < end)) {
            return index;
        }
        this.evict(index, false);
        int clock = start;
        for (int i = 0; i < length; ++i) {
            int hand;
            if ((clock += 4) >= tableLength) {
                clock = start;
            }
            if ((hand = this.hashtable.get(clock + 0)) != 1) continue;
            return clock;
        }
        return start + 4 * this.rndm.nextInt(length) & tableLength - 1;
    }
}

