/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.propertydescriptor;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import org.dozer.BeanBuilder;
import org.dozer.builder.ProtoBeanBuilder;
import org.dozer.fieldmap.FieldMap;
import org.dozer.fieldmap.HintContainer;
import org.dozer.propertydescriptor.AbstractPropertyDescriptor;
import org.dozer.util.DeepHierarchyUtils;
import org.dozer.util.MappingUtils;
import org.dozer.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoFieldPropertyDescriptor
extends AbstractPropertyDescriptor {
    private final Logger logger = LoggerFactory.getLogger(ProtoFieldPropertyDescriptor.class);
    private Class<?> _propertyType;
    private Class<?> _genericType;
    private Descriptors.FieldDescriptor _fieldDescriptor;

    public ProtoFieldPropertyDescriptor(Class<?> clazz, String fieldName, boolean isIndexed, int index, HintContainer srcDeepIndexHintContainer, HintContainer destDeepIndexHintContainer) {
        super(clazz, fieldName, isIndexed, index, srcDeepIndexHintContainer, destDeepIndexHintContainer);
    }

    public Class<?> getPropertyType() {
        if (this._propertyType == null) {
            Class result;
            if (MappingUtils.isDeepMapping((String)this.fieldName)) {
                try {
                    result = DeepHierarchyUtils.getDeepFieldType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.srcDeepIndexHintContainer);
                }
                catch (Exception ignore) {
                    this.logger.info("Determine field type by srcDeepIndexHintContainer failed");
                    try {
                        result = DeepHierarchyUtils.getDeepFieldType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.destDeepIndexHintContainer);
                    }
                    catch (Exception secondIgnore) {
                        this.logger.info("Determine field type by destDeepIndexHintContainer failed");
                        result = null;
                    }
                }
            } else {
                result = ProtoUtils.getJavaClass(this.getFieldDescriptor());
            }
            this._propertyType = result;
        }
        return this._propertyType;
    }

    public Object getPropertyValue(Object bean) {
        Object result;
        if (MappingUtils.isDeepMapping((String)this.fieldName)) {
            result = DeepHierarchyUtils.getDeepFieldValue((Object)bean, (String)this.fieldName, (boolean)this.isIndexed, (int)this.index, (HintContainer)this.srcDeepIndexHintContainer);
        } else {
            result = this.getSimplePropertyValue(bean);
            if (this.isIndexed) {
                result = MappingUtils.getIndexedValue((Object)result, (int)this.index);
            }
        }
        return result;
    }

    private Object getSimplePropertyValue(Object bean) {
        if (bean instanceof BeanBuilder) {
            return null;
        }
        if (!(bean instanceof Message)) {
            MappingUtils.throwMappingException((String)"Try to pass non proto object to ProtoFieldPropertyDescriptor");
        }
        Message message = (Message)bean;
        Object value = ProtoUtils.getFieldValue(message, this.fieldName);
        return ProtoUtils.unwrapEnums(value);
    }

    public void setPropertyValue(Object bean, Object value, FieldMap fieldMap) {
        if (!(bean instanceof ProtoBeanBuilder)) {
            MappingUtils.throwMappingException((String)"should be a ProtoBeanBuilder instance");
        }
        ProtoBeanBuilder builder = (ProtoBeanBuilder)bean;
        if ((value = ProtoUtils.wrapEnums(value)) != null) {
            builder.internalProtoBuilder().setField(this.getFieldDescriptor(), value);
        } else {
            builder.internalProtoBuilder().clearField(this.getFieldDescriptor());
        }
    }

    public Class<?> genericType() {
        if (this._genericType == null) {
            Class result;
            if (MappingUtils.isDeepMapping((String)this.fieldName)) {
                try {
                    result = DeepHierarchyUtils.getDeepGenericType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.srcDeepIndexHintContainer);
                }
                catch (Exception ignore) {
                    this.logger.info("Determine field generic type by srcDeepIndexHintContainer failed");
                    try {
                        result = DeepHierarchyUtils.getDeepGenericType((Class)this.clazz, (String)this.fieldName, (HintContainer)this.destDeepIndexHintContainer);
                    }
                    catch (Exception secondIgnore) {
                        this.logger.info("Determine field generic type by destDeepIndexHintContainer failed");
                        result = null;
                    }
                }
            } else {
                result = ProtoUtils.getJavaGenericClassForCollection(this.getFieldDescriptor());
            }
            this._genericType = result;
        }
        return this._genericType;
    }

    private Descriptors.FieldDescriptor getFieldDescriptor() {
        if (this._fieldDescriptor == null) {
            this._fieldDescriptor = ProtoUtils.getFieldDescriptor(this.clazz, this.fieldName);
            if (this._fieldDescriptor == null && !MappingUtils.isDeepMapping((String)this.fieldName)) {
                MappingUtils.throwMappingException((String)("No field descriptor for field with name: " + this.fieldName));
            }
        }
        return this._fieldDescriptor;
    }
}

