/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import org.dozer.classmap.MappingFileData;
import org.dozer.loader.xml.XMLParser;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.util.MappingUtils;
import org.dozer.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class MappingFileReader {
    private static final Logger log = LoggerFactory.getLogger(MappingFileReader.class);
    private final DocumentBuilder documentBuilder;

    public MappingFileReader(XMLParserFactory parserFactory) {
        this.documentBuilder = parserFactory.createParser();
    }

    public MappingFileData read(String fileName) {
        ResourceLoader loader = new ResourceLoader();
        URL url = loader.getResource(fileName);
        return this.read(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingFileData read(URL url) {
        MappingFileData result = null;
        InputStream stream = null;
        try {
            stream = url.openStream();
            Document document = this.documentBuilder.parse(stream);
            XMLParser parser = new XMLParser(document);
            result = parser.load();
        }
        catch (Throwable e) {
            log.error("Error while loading dozer mapping file url: [" + url + "]", e);
            MappingUtils.throwMappingException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                MappingUtils.throwMappingException(e);
            }
        }
        return result;
    }
}

