/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigDecimalConverter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.lang.ClassUtils;
import org.dozer.converters.CalendarConverter;
import org.dozer.converters.ConversionException;
import org.dozer.converters.DateConverter;
import org.dozer.converters.DateFormatContainer;
import org.dozer.converters.IntegerConverter;
import org.dozer.converters.LongConverter;
import org.dozer.converters.StringConstructorConverter;
import org.dozer.converters.StringConverter;
import org.dozer.converters.XMLGregorianCalendarConverter;

public class PrimitiveOrWrapperConverter {
    private static final Map CONVERTER_MAP = new HashMap(10);

    public Object convert(Object srcFieldValue, Class destFieldClass, DateFormatContainer dateFormatContainer) {
        if (srcFieldValue == null || destFieldClass == null || srcFieldValue.equals("") && !destFieldClass.equals(String.class)) {
            return null;
        }
        Converter converter = this.getPrimitiveOrWrapperConverter(destFieldClass, dateFormatContainer);
        try {
            return converter.convert(destFieldClass, srcFieldValue);
        }
        catch (org.apache.commons.beanutils.ConversionException e) {
            throw new ConversionException(e);
        }
    }

    private Converter getPrimitiveOrWrapperConverter(Class destClass, DateFormatContainer dateFormatContainer) {
        if (String.class.equals((Object)destClass)) {
            return new StringConverter(dateFormatContainer);
        }
        Converter result = (Converter)CONVERTER_MAP.get(ClassUtils.primitiveToWrapper((Class)destClass));
        if (result == null) {
            if (Date.class.isAssignableFrom(destClass)) {
                result = new DateConverter(dateFormatContainer.getDateFormat());
            }
            if (Calendar.class.isAssignableFrom(destClass)) {
                result = new CalendarConverter(dateFormatContainer.getDateFormat());
            }
            if (XMLGregorianCalendar.class.isAssignableFrom(destClass)) {
                result = new XMLGregorianCalendarConverter(dateFormatContainer.getDateFormat());
            }
        }
        return result == null ? new StringConstructorConverter(dateFormatContainer) : result;
    }

    static {
        CONVERTER_MAP.put(Integer.class, new IntegerConverter());
        CONVERTER_MAP.put(Double.class, new DoubleConverter());
        CONVERTER_MAP.put(Short.class, new ShortConverter());
        CONVERTER_MAP.put(Character.class, new CharacterConverter());
        CONVERTER_MAP.put(Long.class, new LongConverter());
        CONVERTER_MAP.put(Boolean.class, new BooleanConverter());
        CONVERTER_MAP.put(Byte.class, new ByteConverter());
        CONVERTER_MAP.put(Float.class, new FloatConverter());
        CONVERTER_MAP.put(BigDecimal.class, new BigDecimalConverter());
        CONVERTER_MAP.put(BigInteger.class, new BigIntegerConverter());
    }
}

