/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.classmap;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.dozer.classmap.ClassMap;
import org.dozer.classmap.ClassMapKeyFactory;
import org.dozer.util.MappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMappings {
    private Map<String, ClassMap> classMappings = new ConcurrentHashMap<String, ClassMap>();
    private ClassMapKeyFactory keyFactory = new ClassMapKeyFactory();

    public void add(Class<?> srcClass, Class<?> destClass, ClassMap classMap) {
        ClassMap result = this.classMappings.put(this.keyFactory.createKey(srcClass, destClass), classMap);
        this.failOnDuplicate(result, classMap);
    }

    public void add(Class<?> srcClass, Class<?> destClass, String mapId, ClassMap classMap) {
        ClassMap result = this.classMappings.put(this.keyFactory.createKey(srcClass, destClass, mapId), classMap);
        this.failOnDuplicate(result, classMap);
    }

    public void addAll(ClassMappings additionalClassMappings) {
        Map<String, ClassMap> newMappings = additionalClassMappings.getAll();
        for (Map.Entry<String, ClassMap> entry : newMappings.entrySet()) {
            ClassMap result = this.classMappings.put(entry.getKey(), entry.getValue());
            this.failOnDuplicate(result, entry.getValue());
        }
    }

    public void failOnDuplicate(Object result, ClassMap classMap) {
        if (result != null && !classMap.getSrcClassName().equals(classMap.getDestClassName())) {
            throw new IllegalArgumentException("Duplicate Class Mapping Found. Source: " + classMap.getSrcClassName() + " Destination: " + classMap.getDestClassName() + " map-id: " + classMap.getMapId());
        }
    }

    public Map<String, ClassMap> getAll() {
        return new HashMap<String, ClassMap>(this.classMappings);
    }

    public long size() {
        return this.classMappings.size();
    }

    public ClassMap find(Class<?> srcClass, Class<?> destClass) {
        return this.classMappings.get(this.keyFactory.createKey(srcClass, destClass));
    }

    public boolean contains(Class<?> srcClass, Class<?> destClass, String mapId) {
        String key = this.keyFactory.createKey(srcClass, destClass, mapId);
        return this.classMappings.containsKey(key);
    }

    public ClassMap find(Class<?> srcClass, Class<?> destClass, String mapId) {
        String key = this.keyFactory.createKey(srcClass, destClass, mapId);
        ClassMap mapping = this.classMappings.get(key);
        if (mapping == null) {
            mapping = this.findInterfaceMapping(destClass, srcClass, mapId);
        }
        if (!MappingUtils.isBlankOrNull(mapId) && mapping == null) {
            for (Map.Entry<String, ClassMap> entry : this.classMappings.entrySet()) {
                ClassMap classMap = entry.getValue();
                if (StringUtils.equals((String)classMap.getMapId(), (String)mapId) && classMap.getSrcClassToMap().isAssignableFrom(srcClass) && classMap.getDestClassToMap().isAssignableFrom(destClass)) {
                    return classMap;
                }
                if (!StringUtils.equals((String)classMap.getMapId(), (String)mapId) || !srcClass.equals(destClass)) continue;
                return classMap;
            }
            MappingUtils.throwMappingException("Class mapping not found by map-id: " + key);
        }
        return mapping;
    }

    private ClassMap findInterfaceMapping(Class<?> destClass, Class<?> srcClass, String mapId) {
        Object[] keys;
        for (Object key : keys = this.classMappings.keySet().toArray()) {
            ClassMap map = this.classMappings.get(key);
            Class<?> mappingDestClass = map.getDestClassToMap();
            Class<?> mappingSrcClass = map.getSrcClassToMap();
            if (mapId == null && map.getMapId() != null || mapId != null && !mapId.equals(map.getMapId())) continue;
            if (mappingSrcClass.isInterface() && mappingSrcClass.isAssignableFrom(srcClass)) {
                if (mappingDestClass.isInterface() && mappingDestClass.isAssignableFrom(destClass)) {
                    return map;
                }
                if (destClass.equals(mappingDestClass)) {
                    return map;
                }
            }
            if (!destClass.isAssignableFrom(mappingDestClass) && (!mappingDestClass.isInterface() || !mappingDestClass.isAssignableFrom(destClass)) || !MappingUtils.getRealClass(srcClass).equals(mappingSrcClass)) continue;
            return map;
        }
        return null;
    }
}

