/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.util;

import org.apache.commons.lang.ClassUtils;
import org.dozer.util.DozerConstants;
import org.dozer.util.DozerProxyResolver;
import org.dozer.util.MappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxyResolver
implements DozerProxyResolver {
    @Override
    public Class<?> loadClass(String name) {
        Class result = null;
        try {
            result = ClassUtils.getClass((String)name);
        }
        catch (ClassNotFoundException e) {
            MappingUtils.throwMappingException(e);
        }
        return result;
    }

    @Override
    public boolean isProxy(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        return clazz.getName().contains("$$EnhancerByCGLIB$$") || clazz.getName().contains("$$_javassist");
    }

    @Override
    public Class<?> getRealSuperclass(Class<?> clazz) {
        if (this.isProxy(clazz)) {
            return clazz.getSuperclass().getSuperclass();
        }
        return clazz.getSuperclass();
    }

    @Override
    public Class<?> getRealClass(Class<?> clazz) {
        if (this.isProxy(clazz)) {
            Class<?> superclass = clazz.getSuperclass();
            if (DozerConstants.BASE_CLASS.equals(superclass.getName())) {
                return clazz;
            }
            return superclass;
        }
        return clazz;
    }
}

