/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader.xml;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dozer.classmap.MappingDirection;
import org.dozer.classmap.MappingFileData;
import org.dozer.classmap.RelationshipType;
import org.dozer.config.BeanContainer;
import org.dozer.loader.DozerBuilder;
import org.dozer.loader.MappingsSource;
import org.dozer.loader.xml.ELEngine;
import org.dozer.loader.xml.ElementReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLParser
implements MappingsSource {
    private static final Log log = LogFactory.getLog(XMLParser.class);
    private static final String WILDCARD = "wildcard";
    private static final String TRIM_STRINGS = "trim-strings";
    private static final String BEAN_FACTORY = "bean-factory";
    private static final String DATE_FORMAT = "date-format";
    private static final String RELATIONSHIP_TYPE = "relationship-type";
    private static final String REMOVE_ORPHANS = "remove-orphans";
    private static final String CONFIGURATION_ELEMENT = "configuration";
    private static final String STOP_ON_ERRORS_ELEMENT = "stop-on-errors";
    private static final String CUSTOM_CONVERTERS_ELEMENT = "custom-converters";
    private static final String COPY_BY_REFERENCES_ELEMENT = "copy-by-references";
    private static final String COPY_BY_REFERENCE = "copy-by-reference";
    private static final String CONVERTER_ELEMENT = "converter";
    private static final String CLASS_A_ELEMENT = "class-a";
    private static final String CLASS_B_ELEMENT = "class-b";
    private static final String MAPPING_ELEMENT = "mapping";
    private static final String FIELD_ELEMENT = "field";
    private static final String FIELD_EXCLUDE_ELEMENT = "field-exclude";
    private static final String A_ELEMENT = "a";
    private static final String B_ELEMENT = "b";
    private static final String SRC_TYPE_HINT_ELEMENT = "a-hint";
    private static final String DEST_TYPE_HINT_ELEMENT = "b-hint";
    private static final String SRC_TYPE_DEEP_INDEX_HINT_ELEMENT = "a-deep-index-hint";
    private static final String DEST_TYPE_DEEP_INDEX_HINT_ELEMENT = "b-deep-index-hint";
    private static final String ALLOWED_EXCEPTIONS_ELEMENT = "allowed-exceptions";
    private static final String ALLOWED_EXCEPTION_ELEMENT = "exception";
    private static final String VARIABLES_ELEMENT = "variables";
    private static final String VARIABLE_ELEMENT = "variable";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String COPY_BY_REFERENCE_ATTRIBUTE = "copy-by-reference";
    private static final String THE_SET_METHOD_ATTRIBUTE = "set-method";
    private static final String THE_GET_METHOD_ATTRIBUTE = "get-method";
    private static final String STOP_ON_ERRORS_ATTRIBUTE = "stop-on-errors";
    private static final String MAPID_ATTRIBUTE = "map-id";
    private static final String MAP_SET_METHOD_ATTRIBUTE = "map-set-method";
    private static final String MAP_GET_METHOD_ATTRIBUTE = "map-get-method";
    private static final String KEY_ATTRIBUTE = "key";
    private static final String FACTORY_BEANID_ATTRIBUTE = "factory-bean-id";
    private static final String IS_ACCESSIBLE_ATTRIBUTE = "is-accessible";
    private static final String CREATE_METHOD_ATTRIBUTE = "create-method";
    private static final String MAP_NULL_ATTRIBUTE = "map-null";
    private static final String MAP_EMPTY_STRING_ATTRIBUTE = "map-empty-string";
    private static final String CUSTOM_CONVERTER_ATTRIBUTE = "custom-converter";
    private static final String CUSTOM_CONVERTER_ID_ATTRIBUTE = "custom-converter-id";
    private static final String CUSTOM_CONVERTER_PARAM_ATTRIBUTE = "custom-converter-param";
    private final Document document;
    private final ElementReader elementReader;

    public XMLParser(Document document) {
        this.document = document;
        this.elementReader = BeanContainer.getInstance().getElementReader();
    }

    private String getAttribute(Element element, String attribute) {
        return this.elementReader.getAttribute(element, attribute);
    }

    private String getNodeValue(Element element) {
        return this.elementReader.getNodeValue(element);
    }

    private void debugElement(Element element) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("config name: " + element.getNodeName()));
            log.debug((Object)("  value: " + element.getFirstChild().getNodeValue()));
        }
    }

    public MappingFileData load() {
        DozerBuilder builder = new DozerBuilder();
        Element theRoot = this.document.getDocumentElement();
        NodeList nl = theRoot.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            if (log.isDebugEnabled()) {
                log.debug((Object)("name: " + ele.getNodeName()));
            }
            if (CONFIGURATION_ELEMENT.equals(ele.getNodeName())) {
                this.parseConfiguration(ele, builder);
                continue;
            }
            if (!MAPPING_ELEMENT.equals(ele.getNodeName())) continue;
            this.parseMapping(ele, builder);
        }
        return builder.build();
    }

    private void parseMapping(Element ele, DozerBuilder builder) {
        DozerBuilder.MappingBuilder definitionBuilder = builder.mapping();
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, DATE_FORMAT))) {
            definitionBuilder.dateFormat(this.getAttribute(ele, DATE_FORMAT));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, MAP_NULL_ATTRIBUTE))) {
            definitionBuilder.mapNull(BooleanUtils.toBoolean((String)this.getAttribute(ele, MAP_NULL_ATTRIBUTE)));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, MAP_EMPTY_STRING_ATTRIBUTE))) {
            definitionBuilder.mapEmptyString(BooleanUtils.toBoolean((String)this.getAttribute(ele, MAP_EMPTY_STRING_ATTRIBUTE)));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, BEAN_FACTORY))) {
            definitionBuilder.beanFactory(this.getAttribute(ele, BEAN_FACTORY));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, RELATIONSHIP_TYPE))) {
            String relationshipTypeValue = this.getAttribute(ele, RELATIONSHIP_TYPE);
            RelationshipType relationshipType = RelationshipType.valueOf(relationshipTypeValue);
            definitionBuilder.relationshipType(relationshipType);
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, WILDCARD))) {
            definitionBuilder.wildcard(Boolean.valueOf(this.getAttribute(ele, WILDCARD)));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, TRIM_STRINGS))) {
            definitionBuilder.trimStrings(Boolean.valueOf(this.getAttribute(ele, TRIM_STRINGS)));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, "stop-on-errors"))) {
            definitionBuilder.stopOnErrors(Boolean.valueOf(this.getAttribute(ele, "stop-on-errors")));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, MAPID_ATTRIBUTE))) {
            definitionBuilder.mapId(this.getAttribute(ele, MAPID_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, TYPE_ATTRIBUTE))) {
            String mappingDirection = this.getAttribute(ele, TYPE_ATTRIBUTE);
            MappingDirection direction = MappingDirection.valueOf(mappingDirection);
            definitionBuilder.type(direction);
        }
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            DozerBuilder.ClassDefinitionBuilder classBuilder;
            String typeName;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            if (CLASS_A_ELEMENT.equals(element.getNodeName())) {
                typeName = this.getNodeValue(element);
                classBuilder = definitionBuilder.classA(typeName);
                this.parseClass(element, classBuilder);
            }
            if (CLASS_B_ELEMENT.equals(element.getNodeName())) {
                typeName = this.getNodeValue(element);
                classBuilder = definitionBuilder.classB(typeName);
                this.parseClass(element, classBuilder);
            }
            if (FIELD_ELEMENT.equals(element.getNodeName())) {
                this.parseGenericFieldMap(element, definitionBuilder);
                continue;
            }
            if (!FIELD_EXCLUDE_ELEMENT.equals(element.getNodeName())) continue;
            this.parseFieldExcludeMap(element, definitionBuilder);
        }
    }

    private void parseClass(Element element, DozerBuilder.ClassDefinitionBuilder classBuilder) {
        if (StringUtils.isNotEmpty((String)this.getAttribute(element, MAP_GET_METHOD_ATTRIBUTE))) {
            classBuilder.mapGetMethod(this.getAttribute(element, MAP_GET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(element, MAP_SET_METHOD_ATTRIBUTE))) {
            classBuilder.mapSetMethod(this.getAttribute(element, MAP_SET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(element, BEAN_FACTORY))) {
            classBuilder.beanFactory(this.getAttribute(element, BEAN_FACTORY));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(element, FACTORY_BEANID_ATTRIBUTE))) {
            classBuilder.factoryBeanId(this.getAttribute(element, FACTORY_BEANID_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(element, CREATE_METHOD_ATTRIBUTE))) {
            classBuilder.createMethod(this.getAttribute(element, CREATE_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(element, MAP_NULL_ATTRIBUTE))) {
            classBuilder.mapNull(Boolean.valueOf(this.getAttribute(element, MAP_NULL_ATTRIBUTE)));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(element, MAP_EMPTY_STRING_ATTRIBUTE))) {
            classBuilder.mapEmptyString(Boolean.valueOf(this.getAttribute(element, MAP_EMPTY_STRING_ATTRIBUTE)));
        }
    }

    private void parseFieldExcludeMap(Element ele, DozerBuilder.MappingBuilder definitionBuilder) {
        DozerBuilder.FieldExclusionBuilder fieldMapBuilder = definitionBuilder.fieldExclude();
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, TYPE_ATTRIBUTE))) {
            String mappingDirection = this.getAttribute(ele, TYPE_ATTRIBUTE);
            MappingDirection direction = MappingDirection.valueOf(mappingDirection);
            fieldMapBuilder.type(direction);
        }
        NodeList nodeList = ele.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            this.parseFieldElements(element, fieldMapBuilder);
        }
    }

    private void parseFieldElements(Element element, DozerBuilder.FieldBuider fieldMapBuilder) {
        DozerBuilder.FieldDefinitionBuilder fieldBuilder;
        String type;
        String name;
        if (A_ELEMENT.equals(element.getNodeName())) {
            name = this.getNodeValue(element);
            type = this.getAttribute(element, TYPE_ATTRIBUTE);
            fieldBuilder = fieldMapBuilder.a(name, type);
            this.parseField(element, fieldBuilder);
        }
        if (B_ELEMENT.equals(element.getNodeName())) {
            name = this.getNodeValue(element);
            type = this.getAttribute(element, TYPE_ATTRIBUTE);
            fieldBuilder = fieldMapBuilder.b(name, type);
            this.parseField(element, fieldBuilder);
        }
    }

    private void parseGenericFieldMap(Element ele, DozerBuilder.MappingBuilder definitionBuilder) {
        DozerBuilder.FieldMappingBuilder fieldMapBuilder = this.determineFieldMap(definitionBuilder, ele);
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, "copy-by-reference"))) {
            fieldMapBuilder.copyByReference(BooleanUtils.toBoolean((String)this.getAttribute(ele, "copy-by-reference")));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, MAPID_ATTRIBUTE))) {
            fieldMapBuilder.mapId(this.getAttribute(ele, MAPID_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, TYPE_ATTRIBUTE))) {
            String mappingDirection = this.getAttribute(ele, TYPE_ATTRIBUTE);
            MappingDirection direction = MappingDirection.valueOf(mappingDirection);
            fieldMapBuilder.type(direction);
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, CUSTOM_CONVERTER_ATTRIBUTE))) {
            fieldMapBuilder.customConverter(this.getAttribute(ele, CUSTOM_CONVERTER_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, CUSTOM_CONVERTER_ID_ATTRIBUTE))) {
            fieldMapBuilder.customConverterId(this.getAttribute(ele, CUSTOM_CONVERTER_ID_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, CUSTOM_CONVERTER_PARAM_ATTRIBUTE))) {
            fieldMapBuilder.customConverterParam(this.getAttribute(ele, CUSTOM_CONVERTER_PARAM_ATTRIBUTE));
        }
        this.parseFieldMap(ele, fieldMapBuilder);
    }

    private DozerBuilder.FieldMappingBuilder determineFieldMap(DozerBuilder.MappingBuilder definitionBuilder, Element ele) {
        DozerBuilder.FieldMappingBuilder fieldMapBuilder = definitionBuilder.field();
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            DozerBuilder.FieldDefinitionBuilder builder;
            String type;
            String name;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (A_ELEMENT.equals(element.getNodeName())) {
                name = this.getNodeValue(element);
                type = this.getAttribute(element, TYPE_ATTRIBUTE);
                builder = fieldMapBuilder.a(name, type);
                this.parseField(element, builder);
            }
            if (!B_ELEMENT.equals(element.getNodeName())) continue;
            name = this.getNodeValue(element);
            type = this.getAttribute(element, TYPE_ATTRIBUTE);
            builder = fieldMapBuilder.b(name, type);
            this.parseField(element, builder);
        }
        return fieldMapBuilder;
    }

    private void parseFieldMap(Element ele, DozerBuilder.FieldMappingBuilder fieldMapBuilder) {
        this.setRelationshipType(ele, fieldMapBuilder);
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, REMOVE_ORPHANS))) {
            fieldMapBuilder.removeOrphans(BooleanUtils.toBoolean((String)this.getAttribute(ele, REMOVE_ORPHANS)));
        }
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String hint;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            this.parseFieldElements(element, fieldMapBuilder);
            if (SRC_TYPE_HINT_ELEMENT.equals(element.getNodeName())) {
                hint = this.getNodeValue(element);
                fieldMapBuilder.srcHintContainer(hint);
            }
            if (DEST_TYPE_HINT_ELEMENT.equals(element.getNodeName())) {
                hint = this.getNodeValue(element);
                fieldMapBuilder.destHintContainer(hint);
            }
            if (SRC_TYPE_DEEP_INDEX_HINT_ELEMENT.equals(element.getNodeName())) {
                hint = this.getNodeValue(element);
                fieldMapBuilder.srcDeepIndexHintContainer(hint);
            }
            if (!DEST_TYPE_DEEP_INDEX_HINT_ELEMENT.equals(element.getNodeName())) continue;
            hint = this.getNodeValue(element);
            fieldMapBuilder.destDeepIndexHintContainer(hint);
        }
    }

    private void setRelationshipType(Element ele, DozerBuilder.FieldMappingBuilder definitionBuilder) {
        RelationshipType relationshipType = null;
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, RELATIONSHIP_TYPE))) {
            String relationshipTypeValue = this.getAttribute(ele, RELATIONSHIP_TYPE);
            relationshipType = RelationshipType.valueOf(relationshipTypeValue);
        }
        definitionBuilder.relationshipType(relationshipType);
    }

    private void parseField(Element ele, DozerBuilder.FieldDefinitionBuilder fieldBuilder) {
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, DATE_FORMAT))) {
            fieldBuilder.dateFormat(this.getAttribute(ele, DATE_FORMAT));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, THE_GET_METHOD_ATTRIBUTE))) {
            fieldBuilder.theGetMethod(this.getAttribute(ele, THE_GET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, THE_SET_METHOD_ATTRIBUTE))) {
            fieldBuilder.theSetMethod(this.getAttribute(ele, THE_SET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, MAP_GET_METHOD_ATTRIBUTE))) {
            fieldBuilder.mapGetMethod(this.getAttribute(ele, MAP_GET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, MAP_SET_METHOD_ATTRIBUTE))) {
            fieldBuilder.mapSetMethod(this.getAttribute(ele, MAP_SET_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, KEY_ATTRIBUTE))) {
            fieldBuilder.key(this.getAttribute(ele, KEY_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, CREATE_METHOD_ATTRIBUTE))) {
            fieldBuilder.createMethod(this.getAttribute(ele, CREATE_METHOD_ATTRIBUTE));
        }
        if (StringUtils.isNotEmpty((String)this.getAttribute(ele, IS_ACCESSIBLE_ATTRIBUTE))) {
            fieldBuilder.accessible(BooleanUtils.toBoolean((String)this.getAttribute(ele, IS_ACCESSIBLE_ATTRIBUTE)));
        }
    }

    private void parseConfiguration(Element ele, DozerBuilder builder) {
        DozerBuilder.ConfigurationBuilder configBuilder = builder.configuration();
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            String nodeValue = this.getNodeValue(element);
            if ("stop-on-errors".equals(element.getNodeName())) {
                configBuilder.stopOnErrors(Boolean.valueOf(nodeValue));
                continue;
            }
            if (DATE_FORMAT.equals(element.getNodeName())) {
                configBuilder.dateFormat(nodeValue);
                continue;
            }
            if (WILDCARD.equals(element.getNodeName())) {
                configBuilder.wildcard(Boolean.valueOf(nodeValue));
                continue;
            }
            if (TRIM_STRINGS.equals(element.getNodeName())) {
                configBuilder.trimStrings(Boolean.valueOf(nodeValue));
                continue;
            }
            if (RELATIONSHIP_TYPE.equals(element.getNodeName())) {
                RelationshipType relationshipType = RelationshipType.valueOf(nodeValue);
                configBuilder.relationshipType(relationshipType);
                continue;
            }
            if (BEAN_FACTORY.equals(element.getNodeName())) {
                configBuilder.beanFactory(nodeValue);
                continue;
            }
            if (CUSTOM_CONVERTERS_ELEMENT.equals(element.getNodeName())) {
                this.parseCustomConverters(element, configBuilder);
                continue;
            }
            if (COPY_BY_REFERENCES_ELEMENT.equals(element.getNodeName())) {
                this.parseCopyByReferences(element, configBuilder);
                continue;
            }
            if (ALLOWED_EXCEPTIONS_ELEMENT.equals(element.getNodeName())) {
                this.parseAllowedExceptions(element, configBuilder);
                continue;
            }
            if (!VARIABLES_ELEMENT.equals(element.getNodeName())) continue;
            this.parseVariables(element);
        }
    }

    private void parseVariables(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            ELEngine engine;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            this.debugElement(ele);
            if (!VARIABLE_ELEMENT.equals(ele.getNodeName()) || (engine = BeanContainer.getInstance().getElEngine()) == null) continue;
            String name = this.getAttribute(ele, NAME_ATTRIBUTE);
            String value = this.getNodeValue(ele);
            engine.setVariable(name, value);
        }
    }

    private void parseCustomConverters(Element ele, DozerBuilder.ConfigurationBuilder config) {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            if (!CONVERTER_ELEMENT.equals(element.getNodeName())) continue;
            String converterType = this.getAttribute(element, TYPE_ATTRIBUTE);
            DozerBuilder.CustomConverterBuilder customConverterBuilder = config.customConverter(converterType);
            NodeList list = element.getChildNodes();
            for (int x = 0; x < list.getLength(); ++x) {
                Node node1 = list.item(x);
                if (!(node1 instanceof Element)) continue;
                Element element1 = (Element)node1;
                if (CLASS_A_ELEMENT.equals(element1.getNodeName())) {
                    customConverterBuilder.classA(this.getNodeValue(element1));
                    continue;
                }
                if (!CLASS_B_ELEMENT.equals(element1.getNodeName())) continue;
                customConverterBuilder.classB(this.getNodeValue(element1));
            }
        }
    }

    private void parseCopyByReferences(Element ele, DozerBuilder.ConfigurationBuilder config) {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            if (!"copy-by-reference".equals(element.getNodeName())) continue;
            String typeMask = this.getNodeValue(element);
            config.copyByReference(typeMask);
        }
    }

    private void parseAllowedExceptions(Element ele, DozerBuilder.ConfigurationBuilder config) {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            this.debugElement(element);
            if (!ALLOWED_EXCEPTION_ELEMENT.equals(element.getNodeName())) continue;
            String exceptionType = this.getNodeValue(element);
            config.allowedException(exceptionType);
        }
    }
}

