/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.dozer.BeanFactory;
import org.dozer.config.BeanContainer;
import org.dozer.factory.BeanCreationDirective;
import org.dozer.factory.BeanCreationStrategy;
import org.dozer.factory.XMLBeanFactory;
import org.dozer.util.DozerClassLoader;
import org.dozer.util.MappingUtils;
import org.dozer.util.ReflectionUtils;

public final class ConstructionStrategies {
    private static final BeanCreationStrategy byCreateMethod = new ByCreateMethod();
    private static final BeanCreationStrategy byGetInstance = new ByGetInstance();
    private static final BeanCreationStrategy byInterface = new ByInterface();
    private static final BeanCreationStrategy xmlBeansBased = new XMLBeansBased();
    private static final BeanCreationStrategy constructorBased = new ByConstructor();
    private static final ByFactory byFactory = new ByFactory();

    public static BeanCreationStrategy byCreateMethod() {
        return byCreateMethod;
    }

    public static BeanCreationStrategy byGetInstance() {
        return byGetInstance;
    }

    public static BeanCreationStrategy byInterface() {
        return byInterface;
    }

    public static BeanCreationStrategy xmlBeansBased() {
        return xmlBeansBased;
    }

    public static BeanCreationStrategy byConstructor() {
        return constructorBased;
    }

    public static ByFactory byFactory() {
        return byFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByConstructor
    implements BeanCreationStrategy {
        ByConstructor() {
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            return true;
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            Class<?> classToCreate = directive.getActualClass();
            try {
                return ByConstructor.newInstance(classToCreate);
            }
            catch (Exception e) {
                if (directive.getAlternateClass() != null) {
                    return ByConstructor.newInstance(directive.getAlternateClass());
                }
                MappingUtils.throwMappingException(e);
                return null;
            }
        }

        private static <T> T newInstance(Class<T> clazz) {
            Constructor<T> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(null);
            }
            catch (SecurityException e) {
                MappingUtils.throwMappingException(e);
            }
            catch (NoSuchMethodException e) {
                MappingUtils.throwMappingException(e);
            }
            if (constructor == null) {
                MappingUtils.throwMappingException("Could not create a new instance of the dest object: " + clazz + ".  Could not find a no-arg constructor for this class.");
            }
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            T result = null;
            try {
                result = constructor.newInstance(null);
            }
            catch (IllegalArgumentException e) {
                MappingUtils.throwMappingException(e);
            }
            catch (InstantiationException e) {
                MappingUtils.throwMappingException(e);
            }
            catch (IllegalAccessException e) {
                MappingUtils.throwMappingException(e);
            }
            catch (InvocationTargetException e) {
                MappingUtils.throwMappingException(e);
            }
            return result;
        }
    }

    static class XMLBeansBased
    implements BeanCreationStrategy {
        BeanFactory xmlBeanFactory = new XMLBeanFactory();

        XMLBeansBased() {
        }

        public boolean isApplicable(BeanCreationDirective directive) {
            Class<?> actualClass = directive.getActualClass();
            return XmlObject.class.isAssignableFrom(actualClass);
        }

        public Object create(BeanCreationDirective directive) {
            Class<?> classToCreate = directive.getActualClass();
            String factoryBeanId = directive.getFactoryId();
            String beanId = !MappingUtils.isBlankOrNull(factoryBeanId) ? factoryBeanId : classToCreate.getName();
            return this.xmlBeanFactory.createBean(directive.getSrcObject(), directive.getSrcClass(), beanId);
        }
    }

    static class ByInterface
    implements BeanCreationStrategy {
        ByInterface() {
        }

        public boolean isApplicable(BeanCreationDirective directive) {
            Class<?> actualClass = directive.getActualClass();
            return Map.class.equals(actualClass) || List.class.equals(actualClass) || Set.class.equals(actualClass);
        }

        public Object create(BeanCreationDirective directive) {
            Class<?> actualClass = directive.getActualClass();
            if (Map.class.equals(actualClass)) {
                return new HashMap();
            }
            if (List.class.equals(actualClass)) {
                return new ArrayList();
            }
            if (Set.class.equals(actualClass)) {
                return new HashSet();
            }
            throw new IllegalStateException("Type not expected : " + actualClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByFactory
    implements BeanCreationStrategy {
        private static final Log log = LogFactory.getLog(ByFactory.class);
        private final ConcurrentMap<String, BeanFactory> factoryCache = new ConcurrentHashMap<String, BeanFactory>();

        ByFactory() {
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            String factoryName = directive.getFactoryName();
            return !MappingUtils.isBlankOrNull(factoryName);
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            Class<?> classToCreate = directive.getActualClass();
            String factoryName = directive.getFactoryName();
            String factoryBeanId = directive.getFactoryId();
            String beanId = !MappingUtils.isBlankOrNull(factoryBeanId) ? factoryBeanId : classToCreate.getName();
            BeanFactory factory = (BeanFactory)this.factoryCache.get(factoryName);
            if (factory == null) {
                Class<?> factoryClass = MappingUtils.loadClass(factoryName);
                if (!BeanFactory.class.isAssignableFrom(factoryClass)) {
                    MappingUtils.throwMappingException("Custom bean factory must implement " + BeanFactory.class.getName() + " interface : " + factoryClass);
                }
                factory = (BeanFactory)ReflectionUtils.newInstance(factoryClass);
                this.factoryCache.put(factoryName, factory);
            }
            Object result = factory.createBean(directive.getSrcObject(), directive.getSrcClass(), beanId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bean instance created with custom factory -->\n  Bean Type: " + result.getClass().getName() + "\n  Factory Name: " + factoryName));
            }
            if (!classToCreate.isAssignableFrom(result.getClass())) {
                MappingUtils.throwMappingException("Custom bean factory (" + factory.getClass() + ") did not return correct type of destination data object. Expected : " + classToCreate + ", Actual : " + result.getClass());
            }
            return result;
        }

        public void setStoredFactories(Map<String, BeanFactory> factories) {
            this.factoryCache.putAll(factories);
        }
    }

    static class ByGetInstance
    extends ByCreateMethod {
        ByGetInstance() {
        }

        public boolean isApplicable(BeanCreationDirective directive) {
            Class<?> actualClass = directive.getActualClass();
            return Calendar.class.isAssignableFrom(actualClass);
        }

        public Object create(BeanCreationDirective directive) {
            directive.setCreateMethod("getInstance");
            return super.create(directive);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByCreateMethod
    implements BeanCreationStrategy {
        ByCreateMethod() {
        }

        @Override
        public boolean isApplicable(BeanCreationDirective directive) {
            String createMethod = directive.getCreateMethod();
            return !MappingUtils.isBlankOrNull(createMethod);
        }

        @Override
        public Object create(BeanCreationDirective directive) {
            Method method;
            Class<?> actualClass = directive.getActualClass();
            String createMethod = directive.getCreateMethod();
            if (createMethod.contains(".")) {
                String methodName = createMethod.substring(createMethod.lastIndexOf(".") + 1, createMethod.length());
                String typeName = createMethod.substring(0, createMethod.lastIndexOf("."));
                DozerClassLoader loader = BeanContainer.getInstance().getClassLoader();
                Class<?> type = loader.loadClass(typeName);
                method = this.findMethod(type, methodName);
            } else {
                method = this.findMethod(actualClass, createMethod);
            }
            return ReflectionUtils.invoke(method, null, null);
        }

        private Method findMethod(Class<?> actualClass, String createMethod) {
            Method method = null;
            try {
                method = ReflectionUtils.getMethod(actualClass, createMethod, null);
            }
            catch (NoSuchMethodException e) {
                MappingUtils.throwMappingException(e);
            }
            return method;
        }
    }
}

