/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.swingbox.view;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fit.cssbox.swingbox.SwingBoxDocument;

public class DelegateView
extends CompositeView {
    private View view;
    private View parent;

    public DelegateView(Element elem) {
        super(elem);
    }

    @Override
    public void setParent(View parent) {
        if (parent == null && this.view != null) {
            this.view.setParent(null);
        }
        this.parent = parent;
        if (parent != null && this.getElement() != null) {
            ViewFactory f = this.getViewFactory();
            this.loadChildren(f);
        }
    }

    @Override
    public View getParent() {
        return this.parent;
    }

    @Override
    protected void loadChildren(ViewFactory f) {
        if (f == null) {
            return;
        }
        Element e = this.getElement();
        if (e.getElementCount() > 0) {
            View[] added = new View[]{f.create(e.getElement(0))};
            this.replace(0, 1, added);
        }
    }

    @Override
    public void replace(int offset, int length, View[] views) {
        if (offset < offset + length && views.length > 0 && this.view != null) {
            this.view.setParent(null);
            this.view = null;
        }
        if (views.length > 0) {
            View tmp = views[0];
            String name = this.getDelegateName();
            for (int i = 0; name != null && i < views.length; ++i) {
                if (name.equals(views[i].getElement().getName())) {
                    if (tmp != views[i]) {
                        tmp.setParent(null);
                    }
                    tmp = views[i];
                    continue;
                }
                if (tmp == views[i]) continue;
                views[i].setParent(null);
            }
            this.view = tmp;
            this.view.setParent(this);
        }
    }

    public String getDelegateName() {
        Element data = this.getElement();
        if (data instanceof SwingBoxDocument.DelegateElement) {
            return ((SwingBoxDocument.DelegateElement)data).getDelegateName();
        }
        return null;
    }

    @Override
    public AttributeSet getAttributes() {
        return null;
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (this.view != null) {
            return this.view.getPreferredSpan(axis);
        }
        return 10.0f;
    }

    @Override
    public float getMinimumSpan(int axis) {
        if (this.view != null) {
            return this.view.getMinimumSpan(axis);
        }
        return 10.0f;
    }

    @Override
    public float getMaximumSpan(int axis) {
        if (this.view != null) {
            return this.view.getMaximumSpan(axis);
        }
        return 2.1474836E9f;
    }

    @Override
    public void preferenceChanged(View child, boolean width, boolean height) {
        if (this.parent != null) {
            this.parent.preferenceChanged(child, width, height);
        }
    }

    @Override
    public float getAlignment(int axis) {
        if (this.view != null) {
            return this.view.getAlignment(axis);
        }
        return 0.0f;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        if (this.view != null) {
            this.view.paint(g, allocation);
        }
    }

    @Override
    public int getViewCount() {
        return this.view != null ? 1 : 0;
    }

    @Override
    public View getView(int n) {
        return this.view;
    }

    @Override
    public int getViewIndex(int pos, Position.Bias b) {
        return this.view != null ? 0 : -1;
    }

    @Override
    public Shape getChildAllocation(int index, Shape a) {
        if (this.view != null) {
            return this.view.getChildAllocation(index, a);
        }
        return a;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        if (this.view != null) {
            return this.view.modelToView(pos, a, b);
        }
        return null;
    }

    @Override
    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        if (this.view != null) {
            return this.view.modelToView(p0, b0, p1, b1, a);
        }
        return null;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        if (this.view != null) {
            int retValue = this.view.viewToModel(x, y, a, bias);
            return retValue;
        }
        return -1;
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (this.view != null) {
            int nextPos = this.view.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
            if (nextPos != -1) {
                pos = nextPos;
            } else {
                biasRet[0] = b;
            }
        }
        return pos;
    }

    @Override
    public Document getDocument() {
        return this.parent.getDocument();
    }

    @Override
    public int getStartOffset() {
        if (this.view != null) {
            return this.view.getStartOffset();
        }
        return this.getElement().getStartOffset();
    }

    @Override
    public int getEndOffset() {
        if (this.view != null) {
            return this.view.getEndOffset();
        }
        return this.getElement().getEndOffset();
    }

    @Override
    public int getResizeWeight(int axis) {
        if (this.view != null) {
            return this.view.getResizeWeight(axis);
        }
        return 0;
    }

    @Override
    public void setSize(float width, float height) {
        if (this.view != null) {
            this.view.setSize(width, height);
        }
    }

    @Override
    public String getToolTipText(float x, float y, Shape allocation) {
        if (this.view != null) {
            return this.view.getToolTipText(x, y, allocation);
        }
        return super.getToolTipText(x, y, allocation);
    }

    @Override
    protected boolean isBefore(int x, int y, Rectangle alloc) {
        return false;
    }

    @Override
    protected boolean isAfter(int x, int y, Rectangle alloc) {
        return false;
    }

    @Override
    protected View getViewAtPoint(int x, int y, Rectangle alloc) {
        return this.view;
    }

    @Override
    protected void childAllocation(int index, Rectangle a) {
    }
}

