/*
 * Decompiled with CFR 0.152.
 */
package org.fit.pdfdom;

public class BoxStyle {
    public static final String defaultColor = "#000000";
    public static final String defaultFontWeight = "normal";
    public static final String defaultFontStyle = "normal";
    public static final String defaultPosition = "absolute";
    public static final String transparentColor = "rgba(0,0,0,0)";
    private String units;
    private String fontFamily;
    private float fontSize;
    private String fontWeight;
    private String fontStyle;
    private float lineHeight;
    private float wordSpacing;
    private float letterSpacing;
    private String color;
    private String strokeColor;
    private String position;
    private float left;
    private float top;

    public BoxStyle(String units) {
        this.units = new String(units);
        this.fontFamily = null;
        this.fontSize = 0.0f;
        this.fontWeight = null;
        this.fontStyle = null;
        this.lineHeight = 0.0f;
        this.wordSpacing = 0.0f;
        this.letterSpacing = 0.0f;
        this.color = null;
        this.position = null;
        this.left = 0.0f;
        this.top = 0.0f;
    }

    public BoxStyle(BoxStyle src) {
        this.units = new String(src.units);
        this.fontFamily = src.fontFamily == null ? null : new String(src.fontFamily);
        this.fontSize = src.fontSize;
        this.fontWeight = src.fontWeight == null ? null : new String(src.fontWeight);
        this.fontStyle = src.fontStyle == null ? null : new String(src.fontStyle);
        this.lineHeight = src.lineHeight;
        this.wordSpacing = src.wordSpacing;
        this.letterSpacing = src.letterSpacing;
        this.color = src.color == null ? null : new String(src.color);
        this.position = src.position == null ? null : new String(src.position);
        this.left = src.left;
        this.top = src.top;
        this.strokeColor = src.strokeColor;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.position != null && !this.position.equals(defaultPosition)) {
            this.appendString(ret, "position", this.position);
        }
        this.appendLength(ret, "top", this.top);
        this.appendLength(ret, "left", this.left);
        this.appendLength(ret, "line-height", this.lineHeight);
        if (this.fontFamily != null) {
            this.appendString(ret, "font-family", this.fontFamily);
        }
        if (this.fontSize != 0.0f) {
            this.appendLength(ret, "font-size", this.fontSize);
        }
        if (this.fontWeight != null && !"normal".equals(this.fontWeight)) {
            this.appendString(ret, "font-weight", this.fontWeight);
        }
        if (this.fontStyle != null && !"normal".equals(this.fontStyle)) {
            this.appendString(ret, "font-style", this.fontStyle);
        }
        if (this.wordSpacing != 0.0f) {
            this.appendLength(ret, "word-spacing", this.wordSpacing);
        }
        if (this.letterSpacing != 0.0f) {
            this.appendLength(ret, "letter-spacing", this.letterSpacing);
        }
        if (this.color != null && !defaultColor.equals(this.color)) {
            this.appendString(ret, "color", this.color);
        }
        if (this.strokeColor != null && !this.strokeColor.equals(transparentColor)) {
            ret.append(this.createTextStrokeCss(this.strokeColor));
        }
        return ret.toString();
    }

    private void appendString(StringBuilder s, String propertyName, String value) {
        s.append(propertyName);
        s.append(':');
        s.append(value);
        s.append(';');
    }

    private void appendLength(StringBuilder s, String propertyName, float value) {
        s.append(propertyName);
        s.append(':');
        s.append(this.formatLength(value));
        s.append(';');
    }

    public String formatLength(float length) {
        return length + this.units;
    }

    private String createTextStrokeCss(String color) {
        String strokeCss = "-webkit-text-stroke: %color% 1px ;text-shadow:-1px -1px 0 %color%, 1px -1px 0 %color%,-1px 1px 0 %color%, 1px 1px 0 %color%;";
        return strokeCss.replaceAll("%color%", color);
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public float getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
    }

    public float getWordSpacing() {
        return this.wordSpacing;
    }

    public void setWordSpacing(float wordSpacing) {
        this.wordSpacing = wordSpacing;
    }

    public float getLetterSpacing() {
        return this.letterSpacing;
    }

    public void setLetterSpacing(float letterSpacing) {
        this.letterSpacing = letterSpacing;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(String strokeColor) {
        this.strokeColor = strokeColor;
    }

    public float getLeft() {
        return this.left;
    }

    public void setLeft(float left) {
        this.left = left;
    }

    public float getTop() {
        return this.top;
    }

    public void setTop(float top) {
        this.top = top;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.strokeColor == null ? 0 : this.strokeColor.hashCode());
        result = 31 * result + (this.fontFamily == null ? 0 : this.fontFamily.hashCode());
        result = 31 * result + Float.floatToIntBits(this.fontSize);
        result = 31 * result + (this.fontStyle == null ? 0 : this.fontStyle.hashCode());
        result = 31 * result + (this.fontWeight == null ? 0 : this.fontWeight.hashCode());
        result = 31 * result + Float.floatToIntBits(this.letterSpacing);
        result = 31 * result + Float.floatToIntBits(this.wordSpacing);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoxStyle other = (BoxStyle)obj;
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.strokeColor == null ? other.strokeColor != null : !this.strokeColor.equals(other.strokeColor)) {
            return false;
        }
        if (this.fontFamily == null ? other.fontFamily != null : !this.fontFamily.equals(other.fontFamily)) {
            return false;
        }
        if (Float.floatToIntBits(this.fontSize) != Float.floatToIntBits(other.fontSize)) {
            return false;
        }
        if (this.fontStyle == null ? other.fontStyle != null : !this.fontStyle.equals(other.fontStyle)) {
            return false;
        }
        if (this.fontWeight == null ? other.fontWeight != null : !this.fontWeight.equals(other.fontWeight)) {
            return false;
        }
        if (Float.floatToIntBits(this.letterSpacing) != Float.floatToIntBits(other.letterSpacing)) {
            return false;
        }
        return Float.floatToIntBits(this.wordSpacing) == Float.floatToIntBits(other.wordSpacing);
    }
}

