/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.demo;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JFrame;
import javax.swing.tree.DefaultTreeModel;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.fit.cssbox.demo.BoxBrowser;
import org.fit.cssbox.layout.Box;
import org.fit.cssbox.layout.BrowserCanvas;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.pdf.PdfBrowserCanvas;
import org.w3c.dom.Document;

public class PdfBoxBrowser
extends BoxBrowser {
    public URL displayURL(String urlstring) {
        try {
            if (!(urlstring.startsWith("http:") || urlstring.startsWith("ftp:") || urlstring.startsWith("file:"))) {
                urlstring = "http://" + urlstring;
            }
            URL url = new URL(urlstring);
            this.urlText.setText(url.toString());
            URLConnection con = url.openConnection();
            con.setRequestProperty("User-Agent", "Mozilla/5.0 (compatible; BoxBrowserTest/2.x; Linux) CSSBox/2.x (like Gecko)");
            InputStream is = con.getInputStream();
            url = con.getURL();
            System.out.println("Parsing PDF: " + url);
            PDDocument doc = this.loadPdf(is);
            is.close();
            this.contentCanvas = new PdfBrowserCanvas(doc, null, this.contentScroll.getSize(), url);
            this.contentCanvas.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    System.out.println("Click: " + e.getX() + ":" + e.getY());
                    PdfBoxBrowser.this.canvasClick(e.getX(), e.getY());
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            this.contentScroll.setViewportView(this.contentCanvas);
            Viewport viewport = ((BrowserCanvas)this.contentCanvas).getViewport();
            this.root = this.createBoxTree((Box)viewport);
            this.boxTree.setModel(new DefaultTreeModel(this.root));
            Document dom = ((PdfBrowserCanvas)((Object)this.contentCanvas)).getBoxTree().getDocument();
            this.domRoot = this.createDomTree(dom);
            this.domTree.setModel(new DefaultTreeModel(this.domRoot));
            return url;
        }
        catch (Exception e) {
            System.err.println("*** Error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    protected PDDocument loadPdf(InputStream is) throws IOException {
        PDDocument document = null;
        document = PDDocument.load((InputStream)is);
        if (document.isEncrypted()) {
            try {
                document.decrypt("");
            }
            catch (InvalidPasswordException e) {
                System.err.println("Error: Document is encrypted with a password.");
                System.exit(1);
            }
            catch (CryptographyException e) {
                System.err.println("Error: Document is encrypted with a password.");
                System.exit(1);
            }
        }
        return document;
    }

    public static void main(String[] args) {
        browser = new PdfBoxBrowser();
        JFrame main = browser.getMainWindow();
        main.setSize(1200, 600);
        main.setVisible(true);
    }
}

