/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign.decode;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.domassign.decode.Repeater;
import java.util.Map;

public class BorderRadiusRepeater
extends Repeater {
    public BorderRadiusRepeater() {
        super(4);
        this.type = CSSProperty.BorderRadius.class;
        this.names.add("border-top-left-radius");
        this.names.add("border-top-right-radius");
        this.names.add("border-bottom-right-radius");
        this.names.add("border-bottom-left-radius");
    }

    @Override
    protected boolean operation(int i, Map<String, CSSProperty> properties, Map<String, Term<?>> values) {
        Term term = (Term)this.terms.get(i);
        String name = (String)this.names.get(i);
        if (BorderRadiusRepeater.genericTermIdent(this.type, (Term)this.terms.get(i), true, (String)this.names.get(i), properties)) {
            return true;
        }
        if (term instanceof TermList) {
            properties.put(name, CSSProperty.BorderRadius.list_values);
            values.put(name, term);
            return true;
        }
        return false;
    }

    public boolean repeatOverMultiTermDeclaration(Declaration d, Map<String, CSSProperty> properties, Map<String, Term<?>> values) throws IllegalArgumentException {
        Term term;
        if (d.size() == 1 && (term = (Term)d.get(0)) instanceof TermIdent && "INHERIT".equalsIgnoreCase((String)((TermIdent)term).getValue())) {
            Object property = CSSProperty.Translator.createInherit(this.type);
            for (int i = 0; i < this.times; ++i) {
                properties.put((String)this.names.get(i), (CSSProperty)property);
            }
            return true;
        }
        int slash = -1;
        for (int i = 0; i < d.size(); ++i) {
            Term term2 = (Term)d.get(i);
            if (term2.getOperator() != Term.Operator.SLASH) continue;
            slash = i;
            break;
        }
        if (slash == -1) {
            Term<?>[] sterms = this.createFourTerms(d, 0, d.size());
            for (int i = 0; i < 4; ++i) {
                TermList list = tf.createList(2);
                list.add(sterms[i]);
                list.add(sterms[i]);
                this.terms.add(list);
            }
        } else {
            Term<?>[] sterms1 = this.createFourTerms(d, 0, slash);
            Term<?>[] sterms2 = this.createFourTerms(d, slash, d.size());
            for (int i = 0; i < 4; ++i) {
                TermList list = tf.createList(2);
                list.add(sterms1[i]);
                list.add(sterms2[i]);
                this.terms.add(list);
            }
        }
        return this.repeat(properties, values);
    }

    private Term<?>[] createFourTerms(Declaration d, int fromIndex, int toIndex) throws IllegalArgumentException {
        int i;
        int size = toIndex - fromIndex;
        Term[] ret = new Term[4];
        switch (size) {
            case 1: {
                ret[2] = ret[3] = (Term)d.get(fromIndex);
                ret[1] = ret[3];
                ret[0] = ret[3];
                break;
            }
            case 2: {
                ret[0] = ret[2] = (Term)d.get(fromIndex);
                ret[1] = ret[3] = (Term)d.get(fromIndex + 1);
                break;
            }
            case 3: {
                ret[0] = (Term)d.get(fromIndex);
                ret[1] = ret[3] = (Term)d.get(fromIndex + 1);
                ret[2] = (Term)d.get(fromIndex + 2);
                break;
            }
            case 4: {
                for (i = 0; i < 4; ++i) {
                    ret[i] = (Term)d.get(fromIndex + i);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid length of terms in Repeater.");
            }
        }
        if (fromIndex != 0) {
            for (i = 0; i < 4; ++i) {
                if (ret[i].getOperator() != Term.Operator.SLASH) continue;
                ret[i] = this.stripSlash(ret[i]);
            }
        }
        return ret;
    }

    private Term<?> stripSlash(Term<?> src) {
        if (src.getOperator() == Term.Operator.SLASH) {
            if (src instanceof TermLength) {
                return tf.createLength((Float)src.getValue(), ((TermLength)src).getUnit());
            }
            if (src instanceof TermPercent) {
                return tf.createPercent((Float)src.getValue());
            }
            return src;
        }
        return src;
    }
}

