// $ANTLR 3.5.2 CSSTreeParser.g 2016-07-08 23:35:11

package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.MediaQuery;
import cz.vutbr.web.css.RuleList;
import cz.vutbr.web.csskit.antlr.Preparator;


import org.antlr.runtime.*;
import org.antlr.runtime.tree.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class DefaultCSSTreeParser_CSSTreeParser extends TreeParser {
	public static final int EOF=-1;
	public static final int ADJACENT=4;
	public static final int AMPERSAND=5;
	public static final int APOS=6;
	public static final int ASTERISK=7;
	public static final int ATBLOCK=8;
	public static final int ATKEYWORD=9;
	public static final int ATTRIBUTE=10;
	public static final int BRACEBLOCK=11;
	public static final int CDC=12;
	public static final int CDO=13;
	public static final int CHARSET=14;
	public static final int CHILD=15;
	public static final int CLASSKEYWORD=16;
	public static final int COLON=17;
	public static final int COMMA=18;
	public static final int COMMENT=19;
	public static final int CONTAINS=20;
	public static final int CTRL=21;
	public static final int CTRL_CHAR=22;
	public static final int CURLYBLOCK=23;
	public static final int DASHMATCH=24;
	public static final int DECLARATION=25;
	public static final int DESCENDANT=26;
	public static final int DIMENSION=27;
	public static final int DUMMY=28;
	public static final int ELEMENT=29;
	public static final int ENDSWITH=30;
	public static final int EQUALS=31;
	public static final int ESCAPE_CHAR=32;
	public static final int EXCLAMATION=33;
	public static final int EXPRESSION=34;
	public static final int FONTFACE=35;
	public static final int FUNCTION=36;
	public static final int GREATER=37;
	public static final int HASH=38;
	public static final int HAT=39;
	public static final int IDENT=40;
	public static final int IDENT_MACR=41;
	public static final int IMPORT=42;
	public static final int IMPORTANT=43;
	public static final int INCLUDES=44;
	public static final int INDEX=45;
	public static final int INLINESTYLE=46;
	public static final int INTEGER_MACR=47;
	public static final int INVALID_ATSTATEMENT=48;
	public static final int INVALID_DECLARATION=49;
	public static final int INVALID_DIRECTIVE=50;
	public static final int INVALID_IMPORT=51;
	public static final int INVALID_SELECTOR=52;
	public static final int INVALID_SELPART=53;
	public static final int INVALID_STATEMENT=54;
	public static final int INVALID_STRING=55;
	public static final int INVALID_TOKEN=56;
	public static final int LBRACE=57;
	public static final int LCURLY=58;
	public static final int LESS=59;
	public static final int LPAREN=60;
	public static final int MARGIN_AREA=61;
	public static final int MEDIA=62;
	public static final int MEDIA_QUERY=63;
	public static final int MINUS=64;
	public static final int NAME_CHAR=65;
	public static final int NAME_MACR=66;
	public static final int NAME_START=67;
	public static final int NL_CHAR=68;
	public static final int NON_ASCII=69;
	public static final int NUMBER=70;
	public static final int NUMBER_MACR=71;
	public static final int PAGE=72;
	public static final int PARENBLOCK=73;
	public static final int PERCENT=74;
	public static final int PERCENTAGE=75;
	public static final int PLUS=76;
	public static final int POUND=77;
	public static final int PRECEDING=78;
	public static final int PSEUDOCLASS=79;
	public static final int PSEUDOELEM=80;
	public static final int QUESTION=81;
	public static final int QUOT=82;
	public static final int RBRACE=83;
	public static final int RCURLY=84;
	public static final int RPAREN=85;
	public static final int RULE=86;
	public static final int S=87;
	public static final int SELECTOR=88;
	public static final int SEMICOLON=89;
	public static final int SET=90;
	public static final int SLASH=91;
	public static final int SL_COMMENT=92;
	public static final int STARTSWITH=93;
	public static final int STRING=94;
	public static final int STRING_CHAR=95;
	public static final int STRING_MACR=96;
	public static final int STYLESHEET=97;
	public static final int TILDE=98;
	public static final int Tokens=99;
	public static final int UNIRANGE=100;
	public static final int URI=101;
	public static final int URI_CHAR=102;
	public static final int URI_MACR=103;
	public static final int VALUE=104;
	public static final int VIEWPORT=105;
	public static final int W_CHAR=106;
	public static final int W_MACR=107;

	// delegates
	public TreeParser[] getDelegates() {
		return new TreeParser[] {};
	}

	// delegators
	public DefaultCSSTreeParser gDefaultCSSTreeParser;
	public DefaultCSSTreeParser gParent;


	public DefaultCSSTreeParser_CSSTreeParser(TreeNodeStream input, DefaultCSSTreeParser gDefaultCSSTreeParser) {
		this(input, new RecognizerSharedState(), gDefaultCSSTreeParser);
	}
	public DefaultCSSTreeParser_CSSTreeParser(TreeNodeStream input, RecognizerSharedState state, DefaultCSSTreeParser gDefaultCSSTreeParser) {
		super(input, state);
		this.gDefaultCSSTreeParser = gDefaultCSSTreeParser;
		gParent = gDefaultCSSTreeParser;
	}

	@Override public String[] getTokenNames() { return DefaultCSSTreeParser.tokenNames; }
	@Override public String getGrammarFileName() { return "CSSTreeParser.g"; }


		private org.slf4j.Logger log;

		protected cz.vutbr.web.css.RuleFactory rf = cz.vutbr.web.css.CSSFactory.getRuleFactory();
		protected cz.vutbr.web.css.TermFactory tf = cz.vutbr.web.css.CSSFactory.getTermFactory();

		private enum MediaQueryState { START, TYPE, AND, EXPR, TYPEOREXPR }

	    // block preparator
		protected cz.vutbr.web.csskit.antlr.Preparator preparator;
		private List<cz.vutbr.web.css.MediaQuery> wrapMedia;
		private cz.vutbr.web.css.RuleList rules;
		private List<List<cz.vutbr.web.css.MediaQuery>> importMedia;
		private List<String> importPaths;
		
		//prevent imports inside the style sheet
		private boolean preventImports;
		

	  /**
	   * Initializes the tree parser.
	   * @param preparator The preparator to be used for creating the rules.
	   * @param wrapMedia The media queries to be used for wrapping the created rules (e.g. in case
	   *    of parsing and imported style sheet) or null when no wrapping is required.
	   * @return The initialized tree parser 
	   */
	  public void init(cz.vutbr.web.csskit.antlr.Preparator preparator, List<cz.vutbr.web.css.MediaQuery> wrapMedia) {
			this.preparator = preparator;
			this.wrapMedia = wrapMedia;
			this.rules = null;
			this.importMedia = new ArrayList<List<cz.vutbr.web.css.MediaQuery>>();
			this.importPaths = new ArrayList<String>();
			this.preventImports = false;
			this.log = org.slf4j.LoggerFactory.getLogger(getClass());
		}   
	  
	  public cz.vutbr.web.css.RuleList getRules()
	  {
	    return rules;
	  }
	  
	  public List<List<cz.vutbr.web.css.MediaQuery>> getImportMedia()
	  {
	    return importMedia;
	  } 
	  
	  public List<String> getImportPaths()
	  {
	    return importPaths;
	  }
	  
	  @Override
		public void emitErrorMessage(String msg) {
		    log.info("ANTLR: {}", msg);
		}
			
		private String extractText(CommonTree token) {
	        return token.getText();
	    }
	   
	  private String extractTextUnescaped(CommonTree token) {
	        return org.unbescape.css.CssEscape.unescapeCss(token.getText());
	    }

	  private String extractIdUnescaped(CommonTree token) {
	        final String id = token.getText();
	        if (!id.isEmpty() && !Character.isDigit(id.charAt(0)))
	            return org.unbescape.css.CssEscape.unescapeCss(id);
	        else
	            return null;
	    }

	  private java.net.URL extractBase(CommonTree token) {
	      cz.vutbr.web.csskit.antlr.CSSToken ct = (cz.vutbr.web.csskit.antlr.CSSToken) token.getToken();
	      return ct.getBase();
	  }
	    	
	  private cz.vutbr.web.css.Declaration.Source extractSource(CommonTree token) {
	      cz.vutbr.web.csskit.antlr.CSSToken ct = (cz.vutbr.web.csskit.antlr.CSSToken) token.getToken();
	      cz.vutbr.web.css.Declaration.Source src = new cz.vutbr.web.css.Declaration.Source(ct.getBase(), ct.getLine(), ct.getCharPositionInLine());
	      return src;
	  }   
			
	    private void logEnter(String entry) {
	        log.trace("Entering '{}'", entry);
	    }
	    	
	    private void logLeave(String leaving) {
		    log.trace("Leaving '{}'", leaving);
	    }



	// $ANTLR start "inlinestyle"
	// CSSTreeParser.g:100:1: inlinestyle returns [cz.vutbr.web.css.RuleList rules] : ( ^( INLINESTYLE decl= declarations ) | ^( INLINESTYLE (irs= inlineset )+ ) );
	public final cz.vutbr.web.css.RuleList inlinestyle() throws RecognitionException {
		cz.vutbr.web.css.RuleList rules = null;


		List<cz.vutbr.web.css.Declaration> decl =null;
		cz.vutbr.web.css.RuleBlock<?> irs =null;


			logEnter("inlinestyle");
			rules = this.rules = new cz.vutbr.web.csskit.RuleArrayList();

		try {
			// CSSTreeParser.g:109:2: ( ^( INLINESTYLE decl= declarations ) | ^( INLINESTYLE (irs= inlineset )+ ) )
			int alt2=2;
			int LA2_0 = input.LA(1);
			if ( (LA2_0==INLINESTYLE) ) {
				int LA2_1 = input.LA(2);
				if ( (LA2_1==DOWN) ) {
					int LA2_2 = input.LA(3);
					if ( (LA2_2==SET) ) {
						alt2=1;
					}
					else if ( (LA2_2==RULE) ) {
						alt2=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 2, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 2, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 2, 0, input);
				throw nvae;
			}

			switch (alt2) {
				case 1 :
					// CSSTreeParser.g:109:5: ^( INLINESTYLE decl= declarations )
					{
					match(input,INLINESTYLE,FOLLOW_INLINESTYLE_in_inlinestyle53); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_declarations_in_inlinestyle57);
					decl=declarations();
					state._fsp--;

					match(input, Token.UP, null); 


								cz.vutbr.web.css.RuleBlock<?> rb = preparator.prepareInlineRuleSet(decl, null);
								if(rb!=null) {
								     rules.add(rb);
								}
							
					}
					break;
				case 2 :
					// CSSTreeParser.g:116:6: ^( INLINESTYLE (irs= inlineset )+ )
					{
					match(input,INLINESTYLE,FOLLOW_INLINESTYLE_in_inlinestyle72); 
					match(input, Token.DOWN, null); 
					// CSSTreeParser.g:117:5: (irs= inlineset )+
					int cnt1=0;
					loop1:
					while (true) {
						int alt1=2;
						int LA1_0 = input.LA(1);
						if ( (LA1_0==RULE) ) {
							alt1=1;
						}

						switch (alt1) {
						case 1 :
							// CSSTreeParser.g:117:6: irs= inlineset
							{
							pushFollow(FOLLOW_inlineset_in_inlinestyle82);
							irs=inlineset();
							state._fsp--;

							if(irs!=null) rules.add(irs);
							}
							break;

						default :
							if ( cnt1 >= 1 ) break loop1;
							EarlyExitException eee = new EarlyExitException(1, input);
							throw eee;
						}
						cnt1++;
					}

					match(input, Token.UP, null); 

					}
					break;

			}

				log.debug("\n***\n{}\n***\n", rules);	   
				logLeave("inlinestyle");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return rules;
	}
	// $ANTLR end "inlinestyle"



	// $ANTLR start "stylesheet"
	// CSSTreeParser.g:124:1: stylesheet returns [cz.vutbr.web.css.RuleList rules] : ^( STYLESHEET (s= statement )* ) ;
	public final cz.vutbr.web.css.RuleList stylesheet() throws RecognitionException {
		cz.vutbr.web.css.RuleList rules = null;


		cz.vutbr.web.css.RuleBlock<?> s =null;


			logEnter("stylesheet");
		  rules = this.rules = new cz.vutbr.web.csskit.RuleArrayList();

		try {
			// CSSTreeParser.g:133:2: ( ^( STYLESHEET (s= statement )* ) )
			// CSSTreeParser.g:133:4: ^( STYLESHEET (s= statement )* )
			{
			match(input,STYLESHEET,FOLLOW_STYLESHEET_in_stylesheet119); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// CSSTreeParser.g:134:4: (s= statement )*
				loop3:
				while (true) {
					int alt3=2;
					int LA3_0 = input.LA(1);
					if ( (LA3_0==CHARSET||LA3_0==FONTFACE||LA3_0==IMPORT||LA3_0==INVALID_ATSTATEMENT||LA3_0==INVALID_IMPORT||LA3_0==INVALID_STATEMENT||LA3_0==MEDIA||LA3_0==PAGE||LA3_0==RULE||LA3_0==VIEWPORT) ) {
						alt3=1;
					}

					switch (alt3) {
					case 1 :
						// CSSTreeParser.g:134:5: s= statement
						{
						pushFollow(FOLLOW_statement_in_stylesheet128);
						s=statement();
						state._fsp--;

						 if(s!=null) rules.add(s);
						}
						break;

					default :
						break loop3;
					}
				}

				match(input, Token.UP, null); 
			}

			}


				log.debug("\n***\n{}\n***\n", rules);
				logLeave("stylesheet");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return rules;
	}
	// $ANTLR end "stylesheet"


	protected static class statement_scope {
		boolean invalid;
		boolean insideAtstatement;
	}
	protected Stack<statement_scope> statement_stack = new Stack<statement_scope>();


	// $ANTLR start "statement"
	// CSSTreeParser.g:141:1: statement returns [cz.vutbr.web.css.RuleBlock<?> stm] : (rs= ruleset |ats= atstatement | INVALID_STATEMENT );
	public final cz.vutbr.web.css.RuleBlock<?> statement() throws RecognitionException {
		statement_stack.push(new statement_scope());
		cz.vutbr.web.css.RuleBlock<?> stm = null;


		cz.vutbr.web.css.RuleBlock<?> rs =null;
		cz.vutbr.web.css.RuleBlock<?> ats =null;


			logEnter("statement");
			statement_stack.peek().invalid = false;

		try {
			// CSSTreeParser.g:159:2: (rs= ruleset |ats= atstatement | INVALID_STATEMENT )
			int alt4=3;
			switch ( input.LA(1) ) {
			case RULE:
				{
				alt4=1;
				}
				break;
			case CHARSET:
			case FONTFACE:
			case IMPORT:
			case INVALID_ATSTATEMENT:
			case INVALID_IMPORT:
			case MEDIA:
			case PAGE:
			case VIEWPORT:
				{
				alt4=2;
				}
				break;
			case INVALID_STATEMENT:
				{
				alt4=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}
			switch (alt4) {
				case 1 :
					// CSSTreeParser.g:159:4: rs= ruleset
					{
					pushFollow(FOLLOW_ruleset_in_statement177);
					rs=ruleset();
					state._fsp--;

					stm =rs;
					}
					break;
				case 2 :
					// CSSTreeParser.g:160:4: ats= atstatement
					{
					pushFollow(FOLLOW_atstatement_in_statement187);
					ats=atstatement();
					state._fsp--;

					stm =ats;
					}
					break;
				case 3 :
					// CSSTreeParser.g:161:4: INVALID_STATEMENT
					{
					match(input,INVALID_STATEMENT,FOLLOW_INVALID_STATEMENT_in_statement194); 
					 statement_stack.peek().invalid = true; 
					}
					break;

			}

			  if (statement_stack.peek().invalid)
			      log.debug("Statement is invalid");
				logLeave("statement");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			statement_stack.pop();
		}
		return stm;
	}
	// $ANTLR end "statement"


	protected static class atstatement_scope {
		cz.vutbr.web.css.RuleBlock<?> stm;
	}
	protected Stack<atstatement_scope> atstatement_stack = new Stack<atstatement_scope>();


	// $ANTLR start "atstatement"
	// CSSTreeParser.g:165:1: atstatement returns [cz.vutbr.web.css.RuleBlock<?> stmnt] : ( CHARSET | INVALID_IMPORT | ^( IMPORT (im= media )? (iuri= import_uri ) ) | ^( PAGE (i= IDENT )? ( ^( PSEUDOCLASS i= IDENT ) )? decl= declarations ^( SET (m= margin )* ) ) | ^( VIEWPORT decl= declarations ) | ^( FONTFACE decl= declarations ) | ^( MEDIA (mediaList= media )? (rs= ruleset | INVALID_STATEMENT )* ) |unknown= unknown_atrule );
	public final cz.vutbr.web.css.RuleBlock<?> atstatement() throws RecognitionException {
		atstatement_stack.push(new atstatement_scope());
		cz.vutbr.web.css.RuleBlock<?> stmnt = null;


		CommonTree i=null;
		List<cz.vutbr.web.css.MediaQuery> im =null;
		String iuri =null;
		List<cz.vutbr.web.css.Declaration> decl =null;
		cz.vutbr.web.css.RuleMargin m =null;
		List<cz.vutbr.web.css.MediaQuery> mediaList =null;
		cz.vutbr.web.css.RuleBlock<?> rs =null;
		cz.vutbr.web.css.RuleBlock<?> unknown =null;


		    logEnter("atstatement");
			statement_stack.peek().insideAtstatement =true;
			atstatement_stack.peek().stm = stmnt = null;
			List<cz.vutbr.web.css.RuleSet> rules = null;
			List<cz.vutbr.web.css.RuleMargin> margins = null;
			String name = null;
			String pseudo = null;

		try {
			// CSSTreeParser.g:181:2: ( CHARSET | INVALID_IMPORT | ^( IMPORT (im= media )? (iuri= import_uri ) ) | ^( PAGE (i= IDENT )? ( ^( PSEUDOCLASS i= IDENT ) )? decl= declarations ^( SET (m= margin )* ) ) | ^( VIEWPORT decl= declarations ) | ^( FONTFACE decl= declarations ) | ^( MEDIA (mediaList= media )? (rs= ruleset | INVALID_STATEMENT )* ) |unknown= unknown_atrule )
			int alt11=8;
			switch ( input.LA(1) ) {
			case CHARSET:
				{
				alt11=1;
				}
				break;
			case INVALID_IMPORT:
				{
				alt11=2;
				}
				break;
			case IMPORT:
				{
				alt11=3;
				}
				break;
			case PAGE:
				{
				alt11=4;
				}
				break;
			case VIEWPORT:
				{
				alt11=5;
				}
				break;
			case FONTFACE:
				{
				alt11=6;
				}
				break;
			case MEDIA:
				{
				alt11=7;
				}
				break;
			case INVALID_ATSTATEMENT:
				{
				alt11=8;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 11, 0, input);
				throw nvae;
			}
			switch (alt11) {
				case 1 :
					// CSSTreeParser.g:181:4: CHARSET
					{
					match(input,CHARSET,FOLLOW_CHARSET_in_atstatement227); 
					}
					break;
				case 2 :
					// CSSTreeParser.g:182:4: INVALID_IMPORT
					{
					match(input,INVALID_IMPORT,FOLLOW_INVALID_IMPORT_in_atstatement233); 
					}
					break;
				case 3 :
					// CSSTreeParser.g:183:4: ^( IMPORT (im= media )? (iuri= import_uri ) )
					{
					match(input,IMPORT,FOLLOW_IMPORT_in_atstatement240); 
					match(input, Token.DOWN, null); 
					// CSSTreeParser.g:184:8: (im= media )?
					int alt5=2;
					int LA5_0 = input.LA(1);
					if ( (LA5_0==MEDIA_QUERY) ) {
						alt5=1;
					}
					switch (alt5) {
						case 1 :
							// CSSTreeParser.g:184:9: im= media
							{
							pushFollow(FOLLOW_media_in_atstatement252);
							im=media();
							state._fsp--;

							}
							break;

					}

					// CSSTreeParser.g:185:8: (iuri= import_uri )
					// CSSTreeParser.g:185:9: iuri= import_uri
					{
					pushFollow(FOLLOW_import_uri_in_atstatement266);
					iuri=import_uri();
					state._fsp--;

					}

					match(input, Token.UP, null); 


						    if (!this.preventImports)
						    {
							    log.debug("Adding import: {}", iuri);
							    importMedia.add(im);
							    importPaths.add(iuri);
							  }
							  else 
					        log.debug("Ignoring import: {}", iuri);
						  
					}
					break;
				case 4 :
					// CSSTreeParser.g:197:5: ^( PAGE (i= IDENT )? ( ^( PSEUDOCLASS i= IDENT ) )? decl= declarations ^( SET (m= margin )* ) )
					{
					match(input,PAGE,FOLLOW_PAGE_in_atstatement285); 
					match(input, Token.DOWN, null); 
					// CSSTreeParser.g:198:7: (i= IDENT )?
					int alt6=2;
					int LA6_0 = input.LA(1);
					if ( (LA6_0==IDENT) ) {
						alt6=1;
					}
					switch (alt6) {
						case 1 :
							// CSSTreeParser.g:198:8: i= IDENT
							{
							i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_atstatement296); 
							 name = extractTextUnescaped(i); 
							}
							break;

					}

					// CSSTreeParser.g:201:7: ( ^( PSEUDOCLASS i= IDENT ) )?
					int alt7=2;
					int LA7_0 = input.LA(1);
					if ( (LA7_0==PSEUDOCLASS) ) {
						alt7=1;
					}
					switch (alt7) {
						case 1 :
							// CSSTreeParser.g:201:8: ^( PSEUDOCLASS i= IDENT )
							{
							match(input,PSEUDOCLASS,FOLLOW_PSEUDOCLASS_in_atstatement325); 
							match(input, Token.DOWN, null); 
							i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_atstatement329); 
							match(input, Token.UP, null); 

							 pseudo = extractTextUnescaped(i); 
							}
							break;

					}

					pushFollow(FOLLOW_declarations_in_atstatement359);
					decl=declarations();
					state._fsp--;

					match(input,SET,FOLLOW_SET_in_atstatement368); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// CSSTreeParser.g:205:13: (m= margin )*
						loop8:
						while (true) {
							int alt8=2;
							int LA8_0 = input.LA(1);
							if ( (LA8_0==MARGIN_AREA) ) {
								alt8=1;
							}

							switch (alt8) {
							case 1 :
								// CSSTreeParser.g:205:14: m= margin
								{
								pushFollow(FOLLOW_margin_in_atstatement373);
								m=margin();
								state._fsp--;


								        if (m!=null) {
								          if (margins == null) margins = new ArrayList<cz.vutbr.web.css.RuleMargin>();
								          margins.add(m);
								          log.debug("Inserted margin rule #{} into @page", margins.size()+1);
								        }
								      
								}
								break;

							default :
								break loop8;
							}
						}

						match(input, Token.UP, null); 
					}

					match(input, Token.UP, null); 


					      stmnt = preparator.prepareRulePage(decl, margins, name, pseudo);
					      this.preventImports = true;
					    
					}
					break;
				case 5 :
					// CSSTreeParser.g:217:5: ^( VIEWPORT decl= declarations )
					{
					match(input,VIEWPORT,FOLLOW_VIEWPORT_in_atstatement397); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_declarations_in_atstatement401);
					decl=declarations();
					state._fsp--;

					match(input, Token.UP, null); 

					 stmnt = preparator.prepareRuleViewport(decl); this.preventImports = true; 
					}
					break;
				case 6 :
					// CSSTreeParser.g:219:5: ^( FONTFACE decl= declarations )
					{
					match(input,FONTFACE,FOLLOW_FONTFACE_in_atstatement415); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_declarations_in_atstatement419);
					decl=declarations();
					state._fsp--;

					match(input, Token.UP, null); 

					 stmnt = preparator.prepareRuleFontFace(decl); this.preventImports = true; 
					}
					break;
				case 7 :
					// CSSTreeParser.g:221:4: ^( MEDIA (mediaList= media )? (rs= ruleset | INVALID_STATEMENT )* )
					{
					match(input,MEDIA,FOLLOW_MEDIA_in_atstatement432); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// CSSTreeParser.g:221:12: (mediaList= media )?
						int alt9=2;
						int LA9_0 = input.LA(1);
						if ( (LA9_0==MEDIA_QUERY) ) {
							alt9=1;
						}
						switch (alt9) {
							case 1 :
								// CSSTreeParser.g:221:13: mediaList= media
								{
								pushFollow(FOLLOW_media_in_atstatement437);
								mediaList=media();
								state._fsp--;

								}
								break;

						}

						// CSSTreeParser.g:222:4: (rs= ruleset | INVALID_STATEMENT )*
						loop10:
						while (true) {
							int alt10=3;
							int LA10_0 = input.LA(1);
							if ( (LA10_0==RULE) ) {
								alt10=1;
							}
							else if ( (LA10_0==INVALID_STATEMENT) ) {
								alt10=2;
							}

							switch (alt10) {
							case 1 :
								// CSSTreeParser.g:222:7: rs= ruleset
								{
								pushFollow(FOLLOW_ruleset_in_atstatement450);
								rs=ruleset();
								state._fsp--;


													   if(rules==null) rules = new ArrayList<cz.vutbr.web.css.RuleSet>();				
													   if(rs!=null) {
														   // this cast should be safe, because when inside of @statetement, oridinal ruleset
														   // is returned
													       rules.add((cz.vutbr.web.css.RuleSet)rs);
														   log.debug("Inserted ruleset ({}) into @media", rules.size());
													   }
													
								}
								break;
							case 2 :
								// CSSTreeParser.g:231:8: INVALID_STATEMENT
								{
								match(input,INVALID_STATEMENT,FOLLOW_INVALID_STATEMENT_in_atstatement461); 
								 log.debug("Skiping invalid statement in media"); 
								}
								break;

							default :
								break loop10;
							}
						}

						match(input, Token.UP, null); 
					}


							   stmnt = preparator.prepareRuleMedia(rules, mediaList);
							   this.preventImports = true;
						   
					}
					break;
				case 8 :
					// CSSTreeParser.g:239:4: unknown= unknown_atrule
					{
					pushFollow(FOLLOW_unknown_atrule_in_atstatement493);
					unknown=unknown_atrule();
					state._fsp--;

					 stmnt = unknown; 
					}
					break;

			}

			    logLeave("atstatement");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			atstatement_stack.pop();
		}
		return stmnt;
	}
	// $ANTLR end "atstatement"



	// $ANTLR start "unknown_atrule"
	// CSSTreeParser.g:242:1: unknown_atrule returns [cz.vutbr.web.css.RuleBlock<?> stmnt] : INVALID_ATSTATEMENT ;
	public final cz.vutbr.web.css.RuleBlock<?> unknown_atrule() throws RecognitionException {
		cz.vutbr.web.css.RuleBlock<?> stmnt = null;


		 stmnt = null; 
		try {
			// CSSTreeParser.g:244:5: ( INVALID_ATSTATEMENT )
			// CSSTreeParser.g:244:7: INVALID_ATSTATEMENT
			{
			match(input,INVALID_ATSTATEMENT,FOLLOW_INVALID_ATSTATEMENT_in_unknown_atrule518); 
			 log.debug("Skipping invalid at statement"); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmnt;
	}
	// $ANTLR end "unknown_atrule"



	// $ANTLR start "import_uri"
	// CSSTreeParser.g:247:1: import_uri returns [String s] : ( (uri= URI ) | (str= STRING ) );
	public final String import_uri() throws RecognitionException {
		String s = null;


		CommonTree uri=null;
		CommonTree str=null;

		try {
			// CSSTreeParser.g:248:3: ( (uri= URI ) | (str= STRING ) )
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0==URI) ) {
				alt12=1;
			}
			else if ( (LA12_0==STRING) ) {
				alt12=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 12, 0, input);
				throw nvae;
			}

			switch (alt12) {
				case 1 :
					// CSSTreeParser.g:248:5: (uri= URI )
					{
					// CSSTreeParser.g:248:5: (uri= URI )
					// CSSTreeParser.g:248:6: uri= URI
					{
					uri=(CommonTree)match(input,URI,FOLLOW_URI_in_import_uri542); 
					}

					 s = extractTextUnescaped(uri); 
					}
					break;
				case 2 :
					// CSSTreeParser.g:249:5: (str= STRING )
					{
					// CSSTreeParser.g:249:5: (str= STRING )
					// CSSTreeParser.g:249:6: str= STRING
					{
					str=(CommonTree)match(input,STRING,FOLLOW_STRING_in_import_uri554); 
					}

					 s = extractTextUnescaped(str); 
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "import_uri"



	// $ANTLR start "margin"
	// CSSTreeParser.g:252:1: margin returns [cz.vutbr.web.css.RuleMargin m] : ^(area= MARGIN_AREA decl= declarations ) ;
	public final cz.vutbr.web.css.RuleMargin margin() throws RecognitionException {
		cz.vutbr.web.css.RuleMargin m = null;


		CommonTree area=null;
		List<cz.vutbr.web.css.Declaration> decl =null;


		    logEnter("margin");

		try {
			// CSSTreeParser.g:259:2: ( ^(area= MARGIN_AREA decl= declarations ) )
			// CSSTreeParser.g:259:4: ^(area= MARGIN_AREA decl= declarations )
			{
			area=(CommonTree)match(input,MARGIN_AREA,FOLLOW_MARGIN_AREA_in_margin588); 
			match(input, Token.DOWN, null); 
			pushFollow(FOLLOW_declarations_in_margin594);
			decl=declarations();
			state._fsp--;

			match(input, Token.UP, null); 

			 m = preparator.prepareRuleMargin(extractTextUnescaped(area).substring(1), decl); 
			}


			    logLeave("margin");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return m;
	}
	// $ANTLR end "margin"



	// $ANTLR start "media"
	// CSSTreeParser.g:264:1: media returns [List<cz.vutbr.web.css.MediaQuery> queries] : (q= mediaquery )+ ;
	public final List<cz.vutbr.web.css.MediaQuery> media() throws RecognitionException {
		List<cz.vutbr.web.css.MediaQuery> queries = null;


		cz.vutbr.web.css.MediaQuery q =null;


		   logEnter("media");
		   queries = new ArrayList<cz.vutbr.web.css.MediaQuery>();

		try {
			// CSSTreeParser.g:273:2: ( (q= mediaquery )+ )
			// CSSTreeParser.g:273:4: (q= mediaquery )+
			{
			// CSSTreeParser.g:273:4: (q= mediaquery )+
			int cnt13=0;
			loop13:
			while (true) {
				int alt13=2;
				int LA13_0 = input.LA(1);
				if ( (LA13_0==MEDIA_QUERY) ) {
					alt13=1;
				}

				switch (alt13) {
				case 1 :
					// CSSTreeParser.g:273:5: q= mediaquery
					{
					pushFollow(FOLLOW_mediaquery_in_media630);
					q=mediaquery();
					state._fsp--;


									   queries.add(q);
					    
					}
					break;

				default :
					if ( cnt13 >= 1 ) break loop13;
					EarlyExitException eee = new EarlyExitException(13, input);
					throw eee;
				}
				cnt13++;
			}

			}


			   log.debug("Totally returned {} media queries.", queries.size());							  
			   logLeave("media");		   

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return queries;
	}
	// $ANTLR end "media"


	protected static class mediaquery_scope {
		cz.vutbr.web.css.MediaQuery q;
		MediaQueryState state;
		boolean invalid;
	}
	protected Stack<mediaquery_scope> mediaquery_stack = new Stack<mediaquery_scope>();


	// $ANTLR start "mediaquery"
	// CSSTreeParser.g:278:1: mediaquery returns [cz.vutbr.web.css.MediaQuery query] : ^( MEDIA_QUERY ( mediaterm )+ ) ;
	public final cz.vutbr.web.css.MediaQuery mediaquery() throws RecognitionException {
		mediaquery_stack.push(new mediaquery_scope());
		cz.vutbr.web.css.MediaQuery query = null;



		    logEnter("mediaquery");
		    mediaquery_stack.peek().q = query = rf.createMediaQuery();
		    query.unlock();
		    mediaquery_stack.peek().state = MediaQueryState.START;
		    mediaquery_stack.peek().invalid = false;

		try {
			// CSSTreeParser.g:300:3: ( ^( MEDIA_QUERY ( mediaterm )+ ) )
			// CSSTreeParser.g:300:5: ^( MEDIA_QUERY ( mediaterm )+ )
			{
			match(input,MEDIA_QUERY,FOLLOW_MEDIA_QUERY_in_mediaquery666); 
			match(input, Token.DOWN, null); 
			// CSSTreeParser.g:300:19: ( mediaterm )+
			int cnt14=0;
			loop14:
			while (true) {
				int alt14=2;
				int LA14_0 = input.LA(1);
				if ( (LA14_0==DECLARATION||LA14_0==IDENT||LA14_0==INVALID_DECLARATION||LA14_0==INVALID_STATEMENT) ) {
					alt14=1;
				}

				switch (alt14) {
				case 1 :
					// CSSTreeParser.g:300:19: mediaterm
					{
					pushFollow(FOLLOW_mediaterm_in_mediaquery668);
					mediaterm();
					state._fsp--;

					}
					break;

				default :
					if ( cnt14 >= 1 ) break loop14;
					EarlyExitException eee = new EarlyExitException(14, input);
					throw eee;
				}
				cnt14++;
			}

			match(input, Token.UP, null); 

			}


			    if (mediaquery_stack.peek().invalid)
			    {
			        log.trace("Skipping invalid rule {}", query);
			        mediaquery_stack.peek().q.setType("all"); //change the malformed media queries to "not all"
			        mediaquery_stack.peek().q.setNegative(true);
			    }
			    logLeave("mediaquery");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			mediaquery_stack.pop();
		}
		return query;
	}
	// $ANTLR end "mediaquery"



	// $ANTLR start "mediaterm"
	// CSSTreeParser.g:303:1: mediaterm : ( (i= IDENT ) | (e= mediaexpression ) | ( INVALID_STATEMENT ) );
	public final void mediaterm() throws RecognitionException {
		CommonTree i=null;
		cz.vutbr.web.css.MediaExpression e =null;

		try {
			// CSSTreeParser.g:304:3: ( (i= IDENT ) | (e= mediaexpression ) | ( INVALID_STATEMENT ) )
			int alt15=3;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt15=1;
				}
				break;
			case DECLARATION:
			case INVALID_DECLARATION:
				{
				alt15=2;
				}
				break;
			case INVALID_STATEMENT:
				{
				alt15=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 15, 0, input);
				throw nvae;
			}
			switch (alt15) {
				case 1 :
					// CSSTreeParser.g:304:5: (i= IDENT )
					{
					// CSSTreeParser.g:304:5: (i= IDENT )
					// CSSTreeParser.g:304:6: i= IDENT
					{
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_mediaterm686); 

					            String m = extractTextUnescaped(i);
					            MediaQueryState state = mediaquery_stack.peek().state;
					            if (m.equalsIgnoreCase("ONLY") && state == MediaQueryState.START)
					            {
					                mediaquery_stack.peek().state = MediaQueryState.TYPEOREXPR;
					            }
					            else if (m.equalsIgnoreCase("NOT") && state == MediaQueryState.START)
					            {
					                mediaquery_stack.peek().q.setNegative(true);
					                mediaquery_stack.peek().state = MediaQueryState.TYPEOREXPR;
					            }
					            else if (m.equalsIgnoreCase("AND") && state == MediaQueryState.AND)
					            {
					                mediaquery_stack.peek().state = MediaQueryState.EXPR;
					            }
					            else if (state == MediaQueryState.START
					                      || state == MediaQueryState.TYPE
					                      || state == MediaQueryState.TYPEOREXPR)
					            { 
					                mediaquery_stack.peek().q.setType(m);
					                mediaquery_stack.peek().state = MediaQueryState.AND;
					            }
					            else
					            {
					                log.trace("Invalid media query: found ident: {} state: {}", m, state);
					                mediaquery_stack.peek().invalid = true;
					            }
					        
					}

					}
					break;
				case 2 :
					// CSSTreeParser.g:334:6: (e= mediaexpression )
					{
					// CSSTreeParser.g:334:6: (e= mediaexpression )
					// CSSTreeParser.g:334:7: e= mediaexpression
					{
					pushFollow(FOLLOW_mediaexpression_in_mediaterm706);
					e=mediaexpression();
					state._fsp--;


					            if (mediaquery_stack.peek().state == MediaQueryState.START 
					                || mediaquery_stack.peek().state == MediaQueryState.EXPR
					                || mediaquery_stack.peek().state == MediaQueryState.TYPEOREXPR)
					            {
					                if (e.getFeature() != null) //the expression is valid
					                {
							                mediaquery_stack.peek().q.add(e); 
							                mediaquery_stack.peek().state = MediaQueryState.AND;
							            }
							            else
							            {
							                log.trace("Invalidating media query for invalud expression");
							                mediaquery_stack.peek().invalid = true;
							            }
					            }
					            else
					            {
					                log.trace("Invalid media query: found expr, state: {}", mediaquery_stack.peek().state);
					                mediaquery_stack.peek().invalid = true;
					            }
					      
					}

					}
					break;
				case 3 :
					// CSSTreeParser.g:356:6: ( INVALID_STATEMENT )
					{
					// CSSTreeParser.g:356:6: ( INVALID_STATEMENT )
					// CSSTreeParser.g:356:7: INVALID_STATEMENT
					{
					match(input,INVALID_STATEMENT,FOLLOW_INVALID_STATEMENT_in_mediaterm717); 

					            mediaquery_stack.peek().invalid = true;
					      
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "mediaterm"



	// $ANTLR start "mediaexpression"
	// CSSTreeParser.g:361:1: mediaexpression returns [cz.vutbr.web.css.MediaExpression expr] : d= declaration ;
	public final cz.vutbr.web.css.MediaExpression mediaexpression() throws RecognitionException {
		cz.vutbr.web.css.MediaExpression expr = null;


		cz.vutbr.web.css.Declaration d =null;


		    logEnter("mediaquery");
		    expr = rf.createMediaExpression();

		try {
			// CSSTreeParser.g:369:5: (d= declaration )
			// CSSTreeParser.g:369:7: d= declaration
			{
			pushFollow(FOLLOW_declaration_in_mediaexpression752);
			d=declaration();
			state._fsp--;

			 
			          if (d != null) { //if the declaration is valid
			              expr.setFeature(d.getProperty()); 
			              expr.replaceAll(d);
			          } 
			      
			}


			    logLeave("mediaquery");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return expr;
	}
	// $ANTLR end "mediaexpression"



	// $ANTLR start "inlineset"
	// CSSTreeParser.g:377:1: inlineset returns [cz.vutbr.web.css.RuleBlock<?> is] : ^( RULE (p= pseudo )* decl= declarations ) ;
	public final cz.vutbr.web.css.RuleBlock<?> inlineset() throws RecognitionException {
		cz.vutbr.web.css.RuleBlock<?> is = null;


		cz.vutbr.web.css.Selector.PseudoPage p =null;
		List<cz.vutbr.web.css.Declaration> decl =null;


		     logEnter("inlineset");
			 List<cz.vutbr.web.css.Selector.PseudoPage> pplist = new ArrayList<cz.vutbr.web.css.Selector.PseudoPage>();

		try {
			// CSSTreeParser.g:385:2: ( ^( RULE (p= pseudo )* decl= declarations ) )
			// CSSTreeParser.g:385:4: ^( RULE (p= pseudo )* decl= declarations )
			{
			match(input,RULE,FOLLOW_RULE_in_inlineset783); 
			match(input, Token.DOWN, null); 
			// CSSTreeParser.g:385:11: (p= pseudo )*
			loop16:
			while (true) {
				int alt16=2;
				int LA16_0 = input.LA(1);
				if ( ((LA16_0 >= PSEUDOCLASS && LA16_0 <= PSEUDOELEM)) ) {
					alt16=1;
				}

				switch (alt16) {
				case 1 :
					// CSSTreeParser.g:385:12: p= pseudo
					{
					pushFollow(FOLLOW_pseudo_in_inlineset788);
					p=pseudo();
					state._fsp--;

					pplist.add(p);
					}
					break;

				default :
					break loop16;
				}
			}

			pushFollow(FOLLOW_declarations_in_inlineset796);
			decl=declarations();
			state._fsp--;

			match(input, Token.UP, null); 

			 is = preparator.prepareInlineRuleSet(decl, pplist); 
			}


			     logLeave("inlineset");   

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return is;
	}
	// $ANTLR end "inlineset"



	// $ANTLR start "ruleset"
	// CSSTreeParser.g:394:1: ruleset returns [cz.vutbr.web.css.RuleBlock<?> stmnt] : ^( RULE (cs= combined_selector )* decl= declarations ) ;
	public final cz.vutbr.web.css.RuleBlock<?> ruleset() throws RecognitionException {
		cz.vutbr.web.css.RuleBlock<?> stmnt = null;


		cz.vutbr.web.css.CombinedSelector cs =null;
		List<cz.vutbr.web.css.Declaration> decl =null;


		    logEnter("ruleset"); 
		    List<cz.vutbr.web.css.CombinedSelector> cslist = new ArrayList<cz.vutbr.web.css.CombinedSelector>();

		try {
			// CSSTreeParser.g:410:5: ( ^( RULE (cs= combined_selector )* decl= declarations ) )
			// CSSTreeParser.g:410:7: ^( RULE (cs= combined_selector )* decl= declarations )
			{
			match(input,RULE,FOLLOW_RULE_in_ruleset849); 
			match(input, Token.DOWN, null); 
			// CSSTreeParser.g:411:9: (cs= combined_selector )*
			loop17:
			while (true) {
				int alt17=2;
				int LA17_0 = input.LA(1);
				if ( (LA17_0==INVALID_SELECTOR||LA17_0==SELECTOR) ) {
					alt17=1;
				}

				switch (alt17) {
				case 1 :
					// CSSTreeParser.g:411:10: cs= combined_selector
					{
					pushFollow(FOLLOW_combined_selector_in_ruleset863);
					cs=combined_selector();
					state._fsp--;

					if(cs!=null && !cs.isEmpty() && !statement_stack.peek().invalid) {
					            cslist.add(cs);
					            log.debug("Inserted combined selector ({}) into ruleset",  cslist.size());
					         }   
					        
					}
					break;

				default :
					break loop17;
				}
			}

			pushFollow(FOLLOW_declarations_in_ruleset884);
			decl=declarations();
			state._fsp--;

			match(input, Token.UP, null); 

			}


			    if(statement_stack.peek().invalid) {
			        stmnt = null;
			        log.debug("Ruleset not valid, so not created");
			    }
			    else {    
					 stmnt = preparator.prepareRuleSet(cslist, decl, (this.wrapMedia != null && !this.wrapMedia.isEmpty()), this.wrapMedia);
					 this.preventImports = true; 
			        }		
			    logLeave("ruleset");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return stmnt;
	}
	// $ANTLR end "ruleset"



	// $ANTLR start "declarations"
	// CSSTreeParser.g:424:1: declarations returns [List<cz.vutbr.web.css.Declaration> decl] : ^( SET (d= declaration )* ) ;
	public final List<cz.vutbr.web.css.Declaration> declarations() throws RecognitionException {
		List<cz.vutbr.web.css.Declaration> decl = null;


		cz.vutbr.web.css.Declaration d =null;


				  logEnter("declarations");
				  decl = new ArrayList<cz.vutbr.web.css.Declaration>();

		try {
			// CSSTreeParser.g:432:2: ( ^( SET (d= declaration )* ) )
			// CSSTreeParser.g:432:4: ^( SET (d= declaration )* )
			{
			match(input,SET,FOLLOW_SET_in_declarations925); 
			if ( input.LA(1)==Token.DOWN ) {
				match(input, Token.DOWN, null); 
				// CSSTreeParser.g:432:10: (d= declaration )*
				loop18:
				while (true) {
					int alt18=2;
					int LA18_0 = input.LA(1);
					if ( (LA18_0==DECLARATION||LA18_0==INVALID_DECLARATION) ) {
						alt18=1;
					}

					switch (alt18) {
					case 1 :
						// CSSTreeParser.g:432:11: d= declaration
						{
						pushFollow(FOLLOW_declaration_in_declarations930);
						d=declaration();
						state._fsp--;


							     if(d!=null) {
						            decl.add(d);
						            log.debug("Inserted declaration #{} ", decl.size()+1);
								 }	
							 
						}
						break;

					default :
						break loop18;
					}
				}

				match(input, Token.UP, null); 
			}

			}


					   logLeave("declarations");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return decl;
	}
	// $ANTLR end "declarations"


	protected static class declaration_scope {
		cz.vutbr.web.css.Declaration d;
		boolean invalid;
	}
	protected Stack<declaration_scope> declaration_stack = new Stack<declaration_scope>();


	// $ANTLR start "declaration"
	// CSSTreeParser.g:445:1: declaration returns [cz.vutbr.web.css.Declaration decl] : ( ^( DECLARATION ( important )? ( INVALID_DIRECTIVE )? property t= terms ) | INVALID_DECLARATION );
	public final cz.vutbr.web.css.Declaration declaration() throws RecognitionException {
		declaration_stack.push(new declaration_scope());
		cz.vutbr.web.css.Declaration decl = null;


		List<cz.vutbr.web.css.Term<?>> t =null;


		    logEnter("declaration");
		    declaration_stack.peek().d = decl = rf.createDeclaration();
		    declaration_stack.peek().invalid = false;

		try {
			// CSSTreeParser.g:465:3: ( ^( DECLARATION ( important )? ( INVALID_DIRECTIVE )? property t= terms ) | INVALID_DECLARATION )
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0==DECLARATION) ) {
				alt21=1;
			}
			else if ( (LA21_0==INVALID_DECLARATION) ) {
				alt21=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 21, 0, input);
				throw nvae;
			}

			switch (alt21) {
				case 1 :
					// CSSTreeParser.g:465:5: ^( DECLARATION ( important )? ( INVALID_DIRECTIVE )? property t= terms )
					{
					match(input,DECLARATION,FOLLOW_DECLARATION_in_declaration974); 
					match(input, Token.DOWN, null); 
					// CSSTreeParser.g:466:6: ( important )?
					int alt19=2;
					int LA19_0 = input.LA(1);
					if ( (LA19_0==IMPORTANT) ) {
						alt19=1;
					}
					switch (alt19) {
						case 1 :
							// CSSTreeParser.g:466:7: important
							{
							pushFollow(FOLLOW_important_in_declaration983);
							important();
							state._fsp--;

							 decl.setImportant(true); log.debug("IMPORTANT"); 
							}
							break;

					}

					// CSSTreeParser.g:467:7: ( INVALID_DIRECTIVE )?
					int alt20=2;
					int LA20_0 = input.LA(1);
					if ( (LA20_0==INVALID_DIRECTIVE) ) {
						alt20=1;
					}
					switch (alt20) {
						case 1 :
							// CSSTreeParser.g:467:8: INVALID_DIRECTIVE
							{
							match(input,INVALID_DIRECTIVE,FOLLOW_INVALID_DIRECTIVE_in_declaration996); 
							 declaration_stack.peek().invalid =true; 
							}
							break;

					}

					pushFollow(FOLLOW_property_in_declaration1008);
					property();
					state._fsp--;

					pushFollow(FOLLOW_terms_in_declaration1019);
					t=terms();
					state._fsp--;

					decl.replaceAll(t);
					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// CSSTreeParser.g:471:4: INVALID_DECLARATION
					{
					match(input,INVALID_DECLARATION,FOLLOW_INVALID_DECLARATION_in_declaration1039); 
					 declaration_stack.peek().invalid =true;
					}
					break;

			}

			    if(declaration_stack.peek().invalid || declaration_stack.isEmpty()) {
			        decl =null;
			        log.debug("Declaration was invalidated or already invalid");
			    }
			    else {
			        log.debug("Returning declaration: {}.", decl);
			    }
			    logLeave("declaration");    

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			declaration_stack.pop();
		}
		return decl;
	}
	// $ANTLR end "declaration"



	// $ANTLR start "important"
	// CSSTreeParser.g:474:1: important : IMPORTANT ;
	public final void important() throws RecognitionException {
		try {
			// CSSTreeParser.g:475:5: ( IMPORTANT )
			// CSSTreeParser.g:475:7: IMPORTANT
			{
			match(input,IMPORTANT,FOLLOW_IMPORTANT_in_important1056); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "important"



	// $ANTLR start "property"
	// CSSTreeParser.g:481:1: property : (i= IDENT | MINUS i= IDENT );
	public final void property() throws RecognitionException {
		CommonTree i=null;


		    logEnter("property");

		try {
			// CSSTreeParser.g:489:3: (i= IDENT | MINUS i= IDENT )
			int alt22=2;
			int LA22_0 = input.LA(1);
			if ( (LA22_0==IDENT) ) {
				alt22=1;
			}
			else if ( (LA22_0==MINUS) ) {
				alt22=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 22, 0, input);
				throw nvae;
			}

			switch (alt22) {
				case 1 :
					// CSSTreeParser.g:489:5: i= IDENT
					{
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_property1096); 
					 declaration_stack.peek().d.setProperty(extractTextUnescaped(i)); declaration_stack.peek().d.setSource(extractSource(i)); 
					}
					break;
				case 2 :
					// CSSTreeParser.g:490:5: MINUS i= IDENT
					{
					match(input,MINUS,FOLLOW_MINUS_in_property1104); 
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_property1110); 
					 declaration_stack.peek().d.setProperty("-" + extractTextUnescaped(i)); declaration_stack.peek().d.setSource(extractSource(i)); 
					}
					break;

			}

				log.debug("Setting property: {}", declaration_stack.peek().d.getProperty());	   
			    logLeave("property");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "property"


	protected static class terms_scope {
		List<cz.vutbr.web.css.Term<?>> list;
		cz.vutbr.web.css.Term<?> term;
		cz.vutbr.web.css.Term.Operator op;
		int unary;
		boolean dash;
	}
	protected Stack<terms_scope> terms_stack = new Stack<terms_scope>();


	// $ANTLR start "terms"
	// CSSTreeParser.g:496:1: terms returns [List<cz.vutbr.web.css.Term<?>> tlist] : ^( VALUE ( term )+ ) ;
	public final List<cz.vutbr.web.css.Term<?>> terms() throws RecognitionException {
		terms_stack.push(new terms_scope());
		List<cz.vutbr.web.css.Term<?>> tlist = null;



		    logEnter("terms");
		    terms_stack.peek().list = tlist = new ArrayList<cz.vutbr.web.css.Term<?>>();
		    terms_stack.peek().term = null;
		    terms_stack.peek().op = null;
		    terms_stack.peek().unary = 1;
		    terms_stack.peek().dash = false;

		try {
			// CSSTreeParser.g:516:5: ( ^( VALUE ( term )+ ) )
			// CSSTreeParser.g:516:7: ^( VALUE ( term )+ )
			{
			match(input,VALUE,FOLLOW_VALUE_in_terms1155); 
			match(input, Token.DOWN, null); 
			// CSSTreeParser.g:516:15: ( term )+
			int cnt23=0;
			loop23:
			while (true) {
				int alt23=2;
				int LA23_0 = input.LA(1);
				if ( (LA23_0==ASTERISK||LA23_0==ATKEYWORD||LA23_0==BRACEBLOCK||(LA23_0 >= CLASSKEYWORD && LA23_0 <= COMMA)||(LA23_0 >= CURLYBLOCK && LA23_0 <= DASHMATCH)||LA23_0==DIMENSION||LA23_0==EQUALS||LA23_0==EXPRESSION||(LA23_0 >= FUNCTION && LA23_0 <= HASH)||LA23_0==IDENT||LA23_0==INCLUDES||LA23_0==INVALID_STRING||LA23_0==LESS||LA23_0==MINUS||LA23_0==NUMBER||(LA23_0 >= PARENBLOCK && LA23_0 <= PLUS)||LA23_0==QUESTION||LA23_0==SLASH||LA23_0==STRING||(LA23_0 >= UNIRANGE && LA23_0 <= URI)) ) {
					alt23=1;
				}

				switch (alt23) {
				case 1 :
					// CSSTreeParser.g:516:15: term
					{
					pushFollow(FOLLOW_term_in_terms1157);
					term();
					state._fsp--;

					}
					break;

				default :
					if ( cnt23 >= 1 ) break loop23;
					EarlyExitException eee = new EarlyExitException(23, input);
					throw eee;
				}
				cnt23++;
			}

			match(input, Token.UP, null); 

			}


				log.debug("Totally added {} terms", tlist.size());	   
			    logLeave("terms");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			terms_stack.pop();
		}
		return tlist;
	}
	// $ANTLR end "terms"



	// $ANTLR start "term"
	// CSSTreeParser.g:519:1: term : ( valuepart | CURLYBLOCK | ATKEYWORD );
	public final void term() throws RecognitionException {

		  logEnter("term");

		try {
			// CSSTreeParser.g:523:5: ( valuepart | CURLYBLOCK | ATKEYWORD )
			int alt24=3;
			switch ( input.LA(1) ) {
			case ASTERISK:
			case BRACEBLOCK:
			case CLASSKEYWORD:
			case COLON:
			case COMMA:
			case DASHMATCH:
			case DIMENSION:
			case EQUALS:
			case EXPRESSION:
			case FUNCTION:
			case GREATER:
			case HASH:
			case IDENT:
			case INCLUDES:
			case INVALID_STRING:
			case LESS:
			case MINUS:
			case NUMBER:
			case PARENBLOCK:
			case PERCENT:
			case PERCENTAGE:
			case PLUS:
			case QUESTION:
			case SLASH:
			case STRING:
			case UNIRANGE:
			case URI:
				{
				alt24=1;
				}
				break;
			case CURLYBLOCK:
				{
				alt24=2;
				}
				break;
			case ATKEYWORD:
				{
				alt24=3;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 24, 0, input);
				throw nvae;
			}
			switch (alt24) {
				case 1 :
					// CSSTreeParser.g:523:7: valuepart
					{
					pushFollow(FOLLOW_valuepart_in_term1185);
					valuepart();
					state._fsp--;

					// set operator, store and create next 
					       if(!declaration_stack.peek().invalid && terms_stack.peek().term!=null) {
					          terms_stack.peek().term.setOperator(terms_stack.peek().op);
					          terms_stack.peek().list.add(terms_stack.peek().term);
					          // reinitialization
					          terms_stack.peek().op = cz.vutbr.web.css.Term.Operator.SPACE;
					          terms_stack.peek().unary = 1;
					          terms_stack.peek().dash = false;
					          terms_stack.peek().term = null;
					       }    
					      
					}
					break;
				case 2 :
					// CSSTreeParser.g:535:7: CURLYBLOCK
					{
					match(input,CURLYBLOCK,FOLLOW_CURLYBLOCK_in_term1202); 
					 declaration_stack.peek().invalid = true;
					}
					break;
				case 3 :
					// CSSTreeParser.g:536:7: ATKEYWORD
					{
					match(input,ATKEYWORD,FOLLOW_ATKEYWORD_in_term1212); 
					 declaration_stack.peek().invalid = true;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "term"



	// $ANTLR start "valuepart"
	// CSSTreeParser.g:539:1: valuepart : ( ( MINUS )? i= IDENT | CLASSKEYWORD | ( MINUS )? n= NUMBER | ( MINUS )? p= PERCENTAGE | ( MINUS )? d= DIMENSION |s= string |u= URI |h= HASH | UNIRANGE | INCLUDES | COLON | COMMA | GREATER | LESS | QUESTION | PERCENT | EQUALS | SLASH | PLUS | ASTERISK |e= EXPRESSION | ( MINUS )? ^(f= FUNCTION (t= terms )? ) | DASHMATCH | ^( PARENBLOCK ( any )* ) | ^( BRACEBLOCK ( any )* ) );
	public final void valuepart() throws RecognitionException {
		CommonTree i=null;
		CommonTree n=null;
		CommonTree p=null;
		CommonTree d=null;
		CommonTree u=null;
		CommonTree h=null;
		CommonTree e=null;
		CommonTree f=null;
		String s =null;
		List<cz.vutbr.web.css.Term<?>> t =null;

		try {
			// CSSTreeParser.g:561:5: ( ( MINUS )? i= IDENT | CLASSKEYWORD | ( MINUS )? n= NUMBER | ( MINUS )? p= PERCENTAGE | ( MINUS )? d= DIMENSION |s= string |u= URI |h= HASH | UNIRANGE | INCLUDES | COLON | COMMA | GREATER | LESS | QUESTION | PERCENT | EQUALS | SLASH | PLUS | ASTERISK |e= EXPRESSION | ( MINUS )? ^(f= FUNCTION (t= terms )? ) | DASHMATCH | ^( PARENBLOCK ( any )* ) | ^( BRACEBLOCK ( any )* ) )
			int alt33=25;
			switch ( input.LA(1) ) {
			case MINUS:
				{
				switch ( input.LA(2) ) {
				case IDENT:
					{
					alt33=1;
					}
					break;
				case NUMBER:
					{
					alt33=3;
					}
					break;
				case PERCENTAGE:
					{
					alt33=4;
					}
					break;
				case DIMENSION:
					{
					alt33=5;
					}
					break;
				case FUNCTION:
					{
					alt33=22;
					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 33, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
				}
				break;
			case IDENT:
				{
				alt33=1;
				}
				break;
			case CLASSKEYWORD:
				{
				alt33=2;
				}
				break;
			case NUMBER:
				{
				alt33=3;
				}
				break;
			case PERCENTAGE:
				{
				alt33=4;
				}
				break;
			case DIMENSION:
				{
				alt33=5;
				}
				break;
			case INVALID_STRING:
			case STRING:
				{
				alt33=6;
				}
				break;
			case URI:
				{
				alt33=7;
				}
				break;
			case HASH:
				{
				alt33=8;
				}
				break;
			case UNIRANGE:
				{
				alt33=9;
				}
				break;
			case INCLUDES:
				{
				alt33=10;
				}
				break;
			case COLON:
				{
				alt33=11;
				}
				break;
			case COMMA:
				{
				alt33=12;
				}
				break;
			case GREATER:
				{
				alt33=13;
				}
				break;
			case LESS:
				{
				alt33=14;
				}
				break;
			case QUESTION:
				{
				alt33=15;
				}
				break;
			case PERCENT:
				{
				alt33=16;
				}
				break;
			case EQUALS:
				{
				alt33=17;
				}
				break;
			case SLASH:
				{
				alt33=18;
				}
				break;
			case PLUS:
				{
				alt33=19;
				}
				break;
			case ASTERISK:
				{
				alt33=20;
				}
				break;
			case EXPRESSION:
				{
				alt33=21;
				}
				break;
			case FUNCTION:
				{
				alt33=22;
				}
				break;
			case DASHMATCH:
				{
				alt33=23;
				}
				break;
			case PARENBLOCK:
				{
				alt33=24;
				}
				break;
			case BRACEBLOCK:
				{
				alt33=25;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 33, 0, input);
				throw nvae;
			}
			switch (alt33) {
				case 1 :
					// CSSTreeParser.g:561:7: ( MINUS )? i= IDENT
					{
					// CSSTreeParser.g:561:7: ( MINUS )?
					int alt25=2;
					int LA25_0 = input.LA(1);
					if ( (LA25_0==MINUS) ) {
						alt25=1;
					}
					switch (alt25) {
						case 1 :
							// CSSTreeParser.g:561:8: MINUS
							{
							match(input,MINUS,FOLLOW_MINUS_in_valuepart1239); 
							terms_stack.peek().dash =true;
							}
							break;

					}

					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_valuepart1247); 
					terms_stack.peek().term = tf.createIdent(extractTextUnescaped(i), terms_stack.peek().dash);
					}
					break;
				case 2 :
					// CSSTreeParser.g:562:7: CLASSKEYWORD
					{
					match(input,CLASSKEYWORD,FOLLOW_CLASSKEYWORD_in_valuepart1259); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 3 :
					// CSSTreeParser.g:563:6: ( MINUS )? n= NUMBER
					{
					// CSSTreeParser.g:563:6: ( MINUS )?
					int alt26=2;
					int LA26_0 = input.LA(1);
					if ( (LA26_0==MINUS) ) {
						alt26=1;
					}
					switch (alt26) {
						case 1 :
							// CSSTreeParser.g:563:7: MINUS
							{
							match(input,MINUS,FOLLOW_MINUS_in_valuepart1269); 
							terms_stack.peek().unary =-1;
							}
							break;

					}

					n=(CommonTree)match(input,NUMBER,FOLLOW_NUMBER_in_valuepart1277); 
					terms_stack.peek().term = tf.createNumeric(extractText(n), terms_stack.peek().unary);
					}
					break;
				case 4 :
					// CSSTreeParser.g:564:7: ( MINUS )? p= PERCENTAGE
					{
					// CSSTreeParser.g:564:7: ( MINUS )?
					int alt27=2;
					int LA27_0 = input.LA(1);
					if ( (LA27_0==MINUS) ) {
						alt27=1;
					}
					switch (alt27) {
						case 1 :
							// CSSTreeParser.g:564:8: MINUS
							{
							match(input,MINUS,FOLLOW_MINUS_in_valuepart1291); 
							terms_stack.peek().unary =-1;
							}
							break;

					}

					p=(CommonTree)match(input,PERCENTAGE,FOLLOW_PERCENTAGE_in_valuepart1299); 
					 terms_stack.peek().term = tf.createPercent(extractText(p), terms_stack.peek().unary);
					}
					break;
				case 5 :
					// CSSTreeParser.g:565:7: ( MINUS )? d= DIMENSION
					{
					// CSSTreeParser.g:565:7: ( MINUS )?
					int alt28=2;
					int LA28_0 = input.LA(1);
					if ( (LA28_0==MINUS) ) {
						alt28=1;
					}
					switch (alt28) {
						case 1 :
							// CSSTreeParser.g:565:8: MINUS
							{
							match(input,MINUS,FOLLOW_MINUS_in_valuepart1311); 
							terms_stack.peek().unary =-1;
							}
							break;

					}

					d=(CommonTree)match(input,DIMENSION,FOLLOW_DIMENSION_in_valuepart1319); 
					String dim = extractText(d);
									 terms_stack.peek().term = tf.createDimension(dim, terms_stack.peek().unary);
								     if(terms_stack.peek().term==null) {
										 log.info("Unable to create dimension from {}, unary {}", dim, terms_stack.peek().unary);
								         declaration_stack.peek().invalid = true;
									 }
						    
					}
					break;
				case 6 :
					// CSSTreeParser.g:573:7: s= string
					{
					pushFollow(FOLLOW_string_in_valuepart1337);
					s=string();
					state._fsp--;

					 if(s!=null) terms_stack.peek().term = tf.createString(s);
								  else declaration_stack.peek().invalid =true;
								
					}
					break;
				case 7 :
					// CSSTreeParser.g:577:7: u= URI
					{
					u=(CommonTree)match(input,URI,FOLLOW_URI_in_valuepart1356); 
					terms_stack.peek().term = tf.createURI(extractTextUnescaped(u), extractBase(u));
					}
					break;
				case 8 :
					// CSSTreeParser.g:578:7: h= HASH
					{
					h=(CommonTree)match(input,HASH,FOLLOW_HASH_in_valuepart1374); 
					terms_stack.peek().term = tf.createColor(extractText(h));
						     if(terms_stack.peek().term==null)
						         declaration_stack.peek().invalid = true;
						    
					}
					break;
				case 9 :
					// CSSTreeParser.g:583:7: UNIRANGE
					{
					match(input,UNIRANGE,FOLLOW_UNIRANGE_in_valuepart1393); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 10 :
					// CSSTreeParser.g:584:7: INCLUDES
					{
					match(input,INCLUDES,FOLLOW_INCLUDES_in_valuepart1404); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 11 :
					// CSSTreeParser.g:585:7: COLON
					{
					match(input,COLON,FOLLOW_COLON_in_valuepart1415); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 12 :
					// CSSTreeParser.g:586:7: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_valuepart1429); 
					terms_stack.peek().op = cz.vutbr.web.css.Term.Operator.COMMA;
					}
					break;
				case 13 :
					// CSSTreeParser.g:587:7: GREATER
					{
					match(input,GREATER,FOLLOW_GREATER_in_valuepart1447); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 14 :
					// CSSTreeParser.g:588:7: LESS
					{
					match(input,LESS,FOLLOW_LESS_in_valuepart1459); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 15 :
					// CSSTreeParser.g:589:7: QUESTION
					{
					match(input,QUESTION,FOLLOW_QUESTION_in_valuepart1474); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 16 :
					// CSSTreeParser.g:590:7: PERCENT
					{
					match(input,PERCENT,FOLLOW_PERCENT_in_valuepart1485); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 17 :
					// CSSTreeParser.g:591:7: EQUALS
					{
					match(input,EQUALS,FOLLOW_EQUALS_in_valuepart1497); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 18 :
					// CSSTreeParser.g:592:7: SLASH
					{
					match(input,SLASH,FOLLOW_SLASH_in_valuepart1510); 
					terms_stack.peek().op = cz.vutbr.web.css.Term.Operator.SLASH;
					}
					break;
				case 19 :
					// CSSTreeParser.g:593:5: PLUS
					{
					match(input,PLUS,FOLLOW_PLUS_in_valuepart1522); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 20 :
					// CSSTreeParser.g:594:5: ASTERISK
					{
					match(input,ASTERISK,FOLLOW_ASTERISK_in_valuepart1533); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 21 :
					// CSSTreeParser.g:595:5: e= EXPRESSION
					{
					e=(CommonTree)match(input,EXPRESSION,FOLLOW_EXPRESSION_in_valuepart1544); 

							    String exprval = extractText(e);
					        cz.vutbr.web.css.TermExpression expr = tf.createExpression(exprval.substring(11,exprval.length()-1)); //strip the 'expression()'
					        terms_stack.peek().term = expr;
							
					}
					break;
				case 22 :
					// CSSTreeParser.g:600:7: ( MINUS )? ^(f= FUNCTION (t= terms )? )
					{
					// CSSTreeParser.g:600:7: ( MINUS )?
					int alt29=2;
					int LA29_0 = input.LA(1);
					if ( (LA29_0==MINUS) ) {
						alt29=1;
					}
					switch (alt29) {
						case 1 :
							// CSSTreeParser.g:600:8: MINUS
							{
							match(input,MINUS,FOLLOW_MINUS_in_valuepart1555); 
							terms_stack.peek().unary =-1;
							}
							break;

					}

					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_valuepart1564); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// CSSTreeParser.g:600:50: (t= terms )?
						int alt30=2;
						int LA30_0 = input.LA(1);
						if ( (LA30_0==VALUE) ) {
							alt30=1;
						}
						switch (alt30) {
							case 1 :
								// CSSTreeParser.g:600:50: t= terms
								{
								pushFollow(FOLLOW_terms_in_valuepart1568);
								t=terms();
								state._fsp--;

								}
								break;

						}

						match(input, Token.UP, null); 
					}


					        final String fname = extractTextUnescaped(f);
					        if (fname.equalsIgnoreCase("url"))
					        {
					          // the function name is url() after escaping - create an URI
					          if (terms_stack.peek().unary == -1 || t == null || t.size() != 1)
					            declaration_stack.peek().invalid = true;
					          else
					          {
					            cz.vutbr.web.css.Term<?> term = t.get(0);
					            if (term instanceof cz.vutbr.web.css.TermString) 
					              terms_stack.peek().term = tf.createURI(((cz.vutbr.web.css.TermString) term).getValue(), extractBase(f));
					            else
					              declaration_stack.peek().invalid = true;
					          }
					        }
					        else
					        {
						        // create function
						        cz.vutbr.web.css.TermFunction function = tf.createFunction();
						        function.setFunctionName(fname);
						        if (terms_stack.peek().unary == -1) //if started with minus, add the minus to the function name
						            function.setFunctionName('-' + function.getFunctionName());
						        if (t != null)
						        	function.setValue(t);
						        terms_stack.peek().term = function;
						      }
					    
					}
					break;
				case 23 :
					// CSSTreeParser.g:628:7: DASHMATCH
					{
					match(input,DASHMATCH,FOLLOW_DASHMATCH_in_valuepart1580); 
					declaration_stack.peek().invalid = true;
					}
					break;
				case 24 :
					// CSSTreeParser.g:629:7: ^( PARENBLOCK ( any )* )
					{
					match(input,PARENBLOCK,FOLLOW_PARENBLOCK_in_valuepart1591); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// CSSTreeParser.g:629:20: ( any )*
						loop31:
						while (true) {
							int alt31=2;
							int LA31_0 = input.LA(1);
							if ( (LA31_0==BRACEBLOCK||(LA31_0 >= CLASSKEYWORD && LA31_0 <= COMMA)||LA31_0==DASHMATCH||LA31_0==DIMENSION||LA31_0==EQUALS||LA31_0==EXCLAMATION||(LA31_0 >= FUNCTION && LA31_0 <= HASH)||LA31_0==IDENT||LA31_0==INCLUDES||LA31_0==INVALID_STRING||LA31_0==NUMBER||LA31_0==PARENBLOCK||LA31_0==PERCENTAGE||LA31_0==SLASH||LA31_0==STRING||(LA31_0 >= UNIRANGE && LA31_0 <= URI)) ) {
								alt31=1;
							}

							switch (alt31) {
							case 1 :
								// CSSTreeParser.g:629:20: any
								{
								pushFollow(FOLLOW_any_in_valuepart1593);
								any();
								state._fsp--;

								}
								break;

							default :
								break loop31;
							}
						}

						match(input, Token.UP, null); 
					}

					declaration_stack.peek().invalid = true;
					}
					break;
				case 25 :
					// CSSTreeParser.g:630:7: ^( BRACEBLOCK ( any )* )
					{
					match(input,BRACEBLOCK,FOLLOW_BRACEBLOCK_in_valuepart1606); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// CSSTreeParser.g:630:20: ( any )*
						loop32:
						while (true) {
							int alt32=2;
							int LA32_0 = input.LA(1);
							if ( (LA32_0==BRACEBLOCK||(LA32_0 >= CLASSKEYWORD && LA32_0 <= COMMA)||LA32_0==DASHMATCH||LA32_0==DIMENSION||LA32_0==EQUALS||LA32_0==EXCLAMATION||(LA32_0 >= FUNCTION && LA32_0 <= HASH)||LA32_0==IDENT||LA32_0==INCLUDES||LA32_0==INVALID_STRING||LA32_0==NUMBER||LA32_0==PARENBLOCK||LA32_0==PERCENTAGE||LA32_0==SLASH||LA32_0==STRING||(LA32_0 >= UNIRANGE && LA32_0 <= URI)) ) {
								alt32=1;
							}

							switch (alt32) {
							case 1 :
								// CSSTreeParser.g:630:20: any
								{
								pushFollow(FOLLOW_any_in_valuepart1608);
								any();
								state._fsp--;

								}
								break;

							default :
								break loop32;
							}
						}

						match(input, Token.UP, null); 
					}

					declaration_stack.peek().invalid = true;
					}
					break;

			}

			    // convert color
			    cz.vutbr.web.css.Term<?> term = terms_stack.peek().term;
			    if(term!=null) {
			        cz.vutbr.web.css.TermColor colorTerm = null;
			        if(term instanceof cz.vutbr.web.css.TermIdent) {
			            colorTerm = tf.createColor((cz.vutbr.web.css.TermIdent)term);
			            if (colorTerm != null)
			                term = colorTerm;
			        }
			        else if(term instanceof cz.vutbr.web.css.TermFunction) {
			            colorTerm = tf.createColor((cz.vutbr.web.css.TermFunction)term);
			            if(colorTerm != null)
			                term = colorTerm;
			        }
			        // replace with color
			        if(colorTerm!=null) {
			            terms_stack.peek().term = colorTerm;
			        }                    
			    }

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "valuepart"


	protected static class combined_selector_scope {
		boolean invalid;
	}
	protected Stack<combined_selector_scope> combined_selector_stack = new Stack<combined_selector_scope>();


	// $ANTLR start "combined_selector"
	// CSSTreeParser.g:636:1: combined_selector returns [cz.vutbr.web.css.CombinedSelector combinedSelector] : s= selector (c= combinator s= selector )* ;
	public final cz.vutbr.web.css.CombinedSelector combined_selector() throws RecognitionException {
		combined_selector_stack.push(new combined_selector_scope());
		cz.vutbr.web.css.CombinedSelector combinedSelector = null;


		cz.vutbr.web.css.Selector s =null;
		cz.vutbr.web.css.Selector.Combinator c =null;


			logEnter("combined_selector");	  
			combinedSelector = (cz.vutbr.web.css.CombinedSelector) rf.createCombinedSelector().unlock();

		try {
			// CSSTreeParser.g:663:2: (s= selector (c= combinator s= selector )* )
			// CSSTreeParser.g:663:4: s= selector (c= combinator s= selector )*
			{
			pushFollow(FOLLOW_selector_in_combined_selector1656);
			s=selector();
			state._fsp--;


				     combinedSelector.add(s);
				  
			// CSSTreeParser.g:666:3: (c= combinator s= selector )*
			loop34:
			while (true) {
				int alt34=2;
				int LA34_0 = input.LA(1);
				if ( (LA34_0==ADJACENT||LA34_0==CHILD||LA34_0==DESCENDANT||LA34_0==PRECEDING) ) {
					alt34=1;
				}

				switch (alt34) {
				case 1 :
					// CSSTreeParser.g:666:4: c= combinator s= selector
					{
					pushFollow(FOLLOW_combinator_in_combined_selector1665);
					c=combinator();
					state._fsp--;

					pushFollow(FOLLOW_selector_in_combined_selector1669);
					s=selector();
					state._fsp--;


						     s.setCombinator(c);
						     combinedSelector.add(s);	
						  
					}
					break;

				default :
					break loop34;
				}
			}

			}

			  
			    // entire ruleset is not valid when selector is not valid
			    // there is no need to parse selector's when already marked as invalid
			    if(statement_stack.peek().invalid || combined_selector_stack.peek().invalid) {        
			        combinedSelector = null;
			        if(statement_stack.peek().invalid) { 
						log.debug("Ommiting combined selector, whole statement discarded");
					}	
			        else { 
						log.debug("Combined selector is invalid");               
			        }
					// mark whole ruleset as invalid
			        statement_stack.peek().invalid = true;
			    }
			    else {
			        log.debug("Returing combined selector: {}.", combinedSelector); 
			    }
			    logLeave("combined_selector"); 

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			combined_selector_stack.pop();
		}
		return combinedSelector;
	}
	// $ANTLR end "combined_selector"



	// $ANTLR start "combinator"
	// CSSTreeParser.g:673:1: combinator returns [cz.vutbr.web.css.Selector.Combinator combinator] : ( CHILD | ADJACENT | PRECEDING | DESCENDANT );
	public final cz.vutbr.web.css.Selector.Combinator combinator() throws RecognitionException {
		cz.vutbr.web.css.Selector.Combinator combinator = null;


		 logEnter("combinator"); 
		try {
			// CSSTreeParser.g:676:2: ( CHILD | ADJACENT | PRECEDING | DESCENDANT )
			int alt35=4;
			switch ( input.LA(1) ) {
			case CHILD:
				{
				alt35=1;
				}
				break;
			case ADJACENT:
				{
				alt35=2;
				}
				break;
			case PRECEDING:
				{
				alt35=3;
				}
				break;
			case DESCENDANT:
				{
				alt35=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 35, 0, input);
				throw nvae;
			}
			switch (alt35) {
				case 1 :
					// CSSTreeParser.g:676:4: CHILD
					{
					match(input,CHILD,FOLLOW_CHILD_in_combinator1699); 
					combinator =cz.vutbr.web.css.Selector.Combinator.CHILD;
					}
					break;
				case 2 :
					// CSSTreeParser.g:677:4: ADJACENT
					{
					match(input,ADJACENT,FOLLOW_ADJACENT_in_combinator1706); 
					combinator =cz.vutbr.web.css.Selector.Combinator.ADJACENT;
					}
					break;
				case 3 :
					// CSSTreeParser.g:678:5: PRECEDING
					{
					match(input,PRECEDING,FOLLOW_PRECEDING_in_combinator1714); 
					combinator =cz.vutbr.web.css.Selector.Combinator.PRECEDING;
					}
					break;
				case 4 :
					// CSSTreeParser.g:679:4: DESCENDANT
					{
					match(input,DESCENDANT,FOLLOW_DESCENDANT_in_combinator1721); 
					combinator =cz.vutbr.web.css.Selector.Combinator.DESCENDANT;
					}
					break;

			}
			 logLeave("combinator"); 
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return combinator;
	}
	// $ANTLR end "combinator"


	protected static class selector_scope {
		cz.vutbr.web.css.Selector s;
	}
	protected Stack<selector_scope> selector_stack = new Stack<selector_scope>();


	// $ANTLR start "selector"
	// CSSTreeParser.g:683:1: selector returns [cz.vutbr.web.css.Selector sel] : ( ^( SELECTOR ^( ELEMENT (i= IDENT )? ) ( selpart )* ) | ^( SELECTOR ( selpart )+ ) | INVALID_SELECTOR );
	public final cz.vutbr.web.css.Selector selector() throws RecognitionException {
		selector_stack.push(new selector_scope());
		cz.vutbr.web.css.Selector sel = null;


		CommonTree i=null;


			logEnter("selector");
			selector_stack.peek().s =sel=(cz.vutbr.web.css.Selector)rf.createSelector().unlock();
			cz.vutbr.web.css.Selector.ElementName en = rf.createElement(cz.vutbr.web.css.Selector.ElementName.WILDCARD);

		try {
			// CSSTreeParser.g:695:5: ( ^( SELECTOR ^( ELEMENT (i= IDENT )? ) ( selpart )* ) | ^( SELECTOR ( selpart )+ ) | INVALID_SELECTOR )
			int alt39=3;
			int LA39_0 = input.LA(1);
			if ( (LA39_0==SELECTOR) ) {
				int LA39_1 = input.LA(2);
				if ( (LA39_1==DOWN) ) {
					int LA39_3 = input.LA(3);
					if ( (LA39_3==ELEMENT) ) {
						alt39=1;
					}
					else if ( (LA39_3==ATTRIBUTE||LA39_3==CLASSKEYWORD||LA39_3==HASH||LA39_3==INVALID_SELPART||(LA39_3 >= PSEUDOCLASS && LA39_3 <= PSEUDOELEM)) ) {
						alt39=2;
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 39, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 39, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA39_0==INVALID_SELECTOR) ) {
				alt39=3;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}

			switch (alt39) {
				case 1 :
					// CSSTreeParser.g:695:7: ^( SELECTOR ^( ELEMENT (i= IDENT )? ) ( selpart )* )
					{
					match(input,SELECTOR,FOLLOW_SELECTOR_in_selector1757); 
					match(input, Token.DOWN, null); 
					match(input,ELEMENT,FOLLOW_ELEMENT_in_selector1769); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// CSSTreeParser.g:697:11: (i= IDENT )?
						int alt36=2;
						int LA36_0 = input.LA(1);
						if ( (LA36_0==IDENT) ) {
							alt36=1;
						}
						switch (alt36) {
							case 1 :
								// CSSTreeParser.g:697:12: i= IDENT
								{
								i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_selector1785); 
								 en.setName(extractTextUnescaped(i)); 
								}
								break;

						}

						match(input, Token.UP, null); 
					}


							  log.debug("Adding element name: {}.", en.getName());
							  selector_stack.peek().s.add(en);
							 
					// CSSTreeParser.g:703:10: ( selpart )*
					loop37:
					while (true) {
						int alt37=2;
						int LA37_0 = input.LA(1);
						if ( (LA37_0==ATTRIBUTE||LA37_0==CLASSKEYWORD||LA37_0==HASH||LA37_0==INVALID_SELPART||(LA37_0 >= PSEUDOCLASS && LA37_0 <= PSEUDOELEM)) ) {
							alt37=1;
						}

						switch (alt37) {
						case 1 :
							// CSSTreeParser.g:703:10: selpart
							{
							pushFollow(FOLLOW_selpart_in_selector1832);
							selpart();
							state._fsp--;

							}
							break;

						default :
							break loop37;
						}
					}

					match(input, Token.UP, null); 

					}
					break;
				case 2 :
					// CSSTreeParser.g:705:7: ^( SELECTOR ( selpart )+ )
					{
					match(input,SELECTOR,FOLLOW_SELECTOR_in_selector1851); 
					match(input, Token.DOWN, null); 
					// CSSTreeParser.g:706:10: ( selpart )+
					int cnt38=0;
					loop38:
					while (true) {
						int alt38=2;
						int LA38_0 = input.LA(1);
						if ( (LA38_0==ATTRIBUTE||LA38_0==CLASSKEYWORD||LA38_0==HASH||LA38_0==INVALID_SELPART||(LA38_0 >= PSEUDOCLASS && LA38_0 <= PSEUDOELEM)) ) {
							alt38=1;
						}

						switch (alt38) {
						case 1 :
							// CSSTreeParser.g:706:10: selpart
							{
							pushFollow(FOLLOW_selpart_in_selector1863);
							selpart();
							state._fsp--;

							}
							break;

						default :
							if ( cnt38 >= 1 ) break loop38;
							EarlyExitException eee = new EarlyExitException(38, input);
							throw eee;
						}
						cnt38++;
					}

					match(input, Token.UP, null); 

					}
					break;
				case 3 :
					// CSSTreeParser.g:708:7: INVALID_SELECTOR
					{
					match(input,INVALID_SELECTOR,FOLLOW_INVALID_SELECTOR_in_selector1881); 
					 statement_stack.peek().invalid = true; 
					}
					break;

			}

				logLeave("selector");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
			selector_stack.pop();
		}
		return sel;
	}
	// $ANTLR end "selector"



	// $ANTLR start "selpart"
	// CSSTreeParser.g:711:1: selpart : (h= HASH |c= CLASSKEYWORD | ^( ATTRIBUTE ea= attribute ) |p= pseudo | INVALID_SELPART );
	public final void selpart() throws RecognitionException {
		CommonTree h=null;
		CommonTree c=null;
		cz.vutbr.web.css.Selector.ElementAttribute ea =null;
		cz.vutbr.web.css.Selector.PseudoPage p =null;


			logEnter("selpart");
			String ident = null;

		try {
			// CSSTreeParser.g:719:5: (h= HASH |c= CLASSKEYWORD | ^( ATTRIBUTE ea= attribute ) |p= pseudo | INVALID_SELPART )
			int alt40=5;
			switch ( input.LA(1) ) {
			case HASH:
				{
				alt40=1;
				}
				break;
			case CLASSKEYWORD:
				{
				alt40=2;
				}
				break;
			case ATTRIBUTE:
				{
				alt40=3;
				}
				break;
			case PSEUDOCLASS:
			case PSEUDOELEM:
				{
				alt40=4;
				}
				break;
			case INVALID_SELPART:
				{
				alt40=5;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}
			switch (alt40) {
				case 1 :
					// CSSTreeParser.g:719:8: h= HASH
					{
					h=(CommonTree)match(input,HASH,FOLLOW_HASH_in_selpart1915); 

					          ident = extractIdUnescaped(h);
					          if (ident != null)
					            selector_stack.peek().s.add(rf.createID(ident));
					          else
					            combined_selector_stack.peek().invalid = true;
					       
					}
					break;
				case 2 :
					// CSSTreeParser.g:726:7: c= CLASSKEYWORD
					{
					c=(CommonTree)match(input,CLASSKEYWORD,FOLLOW_CLASSKEYWORD_in_selpart1927); 
					 selector_stack.peek().s.add(rf.createClass(extractTextUnescaped(c))); 
					}
					break;
				case 3 :
					// CSSTreeParser.g:727:4: ^( ATTRIBUTE ea= attribute )
					{
					match(input,ATTRIBUTE,FOLLOW_ATTRIBUTE_in_selpart1935); 
					match(input, Token.DOWN, null); 
					pushFollow(FOLLOW_attribute_in_selpart1939);
					ea=attribute();
					state._fsp--;

					 selector_stack.peek().s.add(ea);
					match(input, Token.UP, null); 

					}
					break;
				case 4 :
					// CSSTreeParser.g:728:7: p= pseudo
					{
					pushFollow(FOLLOW_pseudo_in_selpart1953);
					p=pseudo();
					state._fsp--;


					        if (p != null)
					          selector_stack.peek().s.add(p);
					        else
					          combined_selector_stack.peek().invalid = true;
					      
					}
					break;
				case 5 :
					// CSSTreeParser.g:734:4: INVALID_SELPART
					{
					match(input,INVALID_SELPART,FOLLOW_INVALID_SELPART_in_selpart1960); 
					 combined_selector_stack.peek().invalid = true;
					}
					break;

			}

			    logLeave("selpart");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "selpart"



	// $ANTLR start "attribute"
	// CSSTreeParser.g:737:1: attribute returns [cz.vutbr.web.css.Selector.ElementAttribute elemAttr] : i= IDENT ( ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH ) (i= IDENT |s= string ) )? ;
	public final cz.vutbr.web.css.Selector.ElementAttribute attribute() throws RecognitionException {
		cz.vutbr.web.css.Selector.ElementAttribute elemAttr = null;


		CommonTree i=null;
		String s =null;


		    logEnter("attribute");
		    String attribute = null;
			String value = null;
			cz.vutbr.web.css.Selector.Operator op = cz.vutbr.web.css.Selector.Operator.NO_OPERATOR;
			boolean isStringValue = false;

		try {
			// CSSTreeParser.g:755:2: (i= IDENT ( ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH ) (i= IDENT |s= string ) )? )
			// CSSTreeParser.g:755:4: i= IDENT ( ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH ) (i= IDENT |s= string ) )?
			{
			i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_attribute1994); 
			attribute=extractTextUnescaped(i); 
			// CSSTreeParser.g:756:4: ( ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH ) (i= IDENT |s= string ) )?
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==CONTAINS||LA43_0==DASHMATCH||(LA43_0 >= ENDSWITH && LA43_0 <= EQUALS)||LA43_0==INCLUDES||LA43_0==STARTSWITH) ) {
				alt43=1;
			}
			switch (alt43) {
				case 1 :
					// CSSTreeParser.g:756:5: ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH ) (i= IDENT |s= string )
					{
					// CSSTreeParser.g:756:5: ( EQUALS | INCLUDES | DASHMATCH | CONTAINS | STARTSWITH | ENDSWITH )
					int alt41=6;
					switch ( input.LA(1) ) {
					case EQUALS:
						{
						alt41=1;
						}
						break;
					case INCLUDES:
						{
						alt41=2;
						}
						break;
					case DASHMATCH:
						{
						alt41=3;
						}
						break;
					case CONTAINS:
						{
						alt41=4;
						}
						break;
					case STARTSWITH:
						{
						alt41=5;
						}
						break;
					case ENDSWITH:
						{
						alt41=6;
						}
						break;
					default:
						NoViableAltException nvae =
							new NoViableAltException("", 41, 0, input);
						throw nvae;
					}
					switch (alt41) {
						case 1 :
							// CSSTreeParser.g:756:6: EQUALS
							{
							match(input,EQUALS,FOLLOW_EQUALS_in_attribute2003); 
							op=cz.vutbr.web.css.Selector.Operator.EQUALS; 
							}
							break;
						case 2 :
							// CSSTreeParser.g:757:7: INCLUDES
							{
							match(input,INCLUDES,FOLLOW_INCLUDES_in_attribute2014); 
							op=cz.vutbr.web.css.Selector.Operator.INCLUDES; 
							}
							break;
						case 3 :
							// CSSTreeParser.g:758:7: DASHMATCH
							{
							match(input,DASHMATCH,FOLLOW_DASHMATCH_in_attribute2025); 
							op=cz.vutbr.web.css.Selector.Operator.DASHMATCH; 
							}
							break;
						case 4 :
							// CSSTreeParser.g:759:8: CONTAINS
							{
							match(input,CONTAINS,FOLLOW_CONTAINS_in_attribute2036); 
							op=cz.vutbr.web.css.Selector.Operator.CONTAINS; 
							}
							break;
						case 5 :
							// CSSTreeParser.g:760:8: STARTSWITH
							{
							match(input,STARTSWITH,FOLLOW_STARTSWITH_in_attribute2047); 
							op=cz.vutbr.web.css.Selector.Operator.STARTSWITH; 
							}
							break;
						case 6 :
							// CSSTreeParser.g:761:8: ENDSWITH
							{
							match(input,ENDSWITH,FOLLOW_ENDSWITH_in_attribute2058); 
							op=cz.vutbr.web.css.Selector.Operator.ENDSWITH; 
							}
							break;

					}

					// CSSTreeParser.g:763:5: (i= IDENT |s= string )
					int alt42=2;
					int LA42_0 = input.LA(1);
					if ( (LA42_0==IDENT) ) {
						alt42=1;
					}
					else if ( (LA42_0==INVALID_STRING||LA42_0==STRING) ) {
						alt42=2;
					}

					else {
						NoViableAltException nvae =
							new NoViableAltException("", 42, 0, input);
						throw nvae;
					}

					switch (alt42) {
						case 1 :
							// CSSTreeParser.g:763:6: i= IDENT
							{
							i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_attribute2076); 

									value=extractTextUnescaped(i);
									isStringValue=false;
									
							}
							break;
						case 2 :
							// CSSTreeParser.g:767:7: s= string
							{
							pushFollow(FOLLOW_string_in_attribute2088);
							s=string();
							state._fsp--;


									 if(s!=null)  { 
										value=s;
										isStringValue=true;
									 }	
									 else {
										combined_selector_stack.peek().invalid =true;
									 }
									
							}
							break;

					}

					}
					break;

			}

			}


			    if(attribute!=null) {
					elemAttr = rf.createAttribute(value, isStringValue, op, attribute);
				}
				else {
				    log.debug("Invalid attribute element in selector");
				    combined_selector_stack.peek().invalid = true;
				}
			    logLeave("attribute");

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return elemAttr;
	}
	// $ANTLR end "attribute"



	// $ANTLR start "pseudo"
	// CSSTreeParser.g:779:1: pseudo returns [cz.vutbr.web.css.Selector.PseudoPage pseudoPage] : ( ^( PSEUDOCLASS i= IDENT ) | ^( PSEUDOCLASS f= FUNCTION i= IDENT ) | ^( PSEUDOCLASS f= FUNCTION (m= MINUS )? n= NUMBER ) | ^( PSEUDOCLASS f= FUNCTION (m= MINUS )? n= INDEX ) | ^( PSEUDOELEM i= IDENT ) | ^( PSEUDOELEM f= FUNCTION i= IDENT ) | ^( PSEUDOELEM f= FUNCTION (m= MINUS )? n= NUMBER ) | ^( PSEUDOELEM f= FUNCTION (m= MINUS )? n= INDEX ) );
	public final cz.vutbr.web.css.Selector.PseudoPage pseudo() throws RecognitionException {
		cz.vutbr.web.css.Selector.PseudoPage pseudoPage = null;


		CommonTree i=null;
		CommonTree f=null;
		CommonTree m=null;
		CommonTree n=null;


				logEnter("pseudo");

		try {
			// CSSTreeParser.g:784:2: ( ^( PSEUDOCLASS i= IDENT ) | ^( PSEUDOCLASS f= FUNCTION i= IDENT ) | ^( PSEUDOCLASS f= FUNCTION (m= MINUS )? n= NUMBER ) | ^( PSEUDOCLASS f= FUNCTION (m= MINUS )? n= INDEX ) | ^( PSEUDOELEM i= IDENT ) | ^( PSEUDOELEM f= FUNCTION i= IDENT ) | ^( PSEUDOELEM f= FUNCTION (m= MINUS )? n= NUMBER ) | ^( PSEUDOELEM f= FUNCTION (m= MINUS )? n= INDEX ) )
			int alt48=8;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==PSEUDOCLASS) ) {
				int LA48_1 = input.LA(2);
				if ( (LA48_1==DOWN) ) {
					int LA48_3 = input.LA(3);
					if ( (LA48_3==IDENT) ) {
						alt48=1;
					}
					else if ( (LA48_3==FUNCTION) ) {
						switch ( input.LA(4) ) {
						case IDENT:
							{
							alt48=2;
							}
							break;
						case MINUS:
							{
							int LA48_10 = input.LA(5);
							if ( (LA48_10==NUMBER) ) {
								alt48=3;
							}
							else if ( (LA48_10==INDEX) ) {
								alt48=4;
							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 48, 10, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

							}
							break;
						case NUMBER:
							{
							alt48=3;
							}
							break;
						case INDEX:
							{
							alt48=4;
							}
							break;
						default:
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 48, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 48, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 48, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA48_0==PSEUDOELEM) ) {
				int LA48_2 = input.LA(2);
				if ( (LA48_2==DOWN) ) {
					int LA48_4 = input.LA(3);
					if ( (LA48_4==IDENT) ) {
						alt48=5;
					}
					else if ( (LA48_4==FUNCTION) ) {
						switch ( input.LA(4) ) {
						case IDENT:
							{
							alt48=6;
							}
							break;
						case MINUS:
							{
							int LA48_14 = input.LA(5);
							if ( (LA48_14==NUMBER) ) {
								alt48=7;
							}
							else if ( (LA48_14==INDEX) ) {
								alt48=8;
							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 48, 14, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

							}
							break;
						case NUMBER:
							{
							alt48=7;
							}
							break;
						case INDEX:
							{
							alt48=8;
							}
							break;
						default:
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 48, 8, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}
					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 48, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

				}

				else {
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 48, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 48, 0, input);
				throw nvae;
			}

			switch (alt48) {
				case 1 :
					// CSSTreeParser.g:784:4: ^( PSEUDOCLASS i= IDENT )
					{
					match(input,PSEUDOCLASS,FOLLOW_PSEUDOCLASS_in_pseudo2125); 
					match(input, Token.DOWN, null); 
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_pseudo2129); 
					match(input, Token.UP, null); 


								pseudoPage = rf.createPseudoPage(extractTextUnescaped(i), null);
							
					}
					break;
				case 2 :
					// CSSTreeParser.g:788:4: ^( PSEUDOCLASS f= FUNCTION i= IDENT )
					{
					match(input,PSEUDOCLASS,FOLLOW_PSEUDOCLASS_in_pseudo2140); 
					match(input, Token.DOWN, null); 
					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_pseudo2144); 
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_pseudo2148); 
					match(input, Token.UP, null); 


								pseudoPage = rf.createPseudoPage(extractTextUnescaped(i), extractTextUnescaped(f));
							
					}
					break;
				case 3 :
					// CSSTreeParser.g:792:4: ^( PSEUDOCLASS f= FUNCTION (m= MINUS )? n= NUMBER )
					{
					match(input,PSEUDOCLASS,FOLLOW_PSEUDOCLASS_in_pseudo2159); 
					match(input, Token.DOWN, null); 
					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_pseudo2163); 
					// CSSTreeParser.g:792:30: (m= MINUS )?
					int alt44=2;
					int LA44_0 = input.LA(1);
					if ( (LA44_0==MINUS) ) {
						alt44=1;
					}
					switch (alt44) {
						case 1 :
							// CSSTreeParser.g:792:30: m= MINUS
							{
							m=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_pseudo2167); 
							}
							break;

					}

					n=(CommonTree)match(input,NUMBER,FOLLOW_NUMBER_in_pseudo2172); 
					match(input, Token.UP, null); 


					      String exp = extractText(n);
					      if (m != null) exp = "-" + exp;
								pseudoPage = rf.createPseudoPage(exp, extractTextUnescaped(f));
							
					}
					break;
				case 4 :
					// CSSTreeParser.g:798:5: ^( PSEUDOCLASS f= FUNCTION (m= MINUS )? n= INDEX )
					{
					match(input,PSEUDOCLASS,FOLLOW_PSEUDOCLASS_in_pseudo2184); 
					match(input, Token.DOWN, null); 
					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_pseudo2188); 
					// CSSTreeParser.g:798:31: (m= MINUS )?
					int alt45=2;
					int LA45_0 = input.LA(1);
					if ( (LA45_0==MINUS) ) {
						alt45=1;
					}
					switch (alt45) {
						case 1 :
							// CSSTreeParser.g:798:31: m= MINUS
							{
							m=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_pseudo2192); 
							}
							break;

					}

					n=(CommonTree)match(input,INDEX,FOLLOW_INDEX_in_pseudo2197); 
					match(input, Token.UP, null); 


					      String exp = extractText(n);
					      if (m != null) exp = "-" + exp;
					      pseudoPage = rf.createPseudoPage(exp, extractTextUnescaped(f));
					    
					}
					break;
				case 5 :
					// CSSTreeParser.g:805:5: ^( PSEUDOELEM i= IDENT )
					{
					match(input,PSEUDOELEM,FOLLOW_PSEUDOELEM_in_pseudo2215); 
					match(input, Token.DOWN, null); 
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_pseudo2219); 
					match(input, Token.UP, null); 


					      pseudoPage = rf.createPseudoPage(extractTextUnescaped(i), null);
					      if (pseudoPage == null || pseudoPage.getDeclaration() == null)
					      {
					          log.error("invalid pseudo declaration: " + extractTextUnescaped(i));
					          pseudoPage = null;
					      }
					      else if (!pseudoPage.getDeclaration().isPseudoElement())
					      {
					          log.error("pseudo class cannot be used as pseudo element");
					          pseudoPage = null; /* pseudoClasses are not allowed here */
					      }
					    
					}
					break;
				case 6 :
					// CSSTreeParser.g:819:5: ^( PSEUDOELEM f= FUNCTION i= IDENT )
					{
					match(input,PSEUDOELEM,FOLLOW_PSEUDOELEM_in_pseudo2233); 
					match(input, Token.DOWN, null); 
					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_pseudo2237); 
					i=(CommonTree)match(input,IDENT,FOLLOW_IDENT_in_pseudo2241); 
					match(input, Token.UP, null); 


					      log.error("pseudo element cannot be used as a function");
					      pseudoPage = null; /* not allowed */
					    
					}
					break;
				case 7 :
					// CSSTreeParser.g:824:5: ^( PSEUDOELEM f= FUNCTION (m= MINUS )? n= NUMBER )
					{
					match(input,PSEUDOELEM,FOLLOW_PSEUDOELEM_in_pseudo2255); 
					match(input, Token.DOWN, null); 
					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_pseudo2259); 
					// CSSTreeParser.g:824:30: (m= MINUS )?
					int alt46=2;
					int LA46_0 = input.LA(1);
					if ( (LA46_0==MINUS) ) {
						alt46=1;
					}
					switch (alt46) {
						case 1 :
							// CSSTreeParser.g:824:30: m= MINUS
							{
							m=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_pseudo2263); 
							}
							break;

					}

					n=(CommonTree)match(input,NUMBER,FOLLOW_NUMBER_in_pseudo2268); 
					match(input, Token.UP, null); 


					      log.error("pseudo element cannot be used as a function");
					      pseudoPage = null; /* not allowed */
					    
					}
					break;
				case 8 :
					// CSSTreeParser.g:829:5: ^( PSEUDOELEM f= FUNCTION (m= MINUS )? n= INDEX )
					{
					match(input,PSEUDOELEM,FOLLOW_PSEUDOELEM_in_pseudo2282); 
					match(input, Token.DOWN, null); 
					f=(CommonTree)match(input,FUNCTION,FOLLOW_FUNCTION_in_pseudo2286); 
					// CSSTreeParser.g:829:30: (m= MINUS )?
					int alt47=2;
					int LA47_0 = input.LA(1);
					if ( (LA47_0==MINUS) ) {
						alt47=1;
					}
					switch (alt47) {
						case 1 :
							// CSSTreeParser.g:829:30: m= MINUS
							{
							m=(CommonTree)match(input,MINUS,FOLLOW_MINUS_in_pseudo2290); 
							}
							break;

					}

					n=(CommonTree)match(input,INDEX,FOLLOW_INDEX_in_pseudo2295); 
					match(input, Token.UP, null); 


					      log.error("pseudo element cannot be used as a function");
					      pseudoPage = null; /* not allowed */
					    
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return pseudoPage;
	}
	// $ANTLR end "pseudo"



	// $ANTLR start "string"
	// CSSTreeParser.g:836:1: string returns [String s] : (st= STRING | INVALID_STRING );
	public final String string() throws RecognitionException {
		String s = null;


		CommonTree st=null;

		try {
			// CSSTreeParser.g:837:2: (st= STRING | INVALID_STRING )
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==STRING) ) {
				alt49=1;
			}
			else if ( (LA49_0==INVALID_STRING) ) {
				alt49=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 49, 0, input);
				throw nvae;
			}

			switch (alt49) {
				case 1 :
					// CSSTreeParser.g:837:4: st= STRING
					{
					st=(CommonTree)match(input,STRING,FOLLOW_STRING_in_string2319); 
					 s =extractTextUnescaped(st);
					}
					break;
				case 2 :
					// CSSTreeParser.g:838:4: INVALID_STRING
					{
					match(input,INVALID_STRING,FOLLOW_INVALID_STRING_in_string2326); 
					s =null;
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return s;
	}
	// $ANTLR end "string"



	// $ANTLR start "any"
	// CSSTreeParser.g:841:1: any : ( IDENT | CLASSKEYWORD | NUMBER | PERCENTAGE | DIMENSION | string | URI | HASH | UNIRANGE | INCLUDES | COLON | COMMA | GREATER | EQUALS | SLASH | EXCLAMATION | ^( FUNCTION ( any )* ) | DASHMATCH | ^( PARENBLOCK ( any )* ) | ^( BRACEBLOCK ( any )* ) );
	public final void any() throws RecognitionException {
		try {
			// CSSTreeParser.g:842:3: ( IDENT | CLASSKEYWORD | NUMBER | PERCENTAGE | DIMENSION | string | URI | HASH | UNIRANGE | INCLUDES | COLON | COMMA | GREATER | EQUALS | SLASH | EXCLAMATION | ^( FUNCTION ( any )* ) | DASHMATCH | ^( PARENBLOCK ( any )* ) | ^( BRACEBLOCK ( any )* ) )
			int alt53=20;
			switch ( input.LA(1) ) {
			case IDENT:
				{
				alt53=1;
				}
				break;
			case CLASSKEYWORD:
				{
				alt53=2;
				}
				break;
			case NUMBER:
				{
				alt53=3;
				}
				break;
			case PERCENTAGE:
				{
				alt53=4;
				}
				break;
			case DIMENSION:
				{
				alt53=5;
				}
				break;
			case INVALID_STRING:
			case STRING:
				{
				alt53=6;
				}
				break;
			case URI:
				{
				alt53=7;
				}
				break;
			case HASH:
				{
				alt53=8;
				}
				break;
			case UNIRANGE:
				{
				alt53=9;
				}
				break;
			case INCLUDES:
				{
				alt53=10;
				}
				break;
			case COLON:
				{
				alt53=11;
				}
				break;
			case COMMA:
				{
				alt53=12;
				}
				break;
			case GREATER:
				{
				alt53=13;
				}
				break;
			case EQUALS:
				{
				alt53=14;
				}
				break;
			case SLASH:
				{
				alt53=15;
				}
				break;
			case EXCLAMATION:
				{
				alt53=16;
				}
				break;
			case FUNCTION:
				{
				alt53=17;
				}
				break;
			case DASHMATCH:
				{
				alt53=18;
				}
				break;
			case PARENBLOCK:
				{
				alt53=19;
				}
				break;
			case BRACEBLOCK:
				{
				alt53=20;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 53, 0, input);
				throw nvae;
			}
			switch (alt53) {
				case 1 :
					// CSSTreeParser.g:842:5: IDENT
					{
					match(input,IDENT,FOLLOW_IDENT_in_any2342); 
					}
					break;
				case 2 :
					// CSSTreeParser.g:843:5: CLASSKEYWORD
					{
					match(input,CLASSKEYWORD,FOLLOW_CLASSKEYWORD_in_any2348); 
					}
					break;
				case 3 :
					// CSSTreeParser.g:844:5: NUMBER
					{
					match(input,NUMBER,FOLLOW_NUMBER_in_any2354); 
					}
					break;
				case 4 :
					// CSSTreeParser.g:845:5: PERCENTAGE
					{
					match(input,PERCENTAGE,FOLLOW_PERCENTAGE_in_any2360); 
					}
					break;
				case 5 :
					// CSSTreeParser.g:846:5: DIMENSION
					{
					match(input,DIMENSION,FOLLOW_DIMENSION_in_any2366); 
					}
					break;
				case 6 :
					// CSSTreeParser.g:847:5: string
					{
					pushFollow(FOLLOW_string_in_any2372);
					string();
					state._fsp--;

					}
					break;
				case 7 :
					// CSSTreeParser.g:848:5: URI
					{
					match(input,URI,FOLLOW_URI_in_any2378); 
					}
					break;
				case 8 :
					// CSSTreeParser.g:849:5: HASH
					{
					match(input,HASH,FOLLOW_HASH_in_any2384); 
					}
					break;
				case 9 :
					// CSSTreeParser.g:850:5: UNIRANGE
					{
					match(input,UNIRANGE,FOLLOW_UNIRANGE_in_any2390); 
					}
					break;
				case 10 :
					// CSSTreeParser.g:851:5: INCLUDES
					{
					match(input,INCLUDES,FOLLOW_INCLUDES_in_any2396); 
					}
					break;
				case 11 :
					// CSSTreeParser.g:852:5: COLON
					{
					match(input,COLON,FOLLOW_COLON_in_any2402); 
					}
					break;
				case 12 :
					// CSSTreeParser.g:853:5: COMMA
					{
					match(input,COMMA,FOLLOW_COMMA_in_any2408); 
					}
					break;
				case 13 :
					// CSSTreeParser.g:854:5: GREATER
					{
					match(input,GREATER,FOLLOW_GREATER_in_any2414); 
					}
					break;
				case 14 :
					// CSSTreeParser.g:855:5: EQUALS
					{
					match(input,EQUALS,FOLLOW_EQUALS_in_any2420); 
					}
					break;
				case 15 :
					// CSSTreeParser.g:856:5: SLASH
					{
					match(input,SLASH,FOLLOW_SLASH_in_any2426); 
					}
					break;
				case 16 :
					// CSSTreeParser.g:857:5: EXCLAMATION
					{
					match(input,EXCLAMATION,FOLLOW_EXCLAMATION_in_any2432); 
					}
					break;
				case 17 :
					// CSSTreeParser.g:858:5: ^( FUNCTION ( any )* )
					{
					match(input,FUNCTION,FOLLOW_FUNCTION_in_any2439); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// CSSTreeParser.g:858:16: ( any )*
						loop50:
						while (true) {
							int alt50=2;
							int LA50_0 = input.LA(1);
							if ( (LA50_0==BRACEBLOCK||(LA50_0 >= CLASSKEYWORD && LA50_0 <= COMMA)||LA50_0==DASHMATCH||LA50_0==DIMENSION||LA50_0==EQUALS||LA50_0==EXCLAMATION||(LA50_0 >= FUNCTION && LA50_0 <= HASH)||LA50_0==IDENT||LA50_0==INCLUDES||LA50_0==INVALID_STRING||LA50_0==NUMBER||LA50_0==PARENBLOCK||LA50_0==PERCENTAGE||LA50_0==SLASH||LA50_0==STRING||(LA50_0 >= UNIRANGE && LA50_0 <= URI)) ) {
								alt50=1;
							}

							switch (alt50) {
							case 1 :
								// CSSTreeParser.g:858:16: any
								{
								pushFollow(FOLLOW_any_in_any2441);
								any();
								state._fsp--;

								}
								break;

							default :
								break loop50;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;
				case 18 :
					// CSSTreeParser.g:859:5: DASHMATCH
					{
					match(input,DASHMATCH,FOLLOW_DASHMATCH_in_any2450); 
					}
					break;
				case 19 :
					// CSSTreeParser.g:860:5: ^( PARENBLOCK ( any )* )
					{
					match(input,PARENBLOCK,FOLLOW_PARENBLOCK_in_any2457); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// CSSTreeParser.g:860:18: ( any )*
						loop51:
						while (true) {
							int alt51=2;
							int LA51_0 = input.LA(1);
							if ( (LA51_0==BRACEBLOCK||(LA51_0 >= CLASSKEYWORD && LA51_0 <= COMMA)||LA51_0==DASHMATCH||LA51_0==DIMENSION||LA51_0==EQUALS||LA51_0==EXCLAMATION||(LA51_0 >= FUNCTION && LA51_0 <= HASH)||LA51_0==IDENT||LA51_0==INCLUDES||LA51_0==INVALID_STRING||LA51_0==NUMBER||LA51_0==PARENBLOCK||LA51_0==PERCENTAGE||LA51_0==SLASH||LA51_0==STRING||(LA51_0 >= UNIRANGE && LA51_0 <= URI)) ) {
								alt51=1;
							}

							switch (alt51) {
							case 1 :
								// CSSTreeParser.g:860:18: any
								{
								pushFollow(FOLLOW_any_in_any2459);
								any();
								state._fsp--;

								}
								break;

							default :
								break loop51;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;
				case 20 :
					// CSSTreeParser.g:861:5: ^( BRACEBLOCK ( any )* )
					{
					match(input,BRACEBLOCK,FOLLOW_BRACEBLOCK_in_any2468); 
					if ( input.LA(1)==Token.DOWN ) {
						match(input, Token.DOWN, null); 
						// CSSTreeParser.g:861:18: ( any )*
						loop52:
						while (true) {
							int alt52=2;
							int LA52_0 = input.LA(1);
							if ( (LA52_0==BRACEBLOCK||(LA52_0 >= CLASSKEYWORD && LA52_0 <= COMMA)||LA52_0==DASHMATCH||LA52_0==DIMENSION||LA52_0==EQUALS||LA52_0==EXCLAMATION||(LA52_0 >= FUNCTION && LA52_0 <= HASH)||LA52_0==IDENT||LA52_0==INCLUDES||LA52_0==INVALID_STRING||LA52_0==NUMBER||LA52_0==PARENBLOCK||LA52_0==PERCENTAGE||LA52_0==SLASH||LA52_0==STRING||(LA52_0 >= UNIRANGE && LA52_0 <= URI)) ) {
								alt52=1;
							}

							switch (alt52) {
							case 1 :
								// CSSTreeParser.g:861:18: any
								{
								pushFollow(FOLLOW_any_in_any2470);
								any();
								state._fsp--;

								}
								break;

							default :
								break loop52;
							}
						}

						match(input, Token.UP, null); 
					}

					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "any"

	// Delegated rules



	public static final BitSet FOLLOW_INLINESTYLE_in_inlinestyle53 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declarations_in_inlinestyle57 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INLINESTYLE_in_inlinestyle72 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_inlineset_in_inlinestyle82 = new BitSet(new long[]{0x0000000000000008L,0x0000000000400000L});
	public static final BitSet FOLLOW_STYLESHEET_in_stylesheet119 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_statement_in_stylesheet128 = new BitSet(new long[]{0x4049040800004008L,0x0000020000400100L});
	public static final BitSet FOLLOW_ruleset_in_statement177 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_atstatement_in_statement187 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_STATEMENT_in_statement194 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CHARSET_in_atstatement227 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_IMPORT_in_atstatement233 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_in_atstatement240 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_media_in_atstatement252 = new BitSet(new long[]{0x0000000000000000L,0x0000002040000000L});
	public static final BitSet FOLLOW_import_uri_in_atstatement266 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PAGE_in_atstatement285 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IDENT_in_atstatement296 = new BitSet(new long[]{0x0000000000000000L,0x0000000004008000L});
	public static final BitSet FOLLOW_PSEUDOCLASS_in_atstatement325 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IDENT_in_atstatement329 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_declarations_in_atstatement359 = new BitSet(new long[]{0x0000000000000000L,0x0000000004000000L});
	public static final BitSet FOLLOW_SET_in_atstatement368 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_margin_in_atstatement373 = new BitSet(new long[]{0x2000000000000008L});
	public static final BitSet FOLLOW_VIEWPORT_in_atstatement397 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declarations_in_atstatement401 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_FONTFACE_in_atstatement415 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declarations_in_atstatement419 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_MEDIA_in_atstatement432 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_media_in_atstatement437 = new BitSet(new long[]{0x0040000000000008L,0x0000000000400000L});
	public static final BitSet FOLLOW_ruleset_in_atstatement450 = new BitSet(new long[]{0x0040000000000008L,0x0000000000400000L});
	public static final BitSet FOLLOW_INVALID_STATEMENT_in_atstatement461 = new BitSet(new long[]{0x0040000000000008L,0x0000000000400000L});
	public static final BitSet FOLLOW_unknown_atrule_in_atstatement493 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_ATSTATEMENT_in_unknown_atrule518 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URI_in_import_uri542 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_import_uri554 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MARGIN_AREA_in_margin588 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declarations_in_margin594 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_mediaquery_in_media630 = new BitSet(new long[]{0x8000000000000002L});
	public static final BitSet FOLLOW_MEDIA_QUERY_in_mediaquery666 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_mediaterm_in_mediaquery668 = new BitSet(new long[]{0x0042010002000008L});
	public static final BitSet FOLLOW_IDENT_in_mediaterm686 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_mediaexpression_in_mediaterm706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_STATEMENT_in_mediaterm717 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_declaration_in_mediaexpression752 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RULE_in_inlineset783 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_pseudo_in_inlineset788 = new BitSet(new long[]{0x0000000000000000L,0x0000000004018000L});
	public static final BitSet FOLLOW_declarations_in_inlineset796 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_RULE_in_ruleset849 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_combined_selector_in_ruleset863 = new BitSet(new long[]{0x0010000000000000L,0x0000000005000000L});
	public static final BitSet FOLLOW_declarations_in_ruleset884 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_SET_in_declarations925 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_declaration_in_declarations930 = new BitSet(new long[]{0x0002000002000008L});
	public static final BitSet FOLLOW_DECLARATION_in_declaration974 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_important_in_declaration983 = new BitSet(new long[]{0x0004010000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_INVALID_DIRECTIVE_in_declaration996 = new BitSet(new long[]{0x0000010000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_property_in_declaration1008 = new BitSet(new long[]{0x0000000000000000L,0x0000010000000000L});
	public static final BitSet FOLLOW_terms_in_declaration1019 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_INVALID_DECLARATION_in_declaration1039 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORTANT_in_important1056 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_property1096 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_property1104 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_IDENT_in_property1110 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VALUE_in_terms1155 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_term_in_terms1157 = new BitSet(new long[]{0x0880117489870A88L,0x0000003048021E41L});
	public static final BitSet FOLLOW_valuepart_in_term1185 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CURLYBLOCK_in_term1202 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ATKEYWORD_in_term1212 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1239 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_IDENT_in_valuepart1247 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASSKEYWORD_in_valuepart1259 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1269 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_NUMBER_in_valuepart1277 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1291 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000800L});
	public static final BitSet FOLLOW_PERCENTAGE_in_valuepart1299 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1311 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_DIMENSION_in_valuepart1319 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_valuepart1337 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URI_in_valuepart1356 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_in_valuepart1374 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNIRANGE_in_valuepart1393 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INCLUDES_in_valuepart1404 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_valuepart1415 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_valuepart1429 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_in_valuepart1447 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LESS_in_valuepart1459 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_QUESTION_in_valuepart1474 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENT_in_valuepart1485 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_valuepart1497 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SLASH_in_valuepart1510 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_valuepart1522 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASTERISK_in_valuepart1533 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXPRESSION_in_valuepart1544 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_valuepart1555 = new BitSet(new long[]{0x0000001000000000L});
	public static final BitSet FOLLOW_FUNCTION_in_valuepart1564 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_terms_in_valuepart1568 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_DASHMATCH_in_valuepart1580 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PARENBLOCK_in_valuepart1591 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_any_in_valuepart1593 = new BitSet(new long[]{0x0080117289070808L,0x0000003048000A40L});
	public static final BitSet FOLLOW_BRACEBLOCK_in_valuepart1606 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_any_in_valuepart1608 = new BitSet(new long[]{0x0080117289070808L,0x0000003048000A40L});
	public static final BitSet FOLLOW_selector_in_combined_selector1656 = new BitSet(new long[]{0x0000000004008012L,0x0000000000004000L});
	public static final BitSet FOLLOW_combinator_in_combined_selector1665 = new BitSet(new long[]{0x0010000000000000L,0x0000000001000000L});
	public static final BitSet FOLLOW_selector_in_combined_selector1669 = new BitSet(new long[]{0x0000000004008012L,0x0000000000004000L});
	public static final BitSet FOLLOW_CHILD_in_combinator1699 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ADJACENT_in_combinator1706 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PRECEDING_in_combinator1714 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DESCENDANT_in_combinator1721 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SELECTOR_in_selector1757 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_ELEMENT_in_selector1769 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IDENT_in_selector1785 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_selpart_in_selector1832 = new BitSet(new long[]{0x0020004000010408L,0x0000000000018000L});
	public static final BitSet FOLLOW_SELECTOR_in_selector1851 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_selpart_in_selector1863 = new BitSet(new long[]{0x0020004000010408L,0x0000000000018000L});
	public static final BitSet FOLLOW_INVALID_SELECTOR_in_selector1881 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_in_selpart1915 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASSKEYWORD_in_selpart1927 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ATTRIBUTE_in_selpart1935 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_attribute_in_selpart1939 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_pseudo_in_selpart1953 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_SELPART_in_selpart1960 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_attribute1994 = new BitSet(new long[]{0x00001000C1100002L,0x0000000020000000L});
	public static final BitSet FOLLOW_EQUALS_in_attribute2003 = new BitSet(new long[]{0x0080010000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_INCLUDES_in_attribute2014 = new BitSet(new long[]{0x0080010000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_DASHMATCH_in_attribute2025 = new BitSet(new long[]{0x0080010000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_CONTAINS_in_attribute2036 = new BitSet(new long[]{0x0080010000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_STARTSWITH_in_attribute2047 = new BitSet(new long[]{0x0080010000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_ENDSWITH_in_attribute2058 = new BitSet(new long[]{0x0080010000000000L,0x0000000040000000L});
	public static final BitSet FOLLOW_IDENT_in_attribute2076 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_attribute2088 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PSEUDOCLASS_in_pseudo2125 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IDENT_in_pseudo2129 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PSEUDOCLASS_in_pseudo2140 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FUNCTION_in_pseudo2144 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_IDENT_in_pseudo2148 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PSEUDOCLASS_in_pseudo2159 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FUNCTION_in_pseudo2163 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000041L});
	public static final BitSet FOLLOW_MINUS_in_pseudo2167 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_NUMBER_in_pseudo2172 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PSEUDOCLASS_in_pseudo2184 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FUNCTION_in_pseudo2188 = new BitSet(new long[]{0x0000200000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_MINUS_in_pseudo2192 = new BitSet(new long[]{0x0000200000000000L});
	public static final BitSet FOLLOW_INDEX_in_pseudo2197 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PSEUDOELEM_in_pseudo2215 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_IDENT_in_pseudo2219 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PSEUDOELEM_in_pseudo2233 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FUNCTION_in_pseudo2237 = new BitSet(new long[]{0x0000010000000000L});
	public static final BitSet FOLLOW_IDENT_in_pseudo2241 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PSEUDOELEM_in_pseudo2255 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FUNCTION_in_pseudo2259 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000041L});
	public static final BitSet FOLLOW_MINUS_in_pseudo2263 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000040L});
	public static final BitSet FOLLOW_NUMBER_in_pseudo2268 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_PSEUDOELEM_in_pseudo2282 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_FUNCTION_in_pseudo2286 = new BitSet(new long[]{0x0000200000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_MINUS_in_pseudo2290 = new BitSet(new long[]{0x0000200000000000L});
	public static final BitSet FOLLOW_INDEX_in_pseudo2295 = new BitSet(new long[]{0x0000000000000008L});
	public static final BitSet FOLLOW_STRING_in_string2319 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INVALID_STRING_in_string2326 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IDENT_in_any2342 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CLASSKEYWORD_in_any2348 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NUMBER_in_any2354 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENTAGE_in_any2360 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DIMENSION_in_any2366 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_string_in_any2372 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_URI_in_any2378 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_HASH_in_any2384 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_UNIRANGE_in_any2390 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INCLUDES_in_any2396 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_any2402 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMMA_in_any2408 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_in_any2414 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUALS_in_any2420 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SLASH_in_any2426 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXCLAMATION_in_any2432 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FUNCTION_in_any2439 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_any_in_any2441 = new BitSet(new long[]{0x0080117289070808L,0x0000003048000A40L});
	public static final BitSet FOLLOW_DASHMATCH_in_any2450 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PARENBLOCK_in_any2457 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_any_in_any2459 = new BitSet(new long[]{0x0080117289070808L,0x0000003048000A40L});
	public static final BitSet FOLLOW_BRACEBLOCK_in_any2468 = new BitSet(new long[]{0x0000000000000004L});
	public static final BitSet FOLLOW_any_in_any2470 = new BitSet(new long[]{0x0080117289070808L,0x0000003048000A40L});
}
