/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.domassign.DeclarationTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SingleMapNodeData
implements NodeData {
    private static final int COMMON_DECLARATION_SIZE = 7;
    protected static DeclarationTransformer transformer = CSSFactory.getDeclarationTransformer();
    protected static SupportedCSS css = CSSFactory.getSupportedCSS();
    private Map<String, Quadruple> map = new HashMap<String, Quadruple>(css.getTotalProperties(), 1.0f);

    @Override
    public <T extends CSSProperty> T getProperty(String name) {
        return this.getProperty(name, true);
    }

    @Override
    public <T extends CSSProperty> T getProperty(String name, boolean includeInherited) {
        Quadruple q = this.map.get(name);
        if (q == null) {
            return null;
        }
        CSSProperty tmp = includeInherited ? (q.curProp != null ? q.curProp : q.inhProp) : q.curProp;
        CSSProperty retval = tmp;
        return (T)retval;
    }

    @Override
    public Term<?> getValue(String name, boolean includeInherited) {
        Quadruple q = this.map.get(name);
        if (q == null) {
            return null;
        }
        if (includeInherited) {
            if (q.curValue != null) {
                return q.curValue;
            }
            return q.inhValue;
        }
        return q.curValue;
    }

    @Override
    public <T extends Term<?>> T getValue(Class<T> clazz, String name) {
        return this.getValue(clazz, name, true);
    }

    @Override
    public <T extends Term<?>> T getValue(Class<T> clazz, String name, boolean includeInherited) {
        Quadruple q = this.map.get(name);
        if (q == null) {
            return null;
        }
        if (includeInherited) {
            if (q.curValue != null) {
                return (T)((Term)clazz.cast(q.curValue));
            }
            return (T)((Term)clazz.cast(q.inhValue));
        }
        return (T)((Term)clazz.cast(q.curValue));
    }

    @Override
    public NodeData push(Declaration d) {
        HashMap<String, CSSProperty> properties = new HashMap<String, CSSProperty>(7);
        HashMap terms = new HashMap(7);
        boolean result = transformer.parseDeclaration(d, properties, terms);
        if (!result) {
            return this;
        }
        for (String key : properties.keySet()) {
            Quadruple q = this.map.get(key);
            if (q == null) {
                q = new Quadruple();
            }
            q.curProp = (CSSProperty)properties.get(key);
            q.curValue = (Term)terms.get(key);
            q.source = d;
            if (q.curValue != null) {
                q.curValue = q.curValue.setOperator(null);
            }
            this.map.put(key, q);
        }
        return this;
    }

    @Override
    public NodeData concretize() {
        for (String key : this.map.keySet()) {
            Quadruple q = this.map.get(key);
            if (q.curProp != null && q.curProp.equalsInherit()) {
                q.curProp = q.inhProp == null ? css.getDefaultProperty(key) : q.inhProp;
                q.curValue = q.inhValue == null ? css.getDefaultValue(key) : q.inhValue;
            }
            this.map.put(key, q);
        }
        return this;
    }

    @Override
    public NodeData inheritFrom(NodeData parent) throws ClassCastException {
        if (parent == null) {
            return this;
        }
        if (!(parent instanceof SingleMapNodeData)) {
            throw new ClassCastException("Cant't inherit from NodeData different from " + this.getClass().getName() + "(" + parent.getClass().getName() + ")");
        }
        SingleMapNodeData nd = (SingleMapNodeData)parent;
        for (String key : nd.map.keySet()) {
            Quadruple qp = nd.map.get(key);
            Quadruple q = this.map.get(key);
            if (q == null) {
                q = new Quadruple();
            }
            if (qp.inhProp != null && qp.inhProp.inherited()) {
                q.inhProp = qp.inhProp;
                q.inhValue = qp.inhValue;
                q.source = qp.source;
            }
            if (qp.curProp != null && qp.curProp.inherited() || q.curProp != null && q.curProp.equalsInherit()) {
                q.inhProp = qp.curProp;
                q.inhValue = qp.curValue;
                q.source = qp.source;
            }
            if (q.isEmpty()) continue;
            this.map.put(key, q);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(this.map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Term<?> value;
            Quadruple q = this.map.get(key);
            CSSProperty prop = q.curProp;
            if (prop == null) {
                prop = q.inhProp;
            }
            if ((value = q.curValue) == null) {
                value = q.inhValue;
            }
            sb.append(key).append(": ");
            if (value != null) {
                sb.append(value.toString());
            } else {
                sb.append(((Object)prop).toString());
            }
            sb.append(";\n");
        }
        return sb.toString();
    }

    @Override
    public Collection<String> getPropertyNames() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.map.keySet());
        return keys;
    }

    @Override
    public Declaration getSourceDeclaration(String name) {
        Quadruple q = this.map.get(name);
        if (q == null) {
            return null;
        }
        return q.source;
    }

    static class Quadruple {
        CSSProperty inhProp = null;
        CSSProperty curProp = null;
        Term<?> inhValue = null;
        Term<?> curValue = null;
        Declaration source = null;

        public boolean isEmpty() {
            return this.inhProp == null && this.curProp == null && this.inhValue == null && this.curValue == null;
        }
    }
}

