/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Rule;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.ElementUtil;
import cz.vutbr.web.domassign.AssignedDeclaration;
import cz.vutbr.web.domassign.DeclarationMap;
import cz.vutbr.web.domassign.StyleMap;
import cz.vutbr.web.domassign.Traversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class Analyzer {
    private static final Logger log = LoggerFactory.getLogger(Analyzer.class);
    protected static final String UNIVERSAL_HOLDER = "all";
    protected Map<String, Holder> rules = Collections.synchronizedMap(new HashMap());

    public Analyzer(StyleSheet sheet) {
        this.classifyRules(sheet);
    }

    public Analyzer(List<StyleSheet> sheets) {
        for (StyleSheet sheet : sheets) {
            this.classifyRules(sheet);
        }
    }

    public StyleMap evaluateDOM(Document doc, String media, final boolean inherit) {
        DeclarationMap declarations = this.assingDeclarationsToDOM(doc, media, inherit);
        StyleMap nodes = new StyleMap(declarations.size());
        Traversal<StyleMap> traversal = new Traversal<StyleMap>(doc, (Object)declarations, 1){

            @Override
            protected void processNode(StyleMap result, Node current, Object source) {
                NodeData main = CSSFactory.createNodeData();
                List declarations = (List)((DeclarationMap)source).get((Element)current, null);
                if (declarations != null) {
                    for (Declaration d : declarations) {
                        main.push(d);
                    }
                    if (inherit) {
                        main.inheritFrom((NodeData)result.get((Element)this.walker.parentNode(), null));
                    }
                }
                result.put((Element)current, null, main.concretize());
                for (Selector.PseudoDeclaration pseudo : ((DeclarationMap)source).pseudoSet((Element)current)) {
                    NodeData pdata = CSSFactory.createNodeData();
                    declarations = (List)((DeclarationMap)source).get((Element)current, pseudo);
                    if (declarations != null) {
                        for (Declaration d : declarations) {
                            pdata.push(d);
                        }
                        pdata.inheritFrom(main);
                    }
                    result.put((Element)current, pseudo, pdata.concretize());
                }
            }
        };
        traversal.levelTraversal(nodes);
        return nodes;
    }

    protected DeclarationMap assingDeclarationsToDOM(Document doc, String media, boolean inherit) {
        Holder holder = UNIVERSAL_HOLDER.equals(media) ? this.rules.get(UNIVERSAL_HOLDER) : Holder.union(this.rules.get(UNIVERSAL_HOLDER), this.rules.get(media));
        if (log.isTraceEnabled()) {
            log.trace("For media \"{}\" constructed holder:\n {}", (Object)media, (Object)holder);
        }
        DeclarationMap declarations = new DeclarationMap();
        if (holder != null && !holder.isEmpty()) {
            Traversal<DeclarationMap> traversal = new Traversal<DeclarationMap>(doc, (Object)holder, 1){

                @Override
                protected void processNode(DeclarationMap result, Node current, Object source) {
                    Analyzer.this.assignDeclarationsToElement(result, this.walker, (Element)current, (Holder)source);
                }
            };
            if (!inherit) {
                traversal.listTraversal(declarations);
            } else {
                traversal.levelTraversal(declarations);
            }
        }
        return declarations;
    }

    protected void assignDeclarationsToElement(DeclarationMap declarations, TreeWalker walker, Element e, Holder holder) {
        List<RuleSet> rules;
        List<RuleSet> rules2;
        if (log.isDebugEnabled()) {
            log.debug("Traversal of {} {}.", (Object)e.getNodeName(), (Object)e.getNodeValue());
        }
        HashSet<RuleSet> candidates = new HashSet<RuleSet>();
        for (String cname : ElementUtil.elementClasses(e)) {
            rules2 = holder.get(HolderItem.CLASS, cname.toLowerCase());
            if (rules2 == null) continue;
            candidates.addAll(rules2);
        }
        log.trace("After CLASSes {} total candidates.", (Object)candidates.size());
        String id = ElementUtil.elementID(e);
        if (id != null && id.length() != 0 && (rules = holder.get(HolderItem.ID, id.toLowerCase())) != null) {
            candidates.addAll(rules);
        }
        log.trace("After IDs {} total candidates.", (Object)candidates.size());
        String name = ElementUtil.elementName(e);
        if (name != null && (rules2 = holder.get(HolderItem.ELEMENT, name.toLowerCase())) != null) {
            candidates.addAll(rules2);
        }
        log.trace("After ELEMENTs {} total candidates.", (Object)candidates.size());
        candidates.addAll(holder.get(HolderItem.OTHER, null));
        ArrayList clist = new ArrayList(candidates);
        Collections.sort(clist);
        log.debug("Totally {} candidates.", (Object)candidates.size());
        log.trace("With values: {}", clist);
        ArrayList<AssignedDeclaration> eldecl = new ArrayList<AssignedDeclaration>();
        HashSet<Selector.PseudoDeclaration> pseudos = new HashSet<Selector.PseudoDeclaration>();
        for (RuleSet rule : clist) {
            StyleSheet sheet = rule.getStyleSheet();
            if (sheet == null) {
                log.warn("No source style sheet set for rule: {}", (Object)rule.toString());
            }
            StyleSheet.Origin origin = sheet == null ? StyleSheet.Origin.AGENT : sheet.getOrigin();
            for (CombinedSelector s : rule.getSelectors()) {
                if (!this.matchSelector(s, e, walker)) {
                    log.trace("CombinedSelector \"{}\" NOT matched!", (Object)s);
                    continue;
                }
                log.trace("CombinedSelector \"{}\" matched", (Object)s);
                Selector.PseudoDeclaration pseudo = s.getPseudoElement();
                CombinedSelector.Specificity spec = s.computeSpecificity();
                if (pseudo == null) {
                    for (Declaration d : rule) {
                        eldecl.add(new AssignedDeclaration(d, spec, origin));
                    }
                    continue;
                }
                pseudos.add(pseudo);
                for (Declaration d : rule) {
                    declarations.addDeclaration(e, pseudo, new AssignedDeclaration(d, spec, origin));
                }
            }
        }
        Collections.sort(eldecl);
        log.debug("Sorted {} declarations.", (Object)eldecl.size());
        log.trace("With values: {}", eldecl);
        for (Selector.PseudoDeclaration p : pseudos) {
            declarations.sortDeclarations(e, p);
        }
        declarations.put(e, null, eldecl);
    }

    protected boolean matchSelector(CombinedSelector sel, Element e, TreeWalker w) {
        Node current = w.getCurrentNode();
        boolean retval = false;
        Selector.Combinator combinator = null;
        for (int i = sel.size() - 1; i >= 0; --i) {
            Selector s = (Selector)sel.get(i);
            if (combinator == null) {
                retval = s.matches(e);
            } else if (combinator == Selector.Combinator.ADJACENT) {
                Element adjacent = (Element)w.previousSibling();
                retval = false;
                if (adjacent != null) {
                    retval = s.matches(adjacent);
                }
            } else if (combinator == Selector.Combinator.PRECEDING) {
                Element preceding;
                retval = false;
                while (!retval && (preceding = (Element)w.previousSibling()) != null) {
                    retval = s.matches(preceding);
                }
            } else if (combinator == Selector.Combinator.DESCENDANT) {
                Element ancestor;
                retval = false;
                while (!retval && (ancestor = (Element)w.parentNode()) != null) {
                    retval = s.matches(ancestor);
                }
            } else if (combinator == Selector.Combinator.CHILD) {
                Element parent = (Element)w.parentNode();
                retval = false;
                if (parent != null) {
                    retval = s.matches(parent);
                }
            }
            combinator = s.getCombinator();
            if (!retval) break;
        }
        w.setCurrentNode(current);
        return retval;
    }

    private void classifyRules(StyleSheet sheet) {
        Holder all = this.rules.get(UNIVERSAL_HOLDER);
        if (all == null) {
            all = new Holder();
            this.rules.put(UNIVERSAL_HOLDER, all);
        }
        for (Rule rule : sheet) {
            if (rule instanceof RuleSet) {
                RuleSet ruleset = (RuleSet)rule;
                for (CombinedSelector s : ruleset.getSelectors()) {
                    this.insertClassified(all, this.classifySelector(s), ruleset);
                }
            }
            if (!(rule instanceof RuleMedia)) continue;
            RuleMedia rulemedia = (RuleMedia)rule;
            for (RuleSet ruleset : rulemedia) {
                for (CombinedSelector s : ruleset.getSelectors()) {
                    List<HolderSelector> hs = this.classifySelector(s);
                    if (rulemedia.getMedia() == null || rulemedia.getMedia().isEmpty()) {
                        this.insertClassified(this.rules.get(UNIVERSAL_HOLDER), hs, ruleset);
                        continue;
                    }
                    for (String media : rulemedia.getMedia()) {
                        Holder h = this.rules.get(media);
                        if (h == null) {
                            h = new Holder();
                            this.rules.put(media, h);
                        }
                        this.insertClassified(h, hs, ruleset);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Contains rules for {} medias.", (Object)this.rules.size());
            for (String media : this.rules.keySet()) {
                log.debug("For media \"{}\" it is {}", (Object)media, (Object)this.rules.get(media).contentCount());
                if (!log.isTraceEnabled()) continue;
                log.trace("Detailed view: \n{}", (Object)this.rules.get(media));
            }
        }
    }

    private List<HolderSelector> classifySelector(CombinedSelector selector) {
        ArrayList<HolderSelector> hs = new ArrayList<HolderSelector>();
        try {
            String id;
            String className;
            Selector last = selector.getLastSelector();
            String element = last.getElementName();
            if (element != null) {
                if ("*".equals(element)) {
                    hs.add(new HolderSelector(HolderItem.OTHER, null));
                } else {
                    hs.add(new HolderSelector(HolderItem.ELEMENT, element.toLowerCase()));
                }
            }
            if ((className = last.getClassName()) != null) {
                hs.add(new HolderSelector(HolderItem.CLASS, className.toLowerCase()));
            }
            if ((id = last.getIDName()) != null) {
                hs.add(new HolderSelector(HolderItem.ID, id.toLowerCase()));
            }
            if (hs.size() == 0) {
                hs.add(new HolderSelector(HolderItem.OTHER, null));
            }
            return hs;
        }
        catch (UnsupportedOperationException e) {
            log.error("CombinedSelector does not include any selector, this should not happen!");
            return Collections.emptyList();
        }
    }

    private void insertClassified(Holder holder, List<HolderSelector> hs, RuleSet value) {
        for (HolderSelector h : hs) {
            holder.insert(h.item, h.key, value);
        }
    }

    protected static class Holder {
        private List<Map<String, List<RuleSet>>> items = new ArrayList<Map<String, List<RuleSet>>>(HolderItem.values().length - 1);
        private List<RuleSet> others;

        public Holder() {
            for (HolderItem hi : HolderItem.values()) {
                if (hi == HolderItem.OTHER) {
                    this.others = new ArrayList<RuleSet>();
                    continue;
                }
                this.items.add(new HashMap());
            }
        }

        public boolean isEmpty() {
            for (HolderItem hi : HolderItem.values()) {
                if (!(hi == HolderItem.OTHER ? !this.others.isEmpty() : !this.items.get(hi.type).isEmpty())) continue;
                return false;
            }
            return true;
        }

        public static Holder union(Holder one, Holder two) {
            Holder union = new Holder();
            if (one == null) {
                one = new Holder();
            }
            if (two == null) {
                two = new Holder();
            }
            for (HolderItem hi : HolderItem.values()) {
                if (hi == HolderItem.OTHER) {
                    union.others.addAll(one.others);
                    union.others.addAll(two.others);
                    continue;
                }
                Map<String, List<RuleSet>> oneMap = one.items.get(hi.type);
                Map<String, List<RuleSet>> twoMap = two.items.get(hi.type);
                Map<String, List<RuleSet>> unionMap = union.items.get(hi.type);
                unionMap.putAll(oneMap);
                for (String key : twoMap.keySet()) {
                    if (unionMap.containsKey(key)) {
                        unionMap.get(key).addAll((Collection<RuleSet>)twoMap.get(key));
                        continue;
                    }
                    unionMap.put(key, twoMap.get(key));
                }
            }
            return union;
        }

        public void insert(HolderItem item, String key, RuleSet value) {
            if (item == HolderItem.OTHER) {
                this.others.add(value);
                return;
            }
            Map<String, List<RuleSet>> map = this.items.get(item.type);
            List<RuleSet> list = map.get(key);
            if (list == null) {
                list = new ArrayList<RuleSet>();
                map.put(key, list);
            }
            list.add(value);
        }

        public List<RuleSet> get(HolderItem item, String key) {
            if (item == HolderItem.OTHER) {
                return this.others;
            }
            return this.items.get(item.type()).get(key);
        }

        public String contentCount() {
            StringBuilder sb = new StringBuilder();
            for (HolderItem hi : HolderItem.values()) {
                if (hi == HolderItem.OTHER) {
                    sb.append(hi.name()).append(": ").append(this.others.size()).append(" ");
                    continue;
                }
                sb.append(hi.name()).append(":").append(this.items.get(hi.type).size()).append(" ");
            }
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (HolderItem hi : HolderItem.values()) {
                if (hi == HolderItem.OTHER) {
                    sb.append(hi.name()).append(" (").append(this.others.size()).append("): ").append(this.others).append("\n");
                    continue;
                }
                sb.append(hi.name()).append(" (").append(this.items.get(hi.type).size()).append("): ").append(this.items.get(hi.type)).append("\n");
            }
            return sb.toString();
        }
    }

    protected class HolderSelector {
        public HolderItem item;
        public String key;

        public HolderSelector(HolderItem item, String key) {
            this.item = item;
            this.key = key;
        }
    }

    protected static enum HolderItem {
        ELEMENT(0),
        ID(1),
        CLASS(2),
        OTHER(3);

        private int type;

        private HolderItem(int type) {
            this.type = type;
        }

        public int type() {
            return this.type;
        }
    }
}

