// $ANTLR 3.5.2 cz/vutbr/web/csskit/antlr/CSS.g 2014-06-03 21:06:53

package cz.vutbr.web.csskit.antlr;

import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;

import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.SupportedCSS; 



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class CSSLexer extends Lexer {
	public static final int EOF=-1;
	public static final int T__101=101;
	public static final int T__102=102;
	public static final int T__103=103;
	public static final int ADJACENT=4;
	public static final int APOS=5;
	public static final int ASTERISK=6;
	public static final int ATBLOCK=7;
	public static final int ATKEYWORD=8;
	public static final int ATTRIBUTE=9;
	public static final int BRACEBLOCK=10;
	public static final int CDC=11;
	public static final int CDO=12;
	public static final int CHARSET=13;
	public static final int CHILD=14;
	public static final int CLASSKEYWORD=15;
	public static final int COLON=16;
	public static final int COMMA=17;
	public static final int COMMENT=18;
	public static final int CONTAINS=19;
	public static final int CTRL=20;
	public static final int CTRL_CHAR=21;
	public static final int CURLYBLOCK=22;
	public static final int DASHMATCH=23;
	public static final int DECLARATION=24;
	public static final int DESCENDANT=25;
	public static final int DIMENSION=26;
	public static final int ELEMENT=27;
	public static final int ENDSWITH=28;
	public static final int EQUALS=29;
	public static final int ESCAPE_CHAR=30;
	public static final int EXCLAMATION=31;
	public static final int EXPRESSION=32;
	public static final int FONTFACE=33;
	public static final int FUNCTION=34;
	public static final int GREATER=35;
	public static final int HASH=36;
	public static final int IDENT=37;
	public static final int IDENT_MACR=38;
	public static final int IMPORT=39;
	public static final int IMPORTANT=40;
	public static final int IMPORT_END=41;
	public static final int INCLUDES=42;
	public static final int INDEX=43;
	public static final int INLINESTYLE=44;
	public static final int INTEGER_MACR=45;
	public static final int INVALID_DECLARATION=46;
	public static final int INVALID_DIRECTIVE=47;
	public static final int INVALID_IMPORT=48;
	public static final int INVALID_SELECTOR=49;
	public static final int INVALID_SELPART=50;
	public static final int INVALID_STATEMENT=51;
	public static final int INVALID_STRING=52;
	public static final int INVALID_TOKEN=53;
	public static final int LBRACE=54;
	public static final int LCURLY=55;
	public static final int LESS=56;
	public static final int LPAREN=57;
	public static final int MARGIN_AREA=58;
	public static final int MEDIA=59;
	public static final int MINUS=60;
	public static final int NAME_CHAR=61;
	public static final int NAME_MACR=62;
	public static final int NAME_START=63;
	public static final int NL_CHAR=64;
	public static final int NON_ASCII=65;
	public static final int NUMBER=66;
	public static final int NUMBER_MACR=67;
	public static final int PAGE=68;
	public static final int PARENBLOCK=69;
	public static final int PERCENT=70;
	public static final int PERCENTAGE=71;
	public static final int PLUS=72;
	public static final int PRECEDING=73;
	public static final int PSEUDO=74;
	public static final int QUESTION=75;
	public static final int QUOT=76;
	public static final int RBRACE=77;
	public static final int RCURLY=78;
	public static final int RPAREN=79;
	public static final int RULE=80;
	public static final int S=81;
	public static final int SELECTOR=82;
	public static final int SEMICOLON=83;
	public static final int SET=84;
	public static final int SLASH=85;
	public static final int SL_COMMENT=86;
	public static final int STARTSWITH=87;
	public static final int STRING=88;
	public static final int STRING_CHAR=89;
	public static final int STRING_MACR=90;
	public static final int STYLESHEET=91;
	public static final int TILDE=92;
	public static final int UNIRANGE=93;
	public static final int URI=94;
	public static final int URI_CHAR=95;
	public static final int URI_MACR=96;
	public static final int VALUE=97;
	public static final int VIEWPORT=98;
	public static final int W_CHAR=99;
	public static final int W_MACR=100;

	    

	    private static Logger log = LoggerFactory.getLogger(CSSLexer.class);
	    
	    private static SupportedCSS css = CSSFactory.getSupportedCSS();
	    
	    public static class LexerState {
	        
	        public enum RecoveryMode {
	            BALANCED,
	            FUNCTION, 
	            RULE,
	            DECL
	        } 
	    
	        public short curlyNest;
	        public short parenNest;
	        public boolean quotOpen;
	        public boolean aposOpen;
	        
	        public LexerState() {
	        	this.curlyNest = 0;
	        	this.parenNest = 0;
	        	this.quotOpen = false;
	        	this.aposOpen = false;
	        }
	        
	        public LexerState(LexerState clone) {
	        	this();
	            this.curlyNest = clone.curlyNest;
	            this.parenNest = clone.parenNest;
	            this.quotOpen = clone.quotOpen;
	            this.aposOpen = clone.aposOpen;
	        }
	        
	        @Override
	        public boolean equals(Object o)
	        {
	            return (this.curlyNest == ((LexerState) o).curlyNest &&
	                    this.parenNest == ((LexerState) o).parenNest &&
	                    this.quotOpen == ((LexerState) o).quotOpen &&
	                    this.aposOpen == ((LexerState) o).aposOpen);
	        }
	        
	        /**
	         * Checks whether all pair characters (single and double quotatation marks,
	         * curly braces) are balanced
			     */ 
	        public boolean isBalanced() {
	        	return aposOpen==false && quotOpen==false && curlyNest==0 && parenNest==0;
	        }
	        
	        /**
	         * Checks whether some pair characters are balanced. Modes are:
	         * <ul>
	         * <li>BALANCED - everything must be balanced: single and double quotatation marks, curly braces, parentheses 
	         * <li>FUNCTION - within the function arguments: parentheses must be balanced 
	         * <li>RULE - within the CSS rule: all but curly braces
	         * <li>DECL - within declaration: all, keep curly braces at desired state
	         * </ul> 
	         */ 
	        public boolean isBalanced(RecoveryMode mode, LexerState state)
	        {
	            if (mode == RecoveryMode.BALANCED)
	                return aposOpen==false && quotOpen==false && curlyNest==0 && parenNest==0;
	            else if (mode == RecoveryMode.FUNCTION)
	                return parenNest==0;
	            else if (mode == RecoveryMode.RULE)
	                return aposOpen==false && quotOpen==false && parenNest==0;
	            else if (mode == RecoveryMode.DECL)
	                return aposOpen==false && quotOpen==false && parenNest==0 && curlyNest==state.curlyNest;
	            else
	                return false;
	        }
	        
	        /**
	         * Recovers from unexpected EOF by preparing 
	         * new token
	         */ 
	        public CSSToken generateEOFRecover() {
	        	
	        	CSSToken t = null;
	        
	        	if(aposOpen) {
	        		this.aposOpen=false;
	        		t = new CSSToken(CSSLexer.APOS, this);
	        		t.setText("'");
	        	}
	        	else if(quotOpen) {
	        		this.quotOpen=false;
	        		t = new CSSToken(CSSLexer.QUOT, this);
	        		t.setText("\"");
	        	}
	        	else if(parenNest!=0) {
	        		this.parenNest--;
	        		t = new CSSToken(CSSLexer.RPAREN, this);
	        		t.setText(")");
	        	}
	        	else if(curlyNest!=0) {
	        		this.curlyNest--;
	        		t = new CSSToken(CSSLexer.RCURLY, this);
	        		t.setText("}");
	        	}
	        	
	        	log.debug("Recovering from EOF by {}", t);
	        	return t;
	        }
	        
	        @Override
	        public String toString() {
	        	StringBuilder sb = new StringBuilder();
	        	sb.append("{=").append(curlyNest)
	        	  .append(", (=").append(parenNest)
	        	  .append(", '=").append(aposOpen ? "1" : "0")
	        	  .append(", \"=").append(quotOpen ? "1" :"0");
	        	 
	        	return sb.toString();  
	        }
	    }
	    
	    private static class LexerStream {
	    
	    	public CharStream input;
	    	public int mark;
	    	public LexerState ls;
	    	
	    	public LexerStream(CharStream input, LexerState ls) {
	    	    this.input = input;
	    	    this.mark = input.mark();
	    	    this.ls = new LexerState(ls);
	    	}
	    }
	    
	    // number of already processed tokens (for checking the beginning of the style sheet)
	    private int tokencnt = 0;
	    
	    // lexer states for imported files
	    private Stack<LexerStream> imports;
	    
	    // current lexer state
	    private LexerState ls;
	    
	    // this is for orthogonality
	    @SuppressWarnings("unused")
	    private StyleSheet stylesheet;
	    
	    // token recovery
	    private Stack<Integer> expectedToken;
	    
	    /**
	     * This function must be called to initialize lexer's state.
	     * Because we can't change directly generated constructors.
	     * @param stylesheet CSS StyleSheet instance  
	     */
	    public CSSLexer init(StyleSheet stylesheet) {
		    this.imports = new Stack<LexerStream>();
		    this.expectedToken = new Stack<Integer>();
			this.ls = new LexerState();
			this.stylesheet = stylesheet;
			return this;
	    }
	    
	    @Override
	    public void reset() {
	    	super.reset();
	    	this.ls = new LexerState();
	    }
	    
	    /**
	     * Overrides next token to match includes and to 
	     * recover from EOF
	     */
		@Override 
	    public Token nextToken(){
	       Token token = nextTokenRecover();

	       //count non-empty tokens for eventual checking of the style sheet start
	       if (token.getType() == S) {
	           tokencnt++;
	       }

	       // recover from unexpected EOF
	       if(token.getType()==Token.EOF && !ls.isBalanced()) {
	           CSSToken t = ls.generateEOFRecover(); 
	           return (Token) t;
	       }

	       // push back import stream
	       // We've got EOF and have non empty stack
	       if(token.getType()==Token.EOF && !imports.empty()){

	       	 // prepare end token 	
	       	 CSSToken t = new CSSToken(IMPORT_END, ls);
	       	 t.setText("IMPORT_END");
	       
	         // We've got EOF and have non empty stack.
	         LexerStream stream = imports.pop();
	         setCharStream(stream.input);
	         input.rewind(stream.mark);
	         this.ls = stream.ls;
	         
	         // send created token
	         return (Token) t;
	         //token = nextTokenRecover();
	       }       

	       // Skip first token after switching on another input.
	       if(((CommonToken)token).getStartIndex() < 0)
	         token = nextToken();
	        
	       return token;
	    }

	    /**
		 * Adds contextual information about n      {
		 esting into token.
		 */
	    @Override
		public Token emit() {
			CSSToken t = new CSSToken(input, state.type, state.channel,
	                        state.tokenStartCharIndex, getCharIndex()-1);
	        t.setLine(state.tokenStartLine);
	        t.setText(state.text);
	        t.setCharPositionInLine(state.tokenStartCharPositionInLine);
	        t.setBase(((CSSInputStream) input).getBase());
	        
	        // clone lexer state
	        t.setLexerState(new LexerState(ls));
	        emit(t);
	        return t;
		}

		@Override
	    public void emitErrorMessage(String msg) {
	    	log.info("ANTLR: {}", msg);
	    }
	    
	    /**
	     * Does special token recovery for some cases
	     */ 
	    @Override
	    public void recover(RecognitionException re) {
	    	// there is no special recovery
	    	if(expectedToken.isEmpty())
	    		super.recover(re);
	    	else {
	    		switch(expectedToken.pop().intValue()) {
	    		
	    		case IMPORT:  // IMPORT share recovery rules with CHARSET
	    		case CHARSET:
	    			final BitSet charsetFollow = BitSet.of((int) '}', (int) ';');
	    			consumeUntilBalanced(charsetFollow);
	    			break;
	    		case STRING:
	    			// eat character which should be newline but not EOF
	    			if(consumeAnyButEOF()) {
	    				// set back to uninitialized state
	    				ls.quotOpen = false;
	    				ls.aposOpen = false;
	    				// create invalid string token
	    				state.token = (Token) new CSSToken(INVALID_STRING, ls);
	        			state.token.setText("INVALID_STRING");
	    			}
	    			// we can't just let parser generate missing 
	    		    // single/double quot token
	    			// because we have not emitted content of string yet!
	    			// we will fake string token
	    			else {
	    				char enclosing = (ls.quotOpen) ? '"' : '\'';
	    				ls.quotOpen = false;
	    				ls.aposOpen = false;
	    				state.token = (Token) new CSSToken(STRING, ls, 
	    					state.tokenStartCharIndex, getCharIndex() -1);
	        			state.token.setText(
	        				input.substring(state.tokenStartCharIndex, getCharIndex() -1)
	        				+ enclosing);	
	    			}
	    			break;
	    		default:
	    			super.recover(re);
	    		}
	    	}	
	    }
	    
	    /**
	     * Implements Lexer's next token with extra token passing from
	     * recovery function 
	     */
	    private Token nextTokenRecover() {
	    	while (true) {
				state.token = null;
				state.channel = Token.DEFAULT_CHANNEL;
				state.tokenStartCharIndex = input.index();
				state.tokenStartCharPositionInLine = input.getCharPositionInLine();
				state.tokenStartLine = input.getLine();
				state.text = null;
				if ( input.LA(1)==CharStream.EOF ) {
					return getEOFToken();
				}
				try {
					mTokens();
					if ( state.token==null ) {
						emit();
					}
					else if ( state.token==Token.SKIP_TOKEN ) {
						continue;
					}
					return state.token;
				}
				catch (RecognitionException re) {
					reportError(re);
					if ( re instanceof NoViableAltException ) {
						recover(re); 
					}

					// there can be token returned from recovery
	                if(state.token!=null) {
	                    state.token.setChannel(Token.INVALID_TOKEN_TYPE);
	                  	state.token.setInputStream(input);
	                   	state.token.setLine(state.tokenStartLine);
	            		state.token.setCharPositionInLine(state.tokenStartCharPositionInLine);
	            		emit(state.token);
	            		return state.token;
	                }
				}
			}
		}
	    
	    /**
	     * Eats characters until on from follow is found and Lexer state 
	     * is balanced at the moment
	     */ 
	    private void consumeUntilBalanced(BitSet follow) {

	    	log.debug("Lexer entered consumeUntilBalanced with {} and follow {}", 
	    		ls, follow);
	    
	    	int c;
			do {
	    		c = input.LA(1);
	    		// change apostrophe state
	    		if(c=='\'' && ls.quotOpen==false) {
	    			ls.aposOpen = !ls.aposOpen;
	    		}
	    		// change quot state
	    		else if (c=='"' && ls.aposOpen==false) {
	    			ls.quotOpen = !ls.quotOpen;
	    		}
	    		else if(c=='(') {
	    			ls.parenNest++;
	    		}
	    		else if(c==')' && ls.parenNest>0) {
	    			ls.parenNest--;
	    		}
	    		else if(c=='{') {
	    			ls.curlyNest++;
	    		}
	    		else if(c=='}' && ls.curlyNest>0) {
	    			ls.curlyNest--;
	    		}
	    		// handle end of line in string
	    		else if(c=='\n') {
	    			if(ls.quotOpen) ls.quotOpen=false;
	    			else if(ls.aposOpen) ls.aposOpen=false;
	    		} 
	    		else if(c==EOF) {
	    			log.info("Unexpected EOF during consumeUntilBalanced, EOF not consumed");
	    			return;
	    		}
	    	
	    		input.consume();
	    		// log result
	    		if(log.isTraceEnabled())
	    			log.trace("Lexer consumes '{}'({}) until balanced ({}).", 
	    				new Object[] {
	    					Character.toString((char) c),
	    					Integer.toString(c),
	    					ls});
	    			
	    	}while(!(ls.isBalanced() && follow.member(c)));
	    }
	    
	    /**
	     * Consumes arbitrary character but EOF
	     * @return <code>false</code> if EOF was matched,
	     *         <code>true</code> otherwise and that character was consumed
	     */
	    private boolean consumeAnyButEOF() {
	    
	    	int c = input.LA(1);
	    	
	    	if(c==CharStream.EOF)
	    		return false;
	    		
	    	if(log.isTraceEnabled())
	    		log.trace("Lexer consumes '{}' while consumeButEOF", 
	    					Character.toString((char)c));
	    	
	    	// consume character				
	    	input.consume();
	    	return true;
	    }
	    
	    /**
	     * Reads all the contents of an expression. Parenthesis are matched but not in strings.
	     */ 
	    private String readExpressionContents() 
	    {
	      log.debug("readExpressionContents"); 
	    
	      StringBuffer ret = new StringBuffer(); 
	      int parenN = 1; /* one already open */
	      boolean inApos = false;
	      boolean inQuot = false;
	      boolean esc = false;
	      boolean finished = false;
	      int c;
		    while (!finished)
		    {
		        c = input.LA(1);
		        if(c=='\'' && !inQuot && !(inApos && esc)) {
		            inApos = !inApos;
		        }
		        else if (c=='"' && !inApos && !(inQuot && esc)) {
		            inQuot = !inQuot;
		        }
		        else if(c=='(' && !inApos && !inQuot) {
		            parenN++;
		        }
		        else if(c==')' && parenN>0  && !inApos && !inQuot) {
		            parenN--;
		            if (parenN == 0) finished = true;
		        }
		        // handle end of line in string
		        else if (c=='\n') {
		           inQuot = false;
		           inApos = false;
		        } 
		        else if(c==EOF) {
		          log.info("Unexpected EOF during consumeUntilBalanced, EOF not consumed");
		          return ret.toString();
		        }
		        
		        esc = (c == '\\') && !esc;
		        
		        if (!finished) ret.append((char) c);
		        
		        input.consume();
		          
		    }
		    
		    log.debug("Expr: " + ret.toString());
	      return ret.toString();
	    }
	    


	// delegates
	// delegators
	public Lexer[] getDelegates() {
		return new Lexer[] {};
	}

	public CSSLexer() {} 
	public CSSLexer(CharStream input) {
		this(input, new RecognizerSharedState());
	}
	public CSSLexer(CharStream input, RecognizerSharedState state) {
		super(input,state);
	}
	@Override public String getGrammarFileName() { return "cz/vutbr/web/csskit/antlr/CSS.g"; }

	// $ANTLR start "T__101"
	public final void mT__101() throws RecognitionException {
		try {
			int _type = T__101;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:479:8: ( '#' )
			// cz/vutbr/web/csskit/antlr/CSS.g:479:10: '#'
			{
			match('#'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "T__101"

	// $ANTLR start "T__102"
	public final void mT__102() throws RecognitionException {
		try {
			int _type = T__102;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:480:8: ( '^' )
			// cz/vutbr/web/csskit/antlr/CSS.g:480:10: '^'
			{
			match('^'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "T__102"

	// $ANTLR start "T__103"
	public final void mT__103() throws RecognitionException {
		try {
			int _type = T__103;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:481:8: ( 'important' )
			// cz/vutbr/web/csskit/antlr/CSS.g:481:10: 'important'
			{
			match("important"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "T__103"

	// $ANTLR start "IDENT"
	public final void mIDENT() throws RecognitionException {
		try {
			int _type = IDENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1082:2: ( IDENT_MACR )
			// cz/vutbr/web/csskit/antlr/CSS.g:1082:4: IDENT_MACR
			{
			mIDENT_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IDENT"

	// $ANTLR start "CHARSET"
	public final void mCHARSET() throws RecognitionException {
		try {
			int _type = CHARSET;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken s=null;


				expectedToken.push(new Integer(CHARSET));

			// cz/vutbr/web/csskit/antlr/CSS.g:1092:2: ( '@charset' ( S )* s= STRING_MACR ( S )* SEMICOLON )
			// cz/vutbr/web/csskit/antlr/CSS.g:1092:4: '@charset' ( S )* s= STRING_MACR ( S )* SEMICOLON
			{
			match("@charset"); 

			// cz/vutbr/web/csskit/antlr/CSS.g:1092:15: ( S )*
			loop1:
			while (true) {
				int alt1=2;
				int LA1_0 = input.LA(1);
				if ( ((LA1_0 >= '\t' && LA1_0 <= '\r')||LA1_0==' ') ) {
					alt1=1;
				}

				switch (alt1) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1092:15: S
					{
					mS(); 

					}
					break;

				default :
					break loop1;
				}
			}

			int sStart81 = getCharIndex();
			int sStartLine81 = getLine();
			int sStartCharPos81 = getCharPositionInLine();
			mSTRING_MACR(); 
			s = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, sStart81, getCharIndex()-1);
			s.setLine(sStartLine81);
			s.setCharPositionInLine(sStartCharPos81);

			// cz/vutbr/web/csskit/antlr/CSS.g:1092:32: ( S )*
			loop2:
			while (true) {
				int alt2=2;
				int LA2_0 = input.LA(1);
				if ( ((LA2_0 >= '\t' && LA2_0 <= '\r')||LA2_0==' ') ) {
					alt2=1;
				}

				switch (alt2) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1092:32: S
					{
					mS(); 

					}
					break;

				default :
					break loop2;
				}
			}

			mSEMICOLON(); 


				    // we have to trim manually
				    String enc = CSSToken.extractSTRING(s.getText());
				    //System.err.println("CHARSET"+tokencnt);
				    if (tokencnt <= 1) //we are at the beginning of the style sheet
				    {
						    try {
						           log.warn("Changing charset to {}", enc);
						          ((CSSInputStream) input).setEncoding(enc);
						          //input = setCharStream(new ANTLFileStream(input.getSourceName(), enc));
						        }
						        catch(IllegalCharsetNameException icne) {
						        	log.warn("Could not change to unsupported charset!", icne);
						        	throw new RuntimeException(new CSSException("Unsupported charset: " + enc));
						        }
						        catch (IOException e) {
			                log.warn("Could not change to unsupported charset!", e);
						        }
						 }
						 else
						      log.warn("Ignoring @charset rule not at the beginning of the style sheet");
				  
			}

			state.type = _type;
			state.channel = _channel;

				expectedToken.pop();

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CHARSET"

	// $ANTLR start "IMPORT"
	public final void mIMPORT() throws RecognitionException {
		try {
			int _type = IMPORT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			CommonToken s=null;
			CommonToken m=null;


				expectedToken.push(new Integer(IMPORT));
				StringBuilder media = new StringBuilder();
				String mText = null;

			// cz/vutbr/web/csskit/antlr/CSS.g:1126:2: ( '@import' ( S )* (s= STRING_MACR |s= URI ) ( S )* (m= IDENT_MACR ( S )* ( ',' ( S )* m= IDENT_MACR ( S )* )* )? SEMICOLON )
			// cz/vutbr/web/csskit/antlr/CSS.g:1126:4: '@import' ( S )* (s= STRING_MACR |s= URI ) ( S )* (m= IDENT_MACR ( S )* ( ',' ( S )* m= IDENT_MACR ( S )* )* )? SEMICOLON
			{
			match("@import"); 

			// cz/vutbr/web/csskit/antlr/CSS.g:1126:14: ( S )*
			loop3:
			while (true) {
				int alt3=2;
				int LA3_0 = input.LA(1);
				if ( ((LA3_0 >= '\t' && LA3_0 <= '\r')||LA3_0==' ') ) {
					alt3=1;
				}

				switch (alt3) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1126:14: S
					{
					mS(); 

					}
					break;

				default :
					break loop3;
				}
			}

			// cz/vutbr/web/csskit/antlr/CSS.g:1127:4: (s= STRING_MACR |s= URI )
			int alt4=2;
			int LA4_0 = input.LA(1);
			if ( (LA4_0=='\"'||LA4_0=='\'') ) {
				alt4=1;
			}
			else if ( (LA4_0=='u') ) {
				alt4=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}

			switch (alt4) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1127:5: s= STRING_MACR
					{
					int sStart124 = getCharIndex();
					int sStartLine124 = getLine();
					int sStartCharPos124 = getCharPositionInLine();
					mSTRING_MACR(); 
					s = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, sStart124, getCharIndex()-1);
					s.setLine(sStartLine124);
					s.setCharPositionInLine(sStartCharPos124);

					 s.setType(STRING);
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1128:7: s= URI
					{
					int sStart137 = getCharIndex();
					int sStartLine137 = getLine();
					int sStartCharPos137 = getCharPositionInLine();
					mURI(); 
					s = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, sStart137, getCharIndex()-1);
					s.setLine(sStartLine137);
					s.setCharPositionInLine(sStartCharPos137);

					s.setType(URI);
					}
					break;

			}

			// cz/vutbr/web/csskit/antlr/CSS.g:1128:33: ( S )*
			loop5:
			while (true) {
				int alt5=2;
				int LA5_0 = input.LA(1);
				if ( ((LA5_0 >= '\t' && LA5_0 <= '\r')||LA5_0==' ') ) {
					alt5=1;
				}

				switch (alt5) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1128:33: S
					{
					mS(); 

					}
					break;

				default :
					break loop5;
				}
			}

			// cz/vutbr/web/csskit/antlr/CSS.g:1129:6: (m= IDENT_MACR ( S )* ( ',' ( S )* m= IDENT_MACR ( S )* )* )?
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( ((LA10_0 >= 'A' && LA10_0 <= 'Z')||LA10_0=='\\'||LA10_0=='_'||(LA10_0 >= 'a' && LA10_0 <= 'z')||(LA10_0 >= '\u0080' && LA10_0 <= '\uD7FF')||(LA10_0 >= '\uE000' && LA10_0 <= '\uFFFD')) ) {
				alt10=1;
			}
			switch (alt10) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1129:7: m= IDENT_MACR ( S )* ( ',' ( S )* m= IDENT_MACR ( S )* )*
					{
					int mStart153 = getCharIndex();
					int mStartLine153 = getLine();
					int mStartCharPos153 = getCharPositionInLine();
					mIDENT_MACR(); 
					m = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, mStart153, getCharIndex()-1);
					m.setLine(mStartLine153);
					m.setCharPositionInLine(mStartCharPos153);

					 
						        mText = m.getText();
						    	if(css.isSupportedMedia(mText)) 
						    		media.append(mText); 
						    	else
						    	    log.debug("Invalid import media \"{}\"", mText);
						     
					// cz/vutbr/web/csskit/antlr/CSS.g:1136:7: ( S )*
					loop6:
					while (true) {
						int alt6=2;
						int LA6_0 = input.LA(1);
						if ( ((LA6_0 >= '\t' && LA6_0 <= '\r')||LA6_0==' ') ) {
							alt6=1;
						}

						switch (alt6) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1136:7: S
							{
							mS(); 

							}
							break;

						default :
							break loop6;
						}
					}

					// cz/vutbr/web/csskit/antlr/CSS.g:1137:9: ( ',' ( S )* m= IDENT_MACR ( S )* )*
					loop9:
					while (true) {
						int alt9=2;
						int LA9_0 = input.LA(1);
						if ( (LA9_0==',') ) {
							alt9=1;
						}

						switch (alt9) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1137:10: ',' ( S )* m= IDENT_MACR ( S )*
							{
							match(','); 
							// cz/vutbr/web/csskit/antlr/CSS.g:1137:14: ( S )*
							loop7:
							while (true) {
								int alt7=2;
								int LA7_0 = input.LA(1);
								if ( ((LA7_0 >= '\t' && LA7_0 <= '\r')||LA7_0==' ') ) {
									alt7=1;
								}

								switch (alt7) {
								case 1 :
									// cz/vutbr/web/csskit/antlr/CSS.g:1137:14: S
									{
									mS(); 

									}
									break;

								default :
									break loop7;
								}
							}

							int mStart184 = getCharIndex();
							int mStartLine184 = getLine();
							int mStartCharPos184 = getCharPositionInLine();
							mIDENT_MACR(); 
							m = new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, mStart184, getCharIndex()-1);
							m.setLine(mStartLine184);
							m.setCharPositionInLine(mStartCharPos184);

							 
								         mText = m.getText();
								       	 if(css.isSupportedMedia(mText)) 
								       	 		media.append(",").append(mText);
								       	 else
								    	    log.debug("Invalid import media \"{}\"", mText);		
								       	
							// cz/vutbr/web/csskit/antlr/CSS.g:1144:9: ( S )*
							loop8:
							while (true) {
								int alt8=2;
								int LA8_0 = input.LA(1);
								if ( ((LA8_0 >= '\t' && LA8_0 <= '\r')||LA8_0==' ') ) {
									alt8=1;
								}

								switch (alt8) {
								case 1 :
									// cz/vutbr/web/csskit/antlr/CSS.g:1144:9: S
									{
									mS(); 

									}
									break;

								default :
									break loop8;
								}
							}

							}
							break;

						default :
							break loop9;
						}
					}

					}
					break;

			}

			mSEMICOLON(); 


					    // do some funny work with file name to be imported
			        String fileName = s.getText();
			        log.debug("FILE: " + fileName);
			            	  	
			        if(s.getType()==STRING) 
			        	fileName = CSSToken.extractSTRING(fileName);
			        else
			        	fileName = CSSToken.extractURI(fileName);
			            	  	
			        log.info("Will import file \"{}\" with media: {}", 
			          		fileName, media.toString());           	  	
			            	  	
			        // import file
			        URL url = null;
			        try {
			        		    // construct URL
			        		    log.debug("BASE: " + ((CSSInputStream) input).getBase());
			        		    URL base = ((CSSInputStream) input).getBase();
			        		    if (base != null)
			              	    url = DataURLHandler.createURL(base, fileName);
			              	else
			              	{
			              	    log.warn("Base URL is unknown");
			                    url = DataURLHandler.createURL(base, fileName);
			              	}
			              	               			
			              	log.debug("Actually, will try to import file \"{}\"", url.toString());	
			              			
			                // save current lexer's stream
			                LexerStream stream = new LexerStream(input, ls);
			                imports.push(stream);
			                    	
			                CSSToken t = new CSSToken(IMPORT, ls);
			                t.setText(media.toString());
			                    	
			                // switch on new stream
			                String enc = ((CSSInputStream) input).getEncoding();
			                setCharStream(CSSInputStream.urlStream(url, enc));
			                reset();
			                    	
			                log.info("File \"{}\" was imported.", url.toString());
			                emit(t);
			         }
			         catch(MalformedURLException mue) {
			         		log.warn("Unable to construct URL for fileName", fileName); 
			              	// set type to invalid import
			                _type = INVALID_IMPORT;
			                setText("INVALID_IMPORT");
			         }              		 
			         catch(IOException fnf) {
			         		log.warn("Cannot read \"{}\" to import: {}", fileName, fnf.getMessage());
			                // restore state
			                imports.pop();
			                // set type to invalid import
			                _type = INVALID_IMPORT;
			                setText("INVALID_IMPORT");
			          }
				
			}

			state.type = _type;
			state.channel = _channel;

				expectedToken.pop();

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IMPORT"

	// $ANTLR start "MEDIA"
	public final void mMEDIA() throws RecognitionException {
		try {
			int _type = MEDIA;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1209:2: ( '@media' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1209:4: '@media'
			{
			match("@media"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MEDIA"

	// $ANTLR start "PAGE"
	public final void mPAGE() throws RecognitionException {
		try {
			int _type = PAGE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1213:2: ( '@page' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1213:4: '@page'
			{
			match("@page"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PAGE"

	// $ANTLR start "MARGIN_AREA"
	public final void mMARGIN_AREA() throws RecognitionException {
		try {
			int _type = MARGIN_AREA;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1217:3: ( '@top-left-corner' | '@top-left' | '@top-center' | '@top-right' | '@top-right-corner' | '@bottom-left-corner' | '@bottom-left' | '@bottom-center' | '@bottom-right' | '@bottom-right-corner' | '@left-top' | '@left-middle' | '@left-bottom' | '@right-top' | '@right-middle' | '@right-bottom' )
			int alt11=16;
			int LA11_0 = input.LA(1);
			if ( (LA11_0=='@') ) {
				switch ( input.LA(2) ) {
				case 't':
					{
					int LA11_2 = input.LA(3);
					if ( (LA11_2=='o') ) {
						int LA11_6 = input.LA(4);
						if ( (LA11_6=='p') ) {
							int LA11_10 = input.LA(5);
							if ( (LA11_10=='-') ) {
								switch ( input.LA(6) ) {
								case 'l':
									{
									int LA11_18 = input.LA(7);
									if ( (LA11_18=='e') ) {
										int LA11_24 = input.LA(8);
										if ( (LA11_24=='f') ) {
											int LA11_31 = input.LA(9);
											if ( (LA11_31=='t') ) {
												int LA11_37 = input.LA(10);
												if ( (LA11_37=='-') ) {
													alt11=1;
												}

												else {
													alt11=2;
												}

											}

											else {
												int nvaeMark = input.mark();
												try {
													for (int nvaeConsume = 0; nvaeConsume < 9 - 1; nvaeConsume++) {
														input.consume();
													}
													NoViableAltException nvae =
														new NoViableAltException("", 11, 31, input);
													throw nvae;
												} finally {
													input.rewind(nvaeMark);
												}
											}

										}

										else {
											int nvaeMark = input.mark();
											try {
												for (int nvaeConsume = 0; nvaeConsume < 8 - 1; nvaeConsume++) {
													input.consume();
												}
												NoViableAltException nvae =
													new NoViableAltException("", 11, 24, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 7 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 11, 18, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

									}
									break;
								case 'c':
									{
									alt11=3;
									}
									break;
								case 'r':
									{
									int LA11_20 = input.LA(7);
									if ( (LA11_20=='i') ) {
										int LA11_25 = input.LA(8);
										if ( (LA11_25=='g') ) {
											int LA11_32 = input.LA(9);
											if ( (LA11_32=='h') ) {
												int LA11_38 = input.LA(10);
												if ( (LA11_38=='t') ) {
													int LA11_44 = input.LA(11);
													if ( (LA11_44=='-') ) {
														alt11=5;
													}

													else {
														alt11=4;
													}

												}

												else {
													int nvaeMark = input.mark();
													try {
														for (int nvaeConsume = 0; nvaeConsume < 10 - 1; nvaeConsume++) {
															input.consume();
														}
														NoViableAltException nvae =
															new NoViableAltException("", 11, 38, input);
														throw nvae;
													} finally {
														input.rewind(nvaeMark);
													}
												}

											}

											else {
												int nvaeMark = input.mark();
												try {
													for (int nvaeConsume = 0; nvaeConsume < 9 - 1; nvaeConsume++) {
														input.consume();
													}
													NoViableAltException nvae =
														new NoViableAltException("", 11, 32, input);
													throw nvae;
												} finally {
													input.rewind(nvaeMark);
												}
											}

										}

										else {
											int nvaeMark = input.mark();
											try {
												for (int nvaeConsume = 0; nvaeConsume < 8 - 1; nvaeConsume++) {
													input.consume();
												}
												NoViableAltException nvae =
													new NoViableAltException("", 11, 25, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 7 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 11, 20, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

									}
									break;
								default:
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 11, 14, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}
							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 11, 10, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 11, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 11, 2, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case 'b':
					{
					int LA11_3 = input.LA(3);
					if ( (LA11_3=='o') ) {
						int LA11_7 = input.LA(4);
						if ( (LA11_7=='t') ) {
							int LA11_11 = input.LA(5);
							if ( (LA11_11=='t') ) {
								int LA11_15 = input.LA(6);
								if ( (LA11_15=='o') ) {
									int LA11_21 = input.LA(7);
									if ( (LA11_21=='m') ) {
										int LA11_26 = input.LA(8);
										if ( (LA11_26=='-') ) {
											switch ( input.LA(9) ) {
											case 'l':
												{
												int LA11_39 = input.LA(10);
												if ( (LA11_39=='e') ) {
													int LA11_45 = input.LA(11);
													if ( (LA11_45=='f') ) {
														int LA11_49 = input.LA(12);
														if ( (LA11_49=='t') ) {
															int LA11_51 = input.LA(13);
															if ( (LA11_51=='-') ) {
																alt11=6;
															}

															else {
																alt11=7;
															}

														}

														else {
															int nvaeMark = input.mark();
															try {
																for (int nvaeConsume = 0; nvaeConsume < 12 - 1; nvaeConsume++) {
																	input.consume();
																}
																NoViableAltException nvae =
																	new NoViableAltException("", 11, 49, input);
																throw nvae;
															} finally {
																input.rewind(nvaeMark);
															}
														}

													}

													else {
														int nvaeMark = input.mark();
														try {
															for (int nvaeConsume = 0; nvaeConsume < 11 - 1; nvaeConsume++) {
																input.consume();
															}
															NoViableAltException nvae =
																new NoViableAltException("", 11, 45, input);
															throw nvae;
														} finally {
															input.rewind(nvaeMark);
														}
													}

												}

												else {
													int nvaeMark = input.mark();
													try {
														for (int nvaeConsume = 0; nvaeConsume < 10 - 1; nvaeConsume++) {
															input.consume();
														}
														NoViableAltException nvae =
															new NoViableAltException("", 11, 39, input);
														throw nvae;
													} finally {
														input.rewind(nvaeMark);
													}
												}

												}
												break;
											case 'c':
												{
												alt11=8;
												}
												break;
											case 'r':
												{
												int LA11_41 = input.LA(10);
												if ( (LA11_41=='i') ) {
													int LA11_46 = input.LA(11);
													if ( (LA11_46=='g') ) {
														int LA11_50 = input.LA(12);
														if ( (LA11_50=='h') ) {
															int LA11_52 = input.LA(13);
															if ( (LA11_52=='t') ) {
																int LA11_55 = input.LA(14);
																if ( (LA11_55=='-') ) {
																	alt11=10;
																}

																else {
																	alt11=9;
																}

															}

															else {
																int nvaeMark = input.mark();
																try {
																	for (int nvaeConsume = 0; nvaeConsume < 13 - 1; nvaeConsume++) {
																		input.consume();
																	}
																	NoViableAltException nvae =
																		new NoViableAltException("", 11, 52, input);
																	throw nvae;
																} finally {
																	input.rewind(nvaeMark);
																}
															}

														}

														else {
															int nvaeMark = input.mark();
															try {
																for (int nvaeConsume = 0; nvaeConsume < 12 - 1; nvaeConsume++) {
																	input.consume();
																}
																NoViableAltException nvae =
																	new NoViableAltException("", 11, 50, input);
																throw nvae;
															} finally {
																input.rewind(nvaeMark);
															}
														}

													}

													else {
														int nvaeMark = input.mark();
														try {
															for (int nvaeConsume = 0; nvaeConsume < 11 - 1; nvaeConsume++) {
																input.consume();
															}
															NoViableAltException nvae =
																new NoViableAltException("", 11, 46, input);
															throw nvae;
														} finally {
															input.rewind(nvaeMark);
														}
													}

												}

												else {
													int nvaeMark = input.mark();
													try {
														for (int nvaeConsume = 0; nvaeConsume < 10 - 1; nvaeConsume++) {
															input.consume();
														}
														NoViableAltException nvae =
															new NoViableAltException("", 11, 41, input);
														throw nvae;
													} finally {
														input.rewind(nvaeMark);
													}
												}

												}
												break;
											default:
												int nvaeMark = input.mark();
												try {
													for (int nvaeConsume = 0; nvaeConsume < 9 - 1; nvaeConsume++) {
														input.consume();
													}
													NoViableAltException nvae =
														new NoViableAltException("", 11, 33, input);
													throw nvae;
												} finally {
													input.rewind(nvaeMark);
												}
											}
										}

										else {
											int nvaeMark = input.mark();
											try {
												for (int nvaeConsume = 0; nvaeConsume < 8 - 1; nvaeConsume++) {
													input.consume();
												}
												NoViableAltException nvae =
													new NoViableAltException("", 11, 26, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}

									}

									else {
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 7 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 11, 21, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 11, 15, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 11, 11, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 11, 7, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 11, 3, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case 'l':
					{
					int LA11_4 = input.LA(3);
					if ( (LA11_4=='e') ) {
						int LA11_8 = input.LA(4);
						if ( (LA11_8=='f') ) {
							int LA11_12 = input.LA(5);
							if ( (LA11_12=='t') ) {
								int LA11_16 = input.LA(6);
								if ( (LA11_16=='-') ) {
									switch ( input.LA(7) ) {
									case 't':
										{
										alt11=11;
										}
										break;
									case 'm':
										{
										alt11=12;
										}
										break;
									case 'b':
										{
										alt11=13;
										}
										break;
									default:
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 7 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 11, 22, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}
								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 11, 16, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 11, 12, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 11, 8, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 11, 4, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				case 'r':
					{
					int LA11_5 = input.LA(3);
					if ( (LA11_5=='i') ) {
						int LA11_9 = input.LA(4);
						if ( (LA11_9=='g') ) {
							int LA11_13 = input.LA(5);
							if ( (LA11_13=='h') ) {
								int LA11_17 = input.LA(6);
								if ( (LA11_17=='t') ) {
									int LA11_23 = input.LA(7);
									if ( (LA11_23=='-') ) {
										switch ( input.LA(8) ) {
										case 't':
											{
											alt11=14;
											}
											break;
										case 'm':
											{
											alt11=15;
											}
											break;
										case 'b':
											{
											alt11=16;
											}
											break;
										default:
											int nvaeMark = input.mark();
											try {
												for (int nvaeConsume = 0; nvaeConsume < 8 - 1; nvaeConsume++) {
													input.consume();
												}
												NoViableAltException nvae =
													new NoViableAltException("", 11, 30, input);
												throw nvae;
											} finally {
												input.rewind(nvaeMark);
											}
										}
									}

									else {
										int nvaeMark = input.mark();
										try {
											for (int nvaeConsume = 0; nvaeConsume < 7 - 1; nvaeConsume++) {
												input.consume();
											}
											NoViableAltException nvae =
												new NoViableAltException("", 11, 23, input);
											throw nvae;
										} finally {
											input.rewind(nvaeMark);
										}
									}

								}

								else {
									int nvaeMark = input.mark();
									try {
										for (int nvaeConsume = 0; nvaeConsume < 6 - 1; nvaeConsume++) {
											input.consume();
										}
										NoViableAltException nvae =
											new NoViableAltException("", 11, 17, input);
										throw nvae;
									} finally {
										input.rewind(nvaeMark);
									}
								}

							}

							else {
								int nvaeMark = input.mark();
								try {
									for (int nvaeConsume = 0; nvaeConsume < 5 - 1; nvaeConsume++) {
										input.consume();
									}
									NoViableAltException nvae =
										new NoViableAltException("", 11, 13, input);
									throw nvae;
								} finally {
									input.rewind(nvaeMark);
								}
							}

						}

						else {
							int nvaeMark = input.mark();
							try {
								for (int nvaeConsume = 0; nvaeConsume < 4 - 1; nvaeConsume++) {
									input.consume();
								}
								NoViableAltException nvae =
									new NoViableAltException("", 11, 9, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						int nvaeMark = input.mark();
						try {
							for (int nvaeConsume = 0; nvaeConsume < 3 - 1; nvaeConsume++) {
								input.consume();
							}
							NoViableAltException nvae =
								new NoViableAltException("", 11, 5, input);
							throw nvae;
						} finally {
							input.rewind(nvaeMark);
						}
					}

					}
					break;
				default:
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 11, 1, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 11, 0, input);
				throw nvae;
			}

			switch (alt11) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1217:5: '@top-left-corner'
					{
					match("@top-left-corner"); 

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1218:5: '@top-left'
					{
					match("@top-left"); 

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1219:5: '@top-center'
					{
					match("@top-center"); 

					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1220:5: '@top-right'
					{
					match("@top-right"); 

					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1221:5: '@top-right-corner'
					{
					match("@top-right-corner"); 

					}
					break;
				case 6 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1222:5: '@bottom-left-corner'
					{
					match("@bottom-left-corner"); 

					}
					break;
				case 7 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1223:5: '@bottom-left'
					{
					match("@bottom-left"); 

					}
					break;
				case 8 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1224:5: '@bottom-center'
					{
					match("@bottom-center"); 

					}
					break;
				case 9 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1225:5: '@bottom-right'
					{
					match("@bottom-right"); 

					}
					break;
				case 10 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1226:5: '@bottom-right-corner'
					{
					match("@bottom-right-corner"); 

					}
					break;
				case 11 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1227:5: '@left-top'
					{
					match("@left-top"); 

					}
					break;
				case 12 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1228:5: '@left-middle'
					{
					match("@left-middle"); 

					}
					break;
				case 13 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1229:5: '@left-bottom'
					{
					match("@left-bottom"); 

					}
					break;
				case 14 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1230:5: '@right-top'
					{
					match("@right-top"); 

					}
					break;
				case 15 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1231:5: '@right-middle'
					{
					match("@right-middle"); 

					}
					break;
				case 16 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1232:5: '@right-bottom'
					{
					match("@right-bottom"); 

					}
					break;

			}
			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MARGIN_AREA"

	// $ANTLR start "VIEWPORT"
	public final void mVIEWPORT() throws RecognitionException {
		try {
			int _type = VIEWPORT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1236:3: ( '@viewport' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1236:5: '@viewport'
			{
			match("@viewport"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "VIEWPORT"

	// $ANTLR start "FONTFACE"
	public final void mFONTFACE() throws RecognitionException {
		try {
			int _type = FONTFACE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1240:3: ( '@font-face' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1240:5: '@font-face'
			{
			match("@font-face"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FONTFACE"

	// $ANTLR start "ATKEYWORD"
	public final void mATKEYWORD() throws RecognitionException {
		try {
			int _type = ATKEYWORD;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1246:2: ( '@' ( MINUS )? ( IDENT_MACR )? )
			// cz/vutbr/web/csskit/antlr/CSS.g:1246:4: '@' ( MINUS )? ( IDENT_MACR )?
			{
			match('@'); 
			// cz/vutbr/web/csskit/antlr/CSS.g:1246:8: ( MINUS )?
			int alt12=2;
			int LA12_0 = input.LA(1);
			if ( (LA12_0=='-') ) {
				alt12=1;
			}
			switch (alt12) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:
					{
					if ( input.LA(1)=='-' ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

			}

			// cz/vutbr/web/csskit/antlr/CSS.g:1246:15: ( IDENT_MACR )?
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( ((LA13_0 >= 'A' && LA13_0 <= 'Z')||LA13_0=='\\'||LA13_0=='_'||(LA13_0 >= 'a' && LA13_0 <= 'z')||(LA13_0 >= '\u0080' && LA13_0 <= '\uD7FF')||(LA13_0 >= '\uE000' && LA13_0 <= '\uFFFD')) ) {
				alt13=1;
			}
			switch (alt13) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1246:15: IDENT_MACR
					{
					mIDENT_MACR(); 

					}
					break;

			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ATKEYWORD"

	// $ANTLR start "CLASSKEYWORD"
	public final void mCLASSKEYWORD() throws RecognitionException {
		try {
			int _type = CLASSKEYWORD;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1249:5: ( '.' IDENT_MACR )
			// cz/vutbr/web/csskit/antlr/CSS.g:1249:7: '.' IDENT_MACR
			{
			match('.'); 
			mIDENT_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CLASSKEYWORD"

	// $ANTLR start "STRING"
	public final void mSTRING() throws RecognitionException {
		try {
			int _type = STRING;
			int _channel = DEFAULT_TOKEN_CHANNEL;

				expectedToken.push(new Integer(STRING));

			// cz/vutbr/web/csskit/antlr/CSS.g:1261:2: ( STRING_MACR )
			// cz/vutbr/web/csskit/antlr/CSS.g:1261:4: STRING_MACR
			{
			mSTRING_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;

				expectedToken.pop();

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STRING"

	// $ANTLR start "HASH"
	public final void mHASH() throws RecognitionException {
		try {
			int _type = HASH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1266:2: ( '#' NAME_MACR )
			// cz/vutbr/web/csskit/antlr/CSS.g:1266:4: '#' NAME_MACR
			{
			match('#'); 
			mNAME_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "HASH"

	// $ANTLR start "INDEX"
	public final void mINDEX() throws RecognitionException {
		try {
			int _type = INDEX;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1271:3: ( ( INTEGER_MACR )? ( 'N' | 'n' ) ( ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR )? )
			// cz/vutbr/web/csskit/antlr/CSS.g:1271:5: ( INTEGER_MACR )? ( 'N' | 'n' ) ( ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR )?
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1271:5: ( INTEGER_MACR )?
			int alt14=2;
			int LA14_0 = input.LA(1);
			if ( ((LA14_0 >= '0' && LA14_0 <= '9')) ) {
				alt14=1;
			}
			switch (alt14) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1271:5: INTEGER_MACR
					{
					mINTEGER_MACR(); 

					}
					break;

			}

			if ( input.LA(1)=='N'||input.LA(1)=='n' ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			// cz/vutbr/web/csskit/antlr/CSS.g:1271:31: ( ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( ((LA17_0 >= '\t' && LA17_0 <= '\r')||LA17_0==' '||LA17_0=='+'||LA17_0=='-') ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1271:32: ( S )* ( PLUS | MINUS ) ( S )* INTEGER_MACR
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:1271:32: ( S )*
					loop15:
					while (true) {
						int alt15=2;
						int LA15_0 = input.LA(1);
						if ( ((LA15_0 >= '\t' && LA15_0 <= '\r')||LA15_0==' ') ) {
							alt15=1;
						}

						switch (alt15) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1271:32: S
							{
							mS(); 

							}
							break;

						default :
							break loop15;
						}
					}

					if ( input.LA(1)=='+'||input.LA(1)=='-' ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					// cz/vutbr/web/csskit/antlr/CSS.g:1271:50: ( S )*
					loop16:
					while (true) {
						int alt16=2;
						int LA16_0 = input.LA(1);
						if ( ((LA16_0 >= '\t' && LA16_0 <= '\r')||LA16_0==' ') ) {
							alt16=1;
						}

						switch (alt16) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1271:50: S
							{
							mS(); 

							}
							break;

						default :
							break loop16;
						}
					}

					mINTEGER_MACR(); 

					}
					break;

			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INDEX"

	// $ANTLR start "NUMBER"
	public final void mNUMBER() throws RecognitionException {
		try {
			int _type = NUMBER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1276:2: ( NUMBER_MACR )
			// cz/vutbr/web/csskit/antlr/CSS.g:1276:4: NUMBER_MACR
			{
			mNUMBER_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NUMBER"

	// $ANTLR start "PERCENTAGE"
	public final void mPERCENTAGE() throws RecognitionException {
		try {
			int _type = PERCENTAGE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1281:2: ( NUMBER_MACR '%' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1281:4: NUMBER_MACR '%'
			{
			mNUMBER_MACR(); 

			match('%'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PERCENTAGE"

	// $ANTLR start "DIMENSION"
	public final void mDIMENSION() throws RecognitionException {
		try {
			int _type = DIMENSION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1286:2: ( NUMBER_MACR IDENT_MACR )
			// cz/vutbr/web/csskit/antlr/CSS.g:1286:4: NUMBER_MACR IDENT_MACR
			{
			mNUMBER_MACR(); 

			mIDENT_MACR(); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DIMENSION"

	// $ANTLR start "URI"
	public final void mURI() throws RecognitionException {
		try {
			int _type = URI;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1291:2: ( 'url(' W_MACR ( STRING_MACR | URI_MACR ) W_MACR ')' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1291:4: 'url(' W_MACR ( STRING_MACR | URI_MACR ) W_MACR ')'
			{
			match("url("); 

			mW_MACR(); 

			// cz/vutbr/web/csskit/antlr/CSS.g:1291:18: ( STRING_MACR | URI_MACR )
			int alt18=2;
			int LA18_0 = input.LA(1);
			if ( (LA18_0=='\"'||LA18_0=='\'') ) {
				alt18=1;
			}
			else if ( ((LA18_0 >= '\t' && LA18_0 <= '\r')||(LA18_0 >= ' ' && LA18_0 <= '!')||(LA18_0 >= '#' && LA18_0 <= '&')||(LA18_0 >= ')' && LA18_0 <= '~')||(LA18_0 >= '\u0080' && LA18_0 <= '\uD7FF')||(LA18_0 >= '\uE000' && LA18_0 <= '\uFFFD')) ) {
				alt18=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 18, 0, input);
				throw nvae;
			}

			switch (alt18) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1291:19: STRING_MACR
					{
					mSTRING_MACR(); 

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1291:33: URI_MACR
					{
					mURI_MACR(); 

					}
					break;

			}

			mW_MACR(); 

			match(')'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "URI"

	// $ANTLR start "UNIRANGE"
	public final void mUNIRANGE() throws RecognitionException {
		try {
			int _type = UNIRANGE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1295:9: ( 'U+' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) )? ( '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )? )
			// cz/vutbr/web/csskit/antlr/CSS.g:1296:2: 'U+' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) )? ( '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )?
			{
			match("U+"); 

			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			// cz/vutbr/web/csskit/antlr/CSS.g:1300:7: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) )?
			int alt19=2;
			int LA19_0 = input.LA(1);
			if ( ((LA19_0 >= '0' && LA19_0 <= '9')||LA19_0=='?'||(LA19_0 >= 'A' && LA19_0 <= 'F')||(LA19_0 >= 'a' && LA19_0 <= 'f')) ) {
				alt19=1;
			}
			switch (alt19) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1300:8: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' | '?' )
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||input.LA(1)=='?'||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

			}

			// cz/vutbr/web/csskit/antlr/CSS.g:1301:2: ( '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )?
			int alt21=2;
			int LA21_0 = input.LA(1);
			if ( (LA21_0=='-') ) {
				alt21=1;
			}
			switch (alt21) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1301:3: '-' ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )?
					{
					match('-'); 
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					// cz/vutbr/web/csskit/antlr/CSS.g:1306:14: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )?
					int alt20=2;
					int LA20_0 = input.LA(1);
					if ( ((LA20_0 >= '0' && LA20_0 <= '9')||(LA20_0 >= 'A' && LA20_0 <= 'F')||(LA20_0 >= 'a' && LA20_0 <= 'f')) ) {
						alt20=1;
					}
					switch (alt20) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1306:15: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

					}

					}
					break;

			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "UNIRANGE"

	// $ANTLR start "CDO"
	public final void mCDO() throws RecognitionException {
		try {
			int _type = CDO;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1312:2: ( '<!--' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1312:4: '<!--'
			{
			match("<!--"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CDO"

	// $ANTLR start "CDC"
	public final void mCDC() throws RecognitionException {
		try {
			int _type = CDC;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1317:2: ( '-->' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1317:4: '-->'
			{
			match("-->"); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CDC"

	// $ANTLR start "SEMICOLON"
	public final void mSEMICOLON() throws RecognitionException {
		try {
			int _type = SEMICOLON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1320:2: ( ';' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1320:4: ';'
			{
			match(';'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SEMICOLON"

	// $ANTLR start "COLON"
	public final void mCOLON() throws RecognitionException {
		try {
			int _type = COLON;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1324:2: ( ':' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1324:4: ':'
			{
			match(':'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COLON"

	// $ANTLR start "COMMA"
	public final void mCOMMA() throws RecognitionException {
		try {
			int _type = COMMA;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1328:5: ( ',' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1328:7: ','
			{
			match(','); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COMMA"

	// $ANTLR start "QUESTION"
	public final void mQUESTION() throws RecognitionException {
		try {
			int _type = QUESTION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1332:2: ( '?' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1332:4: '?'
			{
			match('?'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "QUESTION"

	// $ANTLR start "PERCENT"
	public final void mPERCENT() throws RecognitionException {
		try {
			int _type = PERCENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1336:2: ( '%' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1336:4: '%'
			{
			match('%'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PERCENT"

	// $ANTLR start "EQUALS"
	public final void mEQUALS() throws RecognitionException {
		try {
			int _type = EQUALS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1340:5: ( '=' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1340:7: '='
			{
			match('='); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EQUALS"

	// $ANTLR start "SLASH"
	public final void mSLASH() throws RecognitionException {
		try {
			int _type = SLASH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1344:5: ( '/' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1344:7: '/'
			{
			match('/'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SLASH"

	// $ANTLR start "GREATER"
	public final void mGREATER() throws RecognitionException {
		try {
			int _type = GREATER;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1348:5: ( '>' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1348:7: '>'
			{
			match('>'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "GREATER"

	// $ANTLR start "LESS"
	public final void mLESS() throws RecognitionException {
		try {
			int _type = LESS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1352:5: ( '<' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1352:7: '<'
			{
			match('<'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LESS"

	// $ANTLR start "LCURLY"
	public final void mLCURLY() throws RecognitionException {
		try {
			int _type = LCURLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1356:2: ( '{' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1356:4: '{'
			{
			match('{'); 
			ls.curlyNest++;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LCURLY"

	// $ANTLR start "RCURLY"
	public final void mRCURLY() throws RecognitionException {
		try {
			int _type = RCURLY;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1360:2: ( '}' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1360:4: '}'
			{
			match('}'); 
			 if(ls.curlyNest>0) ls.curlyNest--;
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RCURLY"

	// $ANTLR start "APOS"
	public final void mAPOS() throws RecognitionException {
		try {
			int _type = APOS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1364:2: ( '\\'' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1364:4: '\\''
			{
			match('\''); 
			 ls.aposOpen=!ls.aposOpen; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "APOS"

	// $ANTLR start "QUOT"
	public final void mQUOT() throws RecognitionException {
		try {
			int _type = QUOT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1368:2: ( '\"' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1368:4: '\"'
			{
			match('\"'); 
			 ls.quotOpen=!ls.quotOpen; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "QUOT"

	// $ANTLR start "LPAREN"
	public final void mLPAREN() throws RecognitionException {
		try {
			int _type = LPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1372:2: ( '(' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1372:4: '('
			{
			match('('); 
			ls.parenNest++; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LPAREN"

	// $ANTLR start "RPAREN"
	public final void mRPAREN() throws RecognitionException {
		try {
			int _type = RPAREN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1376:2: ( ')' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1376:4: ')'
			{
			match(')'); 
			 if(ls.parenNest>0) ls.parenNest--; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RPAREN"

	// $ANTLR start "LBRACE"
	public final void mLBRACE() throws RecognitionException {
		try {
			int _type = LBRACE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1380:2: ( '[' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1380:4: '['
			{
			match('['); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "LBRACE"

	// $ANTLR start "RBRACE"
	public final void mRBRACE() throws RecognitionException {
		try {
			int _type = RBRACE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1384:2: ( ']' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1384:4: ']'
			{
			match(']'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "RBRACE"

	// $ANTLR start "EXCLAMATION"
	public final void mEXCLAMATION() throws RecognitionException {
		try {
			int _type = EXCLAMATION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1388:5: ( '!' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1388:7: '!'
			{
			match('!'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EXCLAMATION"

	// $ANTLR start "TILDE"
	public final void mTILDE() throws RecognitionException {
		try {
			int _type = TILDE;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1392:3: ( '~' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1392:5: '~'
			{
			match('~'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "TILDE"

	// $ANTLR start "MINUS"
	public final void mMINUS() throws RecognitionException {
		try {
			int _type = MINUS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1396:2: ( '-' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1396:4: '-'
			{
			match('-'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "MINUS"

	// $ANTLR start "PLUS"
	public final void mPLUS() throws RecognitionException {
		try {
			int _type = PLUS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1400:2: ( '+' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1400:4: '+'
			{
			match('+'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "PLUS"

	// $ANTLR start "ASTERISK"
	public final void mASTERISK() throws RecognitionException {
		try {
			int _type = ASTERISK;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1404:2: ( '*' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1404:4: '*'
			{
			match('*'); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ASTERISK"

	// $ANTLR start "S"
	public final void mS() throws RecognitionException {
		try {
			int _type = S;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1410:2: ( ( W_CHAR )+ )
			// cz/vutbr/web/csskit/antlr/CSS.g:1410:4: ( W_CHAR )+
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1410:4: ( W_CHAR )+
			int cnt22=0;
			loop22:
			while (true) {
				int alt22=2;
				int LA22_0 = input.LA(1);
				if ( ((LA22_0 >= '\t' && LA22_0 <= '\r')||LA22_0==' ') ) {
					alt22=1;
				}

				switch (alt22) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:
					{
					if ( (input.LA(1) >= '\t' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt22 >= 1 ) break loop22;
					EarlyExitException eee = new EarlyExitException(22, input);
					throw eee;
				}
				cnt22++;
			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "S"

	// $ANTLR start "COMMENT"
	public final void mCOMMENT() throws RecognitionException {
		try {
			int _type = COMMENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1413:2: ( '/*' ( options {greedy=false; } : . )* '*/' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1413:4: '/*' ( options {greedy=false; } : . )* '*/'
			{
			match("/*"); 

			// cz/vutbr/web/csskit/antlr/CSS.g:1413:9: ( options {greedy=false; } : . )*
			loop23:
			while (true) {
				int alt23=2;
				int LA23_0 = input.LA(1);
				if ( (LA23_0=='*') ) {
					int LA23_1 = input.LA(2);
					if ( (LA23_1=='/') ) {
						alt23=2;
					}
					else if ( ((LA23_1 >= '\u0000' && LA23_1 <= '.')||(LA23_1 >= '0' && LA23_1 <= '\uFFFF')) ) {
						alt23=1;
					}

				}
				else if ( ((LA23_0 >= '\u0000' && LA23_0 <= ')')||(LA23_0 >= '+' && LA23_0 <= '\uFFFF')) ) {
					alt23=1;
				}

				switch (alt23) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1413:37: .
					{
					matchAny(); 
					}
					break;

				default :
					break loop23;
				}
			}

			match("*/"); 

			 _channel = HIDDEN; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "COMMENT"

	// $ANTLR start "SL_COMMENT"
	public final void mSL_COMMENT() throws RecognitionException {
		try {
			int _type = SL_COMMENT;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1417:2: ( '//' ( options {greedy=false; } : . )* ( '\\n' | '\\r' ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:1417:4: '//' ( options {greedy=false; } : . )* ( '\\n' | '\\r' )
			{
			match("//"); 

			// cz/vutbr/web/csskit/antlr/CSS.g:1417:9: ( options {greedy=false; } : . )*
			loop24:
			while (true) {
				int alt24=2;
				int LA24_0 = input.LA(1);
				if ( (LA24_0=='\n'||LA24_0=='\r') ) {
					alt24=2;
				}
				else if ( ((LA24_0 >= '\u0000' && LA24_0 <= '\t')||(LA24_0 >= '\u000B' && LA24_0 <= '\f')||(LA24_0 >= '\u000E' && LA24_0 <= '\uFFFF')) ) {
					alt24=1;
				}

				switch (alt24) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1417:37: .
					{
					matchAny(); 
					}
					break;

				default :
					break loop24;
				}
			}

			if ( input.LA(1)=='\n'||input.LA(1)=='\r' ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			 _channel=HIDDEN; 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "SL_COMMENT"

	// $ANTLR start "EXPRESSION"
	public final void mEXPRESSION() throws RecognitionException {
		try {
			int _type = EXPRESSION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1423:3: ( 'expression(' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1423:5: 'expression('
			{
			match("expression("); 

			 readExpressionContents(); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "EXPRESSION"

	// $ANTLR start "FUNCTION"
	public final void mFUNCTION() throws RecognitionException {
		try {
			int _type = FUNCTION;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1428:2: ( IDENT_MACR '(' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1428:4: IDENT_MACR '('
			{
			mIDENT_MACR(); 

			match('('); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "FUNCTION"

	// $ANTLR start "INCLUDES"
	public final void mINCLUDES() throws RecognitionException {
		try {
			int _type = INCLUDES;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1431:2: ( '~=' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1431:4: '~='
			{
			match("~="); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INCLUDES"

	// $ANTLR start "DASHMATCH"
	public final void mDASHMATCH() throws RecognitionException {
		try {
			int _type = DASHMATCH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1435:2: ( '|=' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1435:4: '|='
			{
			match("|="); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "DASHMATCH"

	// $ANTLR start "STARTSWITH"
	public final void mSTARTSWITH() throws RecognitionException {
		try {
			int _type = STARTSWITH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1439:3: ( '^=' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1439:5: '^='
			{
			match("^="); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STARTSWITH"

	// $ANTLR start "ENDSWITH"
	public final void mENDSWITH() throws RecognitionException {
		try {
			int _type = ENDSWITH;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1443:3: ( '$=' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1443:5: '$='
			{
			match("$="); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ENDSWITH"

	// $ANTLR start "CONTAINS"
	public final void mCONTAINS() throws RecognitionException {
		try {
			int _type = CONTAINS;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1447:3: ( '*=' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1447:5: '*='
			{
			match("*="); 

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CONTAINS"

	// $ANTLR start "CTRL"
	public final void mCTRL() throws RecognitionException {
		try {
			int _type = CTRL;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1451:3: ( ( CTRL_CHAR )+ )
			// cz/vutbr/web/csskit/antlr/CSS.g:1451:5: ( CTRL_CHAR )+
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1451:5: ( CTRL_CHAR )+
			int cnt25=0;
			loop25:
			while (true) {
				int alt25=2;
				int LA25_0 = input.LA(1);
				if ( ((LA25_0 >= '\u0000' && LA25_0 <= '\b')||(LA25_0 >= '\u000E' && LA25_0 <= '\u001F')) ) {
					alt25=1;
				}

				switch (alt25) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:
					{
					if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\b')||(input.LA(1) >= '\u000E' && input.LA(1) <= '\u001F') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt25 >= 1 ) break loop25;
					EarlyExitException eee = new EarlyExitException(25, input);
					throw eee;
				}
				cnt25++;
			}

			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CTRL"

	// $ANTLR start "INVALID_TOKEN"
	public final void mINVALID_TOKEN() throws RecognitionException {
		try {
			int _type = INVALID_TOKEN;
			int _channel = DEFAULT_TOKEN_CHANNEL;
			// cz/vutbr/web/csskit/antlr/CSS.g:1455:2: ( . )
			// cz/vutbr/web/csskit/antlr/CSS.g:1455:4: .
			{
			matchAny(); 
			}

			state.type = _type;
			state.channel = _channel;
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INVALID_TOKEN"

	// $ANTLR start "IDENT_MACR"
	public final void mIDENT_MACR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1469:4: ( NAME_START ( NAME_CHAR )* )
			// cz/vutbr/web/csskit/antlr/CSS.g:1469:6: NAME_START ( NAME_CHAR )*
			{
			mNAME_START(); 

			// cz/vutbr/web/csskit/antlr/CSS.g:1469:17: ( NAME_CHAR )*
			loop26:
			while (true) {
				int alt26=2;
				int LA26_0 = input.LA(1);
				if ( (LA26_0=='-'||(LA26_0 >= '0' && LA26_0 <= '9')||(LA26_0 >= 'A' && LA26_0 <= 'Z')||LA26_0=='\\'||LA26_0=='_'||(LA26_0 >= 'a' && LA26_0 <= 'z')||(LA26_0 >= '\u0080' && LA26_0 <= '\uD7FF')||(LA26_0 >= '\uE000' && LA26_0 <= '\uFFFD')) ) {
					alt26=1;
				}

				switch (alt26) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1469:17: NAME_CHAR
					{
					mNAME_CHAR(); 

					}
					break;

				default :
					break loop26;
				}
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "IDENT_MACR"

	// $ANTLR start "NAME_MACR"
	public final void mNAME_MACR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1470:3: ( ( NAME_CHAR )+ )
			// cz/vutbr/web/csskit/antlr/CSS.g:1470:5: ( NAME_CHAR )+
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1470:5: ( NAME_CHAR )+
			int cnt27=0;
			loop27:
			while (true) {
				int alt27=2;
				int LA27_0 = input.LA(1);
				if ( (LA27_0=='-'||(LA27_0 >= '0' && LA27_0 <= '9')||(LA27_0 >= 'A' && LA27_0 <= 'Z')||LA27_0=='\\'||LA27_0=='_'||(LA27_0 >= 'a' && LA27_0 <= 'z')||(LA27_0 >= '\u0080' && LA27_0 <= '\uD7FF')||(LA27_0 >= '\uE000' && LA27_0 <= '\uFFFD')) ) {
					alt27=1;
				}

				switch (alt27) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1470:5: NAME_CHAR
					{
					mNAME_CHAR(); 

					}
					break;

				default :
					if ( cnt27 >= 1 ) break loop27;
					EarlyExitException eee = new EarlyExitException(27, input);
					throw eee;
				}
				cnt27++;
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NAME_MACR"

	// $ANTLR start "NAME_START"
	public final void mNAME_START() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1475:4: ( ( 'a' .. 'z' | 'A' .. 'Z' | '_' | NON_ASCII | ESCAPE_CHAR ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:1475:6: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | NON_ASCII | ESCAPE_CHAR )
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1475:6: ( 'a' .. 'z' | 'A' .. 'Z' | '_' | NON_ASCII | ESCAPE_CHAR )
			int alt28=5;
			int LA28_0 = input.LA(1);
			if ( ((LA28_0 >= 'a' && LA28_0 <= 'z')) ) {
				alt28=1;
			}
			else if ( ((LA28_0 >= 'A' && LA28_0 <= 'Z')) ) {
				alt28=2;
			}
			else if ( (LA28_0=='_') ) {
				alt28=3;
			}
			else if ( ((LA28_0 >= '\u0080' && LA28_0 <= '\uD7FF')||(LA28_0 >= '\uE000' && LA28_0 <= '\uFFFD')) ) {
				alt28=4;
			}
			else if ( (LA28_0=='\\') ) {
				alt28=5;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 28, 0, input);
				throw nvae;
			}

			switch (alt28) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1475:7: 'a' .. 'z'
					{
					matchRange('a','z'); 
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1475:18: 'A' .. 'Z'
					{
					matchRange('A','Z'); 
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1475:29: '_'
					{
					match('_'); 
					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1475:35: NON_ASCII
					{
					mNON_ASCII(); 

					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1475:47: ESCAPE_CHAR
					{
					mESCAPE_CHAR(); 

					}
					break;

			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NAME_START"

	// $ANTLR start "NON_ASCII"
	public final void mNON_ASCII() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1480:4: ( ( '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:
			{
			if ( (input.LA(1) >= '\u0080' && input.LA(1) <= '\uD7FF')||(input.LA(1) >= '\uE000' && input.LA(1) <= '\uFFFD') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NON_ASCII"

	// $ANTLR start "ESCAPE_CHAR"
	public final void mESCAPE_CHAR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1485:3: ( ( '\\\\' ) ( ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? ) | ( '\\u0020' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:1485:5: ( '\\\\' ) ( ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? ) | ( '\\u0020' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) )
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1485:5: ( '\\\\' )
			// cz/vutbr/web/csskit/antlr/CSS.g:1485:6: '\\\\'
			{
			match('\\'); 
			}

			// cz/vutbr/web/csskit/antlr/CSS.g:1486:5: ( ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? ) | ( '\\u0020' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' ) )
			int alt30=2;
			int LA30_0 = input.LA(1);
			if ( ((LA30_0 >= '0' && LA30_0 <= '9')||(LA30_0 >= 'A' && LA30_0 <= 'F')||(LA30_0 >= 'a' && LA30_0 <= 'f')) ) {
				int LA30_1 = input.LA(2);
				if ( ((LA30_1 >= '0' && LA30_1 <= '9')||(LA30_1 >= 'A' && LA30_1 <= 'F')||(LA30_1 >= 'a' && LA30_1 <= 'f')) ) {
					alt30=1;
				}

				else {
					alt30=2;
				}

			}
			else if ( ((LA30_0 >= ' ' && LA30_0 <= '/')||(LA30_0 >= ':' && LA30_0 <= '@')||(LA30_0 >= 'G' && LA30_0 <= '`')||(LA30_0 >= 'g' && LA30_0 <= '~')||(LA30_0 >= '\u0080' && LA30_0 <= '\uD7FF')||(LA30_0 >= '\uE000' && LA30_0 <= '\uFFFD')) ) {
				alt30=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 30, 0, input);
				throw nvae;
			}

			switch (alt30) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1487:7: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:1487:7: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )? )
					// cz/vutbr/web/csskit/antlr/CSS.g:1487:8: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )?
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					// cz/vutbr/web/csskit/antlr/CSS.g:1491:8: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )?
					int alt29=2;
					int LA29_0 = input.LA(1);
					if ( ((LA29_0 >= '0' && LA29_0 <= '9')||(LA29_0 >= 'A' && LA29_0 <= 'F')||(LA29_0 >= 'a' && LA29_0 <= 'f')) ) {
						alt29=1;
					}
					switch (alt29) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1491:9: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

					}

					}

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1494:7: ( '\\u0020' .. '\\u007E' | '\\u0080' .. '\\uD7FF' | '\\uE000' .. '\\uFFFD' )
					{
					if ( (input.LA(1) >= ' ' && input.LA(1) <= '~')||(input.LA(1) >= '\u0080' && input.LA(1) <= '\uD7FF')||(input.LA(1) >= '\uE000' && input.LA(1) <= '\uFFFD') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "ESCAPE_CHAR"

	// $ANTLR start "NAME_CHAR"
	public final void mNAME_CHAR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1500:4: ( ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' | NON_ASCII | ESCAPE_CHAR ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:1500:6: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' | NON_ASCII | ESCAPE_CHAR )
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1500:6: ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | '-' | '_' | NON_ASCII | ESCAPE_CHAR )
			int alt31=7;
			int LA31_0 = input.LA(1);
			if ( ((LA31_0 >= 'a' && LA31_0 <= 'z')) ) {
				alt31=1;
			}
			else if ( ((LA31_0 >= 'A' && LA31_0 <= 'Z')) ) {
				alt31=2;
			}
			else if ( ((LA31_0 >= '0' && LA31_0 <= '9')) ) {
				alt31=3;
			}
			else if ( (LA31_0=='-') ) {
				alt31=4;
			}
			else if ( (LA31_0=='_') ) {
				alt31=5;
			}
			else if ( ((LA31_0 >= '\u0080' && LA31_0 <= '\uD7FF')||(LA31_0 >= '\uE000' && LA31_0 <= '\uFFFD')) ) {
				alt31=6;
			}
			else if ( (LA31_0=='\\') ) {
				alt31=7;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 31, 0, input);
				throw nvae;
			}

			switch (alt31) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1500:7: 'a' .. 'z'
					{
					matchRange('a','z'); 
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1500:18: 'A' .. 'Z'
					{
					matchRange('A','Z'); 
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1500:29: '0' .. '9'
					{
					matchRange('0','9'); 
					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1500:40: '-'
					{
					match('-'); 
					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1500:46: '_'
					{
					match('_'); 
					}
					break;
				case 6 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1500:52: NON_ASCII
					{
					mNON_ASCII(); 

					}
					break;
				case 7 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1500:64: ESCAPE_CHAR
					{
					mESCAPE_CHAR(); 

					}
					break;

			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NAME_CHAR"

	// $ANTLR start "INTEGER_MACR"
	public final void mINTEGER_MACR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1505:5: ( ( '0' .. '9' )+ )
			// cz/vutbr/web/csskit/antlr/CSS.g:1505:7: ( '0' .. '9' )+
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1505:7: ( '0' .. '9' )+
			int cnt32=0;
			loop32:
			while (true) {
				int alt32=2;
				int LA32_0 = input.LA(1);
				if ( ((LA32_0 >= '0' && LA32_0 <= '9')) ) {
					alt32=1;
				}

				switch (alt32) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:
					{
					if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					if ( cnt32 >= 1 ) break loop32;
					EarlyExitException eee = new EarlyExitException(32, input);
					throw eee;
				}
				cnt32++;
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "INTEGER_MACR"

	// $ANTLR start "NUMBER_MACR"
	public final void mNUMBER_MACR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1510:4: ( ( '0' .. '9' )+ | ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ ) )
			int alt36=2;
			alt36 = dfa36.predict(input);
			switch (alt36) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1510:6: ( '0' .. '9' )+
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:1510:6: ( '0' .. '9' )+
					int cnt33=0;
					loop33:
					while (true) {
						int alt33=2;
						int LA33_0 = input.LA(1);
						if ( ((LA33_0 >= '0' && LA33_0 <= '9')) ) {
							alt33=1;
						}

						switch (alt33) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

						default :
							if ( cnt33 >= 1 ) break loop33;
							EarlyExitException eee = new EarlyExitException(33, input);
							throw eee;
						}
						cnt33++;
					}

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1510:20: ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ )
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:1510:20: ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ )
					// cz/vutbr/web/csskit/antlr/CSS.g:1510:21: ( '0' .. '9' )* '.' ( '0' .. '9' )+
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:1510:21: ( '0' .. '9' )*
					loop34:
					while (true) {
						int alt34=2;
						int LA34_0 = input.LA(1);
						if ( ((LA34_0 >= '0' && LA34_0 <= '9')) ) {
							alt34=1;
						}

						switch (alt34) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

						default :
							break loop34;
						}
					}

					match('.'); 
					// cz/vutbr/web/csskit/antlr/CSS.g:1510:37: ( '0' .. '9' )+
					int cnt35=0;
					loop35:
					while (true) {
						int alt35=2;
						int LA35_0 = input.LA(1);
						if ( ((LA35_0 >= '0' && LA35_0 <= '9')) ) {
							alt35=1;
						}

						switch (alt35) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:
							{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
								input.consume();
							}
							else {
								MismatchedSetException mse = new MismatchedSetException(null,input);
								recover(mse);
								throw mse;
							}
							}
							break;

						default :
							if ( cnt35 >= 1 ) break loop35;
							EarlyExitException eee = new EarlyExitException(35, input);
							throw eee;
						}
						cnt35++;
					}

					}

					}
					break;

			}
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NUMBER_MACR"

	// $ANTLR start "STRING_MACR"
	public final void mSTRING_MACR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1515:2: ( QUOT ( STRING_CHAR | APOS )* QUOT | APOS ( STRING_CHAR | QUOT )* APOS )
			int alt39=2;
			int LA39_0 = input.LA(1);
			if ( (LA39_0=='\"') ) {
				alt39=1;
			}
			else if ( (LA39_0=='\'') ) {
				alt39=2;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 39, 0, input);
				throw nvae;
			}

			switch (alt39) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1515:4: QUOT ( STRING_CHAR | APOS )* QUOT
					{
					mQUOT(); 

					// cz/vutbr/web/csskit/antlr/CSS.g:1515:9: ( STRING_CHAR | APOS )*
					loop37:
					while (true) {
						int alt37=3;
						int LA37_0 = input.LA(1);
						if ( (LA37_0=='\t'||(LA37_0 >= ' ' && LA37_0 <= '!')||(LA37_0 >= '#' && LA37_0 <= '&')||(LA37_0 >= '(' && LA37_0 <= '~')||(LA37_0 >= '\u0080' && LA37_0 <= '\uD7FF')||(LA37_0 >= '\uE000' && LA37_0 <= '\uFFFD')) ) {
							alt37=1;
						}
						else if ( (LA37_0=='\'') ) {
							alt37=2;
						}

						switch (alt37) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1515:10: STRING_CHAR
							{
							mSTRING_CHAR(); 

							}
							break;
						case 2 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1515:24: APOS
							{
							mAPOS(); 

							ls.aposOpen=false;
							}
							break;

						default :
							break loop37;
						}
					}

					mQUOT(); 

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1516:4: APOS ( STRING_CHAR | QUOT )* APOS
					{
					mAPOS(); 

					// cz/vutbr/web/csskit/antlr/CSS.g:1516:9: ( STRING_CHAR | QUOT )*
					loop38:
					while (true) {
						int alt38=3;
						int LA38_0 = input.LA(1);
						if ( (LA38_0=='\t'||(LA38_0 >= ' ' && LA38_0 <= '!')||(LA38_0 >= '#' && LA38_0 <= '&')||(LA38_0 >= '(' && LA38_0 <= '~')||(LA38_0 >= '\u0080' && LA38_0 <= '\uD7FF')||(LA38_0 >= '\uE000' && LA38_0 <= '\uFFFD')) ) {
							alt38=1;
						}
						else if ( (LA38_0=='\"') ) {
							alt38=2;
						}

						switch (alt38) {
						case 1 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1516:10: STRING_CHAR
							{
							mSTRING_CHAR(); 

							}
							break;
						case 2 :
							// cz/vutbr/web/csskit/antlr/CSS.g:1516:24: QUOT
							{
							mQUOT(); 

							ls.quotOpen=false;
							}
							break;

						default :
							break loop38;
						}
					}

					mAPOS(); 

					}
					break;

			}
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STRING_MACR"

	// $ANTLR start "STRING_CHAR"
	public final void mSTRING_CHAR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1521:2: ( ( URI_CHAR | ' ' | '(' | ')' | ( '\\\\' NL_CHAR ) ) )
			// cz/vutbr/web/csskit/antlr/CSS.g:1521:5: ( URI_CHAR | ' ' | '(' | ')' | ( '\\\\' NL_CHAR ) )
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1521:5: ( URI_CHAR | ' ' | '(' | ')' | ( '\\\\' NL_CHAR ) )
			int alt40=5;
			int LA40_0 = input.LA(1);
			if ( (LA40_0=='\\') ) {
				int LA40_1 = input.LA(2);
				if ( (LA40_1=='\n'||(LA40_1 >= '\f' && LA40_1 <= '\r')) ) {
					alt40=5;
				}

				else {
					alt40=1;
				}

			}
			else if ( (LA40_0=='\t'||LA40_0=='!'||(LA40_0 >= '#' && LA40_0 <= '&')||(LA40_0 >= '*' && LA40_0 <= '[')||(LA40_0 >= ']' && LA40_0 <= '~')||(LA40_0 >= '\u0080' && LA40_0 <= '\uD7FF')||(LA40_0 >= '\uE000' && LA40_0 <= '\uFFFD')) ) {
				alt40=1;
			}
			else if ( (LA40_0==' ') ) {
				alt40=2;
			}
			else if ( (LA40_0=='(') ) {
				alt40=3;
			}
			else if ( (LA40_0==')') ) {
				alt40=4;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}

			switch (alt40) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1521:6: URI_CHAR
					{
					mURI_CHAR(); 

					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1521:17: ' '
					{
					match(' '); 
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1521:23: '('
					{
					match('('); 
					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1521:29: ')'
					{
					match(')'); 
					}
					break;
				case 5 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1521:35: ( '\\\\' NL_CHAR )
					{
					// cz/vutbr/web/csskit/antlr/CSS.g:1521:35: ( '\\\\' NL_CHAR )
					// cz/vutbr/web/csskit/antlr/CSS.g:1521:36: '\\\\' NL_CHAR
					{
					match('\\'); 
					mNL_CHAR(); 

					}

					}
					break;

			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "STRING_CHAR"

	// $ANTLR start "URI_MACR"
	public final void mURI_MACR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1526:2: ( ( URI_CHAR )* )
			// cz/vutbr/web/csskit/antlr/CSS.g:1526:4: ( URI_CHAR )*
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1526:4: ( URI_CHAR )*
			loop41:
			while (true) {
				int alt41=2;
				int LA41_0 = input.LA(1);
				if ( (LA41_0=='\t'||LA41_0=='!'||(LA41_0 >= '#' && LA41_0 <= '&')||(LA41_0 >= '*' && LA41_0 <= '~')||(LA41_0 >= '\u0080' && LA41_0 <= '\uD7FF')||(LA41_0 >= '\uE000' && LA41_0 <= '\uFFFD')) ) {
					alt41=1;
				}

				switch (alt41) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1526:4: URI_CHAR
					{
					mURI_CHAR(); 

					}
					break;

				default :
					break loop41;
				}
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "URI_MACR"

	// $ANTLR start "URI_CHAR"
	public final void mURI_CHAR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1531:2: ( ( '\\u0009' | '\\u0021' | '\\u0023' .. '\\u0026' | '\\u002A' .. '\\u007E' ) | NON_ASCII | ESCAPE_CHAR )
			int alt42=3;
			int LA42_0 = input.LA(1);
			if ( (LA42_0=='\\') ) {
				int LA42_1 = input.LA(2);
				if ( ((LA42_1 >= ' ' && LA42_1 <= '~')||(LA42_1 >= '\u0080' && LA42_1 <= '\uD7FF')||(LA42_1 >= '\uE000' && LA42_1 <= '\uFFFD')) ) {
					alt42=3;
				}

				else {
					alt42=1;
				}

			}
			else if ( ((LA42_0 >= '\u0080' && LA42_0 <= '\uD7FF')||(LA42_0 >= '\uE000' && LA42_0 <= '\uFFFD')) ) {
				alt42=2;
			}
			else if ( (LA42_0=='\t'||LA42_0=='!'||(LA42_0 >= '#' && LA42_0 <= '&')||(LA42_0 >= '*' && LA42_0 <= '[')||(LA42_0 >= ']' && LA42_0 <= '~')) ) {
				alt42=1;
			}

			else {
				NoViableAltException nvae =
					new NoViableAltException("", 42, 0, input);
				throw nvae;
			}

			switch (alt42) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1531:4: ( '\\u0009' | '\\u0021' | '\\u0023' .. '\\u0026' | '\\u002A' .. '\\u007E' )
					{
					if ( input.LA(1)=='\t'||input.LA(1)=='!'||(input.LA(1) >= '#' && input.LA(1) <= '&')||(input.LA(1) >= '*' && input.LA(1) <= '~') ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1532:6: NON_ASCII
					{
					mNON_ASCII(); 

					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1532:18: ESCAPE_CHAR
					{
					mESCAPE_CHAR(); 

					}
					break;

			}
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "URI_CHAR"

	// $ANTLR start "NL_CHAR"
	public final void mNL_CHAR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1537:4: ( '\\u000A' | '\\u000D' '\\u000A' | '\\u000D' | '\\u000C' )
			int alt43=4;
			switch ( input.LA(1) ) {
			case '\n':
				{
				alt43=1;
				}
				break;
			case '\r':
				{
				int LA43_2 = input.LA(2);
				if ( (LA43_2=='\n') ) {
					alt43=2;
				}

				else {
					alt43=3;
				}

				}
				break;
			case '\f':
				{
				alt43=4;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 43, 0, input);
				throw nvae;
			}
			switch (alt43) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1537:6: '\\u000A'
					{
					match('\n'); 
					}
					break;
				case 2 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1537:17: '\\u000D' '\\u000A'
					{
					match('\r'); 
					match('\n'); 
					}
					break;
				case 3 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1537:37: '\\u000D'
					{
					match('\r'); 
					}
					break;
				case 4 :
					// cz/vutbr/web/csskit/antlr/CSS.g:1537:48: '\\u000C'
					{
					match('\f'); 
					}
					break;

			}
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "NL_CHAR"

	// $ANTLR start "W_MACR"
	public final void mW_MACR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1542:2: ( ( W_CHAR )* )
			// cz/vutbr/web/csskit/antlr/CSS.g:1542:4: ( W_CHAR )*
			{
			// cz/vutbr/web/csskit/antlr/CSS.g:1542:4: ( W_CHAR )*
			loop44:
			while (true) {
				int alt44=2;
				int LA44_0 = input.LA(1);
				if ( ((LA44_0 >= '\t' && LA44_0 <= '\r')||LA44_0==' ') ) {
					alt44=1;
				}

				switch (alt44) {
				case 1 :
					// cz/vutbr/web/csskit/antlr/CSS.g:
					{
					if ( (input.LA(1) >= '\t' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
						input.consume();
					}
					else {
						MismatchedSetException mse = new MismatchedSetException(null,input);
						recover(mse);
						throw mse;
					}
					}
					break;

				default :
					break loop44;
				}
			}

			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "W_MACR"

	// $ANTLR start "W_CHAR"
	public final void mW_CHAR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1547:4: ( '\\u0009' | '\\u000A' | '\\u000B' | '\\u000C' | '\\u000D' | '\\u0020' )
			// cz/vutbr/web/csskit/antlr/CSS.g:
			{
			if ( (input.LA(1) >= '\t' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "W_CHAR"

	// $ANTLR start "CTRL_CHAR"
	public final void mCTRL_CHAR() throws RecognitionException {
		try {
			// cz/vutbr/web/csskit/antlr/CSS.g:1552:5: ( '\\u0000' .. '\\u0008' | '\\u000E' .. '\\u001F' )
			// cz/vutbr/web/csskit/antlr/CSS.g:
			{
			if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\b')||(input.LA(1) >= '\u000E' && input.LA(1) <= '\u001F') ) {
				input.consume();
			}
			else {
				MismatchedSetException mse = new MismatchedSetException(null,input);
				recover(mse);
				throw mse;
			}
			}

		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "CTRL_CHAR"

	@Override
	public void mTokens() throws RecognitionException {
		// cz/vutbr/web/csskit/antlr/CSS.g:1:8: ( T__101 | T__102 | T__103 | IDENT | CHARSET | IMPORT | MEDIA | PAGE | MARGIN_AREA | VIEWPORT | FONTFACE | ATKEYWORD | CLASSKEYWORD | STRING | HASH | INDEX | NUMBER | PERCENTAGE | DIMENSION | URI | UNIRANGE | CDO | CDC | SEMICOLON | COLON | COMMA | QUESTION | PERCENT | EQUALS | SLASH | GREATER | LESS | LCURLY | RCURLY | APOS | QUOT | LPAREN | RPAREN | LBRACE | RBRACE | EXCLAMATION | TILDE | MINUS | PLUS | ASTERISK | S | COMMENT | SL_COMMENT | EXPRESSION | FUNCTION | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS | CTRL | INVALID_TOKEN )
		int alt45=57;
		alt45 = dfa45.predict(input);
		switch (alt45) {
			case 1 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:10: T__101
				{
				mT__101(); 

				}
				break;
			case 2 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:17: T__102
				{
				mT__102(); 

				}
				break;
			case 3 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:24: T__103
				{
				mT__103(); 

				}
				break;
			case 4 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:31: IDENT
				{
				mIDENT(); 

				}
				break;
			case 5 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:37: CHARSET
				{
				mCHARSET(); 

				}
				break;
			case 6 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:45: IMPORT
				{
				mIMPORT(); 

				}
				break;
			case 7 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:52: MEDIA
				{
				mMEDIA(); 

				}
				break;
			case 8 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:58: PAGE
				{
				mPAGE(); 

				}
				break;
			case 9 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:63: MARGIN_AREA
				{
				mMARGIN_AREA(); 

				}
				break;
			case 10 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:75: VIEWPORT
				{
				mVIEWPORT(); 

				}
				break;
			case 11 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:84: FONTFACE
				{
				mFONTFACE(); 

				}
				break;
			case 12 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:93: ATKEYWORD
				{
				mATKEYWORD(); 

				}
				break;
			case 13 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:103: CLASSKEYWORD
				{
				mCLASSKEYWORD(); 

				}
				break;
			case 14 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:116: STRING
				{
				mSTRING(); 

				}
				break;
			case 15 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:123: HASH
				{
				mHASH(); 

				}
				break;
			case 16 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:128: INDEX
				{
				mINDEX(); 

				}
				break;
			case 17 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:134: NUMBER
				{
				mNUMBER(); 

				}
				break;
			case 18 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:141: PERCENTAGE
				{
				mPERCENTAGE(); 

				}
				break;
			case 19 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:152: DIMENSION
				{
				mDIMENSION(); 

				}
				break;
			case 20 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:162: URI
				{
				mURI(); 

				}
				break;
			case 21 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:166: UNIRANGE
				{
				mUNIRANGE(); 

				}
				break;
			case 22 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:175: CDO
				{
				mCDO(); 

				}
				break;
			case 23 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:179: CDC
				{
				mCDC(); 

				}
				break;
			case 24 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:183: SEMICOLON
				{
				mSEMICOLON(); 

				}
				break;
			case 25 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:193: COLON
				{
				mCOLON(); 

				}
				break;
			case 26 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:199: COMMA
				{
				mCOMMA(); 

				}
				break;
			case 27 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:205: QUESTION
				{
				mQUESTION(); 

				}
				break;
			case 28 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:214: PERCENT
				{
				mPERCENT(); 

				}
				break;
			case 29 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:222: EQUALS
				{
				mEQUALS(); 

				}
				break;
			case 30 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:229: SLASH
				{
				mSLASH(); 

				}
				break;
			case 31 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:235: GREATER
				{
				mGREATER(); 

				}
				break;
			case 32 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:243: LESS
				{
				mLESS(); 

				}
				break;
			case 33 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:248: LCURLY
				{
				mLCURLY(); 

				}
				break;
			case 34 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:255: RCURLY
				{
				mRCURLY(); 

				}
				break;
			case 35 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:262: APOS
				{
				mAPOS(); 

				}
				break;
			case 36 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:267: QUOT
				{
				mQUOT(); 

				}
				break;
			case 37 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:272: LPAREN
				{
				mLPAREN(); 

				}
				break;
			case 38 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:279: RPAREN
				{
				mRPAREN(); 

				}
				break;
			case 39 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:286: LBRACE
				{
				mLBRACE(); 

				}
				break;
			case 40 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:293: RBRACE
				{
				mRBRACE(); 

				}
				break;
			case 41 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:300: EXCLAMATION
				{
				mEXCLAMATION(); 

				}
				break;
			case 42 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:312: TILDE
				{
				mTILDE(); 

				}
				break;
			case 43 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:318: MINUS
				{
				mMINUS(); 

				}
				break;
			case 44 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:324: PLUS
				{
				mPLUS(); 

				}
				break;
			case 45 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:329: ASTERISK
				{
				mASTERISK(); 

				}
				break;
			case 46 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:338: S
				{
				mS(); 

				}
				break;
			case 47 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:340: COMMENT
				{
				mCOMMENT(); 

				}
				break;
			case 48 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:348: SL_COMMENT
				{
				mSL_COMMENT(); 

				}
				break;
			case 49 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:359: EXPRESSION
				{
				mEXPRESSION(); 

				}
				break;
			case 50 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:370: FUNCTION
				{
				mFUNCTION(); 

				}
				break;
			case 51 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:379: INCLUDES
				{
				mINCLUDES(); 

				}
				break;
			case 52 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:388: DASHMATCH
				{
				mDASHMATCH(); 

				}
				break;
			case 53 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:398: STARTSWITH
				{
				mSTARTSWITH(); 

				}
				break;
			case 54 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:409: ENDSWITH
				{
				mENDSWITH(); 

				}
				break;
			case 55 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:418: CONTAINS
				{
				mCONTAINS(); 

				}
				break;
			case 56 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:427: CTRL
				{
				mCTRL(); 

				}
				break;
			case 57 :
				// cz/vutbr/web/csskit/antlr/CSS.g:1:432: INVALID_TOKEN
				{
				mINVALID_TOKEN(); 

				}
				break;

		}
	}


	protected DFA36 dfa36 = new DFA36(this);
	protected DFA45 dfa45 = new DFA45(this);
	static final String DFA36_eotS =
		"\1\uffff\1\3\2\uffff";
	static final String DFA36_eofS =
		"\4\uffff";
	static final String DFA36_minS =
		"\2\56\2\uffff";
	static final String DFA36_maxS =
		"\2\71\2\uffff";
	static final String DFA36_acceptS =
		"\2\uffff\1\2\1\1";
	static final String DFA36_specialS =
		"\4\uffff}>";
	static final String[] DFA36_transitionS = {
			"\1\2\1\uffff\12\1",
			"\1\2\1\uffff\12\1",
			"",
			""
	};

	static final short[] DFA36_eot = DFA.unpackEncodedString(DFA36_eotS);
	static final short[] DFA36_eof = DFA.unpackEncodedString(DFA36_eofS);
	static final char[] DFA36_min = DFA.unpackEncodedStringToUnsignedChars(DFA36_minS);
	static final char[] DFA36_max = DFA.unpackEncodedStringToUnsignedChars(DFA36_maxS);
	static final short[] DFA36_accept = DFA.unpackEncodedString(DFA36_acceptS);
	static final short[] DFA36_special = DFA.unpackEncodedString(DFA36_specialS);
	static final short[][] DFA36_transition;

	static {
		int numStates = DFA36_transitionS.length;
		DFA36_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA36_transition[i] = DFA.unpackEncodedString(DFA36_transitionS[i]);
		}
	}

	protected class DFA36 extends DFA {

		public DFA36(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 36;
			this.eot = DFA36_eot;
			this.eof = DFA36_eof;
			this.min = DFA36_min;
			this.max = DFA36_max;
			this.accept = DFA36_accept;
			this.special = DFA36_special;
			this.transition = DFA36_transition;
		}
		@Override
		public String getDescription() {
			return "1509:1: fragment NUMBER_MACR : ( ( '0' .. '9' )+ | ( ( '0' .. '9' )* '.' ( '0' .. '9' )+ ) );";
		}
	}

	static final String DFA45_eotS =
		"\1\uffff\1\54\1\57\5\61\1\53\1\110\1\53\1\113\1\115\1\116\4\61\1\131\1"+
		"\133\6\uffff\1\144\10\uffff\1\156\1\uffff\1\161\1\uffff\1\61\2\53\6\uffff"+
		"\1\61\1\uffff\6\61\2\uffff\1\61\1\uffff\2\61\12\110\2\uffff\1\116\4\uffff"+
		"\1\73\1\116\2\uffff\1\73\1\uffff\1\61\1\uffff\1\61\36\uffff\7\61\12\110"+
		"\1\124\11\61\12\110\1\73\1\71\10\61\3\110\1\u00bb\6\110\1\uffff\10\61"+
		"\2\110\1\u00ce\1\uffff\10\110\10\61\2\110\1\uffff\12\110\5\61\1\110\1"+
		"\uffff\15\110\1\61\1\u0100\1\uffff\1\110\1\u0103\5\110\1\u0103\5\110\1"+
		"\u010e\1\110\1\61\1\uffff\2\110\1\uffff\1\110\1\u0103\5\110\1\u0103\2"+
		"\110\1\uffff\1\u011b\1\61\1\110\1\u0103\10\110\2\uffff\2\110\1\u0103\2"+
		"\110\2\u0103\2\110\1\uffff\4\110\3\u0103\3\110\1\u0103\5\110\1\u0103\3"+
		"\110\1\u0103\4\110\1\u0103\1\110\1\u0103";
	static final String DFA45_eofS =
		"\u0143\uffff";
	static final String DFA45_minS =
		"\1\0\1\55\1\75\1\50\2\11\2\50\1\40\1\142\1\60\2\11\1\45\4\50\1\41\1\55"+
		"\6\uffff\1\52\10\uffff\1\75\1\uffff\1\75\1\uffff\1\50\2\75\6\uffff\1\50"+
		"\1\uffff\6\50\1\40\1\uffff\1\11\1\uffff\2\50\1\150\1\155\1\145\1\141\2"+
		"\157\1\145\2\151\1\157\2\uffff\1\45\4\uffff\1\55\1\45\1\60\1\uffff\1\55"+
		"\1\uffff\1\50\1\uffff\1\50\36\uffff\7\50\1\141\1\160\1\144\1\147\1\160"+
		"\1\164\1\146\1\147\1\145\1\156\1\11\11\50\1\162\1\157\1\151\1\145\1\55"+
		"\2\164\1\150\1\167\1\164\1\55\1\11\10\50\1\163\1\162\1\141\1\55\1\143"+
		"\1\157\1\55\1\164\1\160\1\55\1\uffff\10\50\1\145\1\164\1\55\1\uffff\2"+
		"\145\1\151\1\155\1\142\1\55\1\157\1\146\10\50\1\164\1\11\1\uffff\1\146"+
		"\1\156\1\147\1\55\1\157\1\151\1\157\1\142\1\162\1\141\5\50\1\11\1\uffff"+
		"\1\162\2\164\1\150\1\143\1\160\1\144\1\164\1\157\1\151\1\157\1\164\1\143"+
		"\2\50\1\uffff\1\154\1\55\1\145\1\164\2\145\1\151\1\55\1\144\1\164\1\160"+
		"\1\144\1\164\1\55\1\145\1\50\1\uffff\1\50\1\143\1\uffff\1\162\1\55\1\146"+
		"\1\156\1\147\1\154\1\157\1\55\1\144\1\164\1\uffff\1\55\1\50\1\157\1\55"+
		"\1\143\2\164\1\150\1\145\1\155\1\154\1\157\2\uffff\1\162\1\157\1\55\1"+
		"\145\1\164\2\55\1\145\1\155\1\uffff\1\156\1\162\1\143\1\162\3\55\1\145"+
		"\1\156\1\157\1\55\1\143\1\162\1\145\1\162\1\157\1\55\1\162\1\156\1\162"+
		"\1\55\1\145\1\156\1\162\1\145\1\55\1\162\1\55";
	static final String DFA45_maxS =
		"\1\uffff\1\ufffd\1\75\6\ufffd\1\166\10\ufffd\1\41\1\55\6\uffff\1\57\10"+
		"\uffff\1\75\1\uffff\1\75\1\uffff\1\ufffd\2\75\6\uffff\1\ufffd\1\uffff"+
		"\7\ufffd\1\uffff\1\ufffd\1\uffff\2\ufffd\1\150\1\155\1\145\1\141\2\157"+
		"\1\145\2\151\1\157\2\uffff\1\ufffd\4\uffff\2\ufffd\1\71\1\uffff\1\ufffd"+
		"\1\uffff\1\ufffd\1\uffff\1\ufffd\36\uffff\7\ufffd\1\141\1\160\1\144\1"+
		"\147\1\160\1\164\1\146\1\147\1\145\1\156\1\71\11\ufffd\1\162\1\157\1\151"+
		"\1\145\1\55\2\164\1\150\1\167\1\164\12\ufffd\1\163\1\162\1\141\1\ufffd"+
		"\1\162\1\157\1\55\1\164\1\160\1\55\1\uffff\10\ufffd\1\145\1\164\1\ufffd"+
		"\1\uffff\2\145\1\151\1\155\1\164\1\55\1\157\1\146\10\ufffd\1\164\1\165"+
		"\1\uffff\1\146\1\156\1\147\1\55\1\157\1\151\1\157\1\164\1\162\1\141\5"+
		"\ufffd\1\47\1\uffff\1\162\2\164\1\150\1\162\1\160\1\144\1\164\1\157\1"+
		"\151\1\157\1\164\1\143\2\ufffd\1\uffff\1\154\1\ufffd\1\145\1\164\2\145"+
		"\1\151\1\ufffd\1\144\1\164\1\160\1\144\1\164\1\ufffd\1\145\1\ufffd\1\uffff"+
		"\1\50\1\143\1\uffff\1\162\1\ufffd\1\146\1\156\1\147\1\154\1\157\1\ufffd"+
		"\1\144\1\164\1\uffff\2\ufffd\1\157\1\ufffd\1\143\2\164\1\150\1\145\1\155"+
		"\1\154\1\157\2\uffff\1\162\1\157\1\ufffd\1\145\1\164\2\ufffd\1\145\1\155"+
		"\1\uffff\1\156\1\162\1\143\1\162\3\ufffd\1\145\1\156\1\157\1\ufffd\1\143"+
		"\1\162\1\145\1\162\1\157\1\ufffd\1\162\1\156\1\162\1\ufffd\1\145\1\156"+
		"\1\162\1\145\1\ufffd\1\162\1\ufffd";
	static final String DFA45_acceptS =
		"\24\uffff\1\30\1\31\1\32\1\33\1\34\1\35\1\uffff\1\37\1\41\1\42\1\45\1"+
		"\46\1\47\1\50\1\51\1\uffff\1\54\1\uffff\1\56\3\uffff\1\70\1\71\1\1\1\17"+
		"\1\65\1\2\1\uffff\1\4\7\uffff\1\62\1\uffff\1\20\14\uffff\1\14\1\15\1\uffff"+
		"\1\44\1\16\1\43\1\21\3\uffff\1\22\1\uffff\1\23\1\uffff\1\25\1\uffff\1"+
		"\26\1\40\1\27\1\53\1\30\1\31\1\32\1\33\1\34\1\35\1\57\1\60\1\36\1\37\1"+
		"\41\1\42\1\45\1\46\1\47\1\50\1\51\1\63\1\52\1\54\1\67\1\55\1\56\1\64\1"+
		"\66\1\70\71\uffff\1\24\13\uffff\1\10\22\uffff\1\7\20\uffff\1\6\17\uffff"+
		"\1\5\20\uffff\1\3\2\uffff\1\11\12\uffff\1\12\14\uffff\1\13\1\61\11\uffff"+
		"\1\61\34\uffff";
	static final String DFA45_specialS =
		"\1\0\u0142\uffff}>";
	static final String[] DFA45_transitionS = {
			"\11\52\5\46\22\52\1\46\1\42\1\13\1\1\1\51\1\30\1\53\1\14\1\36\1\37\1"+
			"\45\1\44\1\26\1\23\1\12\1\32\12\15\1\25\1\24\1\22\1\31\1\33\1\27\1\11"+
			"\15\21\1\5\6\21\1\17\5\21\1\40\1\10\1\41\1\2\1\6\1\53\4\47\1\20\3\47"+
			"\1\3\4\47\1\4\6\47\1\16\5\47\1\34\1\50\1\35\1\43\1\53\ud780\7\u0800\53"+
			"\u1ffe\7\2\53",
			"\1\55\2\uffff\12\55\7\uffff\32\55\1\uffff\1\55\2\uffff\1\55\1\uffff"+
			"\32\55\5\uffff\ud780\55\u0800\uffff\u1ffe\55",
			"\1\56",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\14\62\1\60\15\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\5\73\22\uffff\1\73\7\uffff\1\71\2\uffff\1\73\1\uffff\1\72\2\uffff\12"+
			"\64\7\uffff\32\63\1\uffff\1\70\2\uffff\1\66\1\uffff\32\62\5\uffff\ud780"+
			"\67\u0800\uffff\u1ffe\67",
			"\5\73\22\uffff\1\73\7\uffff\1\71\2\uffff\1\73\1\uffff\1\72\2\uffff\12"+
			"\64\7\uffff\32\63\1\uffff\1\70\2\uffff\1\66\1\uffff\32\62\5\uffff\ud780"+
			"\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\20\75\12\74\7\75\6\74\32\75\6\74\30\75\1\uffff\ud780\75\u0800\uffff"+
			"\u1ffe\75",
			"\1\103\1\76\2\uffff\1\107\2\uffff\1\77\2\uffff\1\104\1\100\2\uffff\1"+
			"\101\1\uffff\1\105\1\uffff\1\102\1\uffff\1\106",
			"\12\112\7\uffff\32\111\1\uffff\1\111\2\uffff\1\111\1\uffff\32\111\5"+
			"\uffff\ud780\111\u0800\uffff\u1ffe\111",
			"\1\114\26\uffff\137\114\1\uffff\ud780\114\u0800\uffff\u1ffe\114",
			"\1\114\26\uffff\137\114\1\uffff\ud780\114\u0800\uffff\u1ffe\114",
			"\1\122\10\uffff\1\121\1\uffff\12\120\7\uffff\15\124\1\123\14\124\1\uffff"+
			"\1\124\2\uffff\1\124\1\uffff\15\124\1\117\14\124\5\uffff\ud780\124\u0800"+
			"\uffff\u1ffe\124",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\21\62\1\125\10\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\2\uffff\1\126\1\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff"+
			"\1\70\2\uffff\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\27\62\1\127\2\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\130",
			"\1\132",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\142\4\uffff\1\143",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\155",
			"",
			"\1\160",
			"",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\163",
			"\1\164",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\17\62\1\166\12\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\20\170\12\167\7\170\6\167\32\170\6\167\30\170\1\uffff\ud780\170\u0800"+
			"\uffff\u1ffe\170",
			"",
			"\5\73\22\uffff\1\73\7\uffff\1\71\4\uffff\1\65\2\uffff\12\171\7\uffff"+
			"\32\63\1\uffff\1\70\2\uffff\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800"+
			"\uffff\u1ffe\67",
			"",
			"\1\71\4\uffff\1\65\2\uffff\12\174\7\uffff\6\173\24\63\1\uffff\1\70\2"+
			"\uffff\1\66\1\uffff\6\172\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\175",
			"\1\176",
			"\1\177",
			"\1\u0080",
			"\1\u0081",
			"\1\u0082",
			"\1\u0083",
			"\1\u0084",
			"\1\u0085",
			"\1\u0086",
			"",
			"",
			"\1\122\12\uffff\12\112\7\uffff\32\124\1\uffff\1\124\2\uffff\1\124\1"+
			"\uffff\32\124\5\uffff\ud780\124\u0800\uffff\u1ffe\124",
			"",
			"",
			"",
			"",
			"\1\u0087\2\uffff\12\124\7\uffff\32\124\1\uffff\1\124\2\uffff\1\124\1"+
			"\uffff\32\124\5\uffff\ud780\124\u0800\uffff\u1ffe\124",
			"\1\122\10\uffff\1\121\1\uffff\12\120\7\uffff\15\124\1\123\14\124\1\uffff"+
			"\1\124\2\uffff\1\124\1\uffff\15\124\1\117\14\124\5\uffff\ud780\124\u0800"+
			"\uffff\u1ffe\124",
			"\12\112",
			"",
			"\1\u0087\2\uffff\12\124\7\uffff\32\124\1\uffff\1\124\2\uffff\1\124\1"+
			"\uffff\32\124\5\uffff\ud780\124\u0800\uffff\u1ffe\124",
			"",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\13\62\1\u0088\16\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\17\62\1\u0089\12\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\16\62\1\u008a\13\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u008d\7\uffff\6\u008c\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u008b\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\171\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u0090\7\uffff\6\u008f\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u008e\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u0090\7\uffff\6\u008f\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u008e\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u0090\7\uffff\6\u008f\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u008e\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\u0091",
			"\1\u0092",
			"\1\u0093",
			"\1\u0094",
			"\1\u0095",
			"\1\u0096",
			"\1\u0097",
			"\1\u0098",
			"\1\u0099",
			"\1\u009a",
			"\5\73\22\uffff\1\73\17\uffff\12\u009b",
			"\1\u009c\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\21\62\1\u009d\10\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\21\62\1\u009e\10\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00a1\7\uffff\6\u00a0\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u009f\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00a1\7\uffff\6\u00a0\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u009f\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00a1\7\uffff\6\u00a0\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u009f\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00a4\7\uffff\6\u00a3\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00a2\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00a4\7\uffff\6\u00a3\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00a2\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00a4\7\uffff\6\u00a3\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00a2\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\u00a5",
			"\1\u00a6",
			"\1\u00a7",
			"\1\u00a8",
			"\1\u00a9",
			"\1\u00aa",
			"\1\u00ab",
			"\1\u00ac",
			"\1\u00ad",
			"\1\u00ae",
			"\1\124\2\uffff\12\u009b\7\uffff\32\124\1\uffff\1\124\2\uffff\1\124\1"+
			"\uffff\32\124\5\uffff\ud780\124\u0800\uffff\u1ffe\124",
			"\5\u00af\22\uffff\10\u00af\1\uffff\126\u00af\1\uffff\ud780\u00af\u0800"+
			"\uffff\u1ffe\u00af",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\4\62\1\u00b0\25\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\23\62\1\u00b1\6\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00b4\7\uffff\6\u00b3\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00b2\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00b4\7\uffff\6\u00b3\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00b2\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00b4\7\uffff\6\u00b3\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00b2\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00b7\7\uffff\6\u00b6\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00b5\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00b7\7\uffff\6\u00b6\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00b5\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00b7\7\uffff\6\u00b6\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00b5\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\u00b8",
			"\1\u00b9",
			"\1\u00ba",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u00bd\10\uffff\1\u00bc\5\uffff\1\u00be",
			"\1\u00bf",
			"\1\u00c0",
			"\1\u00c1",
			"\1\u00c2",
			"\1\u00c3",
			"",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\22\62\1\u00c4\7\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\1\u00c5\31\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00c8\7\uffff\6\u00c7\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00c6\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00c8\7\uffff\6\u00c7\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00c6\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00c8\7\uffff\6\u00c7\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00c6\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00cb\7\uffff\6\u00ca\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00c9\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00cb\7\uffff\6\u00ca\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00c9\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00cb\7\uffff\6\u00ca\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00c9\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\u00cc",
			"\1\u00cd",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"",
			"\1\u00cf",
			"\1\u00d0",
			"\1\u00d1",
			"\1\u00d2",
			"\1\u00d5\12\uffff\1\u00d4\6\uffff\1\u00d3",
			"\1\u00d6",
			"\1\u00d7",
			"\1\u00d8",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\22\62\1\u00d9\7\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\15\62\1\u00da\14\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00dd\7\uffff\6\u00dc\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00db\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00dd\7\uffff\6\u00dc\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00db\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\u00dd\7\uffff\6\u00dc\24\63\1\uffff\1"+
			"\70\2\uffff\1\66\1\uffff\6\u00db\24\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\u00de",
			"\5\u00df\22\uffff\1\u00df\1\uffff\1\u00df\4\uffff\1\u00df\115\uffff"+
			"\1\u00e0",
			"",
			"\1\u00e1",
			"\1\u00e2",
			"\1\u00e3",
			"\1\u00e4",
			"\1\u00e5",
			"\1\u00e6",
			"\1\u00e7",
			"\1\u00ea\12\uffff\1\u00e9\6\uffff\1\u00e8",
			"\1\u00eb",
			"\1\u00ec",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\10\62\1\u00ed\21\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\23\62\1\u00ee\6\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\5\u00ef\22\uffff\1\u00ef\1\uffff\1\u00ef\4\uffff\1\u00ef",
			"",
			"\1\u00f0",
			"\1\u00f1",
			"\1\u00f2",
			"\1\u00f3",
			"\1\u00f5\10\uffff\1\u00f4\5\uffff\1\u00f6",
			"\1\u00f7",
			"\1\u00f8",
			"\1\u00f9",
			"\1\u00fa",
			"\1\u00fb",
			"\1\u00fc",
			"\1\u00fd",
			"\1\u00fe",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\16\62\1\u00ff\13\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"",
			"\1\u0101",
			"\1\u0102\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1"+
			"\uffff\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u0104",
			"\1\u0105",
			"\1\u0106",
			"\1\u0107",
			"\1\u0108",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u0109",
			"\1\u010a",
			"\1\u010b",
			"\1\u010c",
			"\1\u010d",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u010f",
			"\1\71\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\15\62\1\u0110\14\62\5\uffff\ud780\67\u0800\uffff\u1ffe"+
			"\67",
			"",
			"\1\u00df",
			"\1\u0111",
			"",
			"\1\u0112",
			"\1\u0113\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1"+
			"\uffff\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u0114",
			"\1\u0115",
			"\1\u0116",
			"\1\u0117",
			"\1\u0118",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u0119",
			"\1\u011a",
			"",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u011c\4\uffff\1\65\2\uffff\12\64\7\uffff\32\63\1\uffff\1\70\2\uffff"+
			"\1\66\1\uffff\32\62\5\uffff\ud780\67\u0800\uffff\u1ffe\67",
			"\1\u011d",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u011e",
			"\1\u011f",
			"\1\u0120",
			"\1\u0121",
			"\1\u0122",
			"\1\u0123",
			"\1\u0124",
			"\1\u0125",
			"",
			"",
			"\1\u0127",
			"\1\u0128",
			"\1\u0129\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1"+
			"\uffff\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u012a",
			"\1\u012b",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u012c",
			"\1\u012d",
			"",
			"\1\u012e",
			"\1\u012f",
			"\1\u0130",
			"\1\u0131",
			"\1\u0132\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1"+
			"\uffff\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u0133",
			"\1\u0134",
			"\1\u0135",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u0136",
			"\1\u0137",
			"\1\u0138",
			"\1\u0139",
			"\1\u013a",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u013b",
			"\1\u013c",
			"\1\u013d",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u013e",
			"\1\u013f",
			"\1\u0140",
			"\1\u0141",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110",
			"\1\u0142",
			"\1\110\2\uffff\12\110\7\uffff\32\110\1\uffff\1\110\2\uffff\1\110\1\uffff"+
			"\32\110\5\uffff\ud780\110\u0800\uffff\u1ffe\110"
	};

	static final short[] DFA45_eot = DFA.unpackEncodedString(DFA45_eotS);
	static final short[] DFA45_eof = DFA.unpackEncodedString(DFA45_eofS);
	static final char[] DFA45_min = DFA.unpackEncodedStringToUnsignedChars(DFA45_minS);
	static final char[] DFA45_max = DFA.unpackEncodedStringToUnsignedChars(DFA45_maxS);
	static final short[] DFA45_accept = DFA.unpackEncodedString(DFA45_acceptS);
	static final short[] DFA45_special = DFA.unpackEncodedString(DFA45_specialS);

	static short[][] DFA45_transition() {
		int numStates = DFA45_transitionS.length;
        short[][] DFA45_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA45_transition[i] = DFA.unpackEncodedString(DFA45_transitionS[i]);
		}
        return DFA45_transition;
	}

	protected class DFA45 extends DFA {

		public DFA45(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 45;
			this.eot = DFA45_eot;
			this.eof = DFA45_eof;
			this.min = DFA45_min;
			this.max = DFA45_max;
			this.accept = DFA45_accept;
			this.special = DFA45_special;
			this.transition = DFA45_transition();
		}
		@Override
		public String getDescription() {
			return "1:1: Tokens : ( T__101 | T__102 | T__103 | IDENT | CHARSET | IMPORT | MEDIA | PAGE | MARGIN_AREA | VIEWPORT | FONTFACE | ATKEYWORD | CLASSKEYWORD | STRING | HASH | INDEX | NUMBER | PERCENTAGE | DIMENSION | URI | UNIRANGE | CDO | CDC | SEMICOLON | COLON | COMMA | QUESTION | PERCENT | EQUALS | SLASH | GREATER | LESS | LCURLY | RCURLY | APOS | QUOT | LPAREN | RPAREN | LBRACE | RBRACE | EXCLAMATION | TILDE | MINUS | PLUS | ASTERISK | S | COMMENT | SL_COMMENT | EXPRESSION | FUNCTION | INCLUDES | DASHMATCH | STARTSWITH | ENDSWITH | CONTAINS | CTRL | INVALID_TOKEN );";
		}
		@Override
		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			IntStream input = _input;
			int _s = s;
			switch ( s ) {
					case 0 : 
						int LA45_0 = input.LA(1);
						s = -1;
						if ( (LA45_0=='#') ) {s = 1;}
						else if ( (LA45_0=='^') ) {s = 2;}
						else if ( (LA45_0=='i') ) {s = 3;}
						else if ( (LA45_0=='n') ) {s = 4;}
						else if ( (LA45_0=='N') ) {s = 5;}
						else if ( (LA45_0=='_') ) {s = 6;}
						else if ( ((LA45_0 >= '\u0080' && LA45_0 <= '\uD7FF')||(LA45_0 >= '\uE000' && LA45_0 <= '\uFFFD')) ) {s = 7;}
						else if ( (LA45_0=='\\') ) {s = 8;}
						else if ( (LA45_0=='@') ) {s = 9;}
						else if ( (LA45_0=='.') ) {s = 10;}
						else if ( (LA45_0=='\"') ) {s = 11;}
						else if ( (LA45_0=='\'') ) {s = 12;}
						else if ( ((LA45_0 >= '0' && LA45_0 <= '9')) ) {s = 13;}
						else if ( (LA45_0=='u') ) {s = 14;}
						else if ( (LA45_0=='U') ) {s = 15;}
						else if ( (LA45_0=='e') ) {s = 16;}
						else if ( ((LA45_0 >= 'A' && LA45_0 <= 'M')||(LA45_0 >= 'O' && LA45_0 <= 'T')||(LA45_0 >= 'V' && LA45_0 <= 'Z')) ) {s = 17;}
						else if ( (LA45_0=='<') ) {s = 18;}
						else if ( (LA45_0=='-') ) {s = 19;}
						else if ( (LA45_0==';') ) {s = 20;}
						else if ( (LA45_0==':') ) {s = 21;}
						else if ( (LA45_0==',') ) {s = 22;}
						else if ( (LA45_0=='?') ) {s = 23;}
						else if ( (LA45_0=='%') ) {s = 24;}
						else if ( (LA45_0=='=') ) {s = 25;}
						else if ( (LA45_0=='/') ) {s = 26;}
						else if ( (LA45_0=='>') ) {s = 27;}
						else if ( (LA45_0=='{') ) {s = 28;}
						else if ( (LA45_0=='}') ) {s = 29;}
						else if ( (LA45_0=='(') ) {s = 30;}
						else if ( (LA45_0==')') ) {s = 31;}
						else if ( (LA45_0=='[') ) {s = 32;}
						else if ( (LA45_0==']') ) {s = 33;}
						else if ( (LA45_0=='!') ) {s = 34;}
						else if ( (LA45_0=='~') ) {s = 35;}
						else if ( (LA45_0=='+') ) {s = 36;}
						else if ( (LA45_0=='*') ) {s = 37;}
						else if ( ((LA45_0 >= '\t' && LA45_0 <= '\r')||LA45_0==' ') ) {s = 38;}
						else if ( ((LA45_0 >= 'a' && LA45_0 <= 'd')||(LA45_0 >= 'f' && LA45_0 <= 'h')||(LA45_0 >= 'j' && LA45_0 <= 'm')||(LA45_0 >= 'o' && LA45_0 <= 't')||(LA45_0 >= 'v' && LA45_0 <= 'z')) ) {s = 39;}
						else if ( (LA45_0=='|') ) {s = 40;}
						else if ( (LA45_0=='$') ) {s = 41;}
						else if ( ((LA45_0 >= '\u0000' && LA45_0 <= '\b')||(LA45_0 >= '\u000E' && LA45_0 <= '\u001F')) ) {s = 42;}
						else if ( (LA45_0=='&'||LA45_0=='`'||LA45_0=='\u007F'||(LA45_0 >= '\uD800' && LA45_0 <= '\uDFFF')||(LA45_0 >= '\uFFFE' && LA45_0 <= '\uFFFF')) ) {s = 43;}
						if ( s>=0 ) return s;
						break;
			}
			NoViableAltException nvae =
				new NoViableAltException(getDescription(), 45, _s, input);
			error(nvae);
			throw nvae;
		}
	}

}
