/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate;

import java.util.Collections;
import java.util.Set;
import net.sf.beanlib.CollectionPropertyName;
import net.sf.beanlib.hibernate.HibernateBeanPopulatableSupport;
import net.sf.beanlib.hibernate.UnEnhancer;
import net.sf.beanlib.provider.collector.ProtectedSetterMethodCollector;
import net.sf.beanlib.spi.BeanMethodCollector;
import net.sf.beanlib.spi.BeanMethodFinder;
import net.sf.beanlib.spi.BeanPopulatable;
import net.sf.beanlib.spi.BeanSourceHandler;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;
import net.sf.beanlib.spi.DetailedBeanPopulatable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateBeanReplicator {
    private final BeanTransformerSpi hibernateBeanTransformer;
    private Set<Class> entityBeanClassSet;
    private Set<? extends CollectionPropertyName> collectionPropertyNameSet;
    private BeanPopulatable beanPopulatable;
    private BeanPopulatable vetoer;

    public HibernateBeanReplicator(BeanTransformerSpi hibernateBeanTransformer) {
        if (hibernateBeanTransformer == null) {
            throw new IllegalArgumentException("Argument hibernateBeanTransformer must not be null");
        }
        this.hibernateBeanTransformer = hibernateBeanTransformer;
    }

    public final <T> T copy(T from) {
        return from == null ? null : (T)this.copy(from, UnEnhancer.getActualClass(from));
    }

    public final <T> T copy(Object from, Class<T> toClass) {
        if (from == null) {
            return null;
        }
        if (this.beanPopulatable == null) {
            this.beanPopulatable = new HibernateBeanPopulatableSupport(this.entityBeanClassSet, this.collectionPropertyNameSet, this.vetoer);
        }
        this.hibernateBeanTransformer.initBeanPopulatable(this.beanPopulatable);
        try {
            Object object = this.hibernateBeanTransformer.transform(from, toClass, null);
            return (T)object;
        }
        finally {
            this.hibernateBeanTransformer.reset();
        }
    }

    public final <T> T deepCopy(T from) {
        return from == null ? null : (T)this.deepCopy(from, UnEnhancer.getActualClass(from));
    }

    public final <T> T deepCopy(Object from, Class<T> toClass) {
        this.entityBeanClassSet = null;
        this.collectionPropertyNameSet = null;
        this.setDefaultBehavior();
        return this.copy(from, toClass);
    }

    public final <T> T shallowCopy(T from) {
        return from == null ? null : (T)this.shallowCopy(from, UnEnhancer.getActualClass(from));
    }

    public final <T> T shallowCopy(Object from, Class<T> toClass) {
        this.entityBeanClassSet = Collections.emptySet();
        this.collectionPropertyNameSet = Collections.emptySet();
        this.setDefaultBehavior();
        return this.copy(from, toClass);
    }

    private void setDefaultBehavior() {
        this.beanPopulatable = null;
        this.hibernateBeanTransformer.initDetailedBeanPopulatable(null);
        this.hibernateBeanTransformer.initSetterMethodCollector((BeanMethodCollector)ProtectedSetterMethodCollector.inst);
    }

    public final BeanPopulatable getBeanPopulatable() {
        return this.beanPopulatable;
    }

    public final HibernateBeanReplicator initBeanPopulatable(BeanPopulatable beanPopulatable) {
        this.beanPopulatable = beanPopulatable;
        return this;
    }

    @Deprecated
    public final HibernateBeanReplicator initCustomTransformer(CustomBeanTransformerSpi.Factory customTransformerFactory) {
        this.hibernateBeanTransformer.initCustomTransformerFactory(customTransformerFactory);
        return this;
    }

    public final HibernateBeanReplicator initCustomTransformerFactory(CustomBeanTransformerSpi.Factory customTransformerFactory) {
        this.hibernateBeanTransformer.initCustomTransformerFactory(customTransformerFactory);
        return this;
    }

    public final HibernateBeanReplicator initBeanSourceHandler(BeanSourceHandler beanSourceHandler) {
        this.hibernateBeanTransformer.initBeanSourceHandler(beanSourceHandler);
        return this;
    }

    public final HibernateBeanReplicator initDebug(boolean debug) {
        this.hibernateBeanTransformer.initDebug(debug);
        return this;
    }

    public final HibernateBeanReplicator initDetailedBeanPopulatable(DetailedBeanPopulatable detailedBeanPopulatable) {
        this.hibernateBeanTransformer.initDetailedBeanPopulatable(detailedBeanPopulatable);
        return this;
    }

    public final Set getEntityBeanClassSet() {
        return this.entityBeanClassSet;
    }

    public final HibernateBeanReplicator initEntityBeanClassSet(Set<Class> entityBeanClassSet) {
        this.entityBeanClassSet = entityBeanClassSet;
        return this;
    }

    public final Set getCollectionPropertyNameSet() {
        return this.collectionPropertyNameSet;
    }

    public final HibernateBeanReplicator initCollectionPropertyNameSet(Set<? extends CollectionPropertyName> collectionPropertyNameSet) {
        this.collectionPropertyNameSet = collectionPropertyNameSet;
        return this;
    }

    public final BeanPopulatable getVetoer() {
        return this.vetoer;
    }

    public final HibernateBeanReplicator initVetoer(BeanPopulatable vetoer) {
        this.vetoer = vetoer;
        return this;
    }

    public final HibernateBeanReplicator setReaderMethodFinder(BeanMethodFinder readerMethodFinder) {
        this.hibernateBeanTransformer.initReaderMethodFinder(readerMethodFinder);
        return this;
    }

    public final HibernateBeanReplicator initSetterMethodCollector(BeanMethodCollector setterMethodFinder) {
        this.hibernateBeanTransformer.initSetterMethodCollector(setterMethodFinder);
        return this;
    }
}

